declare global {
    interface Window {
        __strapi_previewCleanup?: () => void;
        STRAPI_HIGHLIGHT_HOVER_COLOR?: string;
        STRAPI_HIGHLIGHT_ACTIVE_COLOR?: string;
        STRAPI_DISABLE_STEGA_DECODING?: boolean;
    }
}
/**
 * previewScript will be injected into the preview iframe after being stringified.
 * Therefore it CANNOT use any imports, or refer to any variables outside of its own scope.
 * It's why many functions are defined within previewScript, it's the only way to avoid going full spaghetti.
 * To get a better overview of everything previewScript does, go to the orchestration part at its end.
 */
declare const previewScript: (shouldRun?: boolean) => {
    INTERNAL_EVENTS: {
        readonly STRAPI_FIELD_FOCUS: "strapiFieldFocus";
        readonly STRAPI_FIELD_BLUR: "strapiFieldBlur";
        readonly STRAPI_FIELD_CHANGE: "strapiFieldChange";
        readonly STRAPI_FIELD_FOCUS_INTENT: "strapiFieldFocusIntent";
        readonly STRAPI_FIELD_SINGLE_CLICK_HINT: "strapiFieldSingleClickHint";
    };
} | undefined;
export { previewScript };
