/**
 * These events can be changed safely. They're used by the content manager admin on one side, and by
 * the preview script on the other. We own both ends, and they're not documented to users, so we can
 * do what we want with them.
 */
export declare const INTERNAL_EVENTS: {
    readonly STRAPI_FIELD_FOCUS: "strapiFieldFocus";
    readonly STRAPI_FIELD_BLUR: "strapiFieldBlur";
    readonly STRAPI_FIELD_CHANGE: "strapiFieldChange";
    readonly STRAPI_FIELD_FOCUS_INTENT: "strapiFieldFocusIntent";
    readonly STRAPI_FIELD_SINGLE_CLICK_HINT: "strapiFieldSingleClickHint";
};
/**
 * These events are documented to users, and will be hardcoded in their frontends.
 * Changing any of these would be a breaking change.
 */
export declare const PUBLIC_EVENTS: {
    readonly PREVIEW_READY: "previewReady";
    readonly STRAPI_UPDATE: "strapiUpdate";
    readonly STRAPI_SCRIPT: "strapiScript";
};
/**
 * Error messages for preview field operations.
 * This information is used to trigger notifications.
 */
export declare const PREVIEW_ERROR_MESSAGES: {
    readonly INVALID_FIELD_PATH: {
        readonly type: "danger";
        readonly message: {
            readonly id: "content-manager.preview.error.invalid-field-path";
            readonly defaultMessage: "Could not locate this field in the current document";
        };
    };
    readonly RELATIONS_NOT_HANDLED: {
        readonly type: "info";
        readonly message: {
            readonly id: "content-manager.preview.error.relations-not-handled";
            readonly defaultMessage: "Inline editing for relations is not currently supported.";
        };
    };
    readonly INCOMPLETE_STRAPI_SOURCE: {
        readonly type: "danger";
        readonly message: {
            readonly id: "content-manager.preview.error.incomplete-strapi-source";
            readonly defaultMessage: "This field is missing some required preview information";
        };
    };
    readonly DIFFERENT_DOCUMENT: {
        readonly type: "info";
        readonly message: {
            readonly id: "content-manager.preview.error.different-document";
            readonly defaultMessage: "This field comes from a different document";
        };
    };
};
