'use strict';

var previewScript = require('./previewScript.js');

const scriptResponse = previewScript.previewScript(false);
/**
 * These events can be changed safely. They're used by the content manager admin on one side, and by
 * the preview script on the other. We own both ends, and they're not documented to users, so we can
 * do what we want with them.
 */ const INTERNAL_EVENTS = scriptResponse.INTERNAL_EVENTS;
/**
 * These events are documented to users, and will be hardcoded in their frontends.
 * Changing any of these would be a breaking change.
 */ const PUBLIC_EVENTS = {
    PREVIEW_READY: 'previewReady',
    STRAPI_UPDATE: 'strapiUpdate',
    STRAPI_SCRIPT: 'strapiScript'
};
/**
 * Error messages for preview field operations.
 * This information is used to trigger notifications.
 */ const PREVIEW_ERROR_MESSAGES = {
    INVALID_FIELD_PATH: {
        type: 'danger',
        message: {
            id: 'content-manager.preview.error.invalid-field-path',
            defaultMessage: 'Could not locate this field in the current document'
        }
    },
    RELATIONS_NOT_HANDLED: {
        type: 'info',
        message: {
            id: 'content-manager.preview.error.relations-not-handled',
            defaultMessage: 'Inline editing for relations is not currently supported.'
        }
    },
    INCOMPLETE_STRAPI_SOURCE: {
        type: 'danger',
        message: {
            id: 'content-manager.preview.error.incomplete-strapi-source',
            defaultMessage: 'This field is missing some required preview information'
        }
    },
    DIFFERENT_DOCUMENT: {
        type: 'info',
        message: {
            id: 'content-manager.preview.error.different-document',
            defaultMessage: 'This field comes from a different document'
        }
    }
};

exports.INTERNAL_EVENTS = INTERNAL_EVENTS;
exports.PREVIEW_ERROR_MESSAGES = PREVIEW_ERROR_MESSAGES;
exports.PUBLIC_EVENTS = PUBLIC_EVENTS;
//# sourceMappingURL=constants.js.map
