'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var Icons = require('@strapi/icons');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var styledComponents = require('styled-components');
var collections = require('../../constants/collections.js');
var DocumentRBAC = require('../../features/DocumentRBAC.js');
var useDocument = require('../../hooks/useDocument.js');
var useDocumentLayout = require('../../hooks/useDocumentLayout.js');
var Blocker = require('../../pages/EditView/components/Blocker.js');
var FormLayout = require('../../pages/EditView/components/FormLayout.js');
var data = require('../../pages/EditView/utils/data.js');
var api = require('../../utils/api.js');
var validation = require('../../utils/validation.js');
var InputPopover = require('../components/InputPopover.js');
var PreviewHeader = require('../components/PreviewHeader.js');
var preview = require('../services/preview.js');
var constants = require('../utils/constants.js');
var getSendMessage = require('../utils/getSendMessage.js');
var previewScript = require('../utils/previewScript.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

/* -------------------------------------------------------------------------------------------------
 * Constants
 * -----------------------------------------------------------------------------------------------*/ const DEVICES = [
    {
        name: 'desktop',
        label: {
            id: 'content-manager.preview.device.desktop',
            defaultMessage: 'Desktop'
        },
        width: '100%',
        height: '100%'
    },
    {
        name: 'mobile',
        label: {
            id: 'content-manager.preview.device.mobile',
            defaultMessage: 'Mobile'
        },
        width: '375px',
        height: '667px'
    }
];
const [PreviewProvider, usePreviewContext] = strapiAdmin.createContext('PreviewPage');
/* -------------------------------------------------------------------------------------------------
 * PreviewPage
 * -----------------------------------------------------------------------------------------------*/ const AnimatedArrow = styledComponents.styled(Icons.ArrowLineLeft)`
  will-change: transform;
  rotate: ${(props)=>props.$isSideEditorOpen ? '0deg' : '180deg'};
  transition: rotate 0.2s ease-in-out;
`;
const PreviewPage = ()=>{
    const location = reactRouterDom.useLocation();
    const { formatMessage } = reactIntl.useIntl();
    const iframeRef = React__namespace.useRef(null);
    const [isSideEditorOpen, setIsSideEditorOpen] = React__namespace.useState(true);
    const [popoverField, setPopoverField] = React__namespace.useState(null);
    const { toggleNotification } = strapiAdmin.useNotification();
    // Read all the necessary data from the URL to find the right preview URL
    const { slug: model, id: documentId, collectionType } = reactRouterDom.useParams();
    const [{ query }] = strapiAdmin.useQueryParams();
    const params = React__namespace.useMemo(()=>api.buildValidParams(query), [
        query
    ]);
    const [deviceName, setDeviceName] = React__namespace.useState(DEVICES[0].name);
    const device = DEVICES.find((d)=>d.name === deviceName) ?? DEVICES[0];
    // Listen for ready message from iframe before injecting script
    React__namespace.useEffect(()=>{
        const handleMessage = (event)=>{
            // Only listen to events from the preview iframe
            if (iframeRef.current) {
                const previewOrigin = new URL(iframeRef.current?.src).origin;
                if (event.origin !== previewOrigin) {
                    return;
                }
            }
            if (event.data?.type === constants.PUBLIC_EVENTS.PREVIEW_READY) {
                const script = `(${previewScript.previewScript.toString()})()`;
                const sendMessage = getSendMessage.getSendMessage(iframeRef);
                sendMessage(constants.PUBLIC_EVENTS.STRAPI_SCRIPT, {
                    script
                });
            }
        };
        window.addEventListener('message', handleMessage);
        return ()=>{
            window.removeEventListener('message', handleMessage);
        };
    }, [
        documentId,
        toggleNotification
    ]);
    if (!collectionType) {
        throw new Error('Could not find collectionType in url params');
    }
    if (!model) {
        throw new Error('Could not find model in url params');
    }
    // Only collection types must have a documentId
    if (collectionType === collections.COLLECTION_TYPES && !documentId) {
        throw new Error('Could not find documentId in url params');
    }
    const previewUrlResponse = preview.useGetPreviewUrlQuery({
        params: {
            contentType: model
        },
        query: {
            documentId,
            locale: params.locale,
            status: params.status
        }
    });
    const documentResponse = useDocument.useDocument({
        model,
        collectionType,
        documentId,
        params
    });
    const documentLayoutResponse = useDocumentLayout.useDocumentLayout(model);
    const isLoading = previewUrlResponse.isLoading || documentLayoutResponse.isLoading || documentResponse.isLoading;
    if (isLoading && (!documentResponse.document?.documentId || previewUrlResponse.isLoading)) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Loading, {});
    }
    const initialValues = documentResponse.getInitialFormValues();
    if (previewUrlResponse.error || documentLayoutResponse.error || !documentResponse.document || !documentResponse.meta || !documentResponse.schema || !initialValues) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Error, {});
    }
    if (!previewUrlResponse.data?.data?.url) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.NoData, {});
    }
    const documentTitle = documentResponse.getTitle(documentLayoutResponse.edit.settings.mainField);
    const validateSync = (values, options)=>{
        const { data: cleanedValues, removedAttributes } = data.handleInvisibleAttributes(values, {
            schema: documentResponse.schema,
            initialValues,
            components: documentResponse.components
        });
        const yupSchema = validation.createYupSchema(documentResponse.schema?.attributes, documentResponse.components, {
            status: documentResponse.document?.status,
            removedAttributes,
            ...options
        });
        return yupSchema.validateSync(cleanedValues, {
            abortEarly: false
        });
    };
    const previewUrl = previewUrlResponse.data.data.url;
    const onPreview = ()=>{
        iframeRef?.current?.contentWindow?.postMessage({
            type: 'strapiUpdate'
        }, // The iframe origin is safe to use since it must be provided through the allowedOrigins config
        new URL(iframeRef.current.src).origin);
    };
    const hasAdvancedPreview = window.strapi.features.isEnabled('cms-advanced-preview');
    return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Title, {
                children: formatMessage({
                    id: 'content-manager.preview.page-title',
                    defaultMessage: '{contentType} preview'
                }, {
                    contentType: documentTitle
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(PreviewProvider, {
                url: previewUrl,
                document: documentResponse.document,
                title: documentTitle,
                meta: documentResponse.meta,
                schema: documentResponse.schema,
                components: documentResponse.components,
                layout: documentLayoutResponse.edit,
                onPreview: onPreview,
                iframeRef: iframeRef,
                popoverField: popoverField,
                setPopoverField: setPopoverField,
                children: /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Form, {
                    method: "PUT",
                    disabled: query.status === 'published' && documentResponse && documentResponse.document.status !== 'draft',
                    initialValues: documentResponse.getInitialFormValues(),
                    initialErrors: location?.state?.forceValidation ? validateSync(initialValues, {}) : {},
                    height: "100%",
                    validate: (values, options)=>{
                        const { data: cleanedValues, removedAttributes } = data.handleInvisibleAttributes(values, {
                            schema: documentResponse.schema,
                            initialValues,
                            components: documentResponse.components
                        });
                        const yupSchema = validation.createYupSchema(documentResponse.schema?.attributes, documentResponse.components, {
                            status: documentResponse.document?.status,
                            removedAttributes,
                            ...options
                        });
                        return yupSchema.validate(cleanedValues, {
                            abortEarly: false
                        });
                    },
                    children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                        direction: "column",
                        height: "100%",
                        alignItems: "stretch",
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsx(Blocker.Blocker, {}),
                            /*#__PURE__*/ jsxRuntime.jsx(PreviewHeader.PreviewHeader, {}),
                            /*#__PURE__*/ jsxRuntime.jsx(InputPopover.InputPopover, {
                                documentResponse: documentResponse
                            }),
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                flex: 1,
                                overflow: "auto",
                                alignItems: "stretch",
                                children: [
                                    hasAdvancedPreview && /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                        overflow: "auto",
                                        width: isSideEditorOpen ? '50%' : 0,
                                        borderWidth: "0 1px 0 0",
                                        borderColor: "neutral150",
                                        paddingTop: 6,
                                        paddingBottom: 6,
                                        // Remove horizontal padding when the editor is closed or it won't fully disappear
                                        paddingLeft: isSideEditorOpen ? 6 : 0,
                                        paddingRight: isSideEditorOpen ? 6 : 0,
                                        transition: "all 0.2s ease-in-out",
                                        children: /*#__PURE__*/ jsxRuntime.jsx(FormLayout.FormLayout, {
                                            layout: documentLayoutResponse.edit.layout,
                                            document: documentResponse,
                                            hasBackground: false
                                        })
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                        direction: "column",
                                        alignItems: "stretch",
                                        flex: 1,
                                        height: "100%",
                                        overflow: "hidden",
                                        children: [
                                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                                direction: "row",
                                                background: "neutral0",
                                                padding: 2,
                                                borderWidth: "0 0 1px 0",
                                                borderColor: "neutral150",
                                                children: [
                                                    hasAdvancedPreview && /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                                                        variant: "ghost",
                                                        label: formatMessage(isSideEditorOpen ? {
                                                            id: 'content-manager.preview.content.close-editor',
                                                            defaultMessage: 'Close editor'
                                                        } : {
                                                            id: 'content-manager.preview.content.open-editor',
                                                            defaultMessage: 'Open editor'
                                                        }),
                                                        onClick: ()=>setIsSideEditorOpen((prev)=>!prev),
                                                        children: /*#__PURE__*/ jsxRuntime.jsx(AnimatedArrow, {
                                                            $isSideEditorOpen: isSideEditorOpen
                                                        })
                                                    }),
                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                                                        justifyContent: "center",
                                                        flex: 1,
                                                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.SingleSelect, {
                                                            value: deviceName,
                                                            onChange: (name)=>setDeviceName(name.toString()),
                                                            "aria-label": formatMessage({
                                                                id: 'content-manager.preview.device.select',
                                                                defaultMessage: 'Select device type'
                                                            }),
                                                            children: DEVICES.map((deviceOption)=>/*#__PURE__*/ jsxRuntime.jsx(designSystem.SingleSelectOption, {
                                                                    value: deviceOption.name,
                                                                    children: formatMessage(deviceOption.label)
                                                                }, deviceOption.name))
                                                        })
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                                                direction: "column",
                                                justifyContent: "center",
                                                background: "neutral0",
                                                flex: 1,
                                                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                                    "data-testid": "preview-iframe",
                                                    ref: iframeRef,
                                                    src: previewUrl,
                                                    title: formatMessage({
                                                        id: 'content-manager.preview.panel.title',
                                                        defaultMessage: 'Preview'
                                                    }),
                                                    width: device.width,
                                                    height: device.height,
                                                    borderWidth: 0,
                                                    tag: "iframe"
                                                }, previewUrl)
                                            })
                                        ]
                                    })
                                ]
                            })
                        ]
                    })
                })
            })
        ]
    });
};
/* -------------------------------------------------------------------------------------------------
 * ProtectedPreviewPage
 * -----------------------------------------------------------------------------------------------*/ const ProtectedPreviewPageImpl = ()=>{
    const { slug: model } = reactRouterDom.useParams();
    const { permissions = [], isLoading, error } = strapiAdmin.useRBAC([
        {
            action: 'plugin::content-manager.explorer.read',
            subject: model
        },
        {
            action: 'plugin::content-manager.explorer.update',
            subject: model
        },
        {
            action: 'plugin::content-manager.explorer.publish',
            subject: model
        }
    ]);
    if (isLoading) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Loading, {});
    }
    if (error || !model) {
        return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
            height: "100dvh",
            width: "100dvw",
            position: "fixed",
            top: 0,
            left: 0,
            zIndex: 5,
            background: "neutral0",
            children: /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Error, {})
        });
    }
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
        height: "100dvh",
        width: "100dvw",
        position: "fixed",
        top: 0,
        left: 0,
        zIndex: 5,
        background: "neutral0",
        children: /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Protect, {
            permissions: permissions.filter((permission)=>permission.action.includes('explorer.read')),
            children: /*#__PURE__*/ jsxRuntime.jsx(DocumentRBAC.DocumentRBAC, {
                permissions: permissions,
                children: /*#__PURE__*/ jsxRuntime.jsx(PreviewPage, {})
            })
        })
    });
};
const ProtectedPreviewPage = ()=>{
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Portal, {
        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.FocusTrap, {
            children: /*#__PURE__*/ jsxRuntime.jsx(ProtectedPreviewPageImpl, {})
        })
    });
};

exports.ProtectedPreviewPage = ProtectedPreviewPage;
exports.usePreviewContext = usePreviewContext;
//# sourceMappingURL=Preview.js.map
