'use strict';

var jsxRuntime = require('react/jsx-runtime');
require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var Icons = require('@strapi/icons');
var qs = require('qs');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var styledComponents = require('styled-components');
var InjectionZone = require('../../components/InjectionZone.js');
var DocumentActions = require('../../pages/EditView/components/DocumentActions.js');
var DocumentStatus = require('../../pages/EditView/components/DocumentStatus.js');
var EditViewPage = require('../../pages/EditView/EditViewPage.js');
var Preview = require('../pages/Preview.js');

/* -------------------------------------------------------------------------------------------------
 * ClosePreviewButton
 * -----------------------------------------------------------------------------------------------*/ const ClosePreviewButton = ()=>{
    const [{ query }] = strapiAdmin.useQueryParams();
    const { formatMessage } = reactIntl.useIntl();
    const canGoBack = strapiAdmin.useHistory('BackButton', (state)=>state.canGoBack);
    const goBack = strapiAdmin.useHistory('BackButton', (state)=>state.goBack);
    const history = strapiAdmin.useHistory('BackButton', (state)=>state.history);
    const locationIndex = strapiAdmin.useHistory('BackButton', (state)=>state.currentLocationIndex);
    /**
   * Get the link destination from the history.
   * Rely on a fallback (the parent edit view page) if there's no page to go back .
   */ const historyTo = canGoBack ? history.at(locationIndex - 2) : undefined;
    const fallback = {
        pathname: '..',
        search: qs.stringify(query, {
            encode: false
        })
    };
    const toWithFallback = historyTo ?? fallback;
    const handleClick = (e)=>{
        if (canGoBack) {
            // Prevent normal link behavior, go back in the history stack instead
            e.preventDefault();
            goBack();
            return;
        }
    // Otherwise rely on native link behavior to go back to the edit view. We don't use navigate()
    // here in order to get the relative="path" functionality from the Link component.
    };
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
        variant: "ghost",
        tag: reactRouterDom.Link,
        relative: "path",
        to: toWithFallback,
        onClick: handleClick,
        label: formatMessage({
            id: 'content-manager.preview.header.close',
            defaultMessage: 'Close preview'
        }),
        children: /*#__PURE__*/ jsxRuntime.jsx(Icons.Cross, {})
    });
};
/* -------------------------------------------------------------------------------------------------
 * Status
 * -----------------------------------------------------------------------------------------------*/ const Status = ()=>{
    // Get status
    const document = Preview.usePreviewContext('PreviewHeader', (state)=>state.document);
    const schema = Preview.usePreviewContext('PreviewHeader', (state)=>state.schema);
    const meta = Preview.usePreviewContext('PreviewHeader', (state)=>state.meta);
    const hasDraftAndPublished = schema?.options?.draftAndPublish ?? false;
    if (!hasDraftAndPublished) {
        return null;
    }
    const status = EditViewPage.getDocumentStatus(document, meta);
    return /*#__PURE__*/ jsxRuntime.jsx(DocumentStatus.DocumentStatus, {
        status: status,
        size: "XS"
    });
};
const PreviewTabs = ()=>{
    const { formatMessage } = reactIntl.useIntl();
    // URL query params
    const [{ query }, setQuery] = strapiAdmin.useQueryParams();
    // Get status
    const document = Preview.usePreviewContext('PreviewHeader', (state)=>state.document);
    const schema = Preview.usePreviewContext('PreviewHeader', (state)=>state.schema);
    const meta = Preview.usePreviewContext('PreviewHeader', (state)=>state.meta);
    const hasDraftAndPublish = schema?.options?.draftAndPublish ?? false;
    const documentStatus = EditViewPage.getDocumentStatus(document, meta);
    const handleTabChange = (status)=>{
        if (status === 'published' || status === 'draft') {
            setQuery({
                status
            }, 'push', true);
        }
    };
    if (!hasDraftAndPublish) {
        return null;
    }
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tabs.Root, {
        variant: "simple",
        value: query.status || 'draft',
        onValueChange: handleTabChange,
        children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Tabs.List, {
            "aria-label": formatMessage({
                id: 'preview.tabs.label',
                defaultMessage: 'Document status'
            }),
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(StatusTab, {
                    value: "draft",
                    children: formatMessage({
                        id: 'content-manager.containers.List.draft',
                        defaultMessage: 'draft'
                    })
                }),
                /*#__PURE__*/ jsxRuntime.jsx(StatusTab, {
                    value: "published",
                    disabled: documentStatus === 'draft',
                    children: formatMessage({
                        id: 'content-manager.containers.List.published',
                        defaultMessage: 'published'
                    })
                })
            ]
        })
    });
};
/* -------------------------------------------------------------------------------------------------
 * PreviewHeader
 * -----------------------------------------------------------------------------------------------*/ const PreviewHeader = ()=>{
    const title = Preview.usePreviewContext('PreviewHeader', (state)=>state.title);
    const document = Preview.usePreviewContext('PreviewHeader', (state)=>state.document);
    const schema = Preview.usePreviewContext('PreviewHeader', (state)=>state.schema);
    const meta = Preview.usePreviewContext('PreviewHeader', (state)=>state.meta);
    const plugins = strapiAdmin.useStrapiApp('PreviewHeader', (state)=>state.plugins);
    const [{ query }] = strapiAdmin.useQueryParams();
    const { formatMessage } = reactIntl.useIntl();
    const { toggleNotification } = strapiAdmin.useNotification();
    const { copy } = strapiAdmin.useClipboard();
    const handleCopyLink = ()=>{
        copy(window.location.href);
        toggleNotification({
            message: formatMessage({
                id: 'content-manager.preview.copy.success',
                defaultMessage: 'Copied preview link'
            }),
            type: 'success'
        });
    };
    const hasDraftAndPublish = schema.options?.draftAndPublish ?? false;
    const documentActionProps = {
        activeTab: query.status ?? null,
        collectionType: schema.kind === 'collectionType' ? 'collection-types' : 'single-types',
        model: schema.uid,
        documentId: schema.kind === 'collectionType' ? document.documentId : undefined,
        document,
        meta
    };
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
        height: "48px",
        gap: 4,
        background: "neutral0",
        borderColor: "neutral150",
        tag: "header",
        children: [
            /*#__PURE__*/ jsxRuntime.jsxs(TitleContainer, {
                height: "100%",
                paddingLeft: 2,
                paddingRight: 4,
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(ClosePreviewButton, {}),
                    /*#__PURE__*/ jsxRuntime.jsx(PreviewTitle, {
                        tag: "h1",
                        title: title,
                        maxWidth: "200px",
                        fontSize: 2,
                        paddingLeft: 2,
                        paddingRight: 3,
                        fontWeight: 600,
                        children: title
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(Status, {})
                ]
            }),
            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                flex: 1,
                paddingRight: 2,
                gap: 2,
                justifyContent: hasDraftAndPublish ? 'space-between' : 'flex-end',
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                        flex: "1 1 70%",
                        children: /*#__PURE__*/ jsxRuntime.jsx(PreviewTabs, {})
                    }),
                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                        gap: 2,
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                                label: formatMessage({
                                    id: 'preview.copy.label',
                                    defaultMessage: 'Copy preview link'
                                }),
                                onClick: handleCopyLink,
                                children: /*#__PURE__*/ jsxRuntime.jsx(Icons.Link, {})
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(InjectionZone.InjectionZone, {
                                area: "preview.actions"
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.DescriptionComponentRenderer, {
                                props: documentActionProps,
                                descriptions: plugins['content-manager'].apis.getDocumentActions('preview'),
                                children: (actions)=>{
                                    const filteredActions = actions.filter((action)=>[
                                            action.position
                                        ].flat().includes('preview'));
                                    const [primaryAction, secondaryAction] = filteredActions;
                                    if (!primaryAction && !secondaryAction) return null;
                                    // Both actions are available when draft and publish enabled
                                    if (primaryAction && secondaryAction) {
                                        return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                                            children: [
                                                /*#__PURE__*/ jsxRuntime.jsx(DocumentActions.DocumentActionButton, {
                                                    ...secondaryAction,
                                                    variant: secondaryAction.variant || 'secondary'
                                                }),
                                                /*#__PURE__*/ jsxRuntime.jsx(DocumentActions.DocumentActionButton, {
                                                    ...primaryAction,
                                                    variant: primaryAction.variant || 'default'
                                                })
                                            ]
                                        });
                                    }
                                    // Otherwise we just have the save action
                                    return /*#__PURE__*/ jsxRuntime.jsx(DocumentActions.DocumentActionButton, {
                                        ...primaryAction,
                                        variant: primaryAction.variant || 'secondary'
                                    });
                                }
                            })
                        ]
                    })
                ]
            })
        ]
    });
};
const PreviewTitle = styledComponents.styled(designSystem.Typography)`
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`;
const StatusTab = styledComponents.styled(designSystem.Tabs.Trigger)`
  text-transform: uppercase;
`;
const TitleContainer = styledComponents.styled(designSystem.Flex)`
  border-right: 1px solid ${({ theme })=>theme.colors.neutral150};
`;

exports.PreviewHeader = PreviewHeader;
//# sourceMappingURL=PreviewHeader.js.map
