'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var reactIntl = require('react-intl');
var attributes = require('../../../constants/attributes.js');
var useContentTypeSchema = require('../../../hooks/useContentTypeSchema.js');
var useDebounce = require('../../../hooks/useDebounce.js');
var contentTypes = require('../../../services/contentTypes.js');
var attributes$1 = require('../../../utils/attributes.js');
var users = require('../../../utils/users.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

/**
 * If new attributes are added, this list needs to be updated.
 */ const NOT_ALLOWED_FILTERS = [
    'json',
    'component',
    'media',
    'richtext',
    'dynamiczone',
    'password',
    'blocks'
];
const DEFAULT_ALLOWED_FILTERS = [
    'createdAt',
    'updatedAt'
];
const USER_FILTER_ATTRIBUTES = [
    ...attributes.CREATOR_FIELDS,
    'strapi_assignee'
];
const FiltersImpl = ({ disabled, schema })=>{
    const { attributes: attributes$2, uid: model, options } = schema;
    const { formatMessage, locale } = reactIntl.useIntl();
    const { trackUsage } = strapiAdmin.useTracking();
    const allPermissions = strapiAdmin.useAuth('FiltersImpl', (state)=>state.permissions);
    const [{ query }] = strapiAdmin.useQueryParams();
    const { schemas } = useContentTypeSchema.useContentTypeSchema();
    const canReadAdminUsers = React__namespace.useMemo(()=>allPermissions.filter((permission)=>permission.action === 'admin::users.read' && permission.subject === null).length > 0, [
        allPermissions
    ]);
    const selectedUserIds = (query?.filters?.$and ?? []).reduce((acc, filter)=>{
        const [key, value] = Object.entries(filter)[0];
        if (typeof value.id !== 'object') {
            return acc;
        }
        const id = value.id.$eq || value.id.$ne;
        // Check if the attribute is a relation to admin::user
        const attribute = attributes$2[key];
        const isAdminUserRelation = attribute?.type === 'relation' && 'target' in attribute && attribute.target === 'admin::user';
        if (id && (isAdminUserRelation || USER_FILTER_ATTRIBUTES.includes(key)) && !acc.includes(id)) {
            acc.push(id);
        }
        return acc;
    }, []);
    const { data: userData, isLoading: isLoadingAdminUsers } = strapiAdmin.useAdminUsers({
        filters: {
            id: {
                $in: selectedUserIds
            }
        }
    }, {
        // fetch the list of admin users only if the filter contains users and the
        // current user has permissions to display users
        skip: selectedUserIds.length === 0 || !canReadAdminUsers
    });
    const { users: users$1 = [] } = userData ?? {};
    const { metadata } = contentTypes.useGetContentTypeConfigurationQuery(model, {
        selectFromResult: ({ data })=>({
                metadata: data?.contentType.metadatas ?? {}
            })
    });
    const formatter = designSystem.useCollator(locale, {
        sensitivity: 'base'
    });
    const displayedFilters = React__namespace.useMemo(()=>{
        const [{ properties: { fields = [] } = {
            fields: []
        } }] = allPermissions.filter((permission)=>permission.action === 'plugin::content-manager.explorer.read' && permission.subject === model);
        const allowedFields = fields.filter((field)=>{
            const attribute = attributes$2[field] ?? {};
            return attribute.type && !NOT_ALLOWED_FILTERS.includes(attribute.type);
        });
        return [
            'id',
            'documentId',
            ...allowedFields,
            ...DEFAULT_ALLOWED_FILTERS,
            ...canReadAdminUsers ? attributes.CREATOR_FIELDS : []
        ].map((name)=>{
            const attribute = attributes$2[name];
            if (NOT_ALLOWED_FILTERS.includes(attribute.type)) {
                return null;
            }
            const { mainField: mainFieldName = '', label } = metadata[name].list;
            let filter = {
                name,
                label: label ?? '',
                mainField: attributes$1.getMainField(attribute, mainFieldName, {
                    schemas,
                    components: {}
                }),
                // @ts-expect-error – TODO: this is filtered out above in the `allowedFields` call but TS complains, is there a better way to solve this?
                type: attribute.type
            };
            if (attribute.type === 'relation' && 'target' in attribute && attribute.target === 'admin::user') {
                filter = {
                    ...filter,
                    input: AdminUsersFilter,
                    options: users$1.map((user)=>({
                            label: users.getDisplayName(user),
                            value: user.id.toString()
                        })),
                    operators: [
                        {
                            label: formatMessage({
                                id: 'components.FilterOptions.FILTER_TYPES.$eq',
                                defaultMessage: 'is'
                            }),
                            value: '$eq'
                        },
                        {
                            label: formatMessage({
                                id: 'components.FilterOptions.FILTER_TYPES.$ne',
                                defaultMessage: 'is not'
                            }),
                            value: '$ne'
                        }
                    ],
                    mainField: {
                        name: 'id',
                        type: 'integer'
                    }
                };
            }
            if (attribute.type === 'enumeration') {
                filter = {
                    ...filter,
                    options: attribute.enum.map((value)=>({
                            label: value,
                            value
                        }))
                };
            }
            return filter;
        }).filter(Boolean).toSorted((a, b)=>formatter.compare(a.label, b.label));
    }, [
        allPermissions,
        canReadAdminUsers,
        model,
        attributes$2,
        metadata,
        schemas,
        users$1,
        formatMessage,
        formatter
    ]);
    const onOpenChange = (isOpen)=>{
        if (isOpen) {
            trackUsage('willFilterEntries');
        }
    };
    const handleFilterChange = (data)=>{
        const attribute = attributes$2[data.name];
        if (attribute) {
            trackUsage('didFilterEntries', {
                useRelation: attribute.type === 'relation'
            });
        }
    };
    return /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Filters.Root, {
        disabled: disabled,
        options: displayedFilters,
        onOpenChange: onOpenChange,
        onChange: handleFilterChange,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Filters.Trigger, {}),
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Filters.Popover, {
                zIndex: 499
            }),
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Filters.List, {})
        ]
    });
};
/* -------------------------------------------------------------------------------------------------
 * AdminUsersFilter
 * -----------------------------------------------------------------------------------------------*/ const AdminUsersFilter = ({ name })=>{
    const [pageSize, setPageSize] = React__namespace.useState(10);
    const [search, setSearch] = React__namespace.useState('');
    const { formatMessage } = reactIntl.useIntl();
    const debouncedSearch = useDebounce.useDebounce(search, 300);
    const { data, isLoading } = strapiAdmin.useAdminUsers({
        pageSize,
        _q: debouncedSearch
    });
    const field = strapiAdmin.useField(name);
    const handleOpenChange = (isOpen)=>{
        if (!isOpen) {
            setPageSize(10);
        }
    };
    const { users: users$1 = [], pagination } = data ?? {};
    const { pageCount = 1, page = 1 } = pagination ?? {};
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Combobox, {
        value: field.value,
        "aria-label": formatMessage({
            id: 'content-manager.components.Filters.usersSelect.label',
            defaultMessage: 'Search and select a user to filter'
        }),
        onOpenChange: handleOpenChange,
        onChange: (value)=>field.onChange(name, value),
        loading: isLoading,
        onLoadMore: ()=>setPageSize(pageSize + 10),
        hasMoreItems: page < pageCount,
        onInputChange: (e)=>{
            setSearch(e.currentTarget.value);
        },
        children: users$1.map((user)=>{
            return /*#__PURE__*/ jsxRuntime.jsx(designSystem.ComboboxOption, {
                value: user.id.toString(),
                children: users.getDisplayName(user)
            }, user.id);
        })
    });
};

exports.Filters = FiltersImpl;
//# sourceMappingURL=Filters.js.map
