'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var Icons = require('@strapi/icons');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var styledComponents = require('styled-components');
var yup = require('yup');
var DocumentRBAC = require('../../../../features/DocumentRBAC.js');
var useContentTypeSchema = require('../../../../hooks/useContentTypeSchema.js');
var useDocumentActions = require('../../../../hooks/useDocumentActions.js');
var useDocumentLayout = require('../../../../hooks/useDocumentLayout.js');
var api$1 = require('../../../../services/api.js');
var documents = require('../../../../services/documents.js');
var api = require('../../../../utils/api.js');
var translations = require('../../../../utils/translations.js');
var validation = require('../../../../utils/validation.js');
var DocumentStatus = require('../../../EditView/components/DocumentStatus.js');
var ConfirmBulkActionDialog = require('./ConfirmBulkActionDialog.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const TypographyMaxWidth = styledComponents.styled(designSystem.Typography)`
  max-width: 300px;
`;
const TableComponent = styledComponents.styled(designSystem.RawTable)`
  width: 100%;
  table-layout: fixed;
  td:first-child {
    border-right: 1px solid ${({ theme })=>theme.colors.neutral150};
  }
  td:first-of-type {
    padding: ${({ theme })=>theme.spaces[4]};
  }
`;
/* -------------------------------------------------------------------------------------------------
 * EntryValidationText
 * -----------------------------------------------------------------------------------------------*/ const formatErrorMessages = (errors, parentKey, formatMessage)=>{
    const messages = [];
    Object.entries(errors).forEach(([key, value])=>{
        const currentKey = parentKey ? `${parentKey}.${key}` : key;
        if (typeof value === 'object' && value !== null && !Array.isArray(value)) {
            if ('id' in value && 'defaultMessage' in value) {
                messages.push(formatMessage({
                    id: `${value.id}.withField`,
                    defaultMessage: value.defaultMessage
                }, {
                    field: currentKey
                }));
            } else {
                messages.push(...formatErrorMessages(// @ts-expect-error TODO: check why value is not compatible with FormErrors
                value, currentKey, formatMessage));
            }
        } else {
            messages.push(formatMessage({
                id: `${value}.withField`,
                defaultMessage: value
            }, {
                field: currentKey
            }));
        }
    });
    return messages;
};
const EntryValidationText = ({ validationErrors, status })=>{
    const { formatMessage } = reactIntl.useIntl();
    if (validationErrors) {
        const validationErrorsMessages = formatErrorMessages(validationErrors, '', formatMessage).join(' ');
        return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
            gap: 2,
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(Icons.CrossCircle, {
                    fill: "danger600"
                }),
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tooltip, {
                    label: validationErrorsMessages,
                    children: /*#__PURE__*/ jsxRuntime.jsx(TypographyMaxWidth, {
                        textColor: "danger600",
                        variant: "omega",
                        fontWeight: "bold",
                        ellipsis: true,
                        children: validationErrorsMessages
                    })
                })
            ]
        });
    }
    if (status === 'published') {
        return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
            gap: 2,
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(Icons.CheckCircle, {
                    fill: "success600"
                }),
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                    textColor: "success600",
                    fontWeight: "bold",
                    children: formatMessage({
                        id: 'content-manager.bulk-publish.already-published',
                        defaultMessage: 'Already Published'
                    })
                })
            ]
        });
    }
    if (status === 'modified') {
        return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
            gap: 2,
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(Icons.ArrowsCounterClockwise, {
                    fill: "alternative600"
                }),
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                    textColor: "alternative600",
                    fontWeight: "bold",
                    children: formatMessage({
                        id: 'content-manager.bulk-publish.modified',
                        defaultMessage: 'Ready to publish changes'
                    })
                })
            ]
        });
    }
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
        gap: 2,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(Icons.CheckCircle, {
                fill: "success600"
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                textColor: "success600",
                fontWeight: "bold",
                children: formatMessage({
                    id: 'app.utils.ready-to-publish',
                    defaultMessage: 'Ready to publish'
                })
            })
        ]
    });
};
const TABLE_HEADERS = [
    {
        name: 'id',
        label: 'id'
    },
    {
        name: 'name',
        label: 'name'
    },
    {
        name: 'status',
        label: 'status'
    },
    {
        name: 'publicationStatus',
        label: 'Publication status'
    }
];
const SelectedEntriesTableContent = ({ isPublishing, rowsToDisplay = [], entriesToPublish = [], validationErrors = {} })=>{
    const { pathname } = reactRouterDom.useLocation();
    const { formatMessage } = reactIntl.useIntl();
    const { list: { settings: { mainField } } } = useDocumentLayout.useDocLayout();
    const shouldDisplayMainField = mainField != null && mainField !== 'id';
    return /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Table.Content, {
        children: [
            /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Table.Head, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.HeaderCheckboxCell, {}),
                    TABLE_HEADERS.filter((head)=>head.name !== 'name' || shouldDisplayMainField).map((head)=>/*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.HeaderCell, {
                            ...head
                        }, head.name))
                ]
            }),
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Loading, {}),
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Body, {
                children: rowsToDisplay.map((row)=>/*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Table.Row, {
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.CheckboxCell, {
                                id: row.id
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Cell, {
                                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                    children: row.id
                                })
                            }),
                            shouldDisplayMainField && /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Cell, {
                                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                    children: row[mainField]
                                })
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Cell, {
                                children: /*#__PURE__*/ jsxRuntime.jsx(DocumentStatus.DocumentStatus, {
                                    status: row.status,
                                    maxWidth: 'min-content'
                                })
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Cell, {
                                children: isPublishing && entriesToPublish.includes(row.documentId) ? /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                    gap: 2,
                                    children: [
                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                            children: formatMessage({
                                                id: 'content-manager.success.record.publishing',
                                                defaultMessage: 'Publishing...'
                                            })
                                        }),
                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Loader, {
                                            small: true
                                        })
                                    ]
                                }) : /*#__PURE__*/ jsxRuntime.jsx(EntryValidationText, {
                                    validationErrors: validationErrors[row.documentId],
                                    status: row.status
                                })
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Cell, {
                                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                                        tag: reactRouterDom.Link,
                                        to: {
                                            pathname: `${pathname}/${row.documentId}`,
                                            search: row.locale && `?plugins[i18n][locale]=${row.locale}`
                                        },
                                        state: {
                                            from: pathname
                                        },
                                        label: formatMessage({
                                            id: 'content-manager.bulk-publish.edit',
                                            defaultMessage: 'Edit'
                                        }),
                                        target: "_blank",
                                        marginLeft: "auto",
                                        variant: "ghost",
                                        children: /*#__PURE__*/ jsxRuntime.jsx(Icons.Pencil, {
                                            width: '1.6rem',
                                            height: '1.6rem'
                                        })
                                    })
                                })
                            })
                        ]
                    }, row.id))
            })
        ]
    });
};
const PublicationStatusSummary = ({ count, icon, message, textColor })=>{
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
        justifyContent: "space-between",
        flex: 1,
        gap: 3,
        children: [
            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                gap: 2,
                children: [
                    icon,
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                        textColor: textColor,
                        fontWeight: "bold",
                        children: message
                    })
                ]
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                fontWeight: "bold",
                children: count
            })
        ]
    });
};
const PublicationStatusGrid = ({ entriesReadyToPublishCount, entriesPublishedCount, entriesModifiedCount, entriesWithErrorsCount })=>{
    const { formatMessage } = reactIntl.useIntl();
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
        hasRadius: true,
        borderColor: "neutral150",
        children: /*#__PURE__*/ jsxRuntime.jsx(TableComponent, {
            colCount: 2,
            rowCount: 2,
            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Tbody, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Tr, {
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Td, {
                                children: /*#__PURE__*/ jsxRuntime.jsx(PublicationStatusSummary, {
                                    textColor: "success600",
                                    count: entriesReadyToPublishCount,
                                    icon: /*#__PURE__*/ jsxRuntime.jsx(Icons.CheckCircle, {
                                        fill: "success600"
                                    }),
                                    message: formatMessage({
                                        id: 'app.utils.ready-to-publish',
                                        defaultMessage: 'Ready to publish'
                                    })
                                })
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Td, {
                                children: /*#__PURE__*/ jsxRuntime.jsx(PublicationStatusSummary, {
                                    textColor: "success600",
                                    count: entriesPublishedCount,
                                    icon: /*#__PURE__*/ jsxRuntime.jsx(Icons.CheckCircle, {
                                        fill: "success600"
                                    }),
                                    message: formatMessage({
                                        id: 'app.utils.already-published',
                                        defaultMessage: 'Already published'
                                    })
                                })
                            })
                        ]
                    }),
                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Tr, {
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Td, {
                                children: /*#__PURE__*/ jsxRuntime.jsx(PublicationStatusSummary, {
                                    textColor: "alternative600",
                                    count: entriesModifiedCount,
                                    icon: /*#__PURE__*/ jsxRuntime.jsx(Icons.ArrowsCounterClockwise, {
                                        fill: "alternative600"
                                    }),
                                    message: formatMessage({
                                        id: 'content-manager.bulk-publish.modified',
                                        defaultMessage: 'Ready to publish changes'
                                    })
                                })
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Td, {
                                children: /*#__PURE__*/ jsxRuntime.jsx(PublicationStatusSummary, {
                                    textColor: "danger600",
                                    count: entriesWithErrorsCount,
                                    icon: /*#__PURE__*/ jsxRuntime.jsx(Icons.CrossCircle, {
                                        fill: "danger600"
                                    }),
                                    message: formatMessage({
                                        id: 'content-manager.bulk-publish.waiting-for-action',
                                        defaultMessage: 'Waiting for action'
                                    })
                                })
                            })
                        ]
                    })
                ]
            })
        })
    });
};
const SelectedEntriesModalContent = ({ listViewSelectedEntries, toggleModal, setListViewSelectedDocuments, model })=>{
    const { formatMessage } = reactIntl.useIntl();
    const { schema, components } = useContentTypeSchema.useContentTypeSchema(model);
    const documentIds = listViewSelectedEntries.map(({ documentId })=>documentId);
    // We want to keep the selected entries order same as the list view
    const [{ query }] = strapiAdmin.useQueryParams();
    const params = React__namespace.useMemo(()=>api.buildValidParams(query), [
        query
    ]);
    // Fetch the documents based on the selected entries and update the modal table
    const { data, isLoading, isFetching, refetch } = documents.useGetAllDocumentsQuery({
        model,
        params: {
            page: '1',
            pageSize: documentIds.length.toString(),
            sort: query.sort,
            filters: {
                documentId: {
                    $in: documentIds
                }
            },
            locale: query.plugins?.i18n?.locale
        }
    }, {
        selectFromResult: ({ data, ...restRes })=>({
                data: data?.results ?? [],
                ...restRes
            })
    });
    // Validate the entries based on the schema to show errors if any
    const { rows, validationErrors } = React__namespace.useMemo(()=>{
        if (data.length > 0 && schema) {
            const validate = validation.createYupSchema(schema.attributes, components, // Since this is the "Publish" action, the validation
            // schema must enforce the rules for published entities
            {
                status: 'published'
            });
            const validationErrors = {};
            const rows = data.map((entry)=>{
                try {
                    validate.validateSync(entry, {
                        abortEarly: false
                    });
                    return entry;
                } catch (e) {
                    if (e instanceof yup.ValidationError) {
                        validationErrors[entry.documentId] = strapiAdmin.getYupValidationErrors(e);
                    }
                    return entry;
                }
            });
            return {
                rows,
                validationErrors
            };
        }
        return {
            rows: [],
            validationErrors: {}
        };
    }, [
        components,
        data,
        schema
    ]);
    const [isDialogOpen, setIsDialogOpen] = React__namespace.useState(false);
    const { publishMany: bulkPublishAction, isLoading: isPublishing } = useDocumentActions.useDocumentActions();
    const [, { isLoading: isSubmittingForm }] = documents.usePublishManyDocumentsMutation();
    const selectedRows = strapiAdmin.useTable('publishAction', (state)=>state.selectedRows);
    // Filter selected entries from the updated modal table rows
    const selectedEntries = rows.filter((entry)=>selectedRows.some((selectedEntry)=>selectedEntry.documentId === entry.documentId));
    const entriesToPublish = selectedEntries.filter((entry)=>!validationErrors[entry.documentId]).map((entry)=>entry.documentId);
    const selectedEntriesWithErrorsCount = selectedEntries.filter(({ documentId })=>validationErrors[documentId]).length;
    const selectedEntriesPublishedCount = selectedEntries.filter(({ status })=>status === 'published').length;
    const selectedEntriesModifiedCount = selectedEntries.filter(({ status, documentId })=>status === 'modified' && !validationErrors[documentId]).length;
    const selectedEntriesWithNoErrorsCount = selectedEntries.length - selectedEntriesWithErrorsCount - selectedEntriesPublishedCount;
    const toggleDialog = ()=>setIsDialogOpen((prev)=>!prev);
    const handleConfirmBulkPublish = async ()=>{
        toggleDialog();
        const res = await bulkPublishAction({
            model: model,
            documentIds: entriesToPublish,
            params
        });
        if (!('error' in res)) {
            const unpublishedEntries = rows.filter((row)=>{
                return !entriesToPublish.includes(row.documentId);
            });
            // Keep selection of the entries in list view that were not published
            setListViewSelectedDocuments(unpublishedEntries);
        }
    };
    return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
        children: [
            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Modal.Body, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(PublicationStatusGrid, {
                        entriesReadyToPublishCount: selectedEntriesWithNoErrorsCount - selectedEntriesModifiedCount,
                        entriesPublishedCount: selectedEntriesPublishedCount,
                        entriesModifiedCount: selectedEntriesModifiedCount,
                        entriesWithErrorsCount: selectedEntriesWithErrorsCount
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                        marginTop: 7,
                        children: /*#__PURE__*/ jsxRuntime.jsx(SelectedEntriesTableContent, {
                            isPublishing: isSubmittingForm,
                            rowsToDisplay: rows,
                            entriesToPublish: entriesToPublish,
                            validationErrors: validationErrors
                        })
                    })
                ]
            }),
            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Modal.Footer, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                        onClick: toggleModal,
                        variant: "tertiary",
                        children: formatMessage({
                            id: 'app.components.Button.cancel',
                            defaultMessage: 'Cancel'
                        })
                    }),
                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                        gap: 2,
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                                onClick: refetch,
                                variant: "tertiary",
                                loading: isFetching,
                                children: formatMessage({
                                    id: 'app.utils.refresh',
                                    defaultMessage: 'Refresh'
                                })
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                                onClick: toggleDialog,
                                disabled: selectedEntries.length === 0 || selectedEntries.length === selectedEntriesWithErrorsCount || selectedEntriesPublishedCount === selectedEntries.length || isLoading,
                                loading: isPublishing || isSubmittingForm,
                                children: formatMessage({
                                    id: 'app.utils.publish',
                                    defaultMessage: 'Publish'
                                })
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ jsxRuntime.jsx(ConfirmBulkActionDialog.ConfirmDialogPublishAll, {
                isOpen: isDialogOpen,
                onToggleDialog: toggleDialog,
                isConfirmButtonLoading: isPublishing || isSubmittingForm,
                onConfirm: handleConfirmBulkPublish
            })
        ]
    });
};
/* -------------------------------------------------------------------------------------------------
 * PublishAction
 * -----------------------------------------------------------------------------------------------*/ const PublishAction = ({ documents, model })=>{
    const { formatMessage } = reactIntl.useIntl();
    // Publish button visibility
    const hasPublishPermission = DocumentRBAC.useDocumentRBAC('unpublishAction', (state)=>state.canPublish);
    const showPublishButton = hasPublishPermission && documents.some(({ status })=>status !== 'published');
    const setListViewSelectedDocuments = strapiAdmin.useTable('publishAction', (state)=>state.selectRow);
    const refetchList = ()=>{
        api$1.contentManagerApi.util.invalidateTags([
            {
                type: 'Document',
                id: `${model}_LIST`
            }
        ]);
    };
    if (!showPublishButton) return null;
    return {
        actionType: 'publish',
        variant: 'tertiary',
        label: formatMessage({
            id: 'app.utils.publish',
            defaultMessage: 'Publish'
        }),
        dialog: {
            type: 'modal',
            title: formatMessage({
                id: translations.getTranslation('containers.ListPage.selectedEntriesModal.title'),
                defaultMessage: 'Publish entries'
            }),
            content: ({ onClose })=>{
                return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Root, {
                    rows: documents,
                    defaultSelectedRows: documents,
                    headers: TABLE_HEADERS,
                    children: /*#__PURE__*/ jsxRuntime.jsx(SelectedEntriesModalContent, {
                        listViewSelectedEntries: documents,
                        toggleModal: ()=>{
                            onClose();
                            refetchList();
                        },
                        setListViewSelectedDocuments: setListViewSelectedDocuments,
                        model: model
                    })
                });
            },
            onClose: ()=>{
                refetchList();
            }
        }
    };
};

exports.PublishAction = PublishAction;
exports.SelectedEntriesModalContent = SelectedEntriesModalContent;
//# sourceMappingURL=PublishAction.js.map
