'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var Icons = require('@strapi/icons');
var Symbols = require('@strapi/icons/symbols');
var isEqual = require('lodash/isEqual');
var qs = require('qs');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var styledComponents = require('styled-components');
var InjectionZone = require('../../components/InjectionZone.js');
var hooks = require('../../constants/hooks.js');
var plugin = require('../../constants/plugin.js');
var DocumentRBAC = require('../../features/DocumentRBAC.js');
var useDocument = require('../../hooks/useDocument.js');
var useDocumentLayout = require('../../hooks/useDocumentLayout.js');
var usePrev = require('../../hooks/usePrev.js');
var documents = require('../../services/documents.js');
var api = require('../../utils/api.js');
var translations = require('../../utils/translations.js');
var users = require('../../utils/users.js');
var DocumentStatus = require('../EditView/components/DocumentStatus.js');
var Actions = require('./components/BulkActions/Actions.js');
var Filters = require('./components/Filters.js');
var TableActions = require('./components/TableActions.js');
var CellContent = require('./components/TableCells/CellContent.js');
var ViewSettingsMenu = require('./components/ViewSettingsMenu.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const { INJECT_COLUMN_IN_TABLE } = hooks.HOOKS;
/* -------------------------------------------------------------------------------------------------
 * ListViewPage
 * -----------------------------------------------------------------------------------------------*/ const LayoutsHeaderCustom = styledComponents.styled(strapiAdmin.Layouts.Header)`
  overflow-wrap: anywhere;
`;
const ListViewPage = ()=>{
    const { trackUsage } = strapiAdmin.useTracking();
    const navigate = reactRouterDom.useNavigate();
    const { formatMessage } = reactIntl.useIntl();
    const { toggleNotification } = strapiAdmin.useNotification();
    const { _unstableFormatAPIError: formatAPIError } = strapiAdmin.useAPIErrorHandler(translations.getTranslation);
    const { collectionType, model, schema } = useDocument.useDoc();
    const { list } = useDocumentLayout.useDocumentLayout(model);
    const [displayedHeaders, setDisplayedHeaders] = React__namespace.useState([]);
    const listLayout = usePrev.usePrev(list.layout);
    React__namespace.useEffect(()=>{
        /**
     * ONLY update the displayedHeaders if the document
     * layout has actually changed in value.
     */ if (!isEqual(listLayout, list.layout)) {
            setDisplayedHeaders(list.layout);
        }
    }, [
        list.layout,
        listLayout
    ]);
    const handleSetHeaders = (headers)=>{
        setDisplayedHeaders(useDocumentLayout.convertListLayoutToFieldLayouts(headers, schema.attributes, list.metadatas));
    };
    const [{ query }] = strapiAdmin.useQueryParams({
        page: '1',
        pageSize: list.settings.pageSize.toString(),
        sort: list.settings.defaultSortBy ? `${list.settings.defaultSortBy}:${list.settings.defaultSortOrder}` : ''
    });
    const params = React__namespace.useMemo(()=>api.buildValidParams(query), [
        query
    ]);
    const { data, error, isFetching } = documents.useGetAllDocumentsQuery({
        model,
        params
    });
    /**
   * If the API returns an error, display a notification
   */ React__namespace.useEffect(()=>{
        if (error) {
            toggleNotification({
                type: 'danger',
                message: formatAPIError(error)
            });
        }
    }, [
        error,
        formatAPIError,
        toggleNotification
    ]);
    const { results = [], pagination } = data ?? {};
    React__namespace.useEffect(()=>{
        if (pagination && pagination.pageCount > 0 && pagination.page > pagination.pageCount) {
            navigate({
                search: qs.stringify({
                    ...query,
                    page: pagination.pageCount
                })
            }, {
                replace: true
            });
        }
    }, [
        pagination,
        formatMessage,
        query,
        navigate
    ]);
    const { canCreate } = DocumentRBAC.useDocumentRBAC('ListViewPage', ({ canCreate })=>({
            canCreate
        }));
    const runHookWaterfall = strapiAdmin.useStrapiApp('ListViewPage', ({ runHookWaterfall })=>runHookWaterfall);
    /**
   * Run the waterfall and then inject our additional table headers.
   */ const tableHeaders = React__namespace.useMemo(()=>{
        const headers = runHookWaterfall(INJECT_COLUMN_IN_TABLE, {
            displayedHeaders,
            layout: list
        });
        const formattedHeaders = headers.displayedHeaders.map((header)=>{
            /**
       * When the header label is a string, it is an attribute on the current content-type:
       * Use the attribute name value to compute the translation.
       * Otherwise, it should be a  translation object coming from a plugin that injects into the table (ie i18n, content-releases, review-workflows):
       * Use the translation object as is.
       */ const translation = typeof header.label === 'string' ? {
                id: `content-manager.content-types.${model}.${header.name}`,
                defaultMessage: header.label
            } : header.label;
            return {
                ...header,
                label: formatMessage(translation),
                name: `${header.name}${header.mainField?.name ? `.${header.mainField.name}` : ''}`
            };
        });
        if (schema?.options?.draftAndPublish) {
            formattedHeaders.push({
                attribute: {
                    type: 'custom'
                },
                name: 'status',
                label: formatMessage({
                    id: translations.getTranslation(`containers.list.table-headers.status`),
                    defaultMessage: 'status'
                }),
                searchable: false,
                sortable: false
            });
        }
        return formattedHeaders;
    }, [
        displayedHeaders,
        formatMessage,
        list,
        runHookWaterfall,
        schema?.options?.draftAndPublish,
        model
    ]);
    if (isFetching) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Loading, {});
    }
    if (error) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Error, {});
    }
    const contentTypeTitle = schema?.info.displayName ? formatMessage({
        id: schema.info.displayName,
        defaultMessage: schema.info.displayName
    }) : formatMessage({
        id: 'content-manager.containers.untitled',
        defaultMessage: 'Untitled'
    });
    const handleRowClick = (id)=>()=>{
            trackUsage('willEditEntryFromList');
            navigate({
                pathname: id.toString(),
                search: qs.stringify({
                    plugins: query.plugins
                })
            });
        };
    if (!isFetching && results.length === 0) {
        return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.tours.contentManager.Introduction, {
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {})
                }),
                /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Page.Main, {
                    children: [
                        /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Title, {
                            children: `${contentTypeTitle}`
                        }),
                        /*#__PURE__*/ jsxRuntime.jsx(LayoutsHeaderCustom, {
                            primaryAction: canCreate ? /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.tours.contentManager.CreateNewEntry, {
                                children: /*#__PURE__*/ jsxRuntime.jsx(CreateButton, {})
                            }) : null,
                            subtitle: formatMessage({
                                id: translations.getTranslation('pages.ListView.header-subtitle'),
                                defaultMessage: '{number, plural, =0 {# entries} one {# entry} other {# entries}} found'
                            }, {
                                number: pagination?.total
                            }),
                            title: contentTypeTitle,
                            navigationAction: /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.BackButton, {})
                        }),
                        /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Action, {
                            endActions: /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(InjectionZone.InjectionZone, {
                                        area: "listView.actions"
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(ViewSettingsMenu.ViewSettingsMenu, {
                                        setHeaders: handleSetHeaders,
                                        resetHeaders: ()=>setDisplayedHeaders(list.layout),
                                        headers: displayedHeaders.map((header)=>header.name)
                                    })
                                ]
                            }),
                            startActions: /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                                children: [
                                    list.settings.searchable && /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.SearchInput, {
                                        label: formatMessage({
                                            id: 'app.component.search.label',
                                            defaultMessage: 'Search for {target}'
                                        }, {
                                            target: contentTypeTitle
                                        }),
                                        placeholder: formatMessage({
                                            id: 'global.search',
                                            defaultMessage: 'Search'
                                        }),
                                        trackedEvent: "didSearch"
                                    }),
                                    list.settings.filterable && schema ? /*#__PURE__*/ jsxRuntime.jsx(Filters.Filters, {
                                        schema: schema
                                    }) : null
                                ]
                            })
                        }),
                        /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Content, {
                            children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                background: "neutral0",
                                shadow: "filterShadow",
                                hasRadius: true,
                                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.EmptyStateLayout, {
                                    action: canCreate ? /*#__PURE__*/ jsxRuntime.jsx(CreateButton, {
                                        variant: "secondary"
                                    }) : null,
                                    content: formatMessage({
                                        id: 'app.components.EmptyStateLayout.content-document',
                                        defaultMessage: 'No content found'
                                    }),
                                    hasRadius: true,
                                    icon: /*#__PURE__*/ jsxRuntime.jsx(Symbols.EmptyDocuments, {
                                        width: "16rem"
                                    })
                                })
                            })
                        })
                    ]
                })
            ]
        });
    }
    return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.tours.contentManager.Introduction, {
                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {})
            }),
            /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Page.Main, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Title, {
                        children: `${contentTypeTitle}`
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(LayoutsHeaderCustom, {
                        primaryAction: canCreate ? /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.tours.contentManager.CreateNewEntry, {
                            children: /*#__PURE__*/ jsxRuntime.jsx(CreateButton, {})
                        }) : null,
                        subtitle: formatMessage({
                            id: translations.getTranslation('pages.ListView.header-subtitle'),
                            defaultMessage: '{number, plural, =0 {# entries} one {# entry} other {# entries}} found'
                        }, {
                            number: pagination?.total
                        }),
                        title: contentTypeTitle,
                        navigationAction: /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.BackButton, {})
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Action, {
                        endActions: /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsx(InjectionZone.InjectionZone, {
                                    area: "listView.actions"
                                }),
                                /*#__PURE__*/ jsxRuntime.jsx(ViewSettingsMenu.ViewSettingsMenu, {
                                    setHeaders: handleSetHeaders,
                                    resetHeaders: ()=>setDisplayedHeaders(list.layout),
                                    headers: displayedHeaders.map((header)=>header.name)
                                })
                            ]
                        }),
                        startActions: /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                            children: [
                                list.settings.searchable && /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.SearchInput, {
                                    disabled: results.length === 0,
                                    label: formatMessage({
                                        id: 'app.component.search.label',
                                        defaultMessage: 'Search for {target}'
                                    }, {
                                        target: contentTypeTitle
                                    }),
                                    placeholder: formatMessage({
                                        id: 'global.search',
                                        defaultMessage: 'Search'
                                    }),
                                    trackedEvent: "didSearch"
                                }),
                                list.settings.filterable && schema ? /*#__PURE__*/ jsxRuntime.jsx(Filters.Filters, {
                                    disabled: results.length === 0,
                                    schema: schema
                                }) : null
                            ]
                        })
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Content, {
                        children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                            gap: 4,
                            direction: "column",
                            alignItems: "stretch",
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Table.Root, {
                                    rows: results,
                                    headers: tableHeaders,
                                    isLoading: isFetching,
                                    children: [
                                        /*#__PURE__*/ jsxRuntime.jsx(TableActionsBar, {}),
                                        /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Table.Content, {
                                            children: [
                                                /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Table.Head, {
                                                    children: [
                                                        /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.HeaderCheckboxCell, {}),
                                                        tableHeaders.map((header)=>/*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.HeaderCell, {
                                                                ...header
                                                            }, header.name))
                                                    ]
                                                }),
                                                /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Loading, {}),
                                                /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Empty, {
                                                    action: canCreate ? /*#__PURE__*/ jsxRuntime.jsx(CreateButton, {
                                                        variant: "secondary"
                                                    }) : null
                                                }),
                                                /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Body, {
                                                    children: results.map((row)=>{
                                                        return /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Table.Row, {
                                                            cursor: "pointer",
                                                            onClick: handleRowClick(row.documentId),
                                                            children: [
                                                                /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.CheckboxCell, {
                                                                    id: row.id
                                                                }),
                                                                tableHeaders.map(({ cellFormatter, ...header })=>{
                                                                    if (header.name === 'status') {
                                                                        const { status } = row;
                                                                        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Cell, {
                                                                            children: /*#__PURE__*/ jsxRuntime.jsx(DocumentStatus.DocumentStatus, {
                                                                                status: status,
                                                                                maxWidth: 'min-content'
                                                                            })
                                                                        }, header.name);
                                                                    }
                                                                    if ([
                                                                        'createdBy',
                                                                        'updatedBy'
                                                                    ].includes(header.name.split('.')[0])) {
                                                                        // Display the users full name
                                                                        // Some entries doesn't have a user assigned as creator/updater (ex: entries created through content API)
                                                                        // In this case, we display a dash
                                                                        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Cell, {
                                                                            children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                                                                textColor: "neutral800",
                                                                                children: row[header.name.split('.')[0]] ? users.getDisplayName(row[header.name.split('.')[0]]) : '-'
                                                                            })
                                                                        }, header.name);
                                                                    }
                                                                    if (typeof cellFormatter === 'function') {
                                                                        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Cell, {
                                                                            children: cellFormatter(row, header, {
                                                                                collectionType,
                                                                                model
                                                                            })
                                                                        }, header.name);
                                                                    }
                                                                    return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.Cell, {
                                                                        children: /*#__PURE__*/ jsxRuntime.jsx(CellContent.CellContent, {
                                                                            content: row[header.name.split('.')[0]],
                                                                            rowId: row.documentId,
                                                                            ...header
                                                                        })
                                                                    }, header.name);
                                                                }),
                                                                /*#__PURE__*/ jsxRuntime.jsx(ActionsCell, {
                                                                    onClick: (e)=>e.stopPropagation(),
                                                                    children: /*#__PURE__*/ jsxRuntime.jsx(TableActions.TableActions, {
                                                                        document: row
                                                                    })
                                                                })
                                                            ]
                                                        }, row.id);
                                                    })
                                                })
                                            ]
                                        })
                                    ]
                                }),
                                /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Pagination.Root, {
                                    ...pagination,
                                    onPageSizeChange: ()=>trackUsage('willChangeNumberOfEntriesPerPage'),
                                    children: [
                                        /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Pagination.PageSize, {}),
                                        /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Pagination.Links, {})
                                    ]
                                })
                            ]
                        })
                    })
                ]
            })
        ]
    });
};
const ActionsCell = styledComponents.styled(strapiAdmin.Table.Cell)`
  display: flex;
  justify-content: flex-end;
`;
/* -------------------------------------------------------------------------------------------------
 * TableActionsBar
 * -----------------------------------------------------------------------------------------------*/ const TableActionsBar = ()=>{
    const selectRow = strapiAdmin.useTable('TableActionsBar', (state)=>state.selectRow);
    const [{ query }] = strapiAdmin.useQueryParams();
    const locale = query?.plugins?.i18n?.locale;
    const prevLocale = usePrev.usePrev(locale);
    // TODO: find a better way to reset the selected rows when the locale changes across all the app
    React__namespace.useEffect(()=>{
        if (prevLocale !== locale) {
            selectRow([]);
        }
    }, [
        selectRow,
        prevLocale,
        locale
    ]);
    return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Table.ActionBar, {
        children: /*#__PURE__*/ jsxRuntime.jsx(Actions.BulkActionsRenderer, {})
    });
};
const CreateButton = ({ variant })=>{
    const { formatMessage } = reactIntl.useIntl();
    const { trackUsage } = strapiAdmin.useTracking();
    const [{ query }] = strapiAdmin.useQueryParams();
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
        variant: variant,
        tag: reactRouterDom.Link,
        onClick: ()=>{
            trackUsage('willCreateEntry', {
                status: 'draft'
            });
        },
        startIcon: /*#__PURE__*/ jsxRuntime.jsx(Icons.Plus, {}),
        style: {
            textDecoration: 'none'
        },
        to: {
            pathname: 'create',
            search: qs.stringify({
                plugins: query.plugins
            })
        },
        minWidth: "max-content",
        marginLeft: 2,
        children: formatMessage({
            id: translations.getTranslation('HeaderLayout.button.label-add-entry'),
            defaultMessage: 'Create new entry'
        })
    });
};
/* -------------------------------------------------------------------------------------------------
 * ProtectedListViewPage
 * -----------------------------------------------------------------------------------------------*/ const ProtectedListViewPage = ()=>{
    const { slug = '' } = reactRouterDom.useParams();
    const { permissions = [], isLoading, error } = strapiAdmin.useRBAC(plugin.PERMISSIONS.map((action)=>({
            action,
            subject: slug
        })));
    if (isLoading) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Loading, {});
    }
    if (error || !slug) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Error, {});
    }
    return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Protect, {
        permissions: permissions,
        children: ({ permissions })=>/*#__PURE__*/ jsxRuntime.jsx(DocumentRBAC.DocumentRBAC, {
                permissions: permissions,
                children: /*#__PURE__*/ jsxRuntime.jsx(ListViewPage, {})
            })
    });
};

exports.ListViewPage = ListViewPage;
exports.ProtectedListViewPage = ProtectedListViewPage;
//# sourceMappingURL=ListViewPage.js.map
