import { jsx, jsxs } from 'react/jsx-runtime';
import 'react';
import { Box, Button, Modal, Flex, Typography } from '@strapi/design-system';
import { Collapse } from '@strapi/icons';
import { useIntl } from 'react-intl';
import { styled } from 'styled-components';
import { PreviewWysiwyg } from './PreviewWysiwyg.mjs';

const EditorLayout = ({ children, isExpandMode, error, previewContent = '', onCollapse })=>{
    const { formatMessage } = useIntl();
    if (isExpandMode) {
        return /*#__PURE__*/ jsx(Modal.Root, {
            open: isExpandMode,
            onOpenChange: onCollapse,
            children: /*#__PURE__*/ jsx(Modal.Content, {
                style: {
                    maxWidth: 'unset',
                    width: 'unset'
                },
                children: /*#__PURE__*/ jsxs(Flex, {
                    height: "90dvh",
                    width: "90dvw",
                    alignItems: "flex-start",
                    children: [
                        /*#__PURE__*/ jsx(BoxWithBorder, {
                            flex: "1",
                            height: "100%",
                            children: children
                        }),
                        /*#__PURE__*/ jsxs(Flex, {
                            alignItems: "start",
                            direction: "column",
                            flex: 1,
                            height: "100%",
                            width: "100%",
                            children: [
                                /*#__PURE__*/ jsx(Flex, {
                                    height: "4.8rem",
                                    background: "neutral100",
                                    justifyContent: "flex-end",
                                    shrink: 0,
                                    width: "100%",
                                    children: /*#__PURE__*/ jsxs(ExpandButton, {
                                        onClick: onCollapse,
                                        variant: "tertiary",
                                        size: "M",
                                        children: [
                                            /*#__PURE__*/ jsx(Typography, {
                                                children: formatMessage({
                                                    id: 'components.Wysiwyg.collapse',
                                                    defaultMessage: 'Collapse'
                                                })
                                            }),
                                            /*#__PURE__*/ jsx(Collapse, {})
                                        ]
                                    })
                                }),
                                /*#__PURE__*/ jsx(Box, {
                                    position: "relative",
                                    height: "100%",
                                    width: "100%",
                                    children: /*#__PURE__*/ jsx(PreviewWysiwyg, {
                                        data: previewContent
                                    })
                                })
                            ]
                        })
                    ]
                })
            })
        });
    }
    return /*#__PURE__*/ jsx(Flex, {
        borderColor: error ? 'danger600' : 'neutral200',
        borderStyle: "solid",
        borderWidth: "1px",
        hasRadius: true,
        direction: "column",
        alignItems: "stretch",
        children: children
    });
};
const BoxWithBorder = styled(Box)`
  border-right: 1px solid ${({ theme })=>theme.colors.neutral200};
`;
const ExpandButton = styled(Button)`
  background-color: transparent;
  border: none;
  align-items: center;

  & > span {
    display: flex;
    justify-content: space-between;
    align-items: center;
    width: 100%;
    font-weight: ${({ theme })=>theme.fontWeights.regular};
  }

  svg {
    margin-left: ${({ theme })=>`${theme.spaces[2]}`};

    path {
      fill: ${({ theme })=>theme.colors.neutral700};
      width: 1.2rem;
      height: 1.2rem;
    }
  }
`;

export { EditorLayout, ExpandButton };
//# sourceMappingURL=EditorLayout.mjs.map
