'use strict';

var jsxRuntime = require('react/jsx-runtime');
require('react');
var designSystem = require('@strapi/design-system');
var Icons = require('@strapi/icons');
var reactIntl = require('react-intl');
var styledComponents = require('styled-components');
var PreviewWysiwyg = require('./PreviewWysiwyg.js');

const EditorLayout = ({ children, isExpandMode, error, previewContent = '', onCollapse })=>{
    const { formatMessage } = reactIntl.useIntl();
    if (isExpandMode) {
        return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Root, {
            open: isExpandMode,
            onOpenChange: onCollapse,
            children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Content, {
                style: {
                    maxWidth: 'unset',
                    width: 'unset'
                },
                children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                    height: "90dvh",
                    width: "90dvw",
                    alignItems: "flex-start",
                    children: [
                        /*#__PURE__*/ jsxRuntime.jsx(BoxWithBorder, {
                            flex: "1",
                            height: "100%",
                            children: children
                        }),
                        /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                            alignItems: "start",
                            direction: "column",
                            flex: 1,
                            height: "100%",
                            width: "100%",
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                                    height: "4.8rem",
                                    background: "neutral100",
                                    justifyContent: "flex-end",
                                    shrink: 0,
                                    width: "100%",
                                    children: /*#__PURE__*/ jsxRuntime.jsxs(ExpandButton, {
                                        onClick: onCollapse,
                                        variant: "tertiary",
                                        size: "M",
                                        children: [
                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                                children: formatMessage({
                                                    id: 'components.Wysiwyg.collapse',
                                                    defaultMessage: 'Collapse'
                                                })
                                            }),
                                            /*#__PURE__*/ jsxRuntime.jsx(Icons.Collapse, {})
                                        ]
                                    })
                                }),
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                    position: "relative",
                                    height: "100%",
                                    width: "100%",
                                    children: /*#__PURE__*/ jsxRuntime.jsx(PreviewWysiwyg.PreviewWysiwyg, {
                                        data: previewContent
                                    })
                                })
                            ]
                        })
                    ]
                })
            })
        });
    }
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
        borderColor: error ? 'danger600' : 'neutral200',
        borderStyle: "solid",
        borderWidth: "1px",
        hasRadius: true,
        direction: "column",
        alignItems: "stretch",
        children: children
    });
};
const BoxWithBorder = styledComponents.styled(designSystem.Box)`
  border-right: 1px solid ${({ theme })=>theme.colors.neutral200};
`;
const ExpandButton = styledComponents.styled(designSystem.Button)`
  background-color: transparent;
  border: none;
  align-items: center;

  & > span {
    display: flex;
    justify-content: space-between;
    align-items: center;
    width: 100%;
    font-weight: ${({ theme })=>theme.fontWeights.regular};
  }

  svg {
    margin-left: ${({ theme })=>`${theme.spaces[2]}`};

    path {
      fill: ${({ theme })=>theme.colors.neutral700};
      width: 1.2rem;
      height: 1.2rem;
    }
  }
`;

exports.EditorLayout = EditorLayout;
exports.ExpandButton = ExpandButton;
//# sourceMappingURL=EditorLayout.js.map
