'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var Icons = require('@strapi/icons');
var reactDndHtml5Backend = require('react-dnd-html5-backend');
var reactIntl = require('react-intl');
var styledComponents = require('styled-components');
var ComponentIcon = require('../../../../../components/ComponentIcon.js');
var dragAndDrop = require('../../../../../constants/dragAndDrop.js');
var useDocumentContext = require('../../../../../hooks/useDocumentContext.js');
var useDocumentLayout = require('../../../../../hooks/useDocumentLayout.js');
var useDragAndDrop = require('../../../../../hooks/useDragAndDrop.js');
var objects = require('../../../../../utils/objects.js');
var translations = require('../../../../../utils/translations.js');
var FormLayout = require('../../FormLayout.js');
var InputRenderer = require('../../InputRenderer.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const DynamicComponent = ({ componentUid, disabled, index, name, onRemoveComponentClick, onMoveComponent, onGrabItem, onDropItem, onCancel, dynamicComponentsByCategory = {}, onAddComponent, children })=>{
    const { formatMessage } = reactIntl.useIntl();
    const formValues = strapiAdmin.useForm('DynamicComponent', (state)=>state.values);
    const { currentDocument, currentDocumentMeta } = useDocumentContext.useDocumentContext('DynamicComponent');
    const rulesEngine = strapiAdmin.createRulesEngine();
    const isDesktop = strapiAdmin.useIsDesktop();
    const { edit: { components } } = useDocumentLayout.useDocumentLayout(currentDocumentMeta.model);
    const title = React__namespace.useMemo(()=>{
        const { mainField } = components[componentUid]?.settings ?? {
            mainField: 'id'
        };
        const mainFieldValue = objects.getIn(formValues, `${name}.${index}.${mainField}`);
        const displayedValue = mainField === 'id' || !mainFieldValue ? '' : String(mainFieldValue).trim();
        const mainValue = displayedValue.length > 0 ? `- ${displayedValue}` : displayedValue;
        return mainValue;
    }, [
        componentUid,
        components,
        formValues,
        name,
        index
    ]);
    const { icon, displayName } = React__namespace.useMemo(()=>{
        const [category] = componentUid.split('.');
        const { icon, displayName } = (dynamicComponentsByCategory[category] ?? []).find((component)=>component.uid === componentUid) ?? {
            icon: null,
            displayName: null
        };
        return {
            icon,
            displayName
        };
    }, [
        componentUid,
        dynamicComponentsByCategory
    ]);
    const [{ handlerId, isDragging, handleKeyDown }, boxRef, dropRef, dragRef, dragPreviewRef] = useDragAndDrop.useDragAndDrop(!disabled, {
        type: `${dragAndDrop.ItemTypes.DYNAMIC_ZONE}_${name}`,
        index,
        item: {
            index,
            displayedValue: `${displayName} ${title}`,
            icon
        },
        onMoveItem: onMoveComponent,
        onDropItem,
        onGrabItem,
        onCancel
    });
    React__namespace.useEffect(()=>{
        dragPreviewRef(reactDndHtml5Backend.getEmptyImage(), {
            captureDraggingState: false
        });
    }, [
        dragPreviewRef,
        index
    ]);
    /**
   * We don't need the accordion's to communicate with each other,
   * so a unique value for their state is enough.
   */ const accordionValue = React__namespace.useId();
    const { value = [], rawError } = strapiAdmin.useField(`${name}.${index}`);
    const [collapseToOpen, setCollapseToOpen] = React__namespace.useState('');
    React__namespace.useEffect(()=>{
        if (rawError && value) {
            setCollapseToOpen(accordionValue);
        }
    }, [
        rawError,
        value,
        accordionValue
    ]);
    const composedBoxRefs = designSystem.useComposedRefs(boxRef, dropRef);
    const accordionActions = disabled ? null : /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                variant: "ghost",
                label: formatMessage({
                    id: translations.getTranslation('components.DynamicZone.delete-label'),
                    defaultMessage: 'Delete {name}'
                }, {
                    name: title
                }),
                onClick: onRemoveComponentClick,
                children: /*#__PURE__*/ jsxRuntime.jsx(Icons.Trash, {})
            }),
            isDesktop && /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                variant: "ghost",
                onClick: (e)=>e.stopPropagation(),
                "data-handler-id": handlerId,
                ref: dragRef,
                label: formatMessage({
                    id: translations.getTranslation('components.DragHandle-label'),
                    defaultMessage: 'Drag'
                }),
                onKeyDown: handleKeyDown,
                children: /*#__PURE__*/ jsxRuntime.jsx(Icons.Drag, {})
            }),
            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Menu.Root, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Menu.Trigger, {
                        size: "S",
                        endIcon: null,
                        paddingLeft: 0,
                        paddingRight: 0,
                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                            variant: "ghost",
                            label: formatMessage({
                                id: translations.getTranslation('components.DynamicZone.more-actions'),
                                defaultMessage: 'More actions'
                            }),
                            tag: "span",
                            children: /*#__PURE__*/ jsxRuntime.jsx(Icons.More, {
                                "aria-hidden": true,
                                focusable: false
                            })
                        })
                    }),
                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Menu.Content, {
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Menu.SubRoot, {
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Menu.SubTrigger, {
                                        children: formatMessage({
                                            id: translations.getTranslation('components.DynamicZone.add-item-above'),
                                            defaultMessage: 'Add component above'
                                        })
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Menu.SubContent, {
                                        children: Object.entries(dynamicComponentsByCategory).map(([category, components])=>/*#__PURE__*/ jsxRuntime.jsxs(React__namespace.Fragment, {
                                                children: [
                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Menu.Label, {
                                                        children: category
                                                    }),
                                                    components.map(({ displayName, uid })=>/*#__PURE__*/ jsxRuntime.jsx(designSystem.Menu.Item, {
                                                            onSelect: ()=>onAddComponent(uid, index),
                                                            children: displayName
                                                        }, uid))
                                                ]
                                            }, category))
                                    })
                                ]
                            }),
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Menu.SubRoot, {
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Menu.SubTrigger, {
                                        children: formatMessage({
                                            id: translations.getTranslation('components.DynamicZone.add-item-below'),
                                            defaultMessage: 'Add component below'
                                        })
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Menu.SubContent, {
                                        children: Object.entries(dynamicComponentsByCategory).map(([category, components])=>/*#__PURE__*/ jsxRuntime.jsxs(React__namespace.Fragment, {
                                                children: [
                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Menu.Label, {
                                                        children: category
                                                    }),
                                                    components.map(({ displayName, uid })=>/*#__PURE__*/ jsxRuntime.jsx(designSystem.Menu.Item, {
                                                            onSelect: ()=>onAddComponent(uid, index + 1),
                                                            children: displayName
                                                        }, uid))
                                                ]
                                            }, category))
                                    })
                                ]
                            })
                        ]
                    })
                ]
            })
        ]
    });
    const accordionTitle = title ? `${displayName} ${title}` : displayName;
    return /*#__PURE__*/ jsxRuntime.jsxs(ComponentContainer, {
        tag: "li",
        width: "100%",
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                justifyContent: "center",
                children: /*#__PURE__*/ jsxRuntime.jsx(Rectangle, {
                    background: "neutral200"
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(StyledBox, {
                ref: composedBoxRefs,
                hasRadius: true,
                children: isDragging ? /*#__PURE__*/ jsxRuntime.jsx(Preview, {}) : /*#__PURE__*/ jsxRuntime.jsx(designSystem.Accordion.Root, {
                    value: collapseToOpen,
                    onValueChange: setCollapseToOpen,
                    children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Accordion.Item, {
                        value: accordionValue,
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Accordion.Header, {
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Accordion.Trigger, {
                                        icon: icon && ComponentIcon.COMPONENT_ICONS[icon] ? ComponentIcon.COMPONENT_ICONS[icon] : ComponentIcon.COMPONENT_ICONS.dashboard,
                                        children: accordionTitle
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Accordion.Actions, {
                                        children: accordionActions
                                    })
                                ]
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Accordion.Content, {
                                children: /*#__PURE__*/ jsxRuntime.jsx(AccordionContentRadius, {
                                    background: "neutral0",
                                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                        paddingLeft: 6,
                                        paddingRight: 6,
                                        paddingTop: 6,
                                        paddingBottom: 6,
                                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Root, {
                                            gap: 4,
                                            children: components[componentUid]?.layout?.map((row, rowInd)=>{
                                                const visibleFields = row.filter(({ ...field })=>{
                                                    const condition = field.attribute.conditions?.visible;
                                                    if (condition) {
                                                        return rulesEngine.evaluate(condition, value);
                                                    }
                                                    return true;
                                                });
                                                if (visibleFields.length === 0) {
                                                    return null; // Skip rendering the entire grid row
                                                }
                                                return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                                    col: 12,
                                                    xs: 12,
                                                    direction: "column",
                                                    alignItems: "stretch",
                                                    children: /*#__PURE__*/ jsxRuntime.jsx(FormLayout.ResponsiveGridRoot, {
                                                        gap: 4,
                                                        children: visibleFields.map(({ size, ...field })=>{
                                                            const fieldName = `${name}.${index}.${field.name}`;
                                                            const fieldWithTranslatedLabel = {
                                                                ...field,
                                                                label: formatMessage({
                                                                    id: `content-manager.components.${componentUid}.${field.name}`,
                                                                    defaultMessage: field.label
                                                                })
                                                            };
                                                            return /*#__PURE__*/ jsxRuntime.jsx(FormLayout.ResponsiveGridItem, {
                                                                col: size,
                                                                s: 12,
                                                                xs: 12,
                                                                direction: "column",
                                                                alignItems: "stretch",
                                                                children: children ? children({
                                                                    ...fieldWithTranslatedLabel,
                                                                    document: currentDocument,
                                                                    name: fieldName
                                                                }) : /*#__PURE__*/ jsxRuntime.jsx(InputRenderer.InputRenderer, {
                                                                    ...fieldWithTranslatedLabel,
                                                                    document: currentDocument,
                                                                    name: fieldName
                                                                })
                                                            }, fieldName);
                                                        })
                                                    })
                                                }, rowInd);
                                            })
                                        })
                                    })
                                })
                            })
                        ]
                    })
                })
            })
        ]
    });
};
// TODO: Delete once https://github.com/strapi/design-system/pull/858
// is merged and released.
const StyledBox = styledComponents.styled(designSystem.Box)`
  > div:first-child {
    box-shadow: ${({ theme })=>theme.shadows.tableShadow};
  }
`;
const AccordionContentRadius = styledComponents.styled(designSystem.Box)`
  border-radius: 0 0 ${({ theme })=>theme.spaces[1]} ${({ theme })=>theme.spaces[1]};
`;
const Rectangle = styledComponents.styled(designSystem.Box)`
  width: ${({ theme })=>theme.spaces[2]};
  height: ${({ theme })=>theme.spaces[4]};
`;
const Preview = styledComponents.styled.span`
  display: block;
  background-color: ${({ theme })=>theme.colors.primary100};
  outline: 1px dashed ${({ theme })=>theme.colors.primary500};
  outline-offset: -1px;
  padding: ${({ theme })=>theme.spaces[6]};
`;
const ComponentContainer = styledComponents.styled(designSystem.Box)`
  list-style: none;
  padding: 0;
  margin: 0;
`;

exports.DynamicComponent = DynamicComponent;
//# sourceMappingURL=DynamicComponent.js.map
