'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var Icons = require('@strapi/icons');
var reactDndHtml5Backend = require('react-dnd-html5-backend');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var styledComponents = require('styled-components');
var dragAndDrop = require('../../../../../constants/dragAndDrop.js');
var useDocumentContext = require('../../../../../hooks/useDocumentContext.js');
var useDragAndDrop = require('../../../../../hooks/useDragAndDrop.js');
var usePrev = require('../../../../../hooks/usePrev.js');
var objects = require('../../../../../utils/objects.js');
var translations = require('../../../../../utils/translations.js');
var data = require('../../../utils/data.js');
var forms = require('../../../utils/forms.js');
var FormLayout = require('../../FormLayout.js');
var ComponentContext = require('../ComponentContext.js');
var Initializer = require('./Initializer.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const RepeatableComponent = ({ attribute, disabled, name, mainField, children, layout })=>{
    const { toggleNotification } = strapiAdmin.useNotification();
    const { formatMessage } = reactIntl.useIntl();
    const { search: searchString } = reactRouterDom.useLocation();
    const search = React__namespace.useMemo(()=>new URLSearchParams(searchString), [
        searchString
    ]);
    const { currentDocument } = useDocumentContext.useDocumentContext('RepeatableComponent');
    const components = currentDocument.components;
    const { value = [], error, rawError } = strapiAdmin.useField(name);
    const addFieldRow = strapiAdmin.useForm('RepeatableComponent', (state)=>state.addFieldRow);
    const moveFieldRow = strapiAdmin.useForm('RepeatableComponent', (state)=>state.moveFieldRow);
    const removeFieldRow = strapiAdmin.useForm('RepeatableComponent', (state)=>state.removeFieldRow);
    const { max = Infinity } = attribute;
    const [collapseToOpen, setCollapseToOpen] = React__namespace.useState('');
    const [liveText, setLiveText] = React__namespace.useState('');
    const rulesEngine = strapiAdmin.createRulesEngine();
    React__namespace.useEffect(()=>{
        const hasNestedErrors = rawError && Array.isArray(rawError) && rawError.length > 0;
        const hasNestedValue = value && Array.isArray(value) && value.length > 0;
        if (hasNestedErrors && hasNestedValue) {
            const errorOpenItems = rawError.map((_, idx)=>{
                return value[idx] ? value[idx].__temp_key__ : null;
            }).filter((value)=>!!value);
            if (errorOpenItems && errorOpenItems.length > 0) {
                setCollapseToOpen((collapseToOpen)=>{
                    if (!errorOpenItems.includes(collapseToOpen)) {
                        return errorOpenItems[0];
                    }
                    return collapseToOpen;
                });
            }
        }
    }, [
        rawError,
        value
    ]);
    /**
   * Get the temp key of the component that has the field that is currently focussed
   * as defined by the `field` query param. We can then force this specific component
   * to be in its "open" state.
   */ const componentTmpKeyWithFocussedField = React__namespace.useMemo(()=>{
        if (search.has('field')) {
            const fieldParam = search.get('field');
            if (!fieldParam) {
                return undefined;
            }
            const [, path] = fieldParam.split(`${name}.`);
            if (objects.getIn(value, path, undefined) !== undefined) {
                const [subpath] = path.split('.');
                return objects.getIn(value, subpath, undefined)?.__temp_key__;
            }
        }
        return undefined;
    }, [
        search,
        name,
        value
    ]);
    const prevValue = usePrev.usePrev(value);
    React__namespace.useEffect(()=>{
        /**
     * When we add a new item to the array, we want to open the collapse.
     */ if (prevValue && prevValue.length < value.length) {
            setCollapseToOpen(value[value.length - 1].__temp_key__);
        }
    }, [
        value,
        prevValue
    ]);
    React__namespace.useEffect(()=>{
        if (typeof componentTmpKeyWithFocussedField === 'string') {
            setCollapseToOpen(componentTmpKeyWithFocussedField);
        }
    }, [
        componentTmpKeyWithFocussedField
    ]);
    const toggleCollapses = ()=>{
        setCollapseToOpen('');
    };
    const handleClick = ()=>{
        if (value.length < max) {
            const schema = components[attribute.component];
            const form = forms.createDefaultForm(schema, components);
            const data$1 = data.transformDocument(schema, components)(form);
            addFieldRow(name, data$1);
        // setCollapseToOpen(nextTempKey);
        } else if (value.length >= max) {
            toggleNotification({
                type: 'info',
                message: formatMessage({
                    id: translations.getTranslation('components.notification.info.maximum-requirement')
                })
            });
        }
    };
    const handleMoveComponentField = (newIndex, currentIndex)=>{
        setLiveText(formatMessage({
            id: translations.getTranslation('dnd.reorder'),
            defaultMessage: '{item}, moved. New position in list: {position}.'
        }, {
            item: `${name}.${currentIndex}`,
            position: getItemPos(newIndex)
        }));
        moveFieldRow(name, currentIndex, newIndex);
    };
    const handleValueChange = (key)=>{
        setCollapseToOpen(key);
    };
    const getItemPos = (index)=>`${index + 1} of ${value.length}`;
    const handleCancel = (index)=>{
        setLiveText(formatMessage({
            id: translations.getTranslation('dnd.cancel-item'),
            defaultMessage: '{item}, dropped. Re-order cancelled.'
        }, {
            item: `${name}.${index}`
        }));
    };
    const handleGrabItem = (index)=>{
        setLiveText(formatMessage({
            id: translations.getTranslation('dnd.grab-item'),
            defaultMessage: `{item}, grabbed. Current position in list: {position}. Press up and down arrow to change position, Spacebar to drop, Escape to cancel.`
        }, {
            item: `${name}.${index}`,
            position: getItemPos(index)
        }));
    };
    const handleDropItem = (index)=>{
        setLiveText(formatMessage({
            id: translations.getTranslation('dnd.drop-item'),
            defaultMessage: `{item}, dropped. Final position in list: {position}.`
        }, {
            item: `${name}.${index}`,
            position: getItemPos(index)
        }));
    };
    const ariaDescriptionId = React__namespace.useId();
    const level = ComponentContext.useComponent('RepeatableComponent', (state)=>state.level);
    if (value.length === 0) {
        return /*#__PURE__*/ jsxRuntime.jsx(Initializer.Initializer, {
            disabled: disabled,
            name: name,
            onClick: handleClick
        });
    }
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Box, {
        hasRadius: true,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.VisuallyHidden, {
                id: ariaDescriptionId,
                children: formatMessage({
                    id: translations.getTranslation('dnd.instructions'),
                    defaultMessage: `Press spacebar to grab and re-order`
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.VisuallyHidden, {
                "aria-live": "assertive",
                children: liveText
            }),
            /*#__PURE__*/ jsxRuntime.jsxs(AccordionRoot, {
                $error: error,
                value: collapseToOpen,
                onValueChange: handleValueChange,
                "aria-describedby": ariaDescriptionId,
                children: [
                    value.map(({ __temp_key__: key, id, ...currentComponentValues }, index)=>{
                        const nameWithIndex = `${name}.${index}`;
                        return /*#__PURE__*/ jsxRuntime.jsx(ComponentContext.ComponentProvider, {
                            // id is always a number in a component
                            id: id,
                            uid: attribute.component,
                            level: level + 1,
                            type: "repeatable",
                            children: /*#__PURE__*/ jsxRuntime.jsx(Component, {
                                disabled: disabled,
                                name: nameWithIndex,
                                attribute: attribute,
                                index: index,
                                mainField: mainField,
                                onMoveItem: handleMoveComponentField,
                                onDeleteComponent: ()=>{
                                    removeFieldRow(name, index);
                                    toggleCollapses();
                                },
                                toggleCollapses: toggleCollapses,
                                onCancel: handleCancel,
                                onDropItem: handleDropItem,
                                onGrabItem: handleGrabItem,
                                __temp_key__: key,
                                children: layout.map((row, index)=>{
                                    const visibleFields = row.filter(({ ...field })=>{
                                        const condition = field.attribute.conditions?.visible;
                                        if (condition) {
                                            return rulesEngine.evaluate(condition, currentComponentValues);
                                        }
                                        return true;
                                    });
                                    if (visibleFields.length === 0) {
                                        return null; // Skip rendering the entire grid row
                                    }
                                    return /*#__PURE__*/ jsxRuntime.jsx(FormLayout.ResponsiveGridRoot, {
                                        gap: 4,
                                        children: visibleFields.map(({ size, ...field })=>{
                                            /**
                         * Layouts are built from schemas so they don't understand the complete
                         * schema tree, for components we append the parent name to the field name
                         * because this is the structure for the data & permissions also understand
                         * the nesting involved.
                         */ const completeFieldName = `${nameWithIndex}.${field.name}`;
                                            const translatedLabel = formatMessage({
                                                id: `content-manager.components.${attribute.component}.${field.name}`,
                                                defaultMessage: field.label
                                            });
                                            return /*#__PURE__*/ jsxRuntime.jsx(FormLayout.ResponsiveGridItem, {
                                                col: size,
                                                s: 12,
                                                xs: 12,
                                                direction: "column",
                                                alignItems: "stretch",
                                                children: children({
                                                    ...field,
                                                    label: translatedLabel,
                                                    name: completeFieldName,
                                                    document: currentDocument
                                                })
                                            }, completeFieldName);
                                        })
                                    }, index);
                                })
                            })
                        }, key);
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(TextButtonCustom, {
                        disabled: disabled,
                        onClick: handleClick,
                        startIcon: /*#__PURE__*/ jsxRuntime.jsx(Icons.Plus, {}),
                        children: formatMessage({
                            id: translations.getTranslation('containers.EditView.add.new-entry'),
                            defaultMessage: 'Add an entry'
                        })
                    })
                ]
            })
        ]
    });
};
const AccordionRoot = styledComponents.styled(designSystem.Accordion.Root)`
  border: 1px solid
    ${({ theme, $error })=>$error ? theme.colors.danger600 : theme.colors.neutral200};
`;
const TextButtonCustom = styledComponents.styled(designSystem.TextButton)`
  width: 100%;
  display: flex;
  justify-content: center;
  border-top: 1px solid ${({ theme })=>theme.colors.neutral200};
  padding-inline: ${(props)=>props.theme.spaces[6]};
  padding-block: ${(props)=>props.theme.spaces[3]};

  &:not([disabled]) {
    cursor: pointer;

    &:hover {
      background-color: ${(props)=>props.theme.colors.primary100};
    }
  }

  span {
    font-weight: 600;
    font-size: 1.4rem;
    line-height: 2.4rem;
  }

  @media (prefers-reduced-motion: no-preference) {
    transition: background-color 120ms ${(props)=>props.theme.motion.easings.easeOutQuad};
  }
`;
const Component = ({ disabled, index, name, mainField = {
    name: 'id',
    type: 'integer'
}, children, onDeleteComponent, toggleCollapses, __temp_key__, ...dragProps })=>{
    const { formatMessage } = reactIntl.useIntl();
    const isDesktop = strapiAdmin.useIsDesktop();
    const displayValue = strapiAdmin.useForm('RepeatableComponent', (state)=>{
        return objects.getIn(state.values, [
            ...name.split('.'),
            mainField.name
        ]);
    });
    const accordionRef = React__namespace.useRef(null);
    /**
   * The last item in the fieldName array will be the index of this component.
   * Drag and drop should be isolated to the parent component so nested repeatable
   * components are not affected by the drag and drop of the parent component in
   * their own re-ordering context.
   */ const componentKey = name.split('.').slice(0, -1).join('.');
    const [{ handlerId, isDragging, handleKeyDown }, boxRef, dropRef, dragRef, dragPreviewRef] = useDragAndDrop.useDragAndDrop(!disabled, {
        type: `${dragAndDrop.ItemTypes.COMPONENT}_${componentKey}`,
        index,
        item: {
            index,
            displayedValue: displayValue
        },
        onStart () {
            // Close all collapses
            toggleCollapses();
        },
        ...dragProps
    });
    React__namespace.useEffect(()=>{
        dragPreviewRef(reactDndHtml5Backend.getEmptyImage(), {
            captureDraggingState: false
        });
    }, [
        dragPreviewRef,
        index
    ]);
    const composedAccordionRefs = designSystem.useComposedRefs(accordionRef, dragRef);
    const composedBoxRefs = designSystem.useComposedRefs(boxRef, dropRef);
    return /*#__PURE__*/ jsxRuntime.jsx(jsxRuntime.Fragment, {
        children: isDragging ? /*#__PURE__*/ jsxRuntime.jsx(Preview, {}) : /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Accordion.Item, {
            ref: composedBoxRefs,
            value: __temp_key__,
            children: [
                /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Accordion.Header, {
                    children: [
                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Accordion.Trigger, {
                            children: displayValue
                        }),
                        /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Accordion.Actions, {
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                                    disabled: disabled,
                                    variant: "ghost",
                                    onClick: onDeleteComponent,
                                    label: formatMessage({
                                        id: translations.getTranslation('containers.Edit.delete'),
                                        defaultMessage: 'Delete'
                                    }),
                                    children: /*#__PURE__*/ jsxRuntime.jsx(Icons.Trash, {})
                                }),
                                isDesktop && /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                                    disabled: disabled,
                                    ref: composedAccordionRefs,
                                    variant: "ghost",
                                    onClick: (e)=>e.stopPropagation(),
                                    "data-handler-id": handlerId,
                                    label: formatMessage({
                                        id: translations.getTranslation('components.DragHandle-label'),
                                        defaultMessage: 'Drag'
                                    }),
                                    onKeyDown: handleKeyDown,
                                    children: /*#__PURE__*/ jsxRuntime.jsx(Icons.Drag, {})
                                })
                            ]
                        })
                    ]
                }),
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Accordion.Content, {
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                        direction: "column",
                        alignItems: "stretch",
                        background: "neutral100",
                        padding: 6,
                        gap: 6,
                        children: children
                    })
                })
            ]
        })
    });
};
const Preview = ()=>{
    return /*#__PURE__*/ jsxRuntime.jsx(StyledSpan, {
        tag: "span",
        padding: 6,
        background: "primary100"
    });
};
const StyledSpan = styledComponents.styled(designSystem.Box)`
  display: block;
  outline: 1px dashed ${({ theme })=>theme.colors.primary500};
  outline-offset: -1px;
`;

exports.RepeatableComponent = RepeatableComponent;
//# sourceMappingURL=Repeatable.js.map
