'use strict';

var jsxRuntime = require('react/jsx-runtime');
require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var styledComponents = require('styled-components');
var collections = require('../../constants/collections.js');
var plugin = require('../../constants/plugin.js');
var DocumentRBAC = require('../../features/DocumentRBAC.js');
var useDocument = require('../../hooks/useDocument.js');
var useDocumentLayout = require('../../hooks/useDocumentLayout.js');
var useLazyComponents = require('../../hooks/useLazyComponents.js');
var useOnce = require('../../hooks/useOnce.js');
var translations = require('../../utils/translations.js');
var validation = require('../../utils/validation.js');
var Blocker = require('./components/Blocker.js');
var FormLayout = require('./components/FormLayout.js');
var Header = require('./components/Header.js');
var Panels = require('./components/Panels.js');
var data = require('./utils/data.js');

/* -------------------------------------------------------------------------------------------------
 * EditViewPage
 * -----------------------------------------------------------------------------------------------*/ const EditViewPage = ()=>{
    const location = reactRouterDom.useLocation();
    const [{ query: { status } }, setQuery] = strapiAdmin.useQueryParams({
        status: 'draft'
    });
    const { formatMessage } = reactIntl.useIntl();
    const { toggleNotification } = strapiAdmin.useNotification();
    const doc = useDocument.useDoc();
    const { document, meta, isLoading: isLoadingDocument, schema, components, collectionType, id, model, hasError, getTitle, getInitialFormValues } = doc;
    const hasDraftAndPublished = schema?.options?.draftAndPublish ?? false;
    useOnce.useOnce(()=>{
        /**
     * We only ever want to fire the notification once otherwise
     * whenever the app re-renders it'll pop up regardless of
     * what we do because the state comes from react-router-dom
     */ if (location?.state && 'error' in location.state) {
            toggleNotification({
                type: 'danger',
                message: location.state.error,
                timeout: 5000
            });
        }
    });
    const isLoadingActionsRBAC = DocumentRBAC.useDocumentRBAC('EditViewPage', (state)=>state.isLoading);
    const isSingleType = collectionType === collections.SINGLE_TYPES;
    /**
   * single-types don't current have an id, but because they're a singleton
   * we can simply use the update operation to continuously update the same
   * document with varying params.
   */ const isCreatingDocument = !id && !isSingleType;
    const { isLoading: isLoadingLayout, edit: { layout, settings: { mainField } } } = useDocumentLayout.useDocumentLayout(model);
    const pageTitle = getTitle(mainField);
    const { isLazyLoading } = useLazyComponents.useLazyComponents([]);
    const isLoading = isLoadingActionsRBAC || isLoadingDocument || isLoadingLayout || isLazyLoading;
    const initialValues = getInitialFormValues(isCreatingDocument);
    if (isLoading && !document?.documentId) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Loading, {});
    }
    if (!initialValues || hasError) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Error, {});
    }
    const handleTabChange = (status)=>{
        if (status === 'published' || status === 'draft') {
            setQuery({
                status
            }, 'push', true);
        }
    };
    const validateSync = (values, options)=>{
        const yupSchema = validation.createYupSchema(schema?.attributes, components, {
            status,
            ...options
        });
        return yupSchema.validateSync(values, {
            abortEarly: false
        });
    };
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Main, {
        paddingLeft: strapiAdmin.RESPONSIVE_DEFAULT_SPACING,
        paddingRight: strapiAdmin.RESPONSIVE_DEFAULT_SPACING,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Title, {
                children: pageTitle
            }),
            isSingleType && /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.tours.contentManager.Introduction, {
                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {})
            }),
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Form, {
                disabled: hasDraftAndPublished && status === 'published',
                initialValues: initialValues,
                method: isCreatingDocument ? 'POST' : 'PUT',
                validate: (values, options)=>{
                    // removes hidden fields from the validation
                    // this is necessary because the yup schema doesn't know about the visibility conditions
                    // and we don't want to validate fields that are not visible
                    const { data: cleanedValues, removedAttributes } = data.handleInvisibleAttributes(values, {
                        schema,
                        initialValues,
                        components
                    });
                    const yupSchema = validation.createYupSchema(schema?.attributes, components, {
                        status,
                        removedAttributes,
                        ...options
                    });
                    return yupSchema.validate(cleanedValues, {
                        abortEarly: false
                    });
                },
                initialErrors: location?.state?.forceValidation ? validateSync(initialValues, {}) : {},
                children: /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                    children: [
                        /*#__PURE__*/ jsxRuntime.jsx(Header.Header, {
                            isCreating: isCreatingDocument,
                            status: hasDraftAndPublished ? getDocumentStatus(document, meta) : undefined,
                            title: pageTitle
                        }),
                        /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Tabs.Root, {
                            variant: "simple",
                            value: status,
                            onValueChange: handleTabChange,
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tabs.List, {
                                    "aria-label": formatMessage({
                                        id: translations.getTranslation('containers.edit.tabs.label'),
                                        defaultMessage: 'Document status'
                                    }),
                                    children: hasDraftAndPublished ? /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                                        children: [
                                            /*#__PURE__*/ jsxRuntime.jsx(StatusTab, {
                                                value: "draft",
                                                children: formatMessage({
                                                    id: translations.getTranslation('containers.edit.tabs.draft'),
                                                    defaultMessage: 'draft'
                                                })
                                            }),
                                            /*#__PURE__*/ jsxRuntime.jsx(StatusTab, {
                                                disabled: !meta || meta.availableStatus.length === 0,
                                                value: "published",
                                                children: formatMessage({
                                                    id: translations.getTranslation('containers.edit.tabs.published'),
                                                    defaultMessage: 'published'
                                                })
                                            })
                                        ]
                                    }) : null
                                }),
                                /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Grid.Root, {
                                    paddingTop: {
                                        initial: 2,
                                        medium: 4,
                                        large: 8
                                    },
                                    gap: 4,
                                    children: [
                                        /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Grid.Item, {
                                            col: 9,
                                            xs: 12,
                                            direction: "column",
                                            alignItems: "stretch",
                                            children: [
                                                /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Tabs.Content, {
                                                    value: "draft",
                                                    children: [
                                                        /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.tours.contentManager.Fields, {
                                                            children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {})
                                                        }),
                                                        /*#__PURE__*/ jsxRuntime.jsx(FormLayout.FormLayout, {
                                                            layout: layout,
                                                            document: doc
                                                        })
                                                    ]
                                                }),
                                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tabs.Content, {
                                                    value: "published",
                                                    children: /*#__PURE__*/ jsxRuntime.jsx(FormLayout.FormLayout, {
                                                        layout: layout,
                                                        document: doc
                                                    })
                                                })
                                            ]
                                        }),
                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                            col: 3,
                                            xs: 12,
                                            direction: "column",
                                            alignItems: "stretch",
                                            children: /*#__PURE__*/ jsxRuntime.jsx(Panels.Panels, {})
                                        })
                                    ]
                                })
                            ]
                        }),
                        /*#__PURE__*/ jsxRuntime.jsx(Blocker.Blocker, {})
                    ]
                })
            })
        ]
    });
};
const StatusTab = styledComponents.styled(designSystem.Tabs.Trigger)`
  text-transform: uppercase;
`;
/**
 * @internal
 * @description Returns the status of the document where its latest state takes priority,
 * this typically will be "published" unless a user has edited their draft in which we should
 * display "modified".
 */ const getDocumentStatus = (document, meta)=>{
    const docStatus = document?.status;
    const statuses = meta?.availableStatus ?? [];
    /**
   * Creating an entry
   */ if (!docStatus) {
        return 'draft';
    }
    /**
   * We're viewing a draft, but the document could have a published version
   */ if (docStatus === 'draft' && statuses.find((doc)=>doc.publishedAt !== null)) {
        return 'published';
    }
    return docStatus;
};
/* -------------------------------------------------------------------------------------------------
 * ProtectedEditViewPage
 * -----------------------------------------------------------------------------------------------*/ const ProtectedEditViewPage = ()=>{
    const { slug = '' } = reactRouterDom.useParams();
    const { permissions = [], isLoading, error } = strapiAdmin.useRBAC(plugin.PERMISSIONS.map((action)=>({
            action,
            subject: slug
        })));
    if (isLoading) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Loading, {});
    }
    if (error || !slug) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Error, {});
    }
    return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Protect, {
        permissions: permissions,
        children: ({ permissions })=>/*#__PURE__*/ jsxRuntime.jsx(DocumentRBAC.DocumentRBAC, {
                permissions: permissions,
                children: /*#__PURE__*/ jsxRuntime.jsx(EditViewPage, {})
            })
    });
};

exports.EditViewPage = EditViewPage;
exports.ProtectedEditViewPage = ProtectedEditViewPage;
exports.getDocumentStatus = getDocumentStatus;
//# sourceMappingURL=EditViewPage.js.map
