'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var Icons = require('@strapi/icons');
var qs = require('qs');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var plugin = require('../../constants/plugin.js');
var History = require('../pages/History.js');
var historyVersion = require('../services/historyVersion.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const VersionHeader = ({ headerId })=>{
    const [isConfirmDialogOpen, setIsConfirmDialogOpen] = React__namespace.useState(false);
    const navigate = reactRouterDom.useNavigate();
    const { formatMessage, formatDate } = reactIntl.useIntl();
    const { trackUsage } = strapiAdmin.useTracking();
    const { toggleNotification } = strapiAdmin.useNotification();
    const [{ query }] = strapiAdmin.useQueryParams();
    const { collectionType, slug } = reactRouterDom.useParams();
    const [restoreVersion, { isLoading }] = historyVersion.useRestoreVersionMutation();
    const { allowedActions } = strapiAdmin.useRBAC(plugin.PERMISSIONS.map((action)=>({
            action,
            subject: slug
        })));
    const version = History.useHistoryContext('VersionHeader', (state)=>state.selectedVersion);
    const mainField = History.useHistoryContext('VersionHeader', (state)=>state.mainField);
    const schema = History.useHistoryContext('VersionHeader', (state)=>state.schema);
    const isCurrentVersion = History.useHistoryContext('VersionHeader', (state)=>state.page === 1 && state.versions.data[0].id === state.selectedVersion.id);
    const mainFieldValue = version.data[mainField];
    const getNextNavigation = ()=>{
        const pluginsQueryParams = qs.stringify({
            plugins: query.plugins
        }, {
            encode: false
        });
        return {
            pathname: '..',
            search: pluginsQueryParams
        };
    };
    const handleRestore = async ()=>{
        try {
            const response = await restoreVersion({
                documentId: version.relatedDocumentId,
                collectionType,
                params: {
                    versionId: version.id,
                    contentType: version.contentType
                },
                body: {
                    contentType: version.contentType
                }
            });
            if ('data' in response) {
                navigate(getNextNavigation(), {
                    relative: 'path'
                });
                toggleNotification({
                    type: 'success',
                    title: formatMessage({
                        id: 'content-manager.restore.success.title',
                        defaultMessage: 'Version restored.'
                    }),
                    message: formatMessage({
                        id: 'content-manager.restore.success.message',
                        defaultMessage: 'A past version of the content was restored.'
                    })
                });
                trackUsage('didRestoreHistoryVersion');
            }
            if ('error' in response) {
                toggleNotification({
                    type: 'danger',
                    message: formatMessage({
                        id: 'content-manager.history.restore.error.message',
                        defaultMessage: 'Could not restore version.'
                    })
                });
            }
        } catch (error) {
            toggleNotification({
                type: 'danger',
                message: formatMessage({
                    id: 'notification.error',
                    defaultMessage: 'An error occurred'
                })
            });
        }
    };
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Dialog.Root, {
        open: isConfirmDialogOpen,
        onOpenChange: setIsConfirmDialogOpen,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.BaseHeader, {
                id: headerId,
                title: formatDate(new Date(version.createdAt), {
                    year: 'numeric',
                    month: 'numeric',
                    day: 'numeric',
                    hour: 'numeric',
                    minute: 'numeric'
                }),
                secondaryAction: /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.GradientBadge, {
                    label: formatMessage({
                        id: 'components.premiumFeature.title',
                        defaultMessage: 'Premium feature'
                    })
                }),
                subtitle: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                    variant: "epsilon",
                    textColor: "neutral600",
                    children: formatMessage({
                        id: 'content-manager.history.version.subtitle',
                        defaultMessage: '{hasLocale, select, true {{subtitle}, in {locale}} other {{subtitle}}}'
                    }, {
                        hasLocale: Boolean(version.locale),
                        subtitle: `${mainFieldValue || ''} (${schema.info.singularName})`.trim(),
                        locale: version.locale?.name
                    })
                }),
                navigationAction: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Link, {
                    startIcon: /*#__PURE__*/ jsxRuntime.jsx(Icons.ArrowLeft, {}),
                    tag: reactRouterDom.NavLink,
                    to: getNextNavigation(),
                    relative: "path",
                    isExternal: false,
                    children: formatMessage({
                        id: 'global.back',
                        defaultMessage: 'Back'
                    })
                }),
                sticky: false,
                primaryAction: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Dialog.Trigger, {
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                        disabled: !allowedActions.canUpdate || isCurrentVersion,
                        onClick: ()=>{
                            setIsConfirmDialogOpen(true);
                        },
                        children: formatMessage({
                            id: 'content-manager.history.restore.confirm.button',
                            defaultMessage: 'Restore'
                        })
                    })
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.ConfirmDialog, {
                onConfirm: handleRestore,
                endAction: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                    fullWidth: true,
                    variant: "secondary",
                    onClick: handleRestore,
                    loading: isLoading,
                    children: formatMessage({
                        id: 'content-manager.history.restore.confirm.button',
                        defaultMessage: 'Restore'
                    })
                }),
                children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                    direction: "column",
                    alignItems: "center",
                    justifyContent: "center",
                    gap: 2,
                    textAlign: "center",
                    children: [
                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                            justifyContent: "center",
                            children: /*#__PURE__*/ jsxRuntime.jsx(Icons.WarningCircle, {
                                width: "24px",
                                height: "24px",
                                fill: "danger600"
                            })
                        }),
                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                            children: formatMessage({
                                id: 'content-manager.history.restore.confirm.title',
                                defaultMessage: 'Are you sure you want to restore this version?'
                            })
                        }),
                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                            children: formatMessage({
                                id: 'content-manager.history.restore.confirm.message',
                                defaultMessage: "{isDraft, select, true {The restored content will override your draft.} other {The restored content won't be published, it will override the draft and be saved as pending changes. You'll be able to publish the changes at anytime.}}"
                            }, {
                                isDraft: version.status === 'draft'
                            })
                        })
                    ]
                })
            })
        ]
    });
};

exports.VersionHeader = VersionHeader;
//# sourceMappingURL=VersionHeader.js.map
