'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var qs = require('qs');
var reactIntl = require('react-intl');
var useContentManagerInitData = require('../hooks/useContentManagerInitData.js');
var useContentTypeSchema = require('../hooks/useContentTypeSchema.js');
var hooks = require('../modules/hooks.js');
var translations = require('../utils/translations.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const LeftMenu = ({ isFullPage = false })=>{
    const [search, setSearch] = React__namespace.useState('');
    const [{ query }] = strapiAdmin.useQueryParams();
    const { formatMessage, locale } = reactIntl.useIntl();
    // Initialize Content Manager data to ensure links are available
    const { isLoading } = useContentManagerInitData.useContentManagerInitData();
    const collectionTypeLinks = hooks.useTypedSelector((state)=>state['content-manager'].app.collectionTypeLinks);
    const singleTypeLinks = hooks.useTypedSelector((state)=>state['content-manager'].app.singleTypeLinks);
    const { schemas } = useContentTypeSchema.useContentTypeSchema();
    const { contains } = designSystem.useFilter(locale, {
        sensitivity: 'base'
    });
    const formatter = designSystem.useCollator(locale, {
        sensitivity: 'base'
    });
    const menu = React__namespace.useMemo(()=>[
            {
                id: 'collectionTypes',
                title: formatMessage({
                    id: translations.getTranslation('components.LeftMenu.collection-types'),
                    defaultMessage: 'Collection Types'
                }),
                searchable: true,
                links: collectionTypeLinks
            },
            {
                id: 'singleTypes',
                title: formatMessage({
                    id: translations.getTranslation('components.LeftMenu.single-types'),
                    defaultMessage: 'Single Types'
                }),
                searchable: true,
                links: singleTypeLinks
            }
        ].map((section)=>({
                ...section,
                links: section.links/**
           * Filter by the search value
           */ .filter((link)=>contains(link.title, search.trim()))/**
           * Sort correctly using the language
           */ .sort((a, b)=>formatter.compare(a.title, b.title))/**
           * Apply the formated strings to the links from react-intl
           */ .map((link)=>{
                    return {
                        ...link,
                        title: formatMessage({
                            id: link.title,
                            defaultMessage: link.title
                        })
                    };
                })
            })), [
        collectionTypeLinks,
        search,
        singleTypeLinks,
        contains,
        formatMessage,
        formatter
    ]);
    const handleClear = ()=>{
        setSearch('');
    };
    const handleChangeSearch = (event)=>{
        setSearch(event.target.value);
    };
    const label = formatMessage({
        id: translations.getTranslation('header.name'),
        defaultMessage: 'Content Manager'
    });
    const getPluginsParamsForLink = (link)=>{
        const schema = schemas.find((schema)=>schema.uid === link.uid);
        const isI18nEnabled = Boolean(schema?.pluginOptions?.i18n?.localized);
        // The search params have the i18n plugin
        if (query.plugins && 'i18n' in query.plugins) {
            // Prepare removal of i18n from the plugins search params
            const { i18n, ...restPlugins } = query.plugins;
            // i18n is not enabled, remove it from the plugins search params
            if (!isI18nEnabled) {
                return restPlugins;
            }
            // i18n is enabled, put the plugins search params back together
            return {
                i18n,
                ...restPlugins
            };
        }
        return query.plugins;
    };
    // Show loading state while data is being fetched
    if (isLoading) {
        return /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.SubNav.Main, {
            "aria-label": label,
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.SubNav.Header, {
                    label: label
                }),
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Divider, {}),
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                    padding: 4,
                    justifyContent: "center",
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Loader, {})
                })
            ]
        });
    }
    return /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.SubNav.Main, {
        "aria-label": label,
        children: [
            !isFullPage && /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.SubNav.Header, {
                        label: label
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Divider, {})
                ]
            }),
            /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.SubNav.Content, {
                children: [
                    isFullPage && /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.SubNav.Header, {
                        label: label
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                        paddingLeft: {
                            initial: 4,
                            large: 5
                        },
                        paddingRight: {
                            initial: 4,
                            large: 5
                        },
                        paddingTop: isFullPage ? 0 : {
                            initial: 4,
                            large: 5
                        },
                        paddingBottom: 0,
                        gap: 3,
                        direction: "column",
                        alignItems: "stretch",
                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Searchbar, {
                            value: search,
                            onChange: handleChangeSearch,
                            onClear: handleClear,
                            placeholder: formatMessage({
                                id: 'search.placeholder',
                                defaultMessage: 'Search'
                            }),
                            size: "S",
                            // eslint-disable-next-line react/no-children-prop
                            children: undefined,
                            name: 'search_contentType',
                            clearLabel: formatMessage({
                                id: 'clearLabel',
                                defaultMessage: 'Clear'
                            })
                        })
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.SubNav.Sections, {
                        children: menu.map((section)=>{
                            return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.SubNav.Section, {
                                label: section.title,
                                badgeLabel: section.links.length.toString(),
                                children: section.links.map((link)=>{
                                    return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.SubNav.Link, {
                                        to: {
                                            pathname: link.to,
                                            search: qs.stringify({
                                                ...qs.parse(link.search ?? ''),
                                                plugins: getPluginsParamsForLink(link)
                                            })
                                        },
                                        label: link.title
                                    }, link.uid);
                                })
                            }, section.id);
                        })
                    })
                ]
            })
        ]
    });
};

exports.LeftMenu = LeftMenu;
//# sourceMappingURL=LeftMenu.js.map
