'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var fractionalIndexing = require('fractional-indexing');
var pipe = require('lodash/fp/pipe');
var reactIntl = require('react-intl');
var attributes = require('../../constants/attributes.js');
var strings = require('../../utils/strings.js');
var translations = require('../../utils/translations.js');
var Fields = require('./Fields.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const ConfigurationForm = ({ attributes: attributes$1, fieldSizes, layout: editLayout, onSubmit })=>{
    const { components, settings, layout, metadatas } = editLayout;
    const { formatMessage } = reactIntl.useIntl();
    const initialValues = React__namespace.useMemo(()=>{
        const transformations = pipe(flattenPanels, replaceMainFieldWithNameOnly, extractMetadata, addTmpSpaceToLayout, addTmpKeysToLayout);
        return {
            layout: transformations(layout),
            settings
        };
    }, [
        layout,
        settings
    ]);
    return /*#__PURE__*/ jsxRuntime.jsx(jsxRuntime.Fragment, {
        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Main, {
            children: /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Form, {
                initialValues: initialValues,
                onSubmit: onSubmit,
                method: "PUT",
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(Header, {
                        name: settings.displayName ?? ''
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Content, {
                        children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                            alignItems: "stretch",
                            background: "neutral0",
                            direction: "column",
                            gap: 6,
                            hasRadius: true,
                            shadow: "tableShadow",
                            paddingTop: 6,
                            paddingBottom: 6,
                            paddingLeft: 7,
                            paddingRight: 7,
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                    variant: "delta",
                                    tag: "h2",
                                    children: formatMessage({
                                        id: translations.getTranslation('containers.SettingPage.settings'),
                                        defaultMessage: 'Settings'
                                    })
                                }),
                                /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Grid.Root, {
                                    children: [
                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                            col: 6,
                                            xs: 12,
                                            direction: "column",
                                            alignItems: "stretch",
                                            children: /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.InputRenderer, {
                                                type: "enumeration",
                                                label: formatMessage({
                                                    id: translations.getTranslation('containers.SettingPage.editSettings.entry.title'),
                                                    defaultMessage: 'Entry title'
                                                }),
                                                hint: formatMessage({
                                                    id: translations.getTranslation('containers.SettingPage.editSettings.entry.title.description'),
                                                    defaultMessage: 'Set the display field of your entry'
                                                }),
                                                name: "settings.mainField",
                                                options: Object.entries(attributes$1).reduce((acc, [key, attribute])=>{
                                                    if (!attribute) {
                                                        return acc;
                                                    }
                                                    /**
                       * Create the list of attributes from the schema as to which can
                       * be our `mainField` and dictate the display name of the schema
                       * we're editing.
                       */ if (!attributes.ATTRIBUTE_TYPES_THAT_CANNOT_BE_MAIN_FIELD.includes(attribute.type)) {
                                                        acc.push({
                                                            label: key,
                                                            value: key
                                                        });
                                                    }
                                                    return acc;
                                                }, [])
                                            })
                                        }),
                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                            paddingTop: 6,
                                            paddingBottom: 6,
                                            col: 12,
                                            s: 12,
                                            direction: "column",
                                            alignItems: "stretch",
                                            children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Divider, {})
                                        }),
                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                            col: 12,
                                            s: 12,
                                            direction: "column",
                                            alignItems: "stretch",
                                            children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                                variant: "delta",
                                                tag: "h3",
                                                children: formatMessage({
                                                    id: translations.getTranslation('containers.SettingPage.view'),
                                                    defaultMessage: 'View'
                                                })
                                            })
                                        }),
                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                            col: 12,
                                            s: 12,
                                            direction: "column",
                                            alignItems: "stretch",
                                            children: /*#__PURE__*/ jsxRuntime.jsx(Fields.Fields, {
                                                attributes: attributes$1,
                                                components: components,
                                                fieldSizes: fieldSizes,
                                                metadatas: metadatas
                                            })
                                        })
                                    ]
                                })
                            ]
                        })
                    })
                ]
            })
        })
    });
};
/**
 * @internal
 * @description Panels don't exist in the layout, so we flatten by one.
 */ const flattenPanels = (layout)=>layout.flat(1);
/**
 * @internal
 * @description We don't need the mainField object in the layout, we only need the name.
 */ const replaceMainFieldWithNameOnly = (layout)=>layout.map((row)=>row.map((field)=>({
                ...field,
                mainField: field.mainField?.name
            })));
/**
 * @internal
 * @description We extract the metadata values from the field layout, because these are editable by the user.
 */ const extractMetadata = (layout)=>{
    return layout.map((row)=>row.map(({ label, disabled, hint, placeholder, size, name, mainField })=>({
                label,
                editable: !disabled,
                description: hint,
                mainField,
                placeholder,
                size,
                name,
                __temp_key__: ''
            })));
};
/**
 * @internal
 * @description Each row of the layout has a max size of 12 (based on bootstrap grid system)
 * So in order to offer a better drop zone we add the _TEMP_ div to complete the remaining substract (12 - existing)
 */ const addTmpSpaceToLayout = (layout)=>[
        ...layout.map((row)=>{
            const totalSpaceTaken = row.reduce((acc, field)=>acc + field.size, 0);
            if (totalSpaceTaken < 12) {
                return [
                    ...row,
                    {
                        name: Fields.TEMP_FIELD_NAME,
                        size: 12 - totalSpaceTaken,
                        __temp_key__: ''
                    }
                ];
            }
            return row;
        })
    ];
/**
 * @internal
 * @description At this point of the transformations we have Field[][], but each row for the form should have a __temp_key__
 * applied. This means we need to change it so `Field` is nested under the children property.
 */ const addTmpKeysToLayout = (layout)=>{
    const keys = fractionalIndexing.generateNKeysBetween(undefined, undefined, layout.length);
    return layout.map((row, rowIndex)=>{
        const fieldKeys = fractionalIndexing.generateNKeysBetween(undefined, undefined, row.length);
        return {
            __temp_key__: keys[rowIndex],
            children: row.map((field, fieldIndex)=>{
                return {
                    ...field,
                    __temp_key__: fieldKeys[fieldIndex]
                };
            })
        };
    });
};
const Header = ({ name })=>{
    const { formatMessage } = reactIntl.useIntl();
    const modified = strapiAdmin.useForm('Header', (state)=>state.modified);
    const isSubmitting = strapiAdmin.useForm('Header', (state)=>state.isSubmitting);
    return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Header, {
        title: formatMessage({
            id: translations.getTranslation('components.SettingsViewWrapper.pluginHeader.title'),
            defaultMessage: `Configure the view - {name}`
        }, {
            name: strings.capitalise(name)
        }),
        subtitle: formatMessage({
            id: translations.getTranslation('components.SettingsViewWrapper.pluginHeader.description.edit-settings'),
            defaultMessage: 'Customize how the edit view will look like.'
        }),
        navigationAction: /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.BackButton, {}),
        primaryAction: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
            disabled: !modified,
            loading: isSubmitting,
            type: "submit",
            children: formatMessage({
                id: 'global.save',
                defaultMessage: 'Save'
            })
        })
    });
};

exports.ConfigurationForm = ConfigurationForm;
//# sourceMappingURL=Form.js.map
