var name = "@strapi/cloud-cli";
var version = "5.33.1";
var description = "Commands to interact with the Strapi Cloud";
var keywords = [
    "strapi",
    "cloud",
    "cli"
];
var homepage = "https://strapi.io";
var bugs = {
    url: "https://github.com/strapi/strapi/issues"
};
var repository = {
    type: "git",
    url: "git://github.com/strapi/strapi.git"
};
var license = "SEE LICENSE IN LICENSE";
var author = {
    name: "Strapi Solutions SAS",
    email: "hi@strapi.io",
    url: "https://strapi.io"
};
var maintainers = [
    {
        name: "Strapi Solutions SAS",
        email: "hi@strapi.io",
        url: "https://strapi.io"
    }
];
var main = "./dist/index.js";
var module = "./dist/index.mjs";
var source = "./src/index.ts";
var types = "./dist/index.d.ts";
var bin = "./bin/index.js";
var files = [
    "./dist",
    "./bin"
];
var scripts = {
    build: "run -T npm-run-all clean --parallel build:code build:types",
    "build:code": "run -T  rollup -c",
    "build:types": "run -T tsc -p tsconfig.build.json --emitDeclarationOnly",
    clean: "run -T rimraf ./dist",
    lint: "run -T eslint .",
    "test:unit": "run -T jest",
    watch: "run -T rollup -c -w"
};
var dependencies = {
    "@strapi/utils": "5.33.1",
    axios: "1.12.2",
    boxen: "5.1.2",
    chalk: "4.1.2",
    "cli-progress": "3.12.0",
    commander: "8.3.0",
    eventsource: "2.0.2",
    "fast-safe-stringify": "2.1.1",
    "fs-extra": "11.2.0",
    inquirer: "8.2.5",
    jsonwebtoken: "9.0.0",
    "jwks-rsa": "3.1.0",
    lodash: "4.17.21",
    minimatch: "9.0.3",
    open: "8.4.0",
    ora: "5.4.1",
    "pkg-up": "3.1.0",
    tar: "6.2.1",
    "xdg-app-paths": "8.3.0",
    yup: "0.32.9"
};
var devDependencies = {
    "@types/cli-progress": "3.11.5",
    "@types/eventsource": "1.1.15",
    "@types/lodash": "^4.14.191",
    "eslint-config-custom": "5.33.1",
    tsconfig: "5.33.1"
};
var engines = {
    node: ">=20.0.0 <=24.x.x",
    npm: ">=6.0.0"
};
var packageJson = {
    name: name,
    version: version,
    description: description,
    keywords: keywords,
    homepage: homepage,
    bugs: bugs,
    repository: repository,
    license: license,
    author: author,
    maintainers: maintainers,
    main: main,
    module: module,
    source: source,
    types: types,
    bin: bin,
    files: files,
    scripts: scripts,
    dependencies: dependencies,
    devDependencies: devDependencies,
    engines: engines
};

export { author, bin, bugs, packageJson as default, dependencies, description, devDependencies, engines, files, homepage, keywords, license, main, maintainers, module, name, repository, scripts, source, types, version };
//# sourceMappingURL=package.json.mjs.map
