import type { Modules } from '@strapi/types';
export declare const REFRESH_COOKIE_NAME = "strapi_admin_refresh";
export declare const DEFAULT_MAX_REFRESH_TOKEN_LIFESPAN: number;
export declare const DEFAULT_IDLE_REFRESH_TOKEN_LIFESPAN: number;
export declare const DEFAULT_MAX_SESSION_LIFESPAN: number;
export declare const DEFAULT_IDLE_SESSION_LIFESPAN: number;
export declare const getRefreshCookieOptions: (secureRequest?: boolean) => {
    httpOnly: boolean;
    secure: boolean;
    overwrite: boolean;
    domain: string | undefined;
    path: string;
    sameSite: boolean | "none" | "strict" | "lax";
    maxAge: undefined;
};
export declare const buildCookieOptionsWithExpiry: (type: 'refresh' | 'session', absoluteExpiresAtISO?: string, secureRequest?: boolean) => {
    httpOnly: boolean;
    secure: boolean;
    overwrite: boolean;
    domain: string | undefined;
    path: string;
    sameSite: boolean | "none" | "strict" | "lax";
    maxAge: undefined;
} | {
    expires: Date;
    maxAge: number;
    httpOnly: boolean;
    secure: boolean;
    overwrite: boolean;
    domain: string | undefined;
    path: string;
    sameSite: boolean | "none" | "strict" | "lax";
};
export declare const getSessionManager: () => Modules.SessionManager.SessionManagerService | null;
export declare const generateDeviceId: () => string;
export declare const extractDeviceParams: (requestBody: unknown) => {
    deviceId: string;
    rememberMe: boolean;
};
