/// <reference types="koa" />
declare let admin: {
    bootstrap: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => Promise<void>;
    register: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => void;
    destroy: () => Promise<void>;
    config: {
        forgotPassword: {
            emailTemplate: {
                subject: string;
                text: string;
                html: string;
            };
        };
    };
    policies: {
        isAuthenticatedAdmin: (policyCtx: any) => boolean;
        hasPermissions: {
            name: string;
            validator: (config: unknown) => void;
            handler: (...args: any[]) => any;
        };
        isTelemetryEnabled: {
            name: string;
            validator: (config: unknown) => void;
            handler: (...args: any[]) => any;
        };
    };
    routes: {
        admin: {
            type: string;
            routes: ({
                method: string;
                path: string;
                handler: string;
                config: {
                    auth: boolean;
                    policies?: undefined;
                };
            } | {
                method: string;
                path: string;
                handler: string;
                config: {
                    policies: (string | {
                        name: string;
                        config: {
                            actions: string[];
                        };
                    })[];
                };
            } | {
                method: string;
                path: string;
                handler: string;
                config: {
                    middlewares: string[];
                    auth: {
                        strategies: {
                            name: string;
                            authenticate: (ctx: import("koa").Context) => Promise<{
                                authenticated: boolean;
                                error?: undefined;
                                ability?: undefined;
                                credentials?: undefined;
                            } | {
                                authenticated: boolean;
                                error: import("@strapi/utils/dist/errors").UnauthorizedError<"Token expired", unknown>;
                                ability?: undefined;
                                credentials?: undefined;
                            } | {
                                authenticated: boolean;
                                ability: import("@casl/ability").Ability<import("@casl/ability").AbilityTuple, any>;
                                credentials: import("../../shared/contracts/transfer").SanitizedTransferToken;
                                error?: undefined;
                            }>;
                            verify: (auth: any, config?: any) => Promise<void>;
                        }[];
                        scope: string[];
                    };
                    policies?: undefined;
                };
            })[];
        };
    };
    services: {
        auth: {
            checkCredentials: ({ email, password }: {
                email: string;
                password: string;
            }) => Promise<(import("../../shared/contracts/shared").AdminUser | null)[] | (boolean | {
                message: string;
            } | null)[]>;
            validatePassword: (password: string, hash: string) => Promise<boolean>;
            hashPassword: (password: string) => Promise<string>;
            forgotPassword: ({ email }?: {
                email: string;
            }) => Promise<any>;
            resetPassword: ({ resetPasswordToken, password }?: {
                resetPasswordToken: string;
                password: string;
            }) => Promise<import("../../shared/contracts/shared").AdminUser>;
        };
        user: {
            create: (attributes: Partial<import("../../shared/contracts/shared").AdminUserCreationPayload> & {
                isActive?: true | undefined;
            }) => Promise<import("../../shared/contracts/shared").AdminUser>;
            updateById: (id: import("@strapi/types/dist/data").ID, attributes: Partial<import("../../shared/contracts/shared").AdminUserUpdatePayload>) => Promise<import("../../shared/contracts/shared").AdminUser>;
            exists: (attributes?: unknown) => Promise<boolean>;
            findRegistrationInfo: (registrationToken: string) => Promise<Pick<import("../../shared/contracts/shared").AdminUser, "firstname" | "lastname" | "email"> | undefined>;
            register: ({ registrationToken, userInfo, }: {
                registrationToken: string;
                userInfo: Partial<import("../../shared/contracts/shared").AdminUser>;
            }) => Promise<import("../../shared/contracts/shared").AdminUser>;
            sanitizeUser: (user: import("../../shared/contracts/shared").AdminUser) => import("../../shared/contracts/shared").SanitizedAdminUser;
            findOne: (id: import("@strapi/types/dist/data").ID, populate?: string[]) => Promise<any>;
            findOneByEmail: (email: string, populate?: never[]) => Promise<any>;
            findPage: (params?: {}) => Promise<unknown>;
            deleteById: (id: import("@strapi/types/dist/data").ID) => Promise<import("../../shared/contracts/shared").AdminUser | null>;
            deleteByIds: (ids: (string | number)[]) => Promise<import("../../shared/contracts/shared").AdminUser[]>;
            countUsersWithoutRole: () => Promise<number>;
            count: (where?: {}) => Promise<number>;
            assignARoleToAll: (roleId: import("@strapi/types/dist/data").ID) => Promise<void>;
            displayWarningIfUsersDontHaveRole: () => Promise<void>;
            resetPasswordByEmail: (email: string, password: string) => Promise<void>;
            getLanguagesInUse: () => Promise<string[]>;
            isFirstSuperAdminUser: (userId: import("@strapi/types/dist/data").ID) => Promise<boolean>;
        };
        role: {
            hooks: {
                willResetSuperAdminPermissions: {
                    call(param: unknown): Promise<unknown>;
                    getHandlers(): import("@strapi/utils/dist/hooks").Handler[];
                    register(handler: import("@strapi/utils/dist/hooks").Handler): import("@strapi/utils/dist/hooks").Hook<import("@strapi/utils/dist/hooks").Handler>;
                    delete(handler: import("@strapi/utils/dist/hooks").Handler): import("@strapi/utils/dist/hooks").Hook<import("@strapi/utils/dist/hooks").Handler>;
                };
            };
            sanitizeRole: <T extends object>(obj: T) => Omit<T, "users" | "permissions">;
            create: (attributes: Partial<import("../../shared/contracts/shared").AdminRole>) => Promise<import("../../shared/contracts/shared").AdminRole>;
            findOne: (params?: {}, populate?: unknown) => Promise<import("../../shared/contracts/shared").AdminRole>;
            findOneWithUsersCount: (params?: {}, populate?: unknown) => Promise<import("./services/role").AdminRoleWithUsersCount>;
            find: (params: {} | undefined, populate: unknown) => Promise<import("../../shared/contracts/shared").AdminRole[]>;
            findAllWithUsersCount: (params: any) => Promise<import("./services/role").AdminRoleWithUsersCount[]>;
            update: (params: any, attributes: Partial<import("../../shared/contracts/shared").AdminRole>) => Promise<import("../../shared/contracts/shared").AdminRole>;
            exists: (params?: unknown) => Promise<boolean>;
            count: (params?: any) => Promise<number>;
            deleteByIds: (ids?: import("@strapi/types/dist/data").ID[]) => Promise<import("../../shared/contracts/shared").AdminRole[]>;
            getUsersCount: (roleId: import("@strapi/types/dist/data").ID) => Promise<number>;
            getSuperAdmin: () => Promise<import("../../shared/contracts/shared").AdminRole | undefined>;
            getSuperAdminWithUsersCount: () => Promise<import("./services/role").AdminRoleWithUsersCount>;
            createRolesIfNoneExist: () => Promise<void>;
            displayWarningIfNoSuperAdmin: () => Promise<void>;
            addPermissions: (roleId: import("@strapi/types/dist/data").ID, permissions: any) => Promise<import("../../shared/contracts/shared").Permission[]>;
            hasSuperAdminRole: (user: import("../../shared/contracts/shared").AdminUser) => boolean;
            assignPermissions: (roleId: import("@strapi/types/dist/data").ID, permissions?: Pick<import("../../shared/contracts/shared").Permission, "conditions" | "action" | "subject">[]) => Promise<import("../../shared/contracts/shared").Permission[]>;
            resetSuperAdminPermissions: () => Promise<void>;
            checkRolesIdForDeletion: (ids?: import("@strapi/types/dist/data").ID[]) => Promise<void>;
            constants: {
                superAdminCode: string;
            };
        };
        passport: {
            init: () => import("koa").Middleware;
            getPassportStrategies: () => import("passport-local").Strategy[];
            authEventsMapper: {
                onConnectionSuccess: string;
                onConnectionError: string;
            };
        };
        token: typeof import("./services/token");
        permission: typeof import("./services/permission");
        metrics: {
            sendDidInviteUser: () => Promise<void>;
            sendDidUpdateRolePermissions: () => Promise<void>;
            sendDidChangeInterfaceLanguage: () => Promise<void>;
            sendUpdateProjectInformation: (strapi: import("@strapi/types/dist/core").Strapi) => Promise<void>;
            startCron: (strapi: import("@strapi/types/dist/core").Strapi) => void;
        };
        'content-type': typeof import("./services/content-type");
        constants: typeof import("./services/constants");
        condition: typeof import("./services/condition");
        action: typeof import("./services/action");
        'api-token': typeof import("./services/api-token");
        transfer: typeof import("./services/transfer");
        'project-settings': typeof import("./services/project-settings");
        encryption: {
            encrypt: (value: string) => string | null;
            decrypt: (encryptedValue: string) => string | null;
        };
        homepage: ({ strapi }: {
            strapi: import("@strapi/types/dist/core").Strapi;
        }) => {
            getKeyStatistics: () => Promise<{
                assets: number;
                contentTypes: number;
                components: number;
                locales: any;
                admins: number;
                webhooks: number;
                apiTokens: number;
            }>;
            getHomepageLayout: (userId: number) => Promise<{
                updatedAt: string;
                version: number;
                widgets: {
                    uid: string;
                    width: 8 | 6 | 4 | 12;
                }[];
            } | null>;
            updateHomepageLayout: (userId: number, input: unknown) => Promise<{
                updatedAt: string;
                version: number;
                widgets: {
                    uid: string;
                    width: 8 | 6 | 4 | 12;
                }[];
            }>;
        };
    };
    controllers: {
        admin: {
            getProjectType(): Promise<{
                data: {
                    isEE: boolean;
                    features: never[];
                    flags: {};
                    ai: {
                        enabled: boolean;
                    };
                };
            }>;
            init(): Promise<{
                data: {
                    uuid: false;
                    hasAdmin: boolean;
                    menuLogo: string | null;
                    authLogo: string | null;
                };
            }>;
            getProjectSettings(): Promise<import("../../shared/contracts/admin").GetProjectSettings.Response>;
            updateProjectSettings(ctx: import("koa").Context): Promise<import("../../shared/contracts/admin").GetProjectSettings.Response>;
            telemetryProperties(ctx: import("koa").Context): Promise<{
                data: {
                    useTypescriptOnServer: any;
                    useTypescriptOnAdmin: any;
                    isHostedOnStrapiCloud: boolean;
                    numberOfAllContentTypes: number;
                    numberOfComponents: number;
                    numberOfDynamicZones: number;
                };
            } | undefined>;
            information(): Promise<{
                data: {
                    currentEnvironment: string;
                    autoReload: false;
                    strapiVersion: null;
                    dependencies: {};
                    projectId: null;
                    nodeVersion: string;
                    communityEdition: boolean;
                    useYarn: boolean;
                };
            }>;
            plugins(ctx: import("koa").Context): Promise<void>;
            licenseTrialTimeLeft(): Promise<{
                trialEndsAt: string;
            } | null>;
            getGuidedTourMeta(ctx: import("koa").Context): Promise<{
                data: {
                    isFirstSuperAdminUser: boolean;
                    schemas: import("@strapi/types/dist/public").ContentTypeSchemas;
                };
            }>;
        };
        'api-token': {
            create(ctx: import("koa").Context): Promise<void>;
            regenerate(ctx: import("koa").Context): Promise<void>;
            list(ctx: import("koa").Context): Promise<void>;
            revoke(ctx: import("koa").Context): Promise<void>;
            get(ctx: import("koa").Context): Promise<void>;
            update(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            getLayout(ctx: import("koa").Context): Promise<void>;
        };
        'authenticated-user': {
            getMe(ctx: import("koa").Context): Promise<void>;
            updateMe(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            getOwnPermissions(ctx: import("koa").Context): Promise<void>;
        };
        authentication: {
            login: import("koa").Middleware<import("koa").DefaultState, import("koa").Context, any>;
            registrationInfo(ctx: import("koa").Context): Promise<void>;
            register(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            registerAdmin(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            forgotPassword(ctx: import("koa").Context): Promise<void>;
            resetPassword(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            accessToken(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            logout(ctx: import("koa").Context): Promise<void>;
        };
        permission: {
            check(ctx: import("koa").Context): Promise<void>;
            getAll(ctx: import("koa").Context): Promise<void>;
        };
        role: {
            create(ctx: import("koa").Context): Promise<void>;
            findOne(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            findAll(ctx: import("koa").Context): Promise<void>;
            update(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            getPermissions(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            updatePermissions(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            deleteOne(ctx: import("koa").Context): Promise<any>;
            deleteMany(ctx: import("koa").Context): Promise<any>;
        };
        transfer: {
            [x: string]: any;
        };
        user: {
            create(ctx: import("koa").Context): Promise<void>;
            find(ctx: import("koa").Context): Promise<void>;
            findOne(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            update(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            deleteOne(ctx: import("koa").Context): Promise<any>;
            deleteMany(ctx: import("koa").Context): Promise<any>;
        };
        webhooks: {
            listWebhooks(ctx: import("koa").Context): Promise<void>;
            getWebhook(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            createWebhook(ctx: import("koa").Context): Promise<void>;
            updateWebhook(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            deleteWebhook(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            deleteWebhooks(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            triggerWebhook(ctx: import("koa").Context): Promise<void>;
        };
        'content-api': {
            getPermissions(ctx: import("koa").Context): Promise<void>;
            getRoutes(ctx: import("koa").Context): Promise<void>;
        };
        homepage: {
            getKeyStatistics(): Promise<{
                data: {
                    assets: number;
                    contentTypes: number;
                    components: number;
                    locales: any;
                    admins: number;
                    webhooks: number;
                    apiTokens: number;
                };
            }>;
            getHomepageLayout(ctx: import("koa").Context): Promise<{
                data: {
                    updatedAt: string;
                    version: number;
                    widgets: {
                        uid: string;
                        width: 8 | 6 | 4 | 12;
                    }[];
                } | null;
            }>;
            updateHomepageLayout(ctx: import("koa").Context): Promise<{
                data: {
                    updatedAt: string;
                    version: number;
                    widgets: {
                        uid: string;
                        width: 8 | 6 | 4 | 12;
                    }[];
                };
            }>;
        };
    };
    contentTypes: {
        permission: {
            schema: {
                collectionName: string;
                info: {
                    name: string;
                    description: string;
                    singularName: string;
                    pluralName: string;
                    displayName: string;
                };
                options: {};
                pluginOptions: {
                    'content-manager': {
                        visible: boolean;
                    };
                    'content-type-builder': {
                        visible: boolean;
                    };
                };
                attributes: {
                    action: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                    };
                    actionParameters: {
                        type: string;
                        configurable: boolean;
                        required: boolean;
                        default: {};
                    };
                    subject: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                    };
                    properties: {
                        type: string;
                        configurable: boolean;
                        required: boolean;
                        default: {};
                    };
                    conditions: {
                        type: string;
                        configurable: boolean;
                        required: boolean;
                        default: never[];
                    };
                    role: {
                        configurable: boolean;
                        type: string;
                        relation: string;
                        inversedBy: string;
                        target: string;
                    };
                };
            };
        };
        user: {
            schema: {
                collectionName: string;
                info: {
                    name: string;
                    description: string;
                    singularName: string;
                    pluralName: string;
                    displayName: string;
                };
                pluginOptions: {
                    'content-manager': {
                        visible: boolean;
                    };
                    'content-type-builder': {
                        visible: boolean;
                    };
                };
                attributes: {
                    firstname: {
                        type: string;
                        unique: boolean;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                    };
                    lastname: {
                        type: string;
                        unique: boolean;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                    };
                    username: {
                        type: string;
                        unique: boolean;
                        configurable: boolean;
                        required: boolean;
                    };
                    email: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                        unique: boolean;
                        private: boolean;
                    };
                    password: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                    resetPasswordToken: {
                        type: string;
                        configurable: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                    registrationToken: {
                        type: string;
                        configurable: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                    isActive: {
                        type: string;
                        default: boolean;
                        configurable: boolean;
                        private: boolean;
                    };
                    roles: {
                        configurable: boolean;
                        private: boolean;
                        type: string;
                        relation: string;
                        inversedBy: string;
                        target: string;
                        collectionName: string;
                    };
                    blocked: {
                        type: string;
                        default: boolean;
                        configurable: boolean;
                        private: boolean;
                    };
                    preferedLanguage: {
                        type: string;
                        configurable: boolean;
                        required: boolean;
                        searchable: boolean;
                    };
                };
                config: {
                    attributes: {
                        resetPasswordToken: {
                            hidden: boolean;
                        };
                        registrationToken: {
                            hidden: boolean;
                        };
                    };
                };
            };
        };
        role: {
            schema: {
                collectionName: string;
                info: {
                    name: string;
                    description: string;
                    singularName: string;
                    pluralName: string;
                    displayName: string;
                };
                options: {};
                pluginOptions: {
                    'content-manager': {
                        visible: boolean;
                    };
                    'content-type-builder': {
                        visible: boolean;
                    };
                };
                attributes: {
                    name: {
                        type: string;
                        minLength: number;
                        unique: boolean;
                        configurable: boolean;
                        required: boolean;
                    };
                    code: {
                        type: string;
                        minLength: number;
                        unique: boolean;
                        configurable: boolean;
                        required: boolean;
                    };
                    description: {
                        type: string;
                        configurable: boolean;
                    };
                    users: {
                        configurable: boolean;
                        type: string;
                        relation: string;
                        mappedBy: string;
                        target: string;
                    };
                    permissions: {
                        configurable: boolean;
                        type: string;
                        relation: string;
                        mappedBy: string;
                        target: string;
                    };
                };
            };
        };
        'api-token': {
            schema: {
                collectionName: string;
                info: {
                    name: string;
                    singularName: string;
                    pluralName: string;
                    displayName: string;
                    description: string;
                };
                options: {};
                pluginOptions: {
                    'content-manager': {
                        visible: boolean;
                    };
                    'content-type-builder': {
                        visible: boolean;
                    };
                };
                attributes: {
                    name: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                        unique: boolean;
                    };
                    description: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                        default: string;
                    };
                    type: {
                        type: string;
                        enum: string[];
                        configurable: boolean;
                        required: boolean;
                        default: string;
                    };
                    accessKey: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                        searchable: boolean;
                    };
                    encryptedKey: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                        searchable: boolean;
                    };
                    lastUsedAt: {
                        type: string;
                        configurable: boolean;
                        required: boolean;
                    };
                    permissions: {
                        type: string;
                        target: string;
                        relation: string;
                        mappedBy: string;
                        configurable: boolean;
                        required: boolean;
                    };
                    expiresAt: {
                        type: string;
                        configurable: boolean;
                        required: boolean;
                    };
                    lifespan: {
                        type: string;
                        configurable: boolean;
                        required: boolean;
                    };
                };
            };
        };
        'api-token-permission': {
            schema: {
                collectionName: string;
                info: {
                    name: string;
                    description: string;
                    singularName: string;
                    pluralName: string;
                    displayName: string;
                };
                options: {};
                pluginOptions: {
                    'content-manager': {
                        visible: boolean;
                    };
                    'content-type-builder': {
                        visible: boolean;
                    };
                };
                attributes: {
                    action: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                    };
                    token: {
                        configurable: boolean;
                        type: string;
                        relation: string;
                        inversedBy: string;
                        target: string;
                    };
                };
            };
        };
        'transfer-token': {
            schema: {
                collectionName: string;
                info: {
                    name: string;
                    singularName: string;
                    pluralName: string;
                    displayName: string;
                    description: string;
                };
                options: {};
                pluginOptions: {
                    'content-manager': {
                        visible: boolean;
                    };
                    'content-type-builder': {
                        visible: boolean;
                    };
                };
                attributes: {
                    name: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                        unique: boolean;
                    };
                    description: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                        default: string;
                    };
                    accessKey: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                    };
                    lastUsedAt: {
                        type: string;
                        configurable: boolean;
                        required: boolean;
                    };
                    permissions: {
                        type: string;
                        target: string;
                        relation: string;
                        mappedBy: string;
                        configurable: boolean;
                        required: boolean;
                    };
                    expiresAt: {
                        type: string;
                        configurable: boolean;
                        required: boolean;
                    };
                    lifespan: {
                        type: string;
                        configurable: boolean;
                        required: boolean;
                    };
                };
            };
        };
        'transfer-token-permission': {
            schema: {
                collectionName: string;
                info: {
                    name: string;
                    description: string;
                    singularName: string;
                    pluralName: string;
                    displayName: string;
                };
                options: {};
                pluginOptions: {
                    'content-manager': {
                        visible: boolean;
                    };
                    'content-type-builder': {
                        visible: boolean;
                    };
                };
                attributes: {
                    action: {
                        type: string;
                        minLength: number;
                        configurable: boolean;
                        required: boolean;
                    };
                    token: {
                        configurable: boolean;
                        type: string;
                        relation: string;
                        inversedBy: string;
                        target: string;
                    };
                };
            };
        };
        session: {
            schema: {
                collectionName: string;
                info: {
                    name: string;
                    description: string;
                    singularName: string;
                    pluralName: string;
                    displayName: string;
                };
                options: {
                    draftAndPublish: boolean;
                };
                pluginOptions: {
                    'content-manager': {
                        visible: boolean;
                    };
                    'content-type-builder': {
                        visible: boolean;
                    };
                    i18n: {
                        localized: boolean;
                    };
                };
                attributes: {
                    userId: {
                        type: string;
                        required: boolean;
                        configurable: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                    sessionId: {
                        type: string;
                        unique: boolean;
                        required: boolean;
                        configurable: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                    childId: {
                        type: string;
                        configurable: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                    deviceId: {
                        type: string;
                        required: boolean;
                        configurable: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                    origin: {
                        type: string;
                        required: boolean;
                        configurable: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                    expiresAt: {
                        type: string;
                        required: boolean;
                        configurable: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                    absoluteExpiresAt: {
                        type: string;
                        configurable: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                    status: {
                        type: string;
                        configurable: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                    type: {
                        type: string;
                        configurable: boolean;
                        private: boolean;
                        searchable: boolean;
                    };
                };
            };
        };
    };
    middlewares: {
        rateLimit: (config: any, { strapi }: {
            strapi: import("@strapi/types/dist/core").Strapi;
        }) => (ctx: import("koa").Context, next: import("koa").Next) => Promise<any>;
        'data-transfer': () => (ctx: import("koa").Context, next: import("koa").Next) => Promise<any>;
    };
};
export default admin;
//# sourceMappingURL=index.d.ts.map