'use strict';

var register = require('./register.js');
var bootstrap = require('./bootstrap.js');
var destroy = require('./destroy.js');
var index = require('./content-types/index.js');
var index$1 = require('./services/index.js');
var index$2 = require('./controllers/index.js');
var index$3 = require('./routes/index.js');
var auditLogs$1 = require('./audit-logs/routes/audit-logs.js');
var auditLogs = require('./audit-logs/controllers/audit-logs.js');
var auditLogs$2 = require('./audit-logs/services/audit-logs.js');
var lifecycles = require('./audit-logs/services/lifecycles.js');
var auditLog = require('./audit-logs/content-types/audit-log.js');
var ai$1 = require('./ai/routes/ai.js');
var ai = require('./ai/controllers/ai.js');
var ai$2 = require('./ai/containers/ai.js');

const getAdminEE = ()=>{
    const eeAdmin = {
        register,
        bootstrap,
        destroy,
        contentTypes: {
            // Always register the audit-log content type to prevent data loss
            'audit-log': auditLog.auditLog,
            ...index
        },
        services: index$1,
        controllers: index$2,
        routes: index$3
    };
    const isAIEnabled = strapi.config.get('admin.ai.enabled', true) && strapi.ee.features.isEnabled('cms-ai');
    const isAuditLogsEnabled = strapi.config.get('admin.auditLogs.enabled', true) && strapi.ee.features.isEnabled('audit-logs');
    return {
        ...eeAdmin,
        controllers: {
            ...eeAdmin.controllers,
            ...isAuditLogsEnabled ? {
                'audit-logs': auditLogs
            } : {},
            ...isAIEnabled ? {
                ai: ai
            } : {}
        },
        routes: {
            ...eeAdmin.routes,
            ...isAuditLogsEnabled ? {
                'audit-logs': auditLogs$1
            } : {},
            ...isAIEnabled ? {
                ai: ai$1
            } : {}
        },
        async register ({ strapi: strapi1 }) {
            // Run the the default registration
            await eeAdmin.register({
                strapi: strapi1
            });
            // Register internal ai service
            if (isAIEnabled) {
                strapi1.add('ai', ai$2.createAIContainer({
                    strapi: strapi1
                }));
            }
            if (isAuditLogsEnabled) {
                // Register an internal audit logs service
                strapi1.add('audit-logs', auditLogs$2.createAuditLogsService(strapi1));
                // Register an internal audit logs lifecycle service
                const auditLogsLifecycle = lifecycles.createAuditLogsLifecycleService(strapi1);
                strapi1.add('audit-logs-lifecycle', auditLogsLifecycle);
                await auditLogsLifecycle.register();
            }
        },
        async destroy ({ strapi: strapi1 }) {
            if (isAuditLogsEnabled) {
                strapi1.get('audit-logs-lifecycle').destroy();
            }
            await eeAdmin.destroy({
                strapi: strapi1
            });
        }
    };
};

module.exports = getAdminEE;
//# sourceMappingURL=index.js.map
