import * as Permissions from '../../../shared/contracts/permissions';
import * as Roles from '../../../shared/contracts/roles';
import * as Users from '../../../shared/contracts/user';
import type { Data } from '@strapi/types';
type GetUsersParams = Users.FindOne.Params | (Users.FindAll.Request['query'] & {
    id?: never;
}) | void;
type GetRolesParams = Roles.FindRole.Request['params'] | (Roles.FindRoles.Request['query'] & {
    id?: never;
});
interface GetRolePermissionsParams {
    id: Data.ID;
}
declare const useCreateUserMutation: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseMutation<import("@reduxjs/toolkit/query").MutationDefinition<import("../../../shared/contracts/shared").AdminUserCreationPayload, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "User" | "LicenseLimits" | "Role" | "RolePermissions", import("..").SanitizedAdminUser, "adminApi">>, useUpdateUserMutation: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseMutation<import("@reduxjs/toolkit/query").MutationDefinition<Omit<Omit<import("..").AdminUser, keyof import("..").Entity | "roles"> & {
    roles: Data.ID[];
} & Users.Update.Params, "blocked">, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "User" | "LicenseLimits" | "Role" | "RolePermissions", import("..").SanitizedAdminUser, "adminApi">>, useDeleteManyUsersMutation: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseMutation<import("@reduxjs/toolkit/query").MutationDefinition<{
    ids: Data.ID[];
}, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "User" | "LicenseLimits" | "Role" | "RolePermissions", import("..").SanitizedAdminUser[], "adminApi">>, useGetRolesQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<void | GetRolesParams, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "User" | "LicenseLimits" | "Role" | "RolePermissions", (import("..").SanitizedAdminRole & {
    usersCount?: number | undefined;
})[], "adminApi">>, useCreateRoleMutation: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseMutation<import("@reduxjs/toolkit/query").MutationDefinition<{
    name: string;
    description?: string | undefined;
}, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "User" | "LicenseLimits" | "Role" | "RolePermissions", import("..").SanitizedAdminRole, "adminApi">>, useUpdateRoleMutation: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseMutation<import("@reduxjs/toolkit/query").MutationDefinition<{
    name?: string | undefined;
    description?: string | undefined;
} & {
    id: string;
}, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "User" | "LicenseLimits" | "Role" | "RolePermissions", import("..").SanitizedAdminRole, "adminApi">>, useGetRolePermissionsQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<GetRolePermissionsParams, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "User" | "LicenseLimits" | "Role" | "RolePermissions", import("../../../shared/contracts/shared").Permission[], "adminApi">>, useGetRolePermissionLayoutQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<{
    role: Data.ID;
}, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "User" | "LicenseLimits" | "Role" | "RolePermissions", {
    conditions: Permissions.Condition[];
    sections: {
        collectionTypes: Permissions.ContentPermission;
        plugins: Permissions.PluginPermission[];
        settings: Permissions.SettingPermission[];
        singleTypes: Permissions.ContentPermission;
    };
}, "adminApi">>, useUpdateRolePermissionsMutation: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseMutation<import("@reduxjs/toolkit/query").MutationDefinition<{
    permissions: Omit<import("../../../shared/contracts/shared").Permission, "id" | "createdAt" | "updatedAt" | "actionParameters">[];
} & {
    id: Data.ID;
}, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "User" | "LicenseLimits" | "Role" | "RolePermissions", Roles.SanitizedPermission[], "adminApi">>;
declare const useAdminUsers: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<GetUsersParams, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "User" | "LicenseLimits" | "Role" | "RolePermissions", {
    users: Users.FindAll.Response['data']['results'];
    pagination: Users.FindAll.Response['data']['pagination'] | null;
}, "adminApi">>;
export { useUpdateUserMutation, useGetRolesQuery, useAdminUsers, useDeleteManyUsersMutation, useCreateUserMutation, useGetRolePermissionsQuery, useGetRolePermissionLayoutQuery, useCreateRoleMutation, useUpdateRolePermissionsMutation, useUpdateRoleMutation, };
export type { GetRolesParams, GetUsersParams, GetRolePermissionsParams };
