/**
 * @public
 * @description This is the redux toolkit api for the admin panel, users
 * should use a combination of `enhanceEndpoints` to add their TagTypes
 * to utilise in their `injectEndpoints` construction for automatic cache
 * re-validation. We specifically do not store any tagTypes by default leaving
 * the API surface as small as possible. None of the data-fetching looks for the
 * StrapiApp are stored here either.
 */
declare const adminApi: import("@reduxjs/toolkit/query/react").Api<import("@reduxjs/toolkit/query/react").BaseQueryFn<string | import("../utils/baseQuery").QueryArguments, unknown, import("../utils/baseQuery").BaseQueryError>, {}, "adminApi", "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig", typeof import("@reduxjs/toolkit/query/react").coreModuleName | typeof import("@reduxjs/toolkit/query/react").reactHooksModuleName>;
export { adminApi };
