import { type UpdateProjectSettings, type Plugins, type GetLicenseLimitInformation, GetGuidedTourMeta } from '../../../shared/contracts/admin';
interface ConfigurationLogo {
    custom?: {
        name?: string;
        url?: string;
    };
    default: string;
}
declare const useInitQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<void, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "LicenseLimits" | "ProjectSettings" | "LicenseTrialTimeLeft", {
    uuid: string | false;
    hasAdmin: boolean;
    menuLogo: string | null;
    authLogo: string | null;
}, "adminApi">>, useTelemetryPropertiesQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<void, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "LicenseLimits" | "ProjectSettings" | "LicenseTrialTimeLeft", {
    useTypescriptOnServer: boolean;
    useTypescriptOnAdmin: boolean;
    isHostedOnStrapiCloud: boolean;
    numberOfAllContentTypes: number;
    numberOfComponents: number;
    numberOfDynamicZones: number;
}, "adminApi">>, useInformationQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<void, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "LicenseLimits" | "ProjectSettings" | "LicenseTrialTimeLeft", {
    currentEnvironment: string;
    autoReload: boolean;
    strapiVersion: string | null;
    dependencies: Record<string, string>;
    projectId: string | null;
    nodeVersion: string;
    communityEdition: boolean;
    useYarn: boolean;
}, "adminApi">>, useProjectSettingsQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<void, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "LicenseLimits" | "ProjectSettings" | "LicenseTrialTimeLeft", {
    authLogo?: ConfigurationLogo['custom'];
    menuLogo?: ConfigurationLogo['custom'];
}, "adminApi">>, useUpdateProjectSettingsMutation: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseMutation<import("@reduxjs/toolkit/query").MutationDefinition<FormData, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "LicenseLimits" | "ProjectSettings" | "LicenseTrialTimeLeft", UpdateProjectSettings.Response, "adminApi">>, useGetPluginsQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<void, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "LicenseLimits" | "ProjectSettings" | "LicenseTrialTimeLeft", Plugins.Response, "adminApi">>, useGetLicenseLimitsQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<void, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "LicenseLimits" | "ProjectSettings" | "LicenseTrialTimeLeft", GetLicenseLimitInformation.Response, "adminApi">>, useGetLicenseTrialTimeLeftQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<void, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "LicenseLimits" | "ProjectSettings" | "LicenseTrialTimeLeft", {
    trialEndsAt: string;
}, "adminApi">>, useGetGuidedTourMetaQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<void, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("..").QueryArguments, unknown, import("..").BaseQueryError>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "LicenseLimits" | "ProjectSettings" | "LicenseTrialTimeLeft", GetGuidedTourMeta.Response, "adminApi">>;
export { useInitQuery, useTelemetryPropertiesQuery, useInformationQuery, useProjectSettingsQuery, useUpdateProjectSettingsMutation, useGetPluginsQuery, useGetLicenseLimitsQuery, useGetLicenseTrialTimeLeftQuery, useGetGuidedTourMetaQuery, };
export type { ConfigurationLogo };
