'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var designSystem = require('@strapi/design-system');
var icons = require('@strapi/icons');
var symbols = require('@strapi/icons/symbols');
var qs = require('qs');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var Tours = require('../../../../components/GuidedTour/Tours.js');
var Layout = require('../../../../components/Layouts/Layout.js');
var PageHelpers = require('../../../../components/PageHelpers.js');
var hooks = require('../../../../core/store/hooks.js');
var Notifications = require('../../../../features/Notifications.js');
var Tracking = require('../../../../features/Tracking.js');
var useAPIErrorHandler = require('../../../../hooks/useAPIErrorHandler.js');
var useOnce = require('../../../../hooks/useOnce.js');
var useRBAC = require('../../../../hooks/useRBAC.js');
var apiTokens = require('../../../../services/apiTokens.js');
var constants = require('../../components/Tokens/constants.js');
var Table = require('../../components/Tokens/Table.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);
var qs__namespace = /*#__PURE__*/_interopNamespaceDefault(qs);

const TABLE_HEADERS = [
    {
        name: 'name',
        label: {
            id: 'Settings.apiTokens.ListView.headers.name',
            defaultMessage: 'Name'
        },
        sortable: true
    },
    {
        name: 'description',
        label: {
            id: 'Settings.apiTokens.ListView.headers.description',
            defaultMessage: 'Description'
        },
        sortable: false
    },
    {
        name: 'createdAt',
        label: {
            id: 'Settings.apiTokens.ListView.headers.createdAt',
            defaultMessage: 'Created at'
        },
        sortable: false
    },
    {
        name: 'lastUsedAt',
        label: {
            id: 'Settings.apiTokens.ListView.headers.lastUsedAt',
            defaultMessage: 'Last used'
        },
        sortable: false
    }
];
const ListView = ()=>{
    const { formatMessage } = reactIntl.useIntl();
    const { toggleNotification } = Notifications.useNotification();
    const permissions = hooks.useTypedSelector((state)=>state.admin_app.permissions.settings?.['api-tokens']);
    const { allowedActions: { canRead, canCreate, canDelete, canUpdate } } = useRBAC.useRBAC(permissions);
    const navigate = reactRouterDom.useNavigate();
    const { trackUsage } = Tracking.useTracking();
    const { _unstableFormatAPIError: formatAPIError } = useAPIErrorHandler.useAPIErrorHandler();
    React__namespace.useEffect(()=>{
        navigate({
            search: qs__namespace.stringify({
                sort: 'name:ASC'
            }, {
                encode: false
            })
        }, {
            replace: true
        });
    }, [
        navigate
    ]);
    const headers = TABLE_HEADERS.map((header)=>({
            ...header,
            label: formatMessage(header.label)
        }));
    useOnce.useOnce(()=>{
        trackUsage('willAccessTokenList', {
            tokenType: constants.API_TOKEN_TYPE
        });
    });
    const { data: apiTokens$1 = [], isLoading, error } = apiTokens.useGetAPITokensQuery();
    React__namespace.useEffect(()=>{
        if (error) {
            toggleNotification({
                type: 'danger',
                message: formatAPIError(error)
            });
        }
    }, [
        error,
        formatAPIError,
        toggleNotification
    ]);
    React__namespace.useEffect(()=>{
        trackUsage('didAccessTokenList', {
            number: apiTokens$1.length,
            tokenType: constants.API_TOKEN_TYPE
        });
    }, [
        apiTokens$1,
        trackUsage
    ]);
    const [deleteToken] = apiTokens.useDeleteAPITokenMutation();
    const handleDelete = async (id)=>{
        try {
            const res = await deleteToken(id);
            if ('error' in res) {
                toggleNotification({
                    type: 'danger',
                    message: formatAPIError(res.error)
                });
                return;
            }
            trackUsage('didDeleteToken');
        } catch  {
            toggleNotification({
                type: 'danger',
                message: formatMessage({
                    id: 'notification.error',
                    defaultMessage: 'Something went wrong'
                })
            });
        }
    };
    return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
        children: [
            apiTokens$1.length > 0 && /*#__PURE__*/ jsxRuntime.jsx(Tours.tours.apiTokens.Introduction, {
                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {})
            }),
            /*#__PURE__*/ jsxRuntime.jsx(PageHelpers.Page.Title, {
                children: formatMessage({
                    id: 'Settings.PageTitle',
                    defaultMessage: 'Settings - {name}'
                }, {
                    name: 'API Tokens'
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(Layout.Layouts.Header, {
                title: formatMessage({
                    id: 'Settings.apiTokens.title',
                    defaultMessage: 'API Tokens'
                }),
                subtitle: formatMessage({
                    id: 'Settings.apiTokens.description',
                    defaultMessage: 'List of generated tokens to consume the API'
                }),
                primaryAction: canCreate && /*#__PURE__*/ jsxRuntime.jsx(designSystem.LinkButton, {
                    tag: reactRouterDom.Link,
                    "data-testid": "create-api-token-button",
                    startIcon: /*#__PURE__*/ jsxRuntime.jsx(icons.Plus, {}),
                    size: "S",
                    onClick: ()=>trackUsage('willAddTokenFromList', {
                            tokenType: constants.API_TOKEN_TYPE
                        }),
                    to: "/settings/api-tokens/create",
                    children: formatMessage({
                        id: 'Settings.apiTokens.create',
                        defaultMessage: 'Create new API Token'
                    })
                })
            }),
            !canRead ? /*#__PURE__*/ jsxRuntime.jsx(PageHelpers.Page.NoPermissions, {}) : /*#__PURE__*/ jsxRuntime.jsx(PageHelpers.Page.Main, {
                "aria-busy": isLoading,
                children: /*#__PURE__*/ jsxRuntime.jsxs(Layout.Layouts.Content, {
                    children: [
                        apiTokens$1.length > 0 && /*#__PURE__*/ jsxRuntime.jsx(Table.Table, {
                            permissions: {
                                canRead,
                                canDelete,
                                canUpdate
                            },
                            headers: headers,
                            isLoading: isLoading,
                            onConfirmDelete: handleDelete,
                            tokens: apiTokens$1,
                            tokenType: constants.API_TOKEN_TYPE
                        }),
                        canCreate && apiTokens$1.length === 0 ? /*#__PURE__*/ jsxRuntime.jsx(designSystem.EmptyStateLayout, {
                            icon: /*#__PURE__*/ jsxRuntime.jsx(symbols.EmptyDocuments, {
                                width: "16rem"
                            }),
                            content: formatMessage({
                                id: 'Settings.apiTokens.addFirstToken',
                                defaultMessage: 'Add your first API Token'
                            }),
                            action: /*#__PURE__*/ jsxRuntime.jsx(designSystem.LinkButton, {
                                tag: reactRouterDom.Link,
                                variant: "secondary",
                                startIcon: /*#__PURE__*/ jsxRuntime.jsx(icons.Plus, {}),
                                to: "/settings/api-tokens/create",
                                children: formatMessage({
                                    id: 'Settings.apiTokens.addNewToken',
                                    defaultMessage: 'Add new API Token'
                                })
                            })
                        }) : null,
                        !canCreate && apiTokens$1.length === 0 ? /*#__PURE__*/ jsxRuntime.jsx(designSystem.EmptyStateLayout, {
                            icon: /*#__PURE__*/ jsxRuntime.jsx(symbols.EmptyDocuments, {
                                width: "16rem"
                            }),
                            content: formatMessage({
                                id: 'Settings.apiTokens.emptyStateLayout',
                                defaultMessage: 'You don’t have any content yet...'
                            })
                        }) : null
                    ]
                })
            })
        ]
    });
};
const ProtectedListView = ()=>{
    const permissions = hooks.useTypedSelector((state)=>state.admin_app.permissions.settings?.['api-tokens'].main);
    return /*#__PURE__*/ jsxRuntime.jsx(PageHelpers.Page.Protect, {
        permissions: permissions,
        children: /*#__PURE__*/ jsxRuntime.jsx(ListView, {})
    });
};

exports.ListView = ListView;
exports.ProtectedListView = ProtectedListView;
//# sourceMappingURL=ListView.js.map
