'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var designSystem = require('@strapi/design-system');
var reactIntl = require('react-intl');
var sonner = require('sonner');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const NotificationsContext = /*#__PURE__*/ React__namespace.createContext({
    toggleNotification: ()=>{}
});
/* -------------------------------------------------------------------------------------------------
 * Provider
 * -----------------------------------------------------------------------------------------------*/ /**
 * @internal
 * @description exposes the `NotificationsContext` to its children and renders notifications
 */ const NotificationsProvider = ({ children })=>{
    const toggleNotification = React__namespace.useCallback(({ type, message, link, timeout, blockTransition, onClose, title })=>{
        sonner.toast.custom((id)=>{
            return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                width: "50rem",
                maxWidth: "100%",
                children: /*#__PURE__*/ jsxRuntime.jsx(Notification, {
                    type: type,
                    message: message,
                    title: title,
                    link: link,
                    clearNotification: ()=>{
                        sonner.toast.dismiss(id);
                        onClose?.();
                    }
                })
            });
        }, {
            duration: blockTransition ? Infinity : timeout
        });
    }, []);
    const value = React__namespace.useMemo(()=>({
            toggleNotification
        }), [
        toggleNotification
    ]);
    return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(sonner.Toaster, {
                position: "top-center"
            }),
            /*#__PURE__*/ jsxRuntime.jsx(NotificationsContext.Provider, {
                value: value,
                children: children
            })
        ]
    });
};
const Notification = ({ clearNotification, link, message, onClose, title, type })=>{
    const { formatMessage } = reactIntl.useIntl();
    const getVariant = ()=>{
        switch(type){
            case 'info':
                return 'default';
            case 'danger':
                return 'danger';
            case 'warning':
                return 'warning';
            default:
                return 'success';
        }
    };
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Alert, {
        action: link ? /*#__PURE__*/ jsxRuntime.jsx(designSystem.Link, {
            href: link.url,
            isExternal: true,
            children: link.label
        }) : undefined,
        onClose: ()=>{
            onClose?.();
            clearNotification();
        },
        closeLabel: formatMessage({
            id: 'global.close',
            defaultMessage: 'Close'
        }),
        title: title,
        variant: getVariant(),
        children: message
    });
};
/* -------------------------------------------------------------------------------------------------
 * Hook
 * -----------------------------------------------------------------------------------------------*/ /**
 * @preserve
 * @description Returns an object to interact with the notification
 * system. The callbacks are wrapped in `useCallback` for a stable
 * identity.
 *
 * @example
 * ```tsx
 * import { useNotification } from '@strapi/strapi/admin';
 *
 * const MyComponent = () => {
 *  const { toggleNotification } = useNotification();
 *
 *  return <button onClick={() => toggleNotification({ message: 'Hello world!' })}>Click me</button>;
 */ const useNotification = ()=>React__namespace.useContext(NotificationsContext);

exports.NotificationsProvider = NotificationsProvider;
exports.useNotification = useNotification;
//# sourceMappingURL=Notifications.js.map
