'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var designSystem = require('@strapi/design-system');
var icons = require('@strapi/icons');
var reactRouterDom = require('react-router-dom');
var styled = require('styled-components');
var theme = require('../constants/theme.js');
var Tours = require('./GuidedTour/Tours.js');

const MainSubNav = styled.styled(designSystem.SubNav)`
  width: 100%;
  height: calc(100dvh - ${theme.HEIGHT_TOP_NAVIGATION} - 1px);
  overflow: hidden;
  background-color: ${({ theme })=>theme.colors.neutral0};
  display: flex;
  flex-direction: column;
  border-right: 0;
  box-shadow: none;
  position: fixed;
  top: calc(${theme.HEIGHT_TOP_NAVIGATION} + 1px);
  left: 0;
  z-index: 2;

  ${({ theme })=>theme.breakpoints.medium} {
    width: 23.2rem;
    position: sticky;
    top: 0;
    border-right: 1px solid ${({ theme })=>theme.colors.neutral150};
  }
  ${({ theme })=>theme.breakpoints.large} {
    height: 100dvh;
  }
`;
const Main = ({ children, ...props })=>/*#__PURE__*/ jsxRuntime.jsx(MainSubNav, {
        ...props,
        children: children
    });
const StyledLink = styled.styled(reactRouterDom.NavLink)`
  display: flex;
  align-items: center;
  justify-content: space-between;
  text-decoration: none;
  height: 32px;

  color: ${({ theme })=>theme.colors.neutral800};

  &.active > div {
    ${({ theme })=>{
    return `
        background-color: ${theme.colors.primary100};
        color: ${theme.colors.primary700};
        font-weight: 500;
      `;
}}
  }

  &:hover.active > div {
    ${({ theme })=>{
    return `
        background-color: ${theme.colors.primary100};
      `;
}}
  }

  &:hover > div {
    ${({ theme })=>{
    return `
        background-color: ${theme.colors.neutral100};
      `;
}}
  }

  &:focus-visible {
    outline-offset: -2px;
  }
`;
const Link = (props)=>{
    const { label, endAction, handleClick, ...rest } = props;
    return /*#__PURE__*/ jsxRuntime.jsx(StyledLink, {
        ...rest,
        onClick: handleClick,
        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
            width: '100%',
            paddingLeft: 3,
            paddingRight: 3,
            borderRadius: 1,
            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                justifyContent: "space-between",
                width: "100%",
                gap: 1,
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                        tag: "div",
                        lineHeight: "32px",
                        width: {
                            initial: '80dvw',
                            medium: '100%'
                        },
                        overflow: "hidden",
                        style: {
                            textOverflow: 'ellipsis',
                            whiteSpace: 'nowrap'
                        },
                        children: label
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                        gap: 2,
                        children: endAction
                    })
                ]
            })
        })
    });
};
const StyledHeader = styled.styled(designSystem.Flex)`
  flex: 0 0 ${theme.HEIGHT_TOP_NAVIGATION};
  height: ${theme.HEIGHT_TOP_NAVIGATION};

  ${({ theme })=>theme.breakpoints.medium} {
    flex: 0 0 ${theme.HEIGHT_TOP_NAVIGATION_MEDIUM};
    height: ${theme.HEIGHT_TOP_NAVIGATION_MEDIUM};
  }
`;
const Header = ({ label })=>{
    return /*#__PURE__*/ jsxRuntime.jsx(StyledHeader, {
        justifyContent: "space-between",
        paddingLeft: {
            initial: 4,
            large: 5
        },
        paddingRight: {
            initial: 4,
            large: 5
        },
        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
            variant: "beta",
            tag: "h2",
            children: label
        })
    });
};
const Sections = ({ children, ...props })=>{
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
        paddingTop: 4,
        paddingBottom: 4,
        maxWidth: {
            initial: '100%',
            medium: '23.2rem'
        },
        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
            tag: "ul",
            gap: "5",
            direction: "column",
            alignItems: "stretch",
            ...props,
            children: children.map((child, index)=>{
                return /*#__PURE__*/ jsxRuntime.jsx("li", {
                    children: child
                }, index);
            })
        })
    });
};
/**
 * TODO:
 * This would be better in the content-type-builder package directly but currently
 * the SubNav API does not expose a way to wrap the link, instead it wraps the link and the list
 */ const GuidedTourTooltip = ({ sectionId, children })=>{
    switch(sectionId){
        case 'models':
            return /*#__PURE__*/ jsxRuntime.jsx(Tours.tours.contentTypeBuilder.CollectionTypes, {
                children: /*#__PURE__*/ jsxRuntime.jsx(Tours.tours.contentTypeBuilder.YourTurn, {
                    children: children
                })
            });
        case 'singleTypes':
            return /*#__PURE__*/ jsxRuntime.jsx(Tours.tours.contentTypeBuilder.SingleTypes, {
                children: children
            });
        case 'components':
            return /*#__PURE__*/ jsxRuntime.jsx(Tours.tours.contentTypeBuilder.Components, {
                children: children
            });
        default:
            return children;
    }
};
const Section = ({ label, children, link, sectionId, badgeLabel })=>{
    const listId = React.useId();
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
        direction: "column",
        alignItems: "stretch",
        gap: 2,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                paddingLeft: {
                    initial: 4,
                    large: 5
                },
                paddingRight: {
                    initial: 4,
                    large: 5
                },
                children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                    position: "relative",
                    justifyContent: "space-between",
                    gap: 2,
                    children: [
                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                            children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                paddingRight: 1,
                                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                    variant: "sigma",
                                    textColor: "neutral600",
                                    children: label
                                })
                            })
                        }),
                        /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                            gap: 1,
                            children: [
                                badgeLabel && /*#__PURE__*/ jsxRuntime.jsx(designSystem.Badge, {
                                    backgroundColor: "neutral150",
                                    textColor: "neutral600",
                                    children: badgeLabel
                                }),
                                link && /*#__PURE__*/ jsxRuntime.jsx(GuidedTourTooltip, {
                                    sectionId: sectionId,
                                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                                        label: link.label,
                                        variant: "ghost",
                                        withTooltip: true,
                                        onClick: link.onClick,
                                        size: "XS",
                                        children: /*#__PURE__*/ jsxRuntime.jsx(icons.Plus, {})
                                    })
                                })
                            ]
                        })
                    ]
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                tag: "ol",
                id: listId,
                direction: "column",
                gap: "2px",
                alignItems: 'stretch',
                marginLeft: {
                    initial: 1,
                    large: 2
                },
                marginRight: {
                    initial: 1,
                    large: 2
                },
                children: children.map((child, index)=>{
                    return /*#__PURE__*/ jsxRuntime.jsx("li", {
                        children: child
                    }, index);
                })
            })
        ]
    });
};
const SubSectionHeader = styled.styled.button`
  cursor: pointer;
  width: 100%;
  border: none;
  padding: 0;
  background: transparent;
  display: flex;
  align-items: center;
  border-radius: ${({ theme })=>theme.borderRadius};
  padding-left: ${({ theme })=>theme.spaces[3]};
  padding-right: ${({ theme })=>theme.spaces[3]};
  padding-top: ${({ theme })=>theme.spaces[2]};
  padding-bottom: ${({ theme })=>theme.spaces[2]};

  &:hover {
    background-color: ${({ theme })=>theme.colors.neutral100};
  }
`;
const SubSectionLinkWrapper = styled.styled.li`
  ${StyledLink} > div {
    padding-left: 36px;
  }
`;
const SubSection = ({ label, children })=>{
    const [isOpen, setOpenLinks] = React.useState(true);
    const [contentHeight, setContentHeight] = React.useState(0);
    const listId = React.useId();
    const contentRef = React.useRef(null);
    React.useEffect(()=>{
        if (contentRef.current) {
            setContentHeight(contentRef.current.scrollHeight);
        }
    }, [
        children
    ]);
    const handleClick = ()=>{
        setOpenLinks((prev)=>!prev);
    };
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Box, {
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                justifyContent: "space-between",
                children: /*#__PURE__*/ jsxRuntime.jsxs(SubSectionHeader, {
                    onClick: handleClick,
                    "aria-expanded": isOpen,
                    "aria-controls": listId,
                    children: [
                        /*#__PURE__*/ jsxRuntime.jsx(icons.ChevronDown, {
                            "aria-hidden": true,
                            fill: "neutral500",
                            style: {
                                transform: `rotate(${isOpen ? '0deg' : '-90deg'})`,
                                transition: 'transform 0.5s'
                            }
                        }),
                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                            paddingLeft: 2,
                            children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                tag: "span",
                                fontWeight: "semiBold",
                                textColor: "neutral800",
                                children: label
                            })
                        })
                    ]
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                ref: contentRef,
                tag: "ul",
                id: listId,
                direction: "column",
                gap: "2px",
                alignItems: 'stretch',
                style: {
                    maxHeight: isOpen ? `${contentHeight}px` : 0,
                    overflow: 'hidden',
                    transition: 'max-height 0.5s cubic-bezier(0, 1, 0, 1)'
                },
                children: children.map((child, index)=>{
                    return /*#__PURE__*/ jsxRuntime.jsx(SubSectionLinkWrapper, {
                        children: child
                    }, index);
                })
            })
        ]
    });
};
const PageWrapper = styled.styled(designSystem.Box)`
  ${MainSubNav} {
    background-color: transparent;
    border-right: none;
  }

  ${({ theme })=>theme.breakpoints.medium} {
    ${MainSubNav} {
      top: 0;
    }
  }
`;
const Content = ({ children })=>{
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.ScrollArea, {
        children: children
    });
};
const SubNav = {
    Main,
    Content,
    Header,
    Link,
    Sections,
    Section,
    SubSection,
    PageWrapper
};

exports.SubNav = SubNav;
//# sourceMappingURL=SubNav.js.map
