"use strict";
var mediaThemeMinimal = (() => {
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
  var __publicField = (obj, key, value) => {
    __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
    return value;
  };

  // src/themes/minimal/index.ts
  var minimal_exports = {};

  // ../../node_modules/player.style/node_modules/media-chrome/dist/constants.js
  var MediaUIEvents = {
    MEDIA_PLAY_REQUEST: "mediaplayrequest",
    MEDIA_PAUSE_REQUEST: "mediapauserequest",
    MEDIA_MUTE_REQUEST: "mediamuterequest",
    MEDIA_UNMUTE_REQUEST: "mediaunmuterequest",
    MEDIA_VOLUME_REQUEST: "mediavolumerequest",
    MEDIA_SEEK_REQUEST: "mediaseekrequest",
    MEDIA_AIRPLAY_REQUEST: "mediaairplayrequest",
    MEDIA_ENTER_FULLSCREEN_REQUEST: "mediaenterfullscreenrequest",
    MEDIA_EXIT_FULLSCREEN_REQUEST: "mediaexitfullscreenrequest",
    MEDIA_PREVIEW_REQUEST: "mediapreviewrequest",
    MEDIA_ENTER_PIP_REQUEST: "mediaenterpiprequest",
    MEDIA_EXIT_PIP_REQUEST: "mediaexitpiprequest",
    MEDIA_ENTER_CAST_REQUEST: "mediaentercastrequest",
    MEDIA_EXIT_CAST_REQUEST: "mediaexitcastrequest",
    MEDIA_SHOW_TEXT_TRACKS_REQUEST: "mediashowtexttracksrequest",
    MEDIA_HIDE_TEXT_TRACKS_REQUEST: "mediahidetexttracksrequest",
    MEDIA_SHOW_SUBTITLES_REQUEST: "mediashowsubtitlesrequest",
    MEDIA_DISABLE_SUBTITLES_REQUEST: "mediadisablesubtitlesrequest",
    MEDIA_TOGGLE_SUBTITLES_REQUEST: "mediatogglesubtitlesrequest",
    MEDIA_PLAYBACK_RATE_REQUEST: "mediaplaybackraterequest",
    MEDIA_RENDITION_REQUEST: "mediarenditionrequest",
    MEDIA_AUDIO_TRACK_REQUEST: "mediaaudiotrackrequest",
    MEDIA_SEEK_TO_LIVE_REQUEST: "mediaseektoliverequest",
    REGISTER_MEDIA_STATE_RECEIVER: "registermediastatereceiver",
    UNREGISTER_MEDIA_STATE_RECEIVER: "unregistermediastatereceiver"
  };
  var MediaStateReceiverAttributes = {
    MEDIA_CHROME_ATTRIBUTES: "mediachromeattributes",
    MEDIA_CONTROLLER: "mediacontroller"
  };
  var MediaUIProps = {
    MEDIA_AIRPLAY_UNAVAILABLE: "mediaAirplayUnavailable",
    MEDIA_FULLSCREEN_UNAVAILABLE: "mediaFullscreenUnavailable",
    MEDIA_PIP_UNAVAILABLE: "mediaPipUnavailable",
    MEDIA_CAST_UNAVAILABLE: "mediaCastUnavailable",
    MEDIA_RENDITION_UNAVAILABLE: "mediaRenditionUnavailable",
    MEDIA_AUDIO_TRACK_UNAVAILABLE: "mediaAudioTrackUnavailable",
    MEDIA_PAUSED: "mediaPaused",
    MEDIA_HAS_PLAYED: "mediaHasPlayed",
    MEDIA_ENDED: "mediaEnded",
    MEDIA_MUTED: "mediaMuted",
    MEDIA_VOLUME_LEVEL: "mediaVolumeLevel",
    MEDIA_VOLUME: "mediaVolume",
    MEDIA_VOLUME_UNAVAILABLE: "mediaVolumeUnavailable",
    MEDIA_IS_PIP: "mediaIsPip",
    MEDIA_IS_CASTING: "mediaIsCasting",
    MEDIA_IS_AIRPLAYING: "mediaIsAirplaying",
    MEDIA_SUBTITLES_LIST: "mediaSubtitlesList",
    MEDIA_SUBTITLES_SHOWING: "mediaSubtitlesShowing",
    MEDIA_IS_FULLSCREEN: "mediaIsFullscreen",
    MEDIA_PLAYBACK_RATE: "mediaPlaybackRate",
    MEDIA_CURRENT_TIME: "mediaCurrentTime",
    MEDIA_DURATION: "mediaDuration",
    MEDIA_SEEKABLE: "mediaSeekable",
    MEDIA_PREVIEW_TIME: "mediaPreviewTime",
    MEDIA_PREVIEW_IMAGE: "mediaPreviewImage",
    MEDIA_PREVIEW_COORDS: "mediaPreviewCoords",
    MEDIA_PREVIEW_CHAPTER: "mediaPreviewChapter",
    MEDIA_LOADING: "mediaLoading",
    MEDIA_BUFFERED: "mediaBuffered",
    MEDIA_STREAM_TYPE: "mediaStreamType",
    MEDIA_TARGET_LIVE_WINDOW: "mediaTargetLiveWindow",
    MEDIA_TIME_IS_LIVE: "mediaTimeIsLive",
    MEDIA_RENDITION_LIST: "mediaRenditionList",
    MEDIA_RENDITION_SELECTED: "mediaRenditionSelected",
    MEDIA_AUDIO_TRACK_LIST: "mediaAudioTrackList",
    MEDIA_AUDIO_TRACK_ENABLED: "mediaAudioTrackEnabled",
    MEDIA_CHAPTERS_CUES: "mediaChaptersCues"
  };
  var MediaUIPropsEntries = Object.entries(
    MediaUIProps
  );
  var MediaUIAttributes = MediaUIPropsEntries.reduce(
    (dictObj, [key, propName]) => {
      dictObj[key] = propName.toLowerCase();
      return dictObj;
    },
    {}
  );
  var AdditionalStateChangeEvents = {
    USER_INACTIVE: "userinactivechange",
    BREAKPOINTS_CHANGE: "breakpointchange",
    BREAKPOINTS_COMPUTED: "breakpointscomputed"
  };
  var MediaStateChangeEvents = MediaUIPropsEntries.reduce(
    (dictObj, [key, propName]) => {
      dictObj[key] = propName.toLowerCase();
      return dictObj;
    },
    { ...AdditionalStateChangeEvents }
  );
  var StateChangeEventToAttributeMap = Object.entries(
    MediaStateChangeEvents
  ).reduce(
    (mapObj, [key, eventType]) => {
      const attrName = MediaUIAttributes[key];
      if (attrName) {
        mapObj[eventType] = attrName;
      }
      return mapObj;
    },
    { userinactivechange: "userinactive" }
  );
  var AttributeToStateChangeEventMap = Object.entries(
    MediaUIAttributes
  ).reduce(
    (mapObj, [key, attrName]) => {
      const evtType = MediaStateChangeEvents[key];
      if (evtType) {
        mapObj[attrName] = evtType;
      }
      return mapObj;
    },
    { userinactive: "userinactivechange" }
  );
  var TextTrackKinds = {
    SUBTITLES: "subtitles",
    CAPTIONS: "captions",
    DESCRIPTIONS: "descriptions",
    CHAPTERS: "chapters",
    METADATA: "metadata"
  };
  var TextTrackModes = {
    DISABLED: "disabled",
    HIDDEN: "hidden",
    SHOWING: "showing"
  };
  var PointerTypes = {
    MOUSE: "mouse",
    PEN: "pen",
    TOUCH: "touch"
  };
  var AvailabilityStates = {
    UNAVAILABLE: "unavailable",
    UNSUPPORTED: "unsupported"
  };
  var StreamTypes = {
    LIVE: "live",
    ON_DEMAND: "on-demand",
    UNKNOWN: "unknown"
  };
  var WebkitPresentationModes = {
    INLINE: "inline",
    FULLSCREEN: "fullscreen",
    PICTURE_IN_PICTURE: "picture-in-picture"
  };

  // ../../node_modules/player.style/node_modules/media-chrome/dist/labels/labels.js
  var tooltipLabels = {
    ENTER_AIRPLAY: "Start airplay",
    EXIT_AIRPLAY: "Stop airplay",
    AUDIO_TRACK_MENU: "Audio",
    CAPTIONS: "Captions",
    ENABLE_CAPTIONS: "Enable captions",
    DISABLE_CAPTIONS: "Disable captions",
    START_CAST: "Start casting",
    STOP_CAST: "Stop casting",
    ENTER_FULLSCREEN: "Enter fullscreen mode",
    EXIT_FULLSCREEN: "Exit fullscreen mode",
    MUTE: "Mute",
    UNMUTE: "Unmute",
    ENTER_PIP: "Enter picture in picture mode",
    EXIT_PIP: "Enter picture in picture mode",
    PLAY: "Play",
    PAUSE: "Pause",
    PLAYBACK_RATE: "Playback rate",
    RENDITIONS: "Quality",
    SEEK_BACKWARD: "Seek backward",
    SEEK_FORWARD: "Seek forward",
    SETTINGS: "Settings"
  };
  var nouns = {
    AUDIO_PLAYER: () => "audio player",
    VIDEO_PLAYER: () => "video player",
    VOLUME: () => "volume",
    SEEK: () => "seek",
    CLOSED_CAPTIONS: () => "closed captions",
    PLAYBACK_RATE: ({ playbackRate = 1 } = {}) => `current playback rate ${playbackRate}`,
    PLAYBACK_TIME: () => `playback time`,
    MEDIA_LOADING: () => `media loading`,
    SETTINGS: () => `settings`,
    AUDIO_TRACKS: () => `audio tracks`,
    QUALITY: () => `quality`
  };
  var verbs = {
    PLAY: () => "play",
    PAUSE: () => "pause",
    MUTE: () => "mute",
    UNMUTE: () => "unmute",
    ENTER_AIRPLAY: () => "start airplay",
    EXIT_AIRPLAY: () => "stop airplay",
    ENTER_CAST: () => "start casting",
    EXIT_CAST: () => "stop casting",
    ENTER_FULLSCREEN: () => "enter fullscreen mode",
    EXIT_FULLSCREEN: () => "exit fullscreen mode",
    ENTER_PIP: () => "enter picture in picture mode",
    EXIT_PIP: () => "exit picture in picture mode",
    SEEK_FORWARD_N_SECS: ({ seekOffset = 30 } = {}) => `seek forward ${seekOffset} seconds`,
    SEEK_BACK_N_SECS: ({ seekOffset = 30 } = {}) => `seek back ${seekOffset} seconds`,
    SEEK_LIVE: () => "seek to live",
    PLAYING_LIVE: () => "playing live"
  };
  var labels_default = {
    ...nouns,
    ...verbs
  };

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/utils.js
  function stringifyRenditionList(renditions) {
    return renditions == null ? void 0 : renditions.map(stringifyRendition).join(" ");
  }
  function parseRenditionList(renditions) {
    return renditions == null ? void 0 : renditions.split(/\s+/).map(parseRendition);
  }
  function stringifyRendition(rendition) {
    if (rendition) {
      const { id, width, height } = rendition;
      return [id, width, height].filter((a) => a != null).join(":");
    }
  }
  function parseRendition(rendition) {
    if (rendition) {
      const [id, width, height] = rendition.split(":");
      return { id, width: +width, height: +height };
    }
  }
  function stringifyAudioTrackList(audioTracks) {
    return audioTracks == null ? void 0 : audioTracks.map(stringifyAudioTrack).join(" ");
  }
  function parseAudioTrackList(audioTracks) {
    return audioTracks == null ? void 0 : audioTracks.split(/\s+/).map(parseAudioTrack);
  }
  function stringifyAudioTrack(audioTrack) {
    if (audioTrack) {
      const { id, kind, language, label } = audioTrack;
      return [id, kind, language, label].filter((a) => a != null).join(":");
    }
  }
  function parseAudioTrack(audioTrack) {
    if (audioTrack) {
      const [id, kind, language, label] = audioTrack.split(":");
      return {
        id,
        kind,
        language,
        label
      };
    }
  }
  function camelCase(name) {
    return name.replace(/[-_]([a-z])/g, ($0, $1) => $1.toUpperCase());
  }
  function isValidNumber(x) {
    return typeof x === "number" && !Number.isNaN(x) && Number.isFinite(x);
  }
  function isNumericString(str) {
    if (typeof str != "string")
      return false;
    return !isNaN(str) && !isNaN(parseFloat(str));
  }
  var delay = (ms) => new Promise((resolve) => setTimeout(resolve, ms));

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/time.js
  var UnitLabels = [
    {
      singular: "hour",
      plural: "hours"
    },
    {
      singular: "minute",
      plural: "minutes"
    },
    {
      singular: "second",
      plural: "seconds"
    }
  ];
  var toTimeUnitPhrase = (timeUnitValue, unitIndex) => {
    const unitLabel = timeUnitValue === 1 ? UnitLabels[unitIndex].singular : UnitLabels[unitIndex].plural;
    return `${timeUnitValue} ${unitLabel}`;
  };
  var formatAsTimePhrase = (seconds) => {
    if (!isValidNumber(seconds))
      return "";
    const positiveSeconds = Math.abs(seconds);
    const negative = positiveSeconds !== seconds;
    const secondsDateTime = new Date(0, 0, 0, 0, 0, positiveSeconds, 0);
    const timeParts = [
      secondsDateTime.getHours(),
      secondsDateTime.getMinutes(),
      secondsDateTime.getSeconds()
    ];
    const timeString = timeParts.map(
      (timeUnitValue, index) => timeUnitValue && toTimeUnitPhrase(timeUnitValue, index)
    ).filter((x) => x).join(", ");
    const negativeSuffix = negative ? " remaining" : "";
    return `${timeString}${negativeSuffix}`;
  };
  function formatTime(seconds, guide) {
    let negative = false;
    if (seconds < 0) {
      negative = true;
      seconds = 0 - seconds;
    }
    seconds = seconds < 0 ? 0 : seconds;
    let s = Math.floor(seconds % 60);
    let m = Math.floor(seconds / 60 % 60);
    let h = Math.floor(seconds / 3600);
    const gm = Math.floor(guide / 60 % 60);
    const gh = Math.floor(guide / 3600);
    if (isNaN(seconds) || seconds === Infinity) {
      h = m = s = "0";
    }
    h = h > 0 || gh > 0 ? h + ":" : "";
    m = ((h || gm >= 10) && m < 10 ? "0" + m : m) + ":";
    s = s < 10 ? "0" + s : s;
    return (negative ? "-" : "") + h + m + s;
  }
  var emptyTimeRanges = Object.freeze({
    length: 0,
    start(index) {
      const unsignedIdx = index >>> 0;
      if (unsignedIdx >= this.length) {
        throw new DOMException(
          `Failed to execute 'start' on 'TimeRanges': The index provided (${unsignedIdx}) is greater than or equal to the maximum bound (${this.length}).`
        );
      }
      return 0;
    },
    end(index) {
      const unsignedIdx = index >>> 0;
      if (unsignedIdx >= this.length) {
        throw new DOMException(
          `Failed to execute 'end' on 'TimeRanges': The index provided (${unsignedIdx}) is greater than or equal to the maximum bound (${this.length}).`
        );
      }
      return 0;
    }
  });

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/server-safe-globals.js
  var EventTarget = class {
    addEventListener() {
    }
    removeEventListener() {
    }
    dispatchEvent() {
      return true;
    }
  };
  var Node = class extends EventTarget {
  };
  var Element = class extends Node {
    constructor() {
      super(...arguments);
      this.role = null;
    }
  };
  var ResizeObserver = class {
    observe() {
    }
    unobserve() {
    }
    disconnect() {
    }
  };
  var documentShim = {
    createElement: function() {
      return new globalThisShim.HTMLElement();
    },
    createElementNS: function() {
      return new globalThisShim.HTMLElement();
    },
    addEventListener() {
    },
    removeEventListener() {
    },
    /**
     *
     * @param {Event} event
     * @returns {boolean}
     */
    dispatchEvent(event) {
      return false;
    }
  };
  var globalThisShim = {
    ResizeObserver,
    document: documentShim,
    Node,
    Element,
    HTMLElement: class HTMLElement extends Element {
      constructor() {
        super(...arguments);
        this.innerHTML = "";
      }
      get content() {
        return new globalThisShim.DocumentFragment();
      }
    },
    DocumentFragment: class DocumentFragment extends EventTarget {
    },
    customElements: {
      get: function() {
      },
      define: function() {
      },
      whenDefined: function() {
      }
    },
    localStorage: {
      /**
       * @param {string} key
       * @returns {string|null}
       */
      getItem(key) {
        return null;
      },
      /**
       * @param {string} key
       * @param {string} value
       */
      setItem(key, value) {
      },
      // eslint-disable-line @typescript-eslint/no-unused-vars
      /**
       * @param {string} key
       */
      removeItem(key) {
      }
      // eslint-disable-line @typescript-eslint/no-unused-vars
    },
    CustomEvent: function CustomEvent2() {
    },
    getComputedStyle: function() {
    },
    navigator: {
      languages: [],
      get userAgent() {
        return "";
      }
    },
    /**
     * @param {string} media
     */
    matchMedia(media) {
      return {
        matches: false,
        media
      };
    }
  };
  var isServer = typeof window === "undefined" || typeof window.customElements === "undefined";
  var isShimmed = Object.keys(globalThisShim).every((key) => key in globalThis);
  var GlobalThis = isServer && !isShimmed ? globalThisShim : globalThis;
  var Document2 = isServer && !isShimmed ? documentShim : globalThis.document;

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/resize-observer.js
  var callbacksMap = /* @__PURE__ */ new WeakMap();
  var getCallbacks = (element) => {
    let callbacks = callbacksMap.get(element);
    if (!callbacks)
      callbacksMap.set(element, callbacks = /* @__PURE__ */ new Set());
    return callbacks;
  };
  var observer = new GlobalThis.ResizeObserver(
    (entries) => {
      for (const entry of entries) {
        for (const callback of getCallbacks(entry.target)) {
          callback(entry);
        }
      }
    }
  );
  function observeResize(element, callback) {
    getCallbacks(element).add(callback);
    observer.observe(element);
  }
  function unobserveResize(element, callback) {
    const callbacks = getCallbacks(element);
    callbacks.delete(callback);
    if (!callbacks.size) {
      observer.unobserve(element);
    }
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/element-utils.js
  function getMediaController(host) {
    var _a3;
    return (_a3 = getAttributeMediaController(host)) != null ? _a3 : closestComposedNode(host, "media-controller");
  }
  function getAttributeMediaController(host) {
    var _a3;
    const { MEDIA_CONTROLLER } = MediaStateReceiverAttributes;
    const mediaControllerId = host.getAttribute(MEDIA_CONTROLLER);
    if (mediaControllerId) {
      return (_a3 = getDocumentOrShadowRoot(host)) == null ? void 0 : _a3.getElementById(
        mediaControllerId
      );
    }
  }
  var updateIconText = (svg, value, selector = ".value") => {
    const node = svg.querySelector(selector);
    if (!node)
      return;
    node.textContent = value;
  };
  var getAllSlotted = (el, name) => {
    const slotSelector = `slot[name="${name}"]`;
    const slot = el.shadowRoot.querySelector(slotSelector);
    if (!slot)
      return [];
    return slot.children;
  };
  var getSlotted = (el, name) => getAllSlotted(el, name)[0];
  var containsComposedNode = (rootNode, childNode) => {
    if (!rootNode || !childNode)
      return false;
    if (rootNode == null ? void 0 : rootNode.contains(childNode))
      return true;
    return containsComposedNode(
      rootNode,
      childNode.getRootNode().host
    );
  };
  var closestComposedNode = (childNode, selector) => {
    if (!childNode)
      return null;
    const closest = childNode.closest(selector);
    if (closest)
      return closest;
    return closestComposedNode(
      childNode.getRootNode().host,
      selector
    );
  };
  function getActiveElement(root = document) {
    var _a3;
    const activeEl = root == null ? void 0 : root.activeElement;
    if (!activeEl)
      return null;
    return (_a3 = getActiveElement(activeEl.shadowRoot)) != null ? _a3 : activeEl;
  }
  function getDocumentOrShadowRoot(node) {
    var _a3;
    const rootNode = (_a3 = node == null ? void 0 : node.getRootNode) == null ? void 0 : _a3.call(node);
    if (rootNode instanceof ShadowRoot || rootNode instanceof Document) {
      return rootNode;
    }
    return null;
  }
  function isElementVisible(element, depth = 3) {
    if (element.checkVisibility) {
      return element.checkVisibility({
        checkOpacity: true,
        checkVisibilityCSS: true
      });
    }
    let el = element;
    while (el && depth > 0) {
      const style = getComputedStyle(el);
      if (style.opacity === "0" || style.visibility === "hidden" || style.display === "none") {
        return false;
      }
      el = el.parentElement;
      depth--;
    }
    return true;
  }
  function getPointProgressOnLine(x, y, p1, p2) {
    const segment = distance(p1, p2);
    const toStart = distance(p1, { x, y });
    const toEnd = distance(p2, { x, y });
    if (toStart > segment || toEnd > segment) {
      return toStart > toEnd ? 1 : 0;
    }
    return toStart / segment;
  }
  function distance(p1, p2) {
    return Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));
  }
  function getOrInsertCSSRule(styleParent, selectorText) {
    const cssRule = getCSSRule(styleParent, (st) => st === selectorText);
    if (cssRule)
      return cssRule;
    return insertCSSRule(styleParent, selectorText);
  }
  function getCSSRule(styleParent, predicate) {
    var _a3;
    let style;
    for (style of styleParent.querySelectorAll("style")) {
      let cssRules;
      try {
        cssRules = (_a3 = style.sheet) == null ? void 0 : _a3.cssRules;
      } catch {
        continue;
      }
      for (const rule of cssRules != null ? cssRules : []) {
        if (predicate(rule.selectorText))
          return rule;
      }
    }
  }
  function insertCSSRule(styleParent, selectorText) {
    var _a3, _b2;
    const styles = (_a3 = styleParent.querySelectorAll("style")) != null ? _a3 : [];
    const style = styles == null ? void 0 : styles[styles.length - 1];
    if (!(style == null ? void 0 : style.sheet)) {
      console.warn(
        "Media Chrome: No style sheet found on style tag of",
        styleParent
      );
      return {
        // @ts-ignore
        style: {
          setProperty: () => {
          },
          removeProperty: () => "",
          getPropertyValue: () => ""
        }
      };
    }
    style == null ? void 0 : style.sheet.insertRule(`${selectorText}{}`, style.sheet.cssRules.length);
    return (
      /** @type {CSSStyleRule} */
      (_b2 = style.sheet.cssRules) == null ? void 0 : _b2[style.sheet.cssRules.length - 1]
    );
  }
  function getNumericAttr(el, attrName, defaultValue = Number.NaN) {
    const attrVal = el.getAttribute(attrName);
    return attrVal != null ? +attrVal : defaultValue;
  }
  function setNumericAttr(el, attrName, value) {
    const nextNumericValue = +value;
    if (value == null || Number.isNaN(nextNumericValue)) {
      if (el.hasAttribute(attrName)) {
        el.removeAttribute(attrName);
      }
      return;
    }
    if (getNumericAttr(el, attrName, void 0) === nextNumericValue)
      return;
    el.setAttribute(attrName, `${nextNumericValue}`);
  }
  function getBooleanAttr(el, attrName) {
    return el.hasAttribute(attrName);
  }
  function setBooleanAttr(el, attrName, value) {
    if (value == null) {
      if (el.hasAttribute(attrName)) {
        el.removeAttribute(attrName);
      }
      return;
    }
    if (getBooleanAttr(el, attrName) == value)
      return;
    el.toggleAttribute(attrName, value);
  }
  function getStringAttr(el, attrName, defaultValue = null) {
    var _a3;
    return (_a3 = el.getAttribute(attrName)) != null ? _a3 : defaultValue;
  }
  function setStringAttr(el, attrName, value) {
    if (value == null) {
      if (el.hasAttribute(attrName)) {
        el.removeAttribute(attrName);
      }
      return;
    }
    const nextValue = `${value}`;
    if (getStringAttr(el, attrName, void 0) === nextValue)
      return;
    el.setAttribute(attrName, nextValue);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-gesture-receiver.js
  var __accessCheck = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet = (obj, member, getter) => {
    __accessCheck(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet = (obj, member, value, setter) => {
    __accessCheck(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _mediaController;
  var template = Document2.createElement("template");
  template.innerHTML = /*html*/
  `
<style>
  :host {
    display: var(--media-control-display, var(--media-gesture-receiver-display, inline-block));
    box-sizing: border-box;
  }
</style>
`;
  var MediaGestureReceiver = class extends GlobalThis.HTMLElement {
    constructor(options = {}) {
      super();
      __privateAdd(this, _mediaController, void 0);
      if (!this.shadowRoot) {
        const shadow = this.attachShadow({ mode: "open" });
        const buttonHTML = template.content.cloneNode(true);
        this.nativeEl = buttonHTML;
        let slotTemplate17 = options.slotTemplate;
        if (!slotTemplate17) {
          slotTemplate17 = Document2.createElement("template");
          slotTemplate17.innerHTML = `<slot>${options.defaultContent || ""}</slot>`;
        }
        this.nativeEl.appendChild(slotTemplate17.content.cloneNode(true));
        shadow.appendChild(buttonHTML);
      }
    }
    // NOTE: Currently "baking in" actions + attrs until we come up with
    // a more robust architecture (CJP)
    static get observedAttributes() {
      return [
        MediaStateReceiverAttributes.MEDIA_CONTROLLER,
        MediaUIAttributes.MEDIA_PAUSED
      ];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      var _a3, _b2, _c, _d, _e;
      if (attrName === MediaStateReceiverAttributes.MEDIA_CONTROLLER) {
        if (oldValue) {
          (_b2 = (_a3 = __privateGet(this, _mediaController)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
          __privateSet(this, _mediaController, null);
        }
        if (newValue && this.isConnected) {
          __privateSet(this, _mediaController, (_c = this.getRootNode()) == null ? void 0 : _c.getElementById(newValue));
          (_e = (_d = __privateGet(this, _mediaController)) == null ? void 0 : _d.associateElement) == null ? void 0 : _e.call(_d, this);
        }
      }
    }
    connectedCallback() {
      var _a3, _b2, _c, _d;
      this.tabIndex = -1;
      this.setAttribute("aria-hidden", "true");
      __privateSet(this, _mediaController, getMediaControllerEl(this));
      if (this.getAttribute(MediaStateReceiverAttributes.MEDIA_CONTROLLER)) {
        (_b2 = (_a3 = __privateGet(this, _mediaController)) == null ? void 0 : _a3.associateElement) == null ? void 0 : _b2.call(_a3, this);
      }
      (_c = __privateGet(this, _mediaController)) == null ? void 0 : _c.addEventListener("pointerdown", this);
      (_d = __privateGet(this, _mediaController)) == null ? void 0 : _d.addEventListener("click", this);
    }
    disconnectedCallback() {
      var _a3, _b2, _c, _d;
      if (this.getAttribute(MediaStateReceiverAttributes.MEDIA_CONTROLLER)) {
        (_b2 = (_a3 = __privateGet(this, _mediaController)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
      }
      (_c = __privateGet(this, _mediaController)) == null ? void 0 : _c.removeEventListener("pointerdown", this);
      (_d = __privateGet(this, _mediaController)) == null ? void 0 : _d.removeEventListener("click", this);
      __privateSet(this, _mediaController, null);
    }
    handleEvent(event) {
      var _a3;
      const composedTarget = (_a3 = event.composedPath()) == null ? void 0 : _a3[0];
      const allowList = ["video", "media-controller"];
      if (!allowList.includes(composedTarget == null ? void 0 : composedTarget.localName))
        return;
      if (event.type === "pointerdown") {
        this._pointerType = event.pointerType;
      } else if (event.type === "click") {
        const { clientX, clientY } = event;
        const { left, top, width, height } = this.getBoundingClientRect();
        const x = clientX - left;
        const y = clientY - top;
        if (x < 0 || y < 0 || x > width || y > height || // In case this element has no dimensions (or display: none) return.
        width === 0 && height === 0) {
          return;
        }
        const { pointerType = this._pointerType } = event;
        this._pointerType = void 0;
        if (pointerType === PointerTypes.TOUCH) {
          this.handleTap(event);
          return;
        } else if (pointerType === PointerTypes.MOUSE) {
          this.handleMouseClick(event);
          return;
        }
      }
    }
    /**
     * @type {boolean} Is the media paused
     */
    get mediaPaused() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_PAUSED);
    }
    set mediaPaused(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_PAUSED, value);
    }
    // NOTE: Currently "baking in" actions + attrs until we come up with
    // a more robust architecture (CJP)
    /**
     * @abstract
     * @argument {Event} e
     */
    handleTap(e) {
    }
    // eslint-disable-line
    // eslint-disable-next-line
    handleMouseClick(e) {
      const eventName = this.mediaPaused ? MediaUIEvents.MEDIA_PLAY_REQUEST : MediaUIEvents.MEDIA_PAUSE_REQUEST;
      this.dispatchEvent(
        new GlobalThis.CustomEvent(eventName, { composed: true, bubbles: true })
      );
    }
  };
  _mediaController = /* @__PURE__ */ new WeakMap();
  function getMediaControllerEl(controlEl) {
    var _a3;
    const mediaControllerId = controlEl.getAttribute(
      MediaStateReceiverAttributes.MEDIA_CONTROLLER
    );
    if (mediaControllerId) {
      return (_a3 = controlEl.getRootNode()) == null ? void 0 : _a3.getElementById(mediaControllerId);
    }
    return closestComposedNode(controlEl, "media-controller");
  }
  if (!GlobalThis.customElements.get("media-gesture-receiver")) {
    GlobalThis.customElements.define(
      "media-gesture-receiver",
      MediaGestureReceiver
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-container.js
  var __accessCheck2 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet2 = (obj, member, getter) => {
    __accessCheck2(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd2 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet2 = (obj, member, value, setter) => {
    __accessCheck2(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateMethod = (obj, member, method) => {
    __accessCheck2(obj, member, "access private method");
    return method;
  };
  var _pointerDownTimeStamp;
  var _currentMedia;
  var _inactiveTimeout;
  var _autohide;
  var _handlePointerMove;
  var handlePointerMove_fn;
  var _handlePointerUp;
  var handlePointerUp_fn;
  var _setInactive;
  var setInactive_fn;
  var _setActive;
  var setActive_fn;
  var _scheduleInactive;
  var scheduleInactive_fn;
  var Attributes = {
    AUDIO: "audio",
    AUTOHIDE: "autohide",
    BREAKPOINTS: "breakpoints",
    GESTURES_DISABLED: "gesturesdisabled",
    KEYBOARD_CONTROL: "keyboardcontrol",
    NO_AUTOHIDE: "noautohide",
    USER_INACTIVE: "userinactive"
  };
  var template2 = Document2.createElement("template");
  template2.innerHTML = /*html*/
  `
  <style>
    ${/*
  * outline on media is turned off because it is allowed to get focus to faciliate hotkeys.
  * However, on keyboard interactions, the focus outline is shown,
  * which is particularly noticeable when going fullscreen via hotkeys.
  */
  ""}
    :host([${MediaUIAttributes.MEDIA_IS_FULLSCREEN}]) ::slotted([slot=media]) {
      outline: none;
    }

    :host {
      box-sizing: border-box;
      position: relative;
      display: inline-block;
      line-height: 0;
      background-color: var(--media-background-color, #000);
    }

    :host(:not([${Attributes.AUDIO}])) [part~=layer]:not([part~=media-layer]) {
      position: absolute;
      top: 0;
      left: 0;
      bottom: 0;
      right: 0;
      display: flex;
      flex-flow: column nowrap;
      align-items: start;
      pointer-events: none;
      background: none;
    }

    slot[name=media] {
      display: var(--media-slot-display, contents);
    }

    ${/*
  * when in audio mode, hide the slotted media element by default
  */
  ""}
    :host([${Attributes.AUDIO}]) slot[name=media] {
      display: var(--media-slot-display, none);
    }

    ${/*
  * when in audio mode, hide the gesture-layer which causes media-controller to be taller than the control bar
  */
  ""}
    :host([${Attributes.AUDIO}]) [part~=layer][part~=gesture-layer] {
      height: 0;
      display: block;
    }

    ${/*
  * if gestures are disabled, don't accept pointer-events
  */
  ""}
    :host(:not([${Attributes.AUDIO}])[${Attributes.GESTURES_DISABLED}]) ::slotted([slot=gestures-chrome]),
    :host(:not([${Attributes.AUDIO}])[${Attributes.GESTURES_DISABLED}]) media-gesture-receiver[slot=gestures-chrome] {
      display: none;
    }

    ${/*
  * any slotted element that isn't a poster or media slot should be pointer-events auto
  * we'll want to add here any slotted elements that shouldn't get pointer-events by default when slotted
  */
  ""}
    ::slotted(:not([slot=media]):not([slot=poster]):not(media-loading-indicator):not([hidden])) {
      pointer-events: auto;
    }

    :host(:not([${Attributes.AUDIO}])) *[part~=layer][part~=centered-layer] {
      align-items: center;
      justify-content: center;
    }

    :host(:not([${Attributes.AUDIO}])) ::slotted(media-gesture-receiver[slot=gestures-chrome]),
    :host(:not([${Attributes.AUDIO}])) media-gesture-receiver[slot=gestures-chrome] {
      align-self: stretch;
      flex-grow: 1;
    }

    slot[name=middle-chrome] {
      display: inline;
      flex-grow: 1;
      pointer-events: none;
      background: none;
    }

    ${/* Position the media and poster elements to fill the container */
  ""}
    ::slotted([slot=media]),
    ::slotted([slot=poster]) {
      width: 100%;
      height: 100%;
    }

    ${/* Video specific styles */
  ""}
    :host(:not([${Attributes.AUDIO}])) .spacer {
      flex-grow: 1;
    }

    ${/* Safari needs this to actually make the element fill the window */
  ""}
    :host(:-webkit-full-screen) {
      ${/* Needs to use !important otherwise easy to break */
  ""}
      width: 100% !important;
      height: 100% !important;
    }

    ${/* Only add these if auto hide is not disabled */
  ""}
    ::slotted(:not([slot=media]):not([slot=poster]):not([${Attributes.NO_AUTOHIDE}]):not([hidden])) {
      opacity: 1;
      transition: opacity 0.25s;
    }

    ${/* Hide controls when inactive, not paused, not audio and auto hide not disabled */
  ""}
    :host([${Attributes.USER_INACTIVE}]:not([${MediaUIAttributes.MEDIA_PAUSED}]):not([${MediaUIAttributes.MEDIA_IS_AIRPLAYING}]):not([${MediaUIAttributes.MEDIA_IS_CASTING}]):not([${Attributes.AUDIO}])) ::slotted(:not([slot=media]):not([slot=poster]):not([${Attributes.NO_AUTOHIDE}])) {
      opacity: 0;
      transition: opacity 1s;
    }

    :host([${Attributes.USER_INACTIVE}]:not([${MediaUIAttributes.MEDIA_PAUSED}]):not([${MediaUIAttributes.MEDIA_IS_CASTING}]):not([${Attributes.AUDIO}])) ::slotted([slot=media]) {
      cursor: none;
    }

    ::slotted(media-control-bar)  {
      align-self: stretch;
    }

    ${/* ::slotted([slot=poster]) doesn't work for slot fallback content so hide parent slot instead */
  ""}
    :host(:not([${Attributes.AUDIO}])[${MediaUIAttributes.MEDIA_HAS_PLAYED}]) slot[name=poster] {
      display: none;
    }

    ::slotted([role="menu"]) {
      align-self: end;
    }

    ::slotted([role="dialog"]) {
      align-self: center;
    }
  </style>

  <slot name="media" part="layer media-layer"></slot>
  <slot name="poster" part="layer poster-layer"></slot>
  <slot name="gestures-chrome" part="layer gesture-layer">
    <media-gesture-receiver slot="gestures-chrome"></media-gesture-receiver>
  </slot>
  <span part="layer vertical-layer">
    <slot name="top-chrome" part="top chrome"></slot>
    <slot name="middle-chrome" part="middle chrome"></slot>
    <slot name="centered-chrome" part="layer centered-layer center centered chrome"></slot>
    ${/* default, effectively "bottom-chrome" */
  ""}
    <slot part="bottom chrome"></slot>
  </span>
`;
  var MEDIA_UI_ATTRIBUTE_NAMES = Object.values(MediaUIAttributes);
  var defaultBreakpoints = "sm:384 md:576 lg:768 xl:960";
  function resizeCallback(entry) {
    setBreakpoints(entry.target, entry.contentRect.width);
  }
  function setBreakpoints(container, width) {
    var _a3;
    if (!container.isConnected)
      return;
    const breakpoints = (_a3 = container.getAttribute(Attributes.BREAKPOINTS)) != null ? _a3 : defaultBreakpoints;
    const ranges = createBreakpointMap(breakpoints);
    const activeBreakpoints = getBreakpoints(ranges, width);
    let changed = false;
    Object.keys(ranges).forEach((name) => {
      if (activeBreakpoints.includes(name)) {
        if (!container.hasAttribute(`breakpoint${name}`)) {
          container.setAttribute(`breakpoint${name}`, "");
          changed = true;
        }
        return;
      }
      if (container.hasAttribute(`breakpoint${name}`)) {
        container.removeAttribute(`breakpoint${name}`);
        changed = true;
      }
    });
    if (changed) {
      const evt = new CustomEvent(MediaStateChangeEvents.BREAKPOINTS_CHANGE, {
        detail: activeBreakpoints
      });
      container.dispatchEvent(evt);
    }
  }
  function createBreakpointMap(breakpoints) {
    const pairs = breakpoints.split(/\s+/);
    return Object.fromEntries(pairs.map((pair) => pair.split(":")));
  }
  function getBreakpoints(breakpoints, width) {
    return Object.keys(breakpoints).filter((name) => {
      return width >= parseInt(breakpoints[name]);
    });
  }
  var MediaContainer = class extends GlobalThis.HTMLElement {
    constructor() {
      super();
      __privateAdd2(this, _handlePointerMove);
      __privateAdd2(this, _handlePointerUp);
      __privateAdd2(this, _setInactive);
      __privateAdd2(this, _setActive);
      __privateAdd2(this, _scheduleInactive);
      __privateAdd2(this, _pointerDownTimeStamp, 0);
      __privateAdd2(this, _currentMedia, null);
      __privateAdd2(this, _inactiveTimeout, null);
      __privateAdd2(this, _autohide, void 0);
      this.breakpointsComputed = false;
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        this.shadowRoot.appendChild(template2.content.cloneNode(true));
      }
      const mutationCallback = (mutationsList) => {
        const media = this.media;
        for (const mutation of mutationsList) {
          if (mutation.type === "childList") {
            mutation.removedNodes.forEach((node) => {
              if (node.slot == "media" && mutation.target == this) {
                let previousSibling = mutation.previousSibling && mutation.previousSibling.previousElementSibling;
                if (!previousSibling || !media) {
                  this.mediaUnsetCallback(node);
                } else {
                  let wasFirst = previousSibling.slot !== "media";
                  while ((previousSibling = previousSibling.previousSibling) !== null) {
                    if (previousSibling.slot == "media")
                      wasFirst = false;
                  }
                  if (wasFirst)
                    this.mediaUnsetCallback(node);
                }
              }
            });
            if (media) {
              mutation.addedNodes.forEach((node) => {
                if (node === media) {
                  this.handleMediaUpdated(media);
                }
              });
            }
          }
        }
      };
      const mutationObserver = new MutationObserver(mutationCallback);
      mutationObserver.observe(this, { childList: true, subtree: true });
      let pendingResizeCb = false;
      const deferResizeCallback = (entry) => {
        if (pendingResizeCb)
          return;
        setTimeout(() => {
          resizeCallback(entry);
          pendingResizeCb = false;
          if (!this.breakpointsComputed) {
            this.breakpointsComputed = true;
            this.dispatchEvent(
              new CustomEvent(MediaStateChangeEvents.BREAKPOINTS_COMPUTED, {
                bubbles: true,
                composed: true
              })
            );
          }
        }, 0);
        pendingResizeCb = true;
      };
      observeResize(this, deferResizeCallback);
      const chainedSlot = this.querySelector(
        ":scope > slot[slot=media]"
      );
      if (chainedSlot) {
        chainedSlot.addEventListener("slotchange", () => {
          const slotEls = chainedSlot.assignedElements({ flatten: true });
          if (!slotEls.length) {
            if (__privateGet2(this, _currentMedia)) {
              this.mediaUnsetCallback(__privateGet2(this, _currentMedia));
            }
            return;
          }
          this.handleMediaUpdated(this.media);
        });
      }
    }
    static get observedAttributes() {
      return [Attributes.AUTOHIDE, Attributes.GESTURES_DISABLED].concat(MEDIA_UI_ATTRIBUTE_NAMES).filter(
        (name) => ![
          MediaUIAttributes.MEDIA_RENDITION_LIST,
          MediaUIAttributes.MEDIA_AUDIO_TRACK_LIST,
          MediaUIAttributes.MEDIA_CHAPTERS_CUES
        ].includes(name)
      );
    }
    // Could share this code with media-chrome-html-element instead
    attributeChangedCallback(attrName, oldValue, newValue) {
      if (attrName.toLowerCase() == Attributes.AUTOHIDE) {
        this.autohide = newValue;
      }
    }
    // First direct child with slot=media, or null
    /**
     * @returns {HTMLVideoElement &
     * {buffered,
     * webkitEnterFullscreen?,
     * webkitExitFullscreen?,
     * requestCast?,
     * webkitShowPlaybackTargetPicker?,
     * videoTracks?,
     * }}
     */
    get media() {
      let media = this.querySelector(":scope > [slot=media]");
      if ((media == null ? void 0 : media.nodeName) == "SLOT")
        media = media.assignedElements({ flatten: true })[0];
      return media;
    }
    /**
     * @param {HTMLMediaElement} media
     */
    async handleMediaUpdated(media) {
      if (!media)
        return;
      __privateSet2(this, _currentMedia, media);
      if (media.localName.includes("-")) {
        await GlobalThis.customElements.whenDefined(media.localName);
      }
      this.mediaSetCallback(media);
    }
    connectedCallback() {
      var _a3;
      const isAudioChrome = this.getAttribute(Attributes.AUDIO) != null;
      const label = isAudioChrome ? nouns.AUDIO_PLAYER() : nouns.VIDEO_PLAYER();
      this.setAttribute("role", "region");
      this.setAttribute("aria-label", label);
      this.handleMediaUpdated(this.media);
      this.setAttribute(Attributes.USER_INACTIVE, "");
      this.addEventListener("pointerdown", this);
      this.addEventListener("pointermove", this);
      this.addEventListener("pointerup", this);
      this.addEventListener("mouseleave", this);
      this.addEventListener("keyup", this);
      (_a3 = GlobalThis.window) == null ? void 0 : _a3.addEventListener("mouseup", this);
    }
    disconnectedCallback() {
      var _a3;
      if (this.media) {
        this.mediaUnsetCallback(this.media);
      }
      (_a3 = GlobalThis.window) == null ? void 0 : _a3.removeEventListener("mouseup", this);
    }
    /**
     * @abstract
     * @param {HTMLMediaElement} media
     */
    mediaSetCallback(media) {
    }
    // eslint-disable-line
    /**
     * @param {HTMLMediaElement} media
     */
    mediaUnsetCallback(media) {
      __privateSet2(this, _currentMedia, null);
    }
    handleEvent(event) {
      switch (event.type) {
        case "pointerdown":
          __privateSet2(this, _pointerDownTimeStamp, event.timeStamp);
          break;
        case "pointermove":
          __privateMethod(this, _handlePointerMove, handlePointerMove_fn).call(this, event);
          break;
        case "pointerup":
          __privateMethod(this, _handlePointerUp, handlePointerUp_fn).call(this, event);
          break;
        case "mouseleave":
          __privateMethod(this, _setInactive, setInactive_fn).call(this);
          break;
        case "mouseup":
          this.removeAttribute(Attributes.KEYBOARD_CONTROL);
          break;
        case "keyup":
          __privateMethod(this, _scheduleInactive, scheduleInactive_fn).call(this);
          this.setAttribute(Attributes.KEYBOARD_CONTROL, "");
          break;
      }
    }
    set autohide(seconds) {
      const parsedSeconds = Number(seconds);
      __privateSet2(this, _autohide, isNaN(parsedSeconds) ? 0 : parsedSeconds);
    }
    get autohide() {
      return (__privateGet2(this, _autohide) === void 0 ? 2 : __privateGet2(this, _autohide)).toString();
    }
  };
  _pointerDownTimeStamp = /* @__PURE__ */ new WeakMap();
  _currentMedia = /* @__PURE__ */ new WeakMap();
  _inactiveTimeout = /* @__PURE__ */ new WeakMap();
  _autohide = /* @__PURE__ */ new WeakMap();
  _handlePointerMove = /* @__PURE__ */ new WeakSet();
  handlePointerMove_fn = function(event) {
    if (event.pointerType !== "mouse") {
      const MAX_TAP_DURATION = 250;
      if (event.timeStamp - __privateGet2(this, _pointerDownTimeStamp) < MAX_TAP_DURATION)
        return;
    }
    __privateMethod(this, _setActive, setActive_fn).call(this);
    clearTimeout(__privateGet2(this, _inactiveTimeout));
    if ([this, this.media].includes(event.target)) {
      __privateMethod(this, _scheduleInactive, scheduleInactive_fn).call(this);
    }
  };
  _handlePointerUp = /* @__PURE__ */ new WeakSet();
  handlePointerUp_fn = function(event) {
    if (event.pointerType === "touch") {
      const controlsVisible = !this.hasAttribute(Attributes.USER_INACTIVE);
      if ([this, this.media].includes(event.target) && controlsVisible) {
        __privateMethod(this, _setInactive, setInactive_fn).call(this);
      } else {
        __privateMethod(this, _scheduleInactive, scheduleInactive_fn).call(this);
      }
    } else if (event.composedPath().some(
      (el) => ["media-play-button", "media-fullscreen-button"].includes(
        el == null ? void 0 : el.localName
      )
    )) {
      __privateMethod(this, _scheduleInactive, scheduleInactive_fn).call(this);
    }
  };
  _setInactive = /* @__PURE__ */ new WeakSet();
  setInactive_fn = function() {
    if (__privateGet2(this, _autohide) < 0)
      return;
    if (this.hasAttribute(Attributes.USER_INACTIVE))
      return;
    this.setAttribute(Attributes.USER_INACTIVE, "");
    const evt = new GlobalThis.CustomEvent(
      MediaStateChangeEvents.USER_INACTIVE,
      { composed: true, bubbles: true, detail: true }
    );
    this.dispatchEvent(evt);
  };
  _setActive = /* @__PURE__ */ new WeakSet();
  setActive_fn = function() {
    if (!this.hasAttribute(Attributes.USER_INACTIVE))
      return;
    this.removeAttribute(Attributes.USER_INACTIVE);
    const evt = new GlobalThis.CustomEvent(
      MediaStateChangeEvents.USER_INACTIVE,
      { composed: true, bubbles: true, detail: false }
    );
    this.dispatchEvent(evt);
  };
  _scheduleInactive = /* @__PURE__ */ new WeakSet();
  scheduleInactive_fn = function() {
    __privateMethod(this, _setActive, setActive_fn).call(this);
    clearTimeout(__privateGet2(this, _inactiveTimeout));
    const autohide = parseInt(this.autohide);
    if (autohide < 0)
      return;
    __privateSet2(this, _inactiveTimeout, setTimeout(() => {
      __privateMethod(this, _setInactive, setInactive_fn).call(this);
    }, autohide * 1e3));
  };
  if (!GlobalThis.customElements.get("media-container")) {
    GlobalThis.customElements.define("media-container", MediaContainer);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/attribute-token-list.js
  var __accessCheck3 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet3 = (obj, member, getter) => {
    __accessCheck3(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd3 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet3 = (obj, member, value, setter) => {
    __accessCheck3(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _el;
  var _attr;
  var _defaultSet;
  var _tokenSet;
  var _tokens;
  var tokens_get;
  var AttributeTokenList = class {
    constructor(el, attr, { defaultValue } = { defaultValue: void 0 }) {
      __privateAdd3(this, _tokens);
      __privateAdd3(this, _el, void 0);
      __privateAdd3(this, _attr, void 0);
      __privateAdd3(this, _defaultSet, void 0);
      __privateAdd3(this, _tokenSet, /* @__PURE__ */ new Set());
      __privateSet3(this, _el, el);
      __privateSet3(this, _attr, attr);
      __privateSet3(this, _defaultSet, new Set(defaultValue));
    }
    [Symbol.iterator]() {
      return __privateGet3(this, _tokens, tokens_get).values();
    }
    get length() {
      return __privateGet3(this, _tokens, tokens_get).size;
    }
    get value() {
      var _a3;
      return (_a3 = [...__privateGet3(this, _tokens, tokens_get)].join(" ")) != null ? _a3 : "";
    }
    set value(val) {
      var _a3;
      if (val === this.value)
        return;
      __privateSet3(this, _tokenSet, /* @__PURE__ */ new Set());
      this.add(...(_a3 = val == null ? void 0 : val.split(" ")) != null ? _a3 : []);
    }
    toString() {
      return this.value;
    }
    item(index) {
      return [...__privateGet3(this, _tokens, tokens_get)][index];
    }
    values() {
      return __privateGet3(this, _tokens, tokens_get).values();
    }
    forEach(callback, thisArg) {
      __privateGet3(this, _tokens, tokens_get).forEach(callback, thisArg);
    }
    add(...tokens) {
      var _a3, _b2;
      tokens.forEach((t) => __privateGet3(this, _tokenSet).add(t));
      if (this.value === "" && !((_a3 = __privateGet3(this, _el)) == null ? void 0 : _a3.hasAttribute(`${__privateGet3(this, _attr)}`))) {
        return;
      }
      (_b2 = __privateGet3(this, _el)) == null ? void 0 : _b2.setAttribute(`${__privateGet3(this, _attr)}`, `${this.value}`);
    }
    remove(...tokens) {
      var _a3;
      tokens.forEach((t) => __privateGet3(this, _tokenSet).delete(t));
      (_a3 = __privateGet3(this, _el)) == null ? void 0 : _a3.setAttribute(`${__privateGet3(this, _attr)}`, `${this.value}`);
    }
    contains(token) {
      return __privateGet3(this, _tokens, tokens_get).has(token);
    }
    toggle(token, force) {
      if (typeof force !== "undefined") {
        if (force) {
          this.add(token);
          return true;
        } else {
          this.remove(token);
          return false;
        }
      }
      if (this.contains(token)) {
        this.remove(token);
        return false;
      }
      this.add(token);
      return true;
    }
    replace(oldToken, newToken) {
      this.remove(oldToken);
      this.add(newToken);
      return oldToken === newToken;
    }
  };
  _el = /* @__PURE__ */ new WeakMap();
  _attr = /* @__PURE__ */ new WeakMap();
  _defaultSet = /* @__PURE__ */ new WeakMap();
  _tokenSet = /* @__PURE__ */ new WeakMap();
  _tokens = /* @__PURE__ */ new WeakSet();
  tokens_get = function() {
    return __privateGet3(this, _tokenSet).size ? __privateGet3(this, _tokenSet) : __privateGet3(this, _defaultSet);
  };

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/captions.js
  var splitTextTracksStr = (textTracksStr = "") => textTracksStr.split(/\s+/);
  var parseTextTrackStr = (textTrackStr = "") => {
    const [kind, language, encodedLabel] = textTrackStr.split(":");
    const label = encodedLabel ? decodeURIComponent(encodedLabel) : void 0;
    return {
      kind: kind === "cc" ? TextTrackKinds.CAPTIONS : TextTrackKinds.SUBTITLES,
      language,
      label
    };
  };
  var parseTextTracksStr = (textTracksStr = "", textTrackLikeObj = {}) => {
    return splitTextTracksStr(textTracksStr).map((textTrackStr) => {
      const textTrackObj = parseTextTrackStr(textTrackStr);
      return {
        ...textTrackLikeObj,
        ...textTrackObj
      };
    });
  };
  var parseTracks = (trackOrTracks) => {
    if (!trackOrTracks)
      return [];
    if (Array.isArray(trackOrTracks)) {
      return trackOrTracks.map((trackObjOrStr) => {
        if (typeof trackObjOrStr === "string") {
          return parseTextTrackStr(trackObjOrStr);
        }
        return trackObjOrStr;
      });
    }
    if (typeof trackOrTracks === "string") {
      return parseTextTracksStr(trackOrTracks);
    }
    return [trackOrTracks];
  };
  var formatTextTrackObj = ({ kind, label, language } = { kind: "subtitles" }) => {
    if (!label)
      return language;
    return `${kind === "captions" ? "cc" : "sb"}:${language}:${encodeURIComponent(
      label
    )}`;
  };
  var stringifyTextTrackList = (textTracks = []) => {
    return Array.prototype.map.call(textTracks, formatTextTrackObj).join(" ");
  };
  var isMatchingPropOf = (key, value) => (obj) => obj[key] === value;
  var textTrackObjAsPred = (filterObj) => {
    const preds = Object.entries(filterObj).map(([key, value]) => {
      return isMatchingPropOf(key, value);
    });
    return (textTrack) => preds.every((pred) => pred(textTrack));
  };
  var updateTracksModeTo = (mode, tracks = [], tracksToUpdate = []) => {
    const preds = parseTracks(tracksToUpdate).map(textTrackObjAsPred);
    const isTrackToUpdate = (textTrack) => {
      return preds.some((pred) => pred(textTrack));
    };
    Array.from(tracks).filter(isTrackToUpdate).forEach((textTrack) => {
      textTrack.mode = mode;
    });
  };
  var getTextTracksList = (media, filterPredOrObj = () => true) => {
    if (!(media == null ? void 0 : media.textTracks))
      return [];
    const filterPred = typeof filterPredOrObj === "function" ? filterPredOrObj : textTrackObjAsPred(filterPredOrObj);
    return Array.from(media.textTracks).filter(filterPred);
  };
  var areSubsOn = (el) => {
    var _a3;
    const showingSubtitles = !!((_a3 = el.mediaSubtitlesShowing) == null ? void 0 : _a3.length) || el.hasAttribute(MediaUIAttributes.MEDIA_SUBTITLES_SHOWING);
    return showingSubtitles;
  };

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/fullscreen-api.js
  var enterFullscreen = (stateOwners) => {
    var _a3;
    const { media, fullscreenElement } = stateOwners;
    const enterFullscreenKey = fullscreenElement && "requestFullscreen" in fullscreenElement ? "requestFullscreen" : fullscreenElement && "webkitRequestFullScreen" in fullscreenElement ? "webkitRequestFullScreen" : void 0;
    if (enterFullscreenKey) {
      const maybePromise = (_a3 = fullscreenElement[enterFullscreenKey]) == null ? void 0 : _a3.call(fullscreenElement);
      if (maybePromise instanceof Promise) {
        return maybePromise.catch(() => {
        });
      }
    } else if (media == null ? void 0 : media.webkitEnterFullscreen) {
      media.webkitEnterFullscreen();
    } else if (media == null ? void 0 : media.requestFullscreen) {
      media.requestFullscreen();
    }
  };
  var exitFullscreenKey = "exitFullscreen" in Document2 ? "exitFullscreen" : "webkitExitFullscreen" in Document2 ? "webkitExitFullscreen" : "webkitCancelFullScreen" in Document2 ? "webkitCancelFullScreen" : void 0;
  var exitFullscreen = (stateOwners) => {
    var _a3;
    const { documentElement } = stateOwners;
    if (exitFullscreenKey) {
      const maybePromise = (_a3 = documentElement == null ? void 0 : documentElement[exitFullscreenKey]) == null ? void 0 : _a3.call(documentElement);
      if (maybePromise instanceof Promise) {
        return maybePromise.catch(() => {
        });
      }
    }
  };
  var fullscreenElementKey = "fullscreenElement" in Document2 ? "fullscreenElement" : "webkitFullscreenElement" in Document2 ? "webkitFullscreenElement" : void 0;
  var getFullscreenElement = (stateOwners) => {
    const { documentElement, media } = stateOwners;
    const docFullscreenElement = documentElement == null ? void 0 : documentElement[fullscreenElementKey];
    if (!docFullscreenElement && "webkitDisplayingFullscreen" in media && "webkitPresentationMode" in media && media.webkitDisplayingFullscreen && media.webkitPresentationMode === WebkitPresentationModes.FULLSCREEN) {
      return media;
    }
    return docFullscreenElement;
  };
  var isFullscreen = (stateOwners) => {
    var _a3;
    const { media, documentElement, fullscreenElement = media } = stateOwners;
    if (!media || !documentElement)
      return false;
    const currentFullscreenElement = getFullscreenElement(stateOwners);
    if (!currentFullscreenElement)
      return false;
    if (currentFullscreenElement === fullscreenElement || currentFullscreenElement === media) {
      return true;
    }
    if (currentFullscreenElement.localName.includes("-")) {
      let currentRoot = currentFullscreenElement.shadowRoot;
      if (!(fullscreenElementKey in currentRoot)) {
        return containsComposedNode(
          currentFullscreenElement,
          /** @TODO clean up type assumptions (e.g. Node) (CJP) */
          // @ts-ignore
          fullscreenElement
        );
      }
      while (currentRoot == null ? void 0 : currentRoot[fullscreenElementKey]) {
        if (currentRoot[fullscreenElementKey] === fullscreenElement)
          return true;
        currentRoot = (_a3 = currentRoot[fullscreenElementKey]) == null ? void 0 : _a3.shadowRoot;
      }
    }
    return false;
  };
  var fullscreenEnabledKey = "fullscreenEnabled" in Document2 ? "fullscreenEnabled" : "webkitFullscreenEnabled" in Document2 ? "webkitFullscreenEnabled" : void 0;
  var isFullscreenEnabled = (stateOwners) => {
    const { documentElement, media } = stateOwners;
    return !!(documentElement == null ? void 0 : documentElement[fullscreenEnabledKey]) || media && "webkitSupportsFullscreen" in media;
  };

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/platform-tests.js
  var testMediaEl;
  var getTestMediaEl = () => {
    var _a3, _b2;
    if (testMediaEl)
      return testMediaEl;
    testMediaEl = (_b2 = (_a3 = Document2) == null ? void 0 : _a3.createElement) == null ? void 0 : _b2.call(_a3, "video");
    return testMediaEl;
  };
  var hasVolumeSupportAsync = async (mediaEl = getTestMediaEl()) => {
    if (!mediaEl)
      return false;
    const prevVolume = mediaEl.volume;
    mediaEl.volume = prevVolume / 2 + 0.1;
    await delay(0);
    return mediaEl.volume !== prevVolume;
  };
  var isSafari = /.*Version\/.*Safari\/.*/.test(
    GlobalThis.navigator.userAgent
  );
  var hasPipSupport = (mediaEl = getTestMediaEl()) => {
    if (GlobalThis.matchMedia("(display-mode: standalone)").matches && isSafari)
      return false;
    return typeof (mediaEl == null ? void 0 : mediaEl.requestPictureInPicture) === "function";
  };
  var hasFullscreenSupport = (mediaEl = getTestMediaEl()) => {
    return isFullscreenEnabled({ documentElement: Document2, media: mediaEl });
  };
  var fullscreenSupported = hasFullscreenSupport();
  var pipSupported = hasPipSupport();
  var airplaySupported = !!GlobalThis.WebKitPlaybackTargetAvailabilityEvent;
  var castSupported = !!GlobalThis.chrome;

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-store/util.js
  var getSubtitleTracks = (stateOwners) => {
    return getTextTracksList(stateOwners.media, (textTrack) => {
      return [TextTrackKinds.SUBTITLES, TextTrackKinds.CAPTIONS].includes(
        textTrack.kind
      );
    }).sort((a, b) => a.kind >= b.kind ? 1 : -1);
  };
  var getShowingSubtitleTracks = (stateOwners) => {
    return getTextTracksList(stateOwners.media, (textTrack) => {
      return textTrack.mode === TextTrackModes.SHOWING && [TextTrackKinds.SUBTITLES, TextTrackKinds.CAPTIONS].includes(
        textTrack.kind
      );
    });
  };
  var toggleSubtitleTracks = (stateOwners, force) => {
    const tracks = getSubtitleTracks(stateOwners);
    const showingSubitleTracks = getShowingSubtitleTracks(stateOwners);
    const subtitlesShowing = !!showingSubitleTracks.length;
    if (!tracks.length)
      return;
    if (force === false || subtitlesShowing && force !== true) {
      updateTracksModeTo(TextTrackModes.DISABLED, tracks, showingSubitleTracks);
    } else if (force === true || !subtitlesShowing && force !== false) {
      let subTrack = tracks[0];
      const { options } = stateOwners;
      if (!(options == null ? void 0 : options.noSubtitlesLangPref)) {
        const subtitlesPref = globalThis.localStorage.getItem(
          "media-chrome-pref-subtitles-lang"
        );
        const userLangPrefs = subtitlesPref ? [subtitlesPref, ...globalThis.navigator.languages] : globalThis.navigator.languages;
        const preferredAvailableSubs = tracks.filter((textTrack) => {
          return userLangPrefs.some(
            (lang) => textTrack.language.toLowerCase().startsWith(lang.split("-")[0])
          );
        }).sort((textTrackA, textTrackB) => {
          const idxA = userLangPrefs.findIndex(
            (lang) => textTrackA.language.toLowerCase().startsWith(lang.split("-")[0])
          );
          const idxB = userLangPrefs.findIndex(
            (lang) => textTrackB.language.toLowerCase().startsWith(lang.split("-")[0])
          );
          return idxA - idxB;
        });
        if (preferredAvailableSubs[0]) {
          subTrack = preferredAvailableSubs[0];
        }
      }
      const { language, label, kind } = subTrack;
      updateTracksModeTo(TextTrackModes.DISABLED, tracks, showingSubitleTracks);
      updateTracksModeTo(TextTrackModes.SHOWING, tracks, [
        { language, label, kind }
      ]);
    }
  };
  var areValuesEq = (x, y) => {
    if (x === y)
      return true;
    if (typeof x !== typeof y)
      return false;
    if (typeof x === "number" && Number.isNaN(x) && Number.isNaN(y))
      return true;
    if (typeof x !== "object")
      return false;
    if (Array.isArray(x))
      return areArraysEq(x, y);
    return Object.entries(x).every(
      // NOTE: Checking key in y to disambiguate between between missing keys and keys whose value are undefined (CJP)
      ([key, value]) => key in y && areValuesEq(value, y[key])
    );
  };
  var areArraysEq = (xs, ys) => {
    const xIsArray = Array.isArray(xs);
    const yIsArray = Array.isArray(ys);
    if (xIsArray !== yIsArray)
      return false;
    if (!(xIsArray || yIsArray))
      return true;
    if (xs.length !== ys.length)
      return false;
    return xs.every((x, i) => areValuesEq(x, ys[i]));
  };

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-store/state-mediator.js
  var StreamTypeValues = Object.values(StreamTypes);
  var volumeSupported;
  var volumeSupportPromise = hasVolumeSupportAsync().then((supported) => {
    volumeSupported = supported;
    return volumeSupported;
  });
  var prepareStateOwners = async (...stateOwners) => {
    await Promise.all(
      stateOwners.filter((x) => x).map(async (stateOwner) => {
        if (!("localName" in stateOwner && stateOwner instanceof GlobalThis.HTMLElement)) {
          return;
        }
        const name = stateOwner.localName;
        if (!name.includes("-"))
          return;
        const classDef = GlobalThis.customElements.get(name);
        if (classDef && stateOwner instanceof classDef)
          return;
        await GlobalThis.customElements.whenDefined(name);
        GlobalThis.customElements.upgrade(stateOwner);
      })
    );
  };
  var stateMediator = {
    mediaPaused: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        return (_a3 = media == null ? void 0 : media.paused) != null ? _a3 : true;
      },
      set(value, stateOwners) {
        var _a3;
        const { media } = stateOwners;
        if (!media)
          return;
        if (value) {
          media.pause();
        } else {
          (_a3 = media.play()) == null ? void 0 : _a3.catch(() => {
          });
        }
      },
      mediaEvents: ["play", "playing", "pause", "emptied"]
    },
    mediaHasPlayed: {
      // We want to let the user know that the media started playing at any point (`media-has-played`).
      // Since these propagators are all called when boostrapping state, let's verify this is
      // a real playing event by checking that 1) there's media and 2) it isn't currently paused.
      get(stateOwners, event) {
        const { media } = stateOwners;
        if (!media)
          return false;
        if (!event)
          return !media.paused;
        return event.type === "playing";
      },
      mediaEvents: ["playing", "emptied"]
    },
    mediaEnded: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        return (_a3 = media == null ? void 0 : media.ended) != null ? _a3 : false;
      },
      mediaEvents: ["seeked", "ended", "emptied"]
    },
    mediaPlaybackRate: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        return (_a3 = media == null ? void 0 : media.playbackRate) != null ? _a3 : 1;
      },
      set(value, stateOwners) {
        const { media } = stateOwners;
        if (!media)
          return;
        if (!Number.isFinite(+value))
          return;
        media.playbackRate = +value;
      },
      mediaEvents: ["ratechange", "loadstart"]
    },
    mediaMuted: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        return (_a3 = media == null ? void 0 : media.muted) != null ? _a3 : false;
      },
      set(value, stateOwners) {
        const { media } = stateOwners;
        if (!media)
          return;
        media.muted = value;
      },
      mediaEvents: ["volumechange"]
    },
    mediaVolume: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        return (_a3 = media == null ? void 0 : media.volume) != null ? _a3 : 1;
      },
      set(value, stateOwners) {
        const { media } = stateOwners;
        if (!media)
          return;
        try {
          if (value == null) {
            GlobalThis.localStorage.removeItem("media-chrome-pref-volume");
          } else {
            GlobalThis.localStorage.setItem(
              "media-chrome-pref-volume",
              value.toString()
            );
          }
        } catch (err) {
        }
        if (!Number.isFinite(+value))
          return;
        media.volume = +value;
      },
      mediaEvents: ["volumechange"],
      stateOwnersUpdateHandlers: [
        (handler, stateOwners) => {
          const {
            options: { noVolumePref }
          } = stateOwners;
          if (noVolumePref)
            return;
          try {
            const volumePref = GlobalThis.localStorage.getItem(
              "media-chrome-pref-volume"
            );
            if (volumePref == null)
              return;
            stateMediator.mediaVolume.set(+volumePref, stateOwners);
            handler(+volumePref);
          } catch (e) {
            console.debug("Error getting volume pref", e);
          }
        }
      ]
    },
    // NOTE: Keeping this roughly equivalent to prior impl to reduce number of changes,
    // however we may want to model "derived" state differently from "primary" state
    // (in this case, derived === mediaVolumeLevel, primary === mediaMuted, mediaVolume) (CJP)
    mediaVolumeLevel: {
      get(stateOwners) {
        const { media } = stateOwners;
        if (typeof (media == null ? void 0 : media.volume) == "undefined")
          return "high";
        if (media.muted || media.volume === 0)
          return "off";
        if (media.volume < 0.5)
          return "low";
        if (media.volume < 0.75)
          return "medium";
        return "high";
      },
      mediaEvents: ["volumechange"]
    },
    mediaCurrentTime: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        return (_a3 = media == null ? void 0 : media.currentTime) != null ? _a3 : 0;
      },
      set(value, stateOwners) {
        const { media } = stateOwners;
        if (!media || media.readyState === 0)
          return;
        media.currentTime = value;
      },
      mediaEvents: ["timeupdate", "loadedmetadata"]
    },
    mediaDuration: {
      get(stateOwners) {
        const { media, options: { defaultDuration } = {} } = stateOwners;
        if (defaultDuration && (!media || !media.duration || Number.isNaN(media.duration) || !Number.isFinite(media.duration))) {
          return defaultDuration;
        }
        return Number.isFinite(media == null ? void 0 : media.duration) ? media.duration : Number.NaN;
      },
      mediaEvents: ["durationchange", "loadedmetadata", "emptied"]
    },
    mediaLoading: {
      get(stateOwners) {
        const { media } = stateOwners;
        return (media == null ? void 0 : media.readyState) < 3;
      },
      mediaEvents: ["waiting", "playing", "emptied"]
    },
    mediaSeekable: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        if (!((_a3 = media == null ? void 0 : media.seekable) == null ? void 0 : _a3.length))
          return void 0;
        const start = media.seekable.start(0);
        const end = media.seekable.end(media.seekable.length - 1);
        if (!start && !end)
          return void 0;
        return [Number(start.toFixed(3)), Number(end.toFixed(3))];
      },
      mediaEvents: ["loadedmetadata", "emptied", "progress", "seekablechange"]
    },
    mediaBuffered: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        const timeRanges = (_a3 = media == null ? void 0 : media.buffered) != null ? _a3 : [];
        return Array.from(timeRanges).map((_, i) => [
          Number(timeRanges.start(i).toFixed(3)),
          Number(timeRanges.end(i).toFixed(3))
        ]);
      },
      mediaEvents: ["progress", "emptied"]
    },
    mediaStreamType: {
      get(stateOwners) {
        const { media, options: { defaultStreamType } = {} } = stateOwners;
        const usedDefaultStreamType = [
          StreamTypes.LIVE,
          StreamTypes.ON_DEMAND
        ].includes(defaultStreamType) ? defaultStreamType : void 0;
        if (!media)
          return usedDefaultStreamType;
        const { streamType } = media;
        if (StreamTypeValues.includes(streamType)) {
          if (streamType === StreamTypes.UNKNOWN) {
            return usedDefaultStreamType;
          }
          return streamType;
        }
        const duration = media.duration;
        if (duration === Infinity) {
          return StreamTypes.LIVE;
        } else if (Number.isFinite(duration)) {
          return StreamTypes.ON_DEMAND;
        }
        return usedDefaultStreamType;
      },
      mediaEvents: [
        "emptied",
        "durationchange",
        "loadedmetadata",
        "streamtypechange"
      ]
    },
    mediaTargetLiveWindow: {
      get(stateOwners) {
        const { media } = stateOwners;
        if (!media)
          return Number.NaN;
        const { targetLiveWindow } = media;
        const streamType = stateMediator.mediaStreamType.get(stateOwners);
        if ((targetLiveWindow == null || Number.isNaN(targetLiveWindow)) && streamType === StreamTypes.LIVE) {
          return 0;
        }
        return targetLiveWindow;
      },
      mediaEvents: [
        "emptied",
        "durationchange",
        "loadedmetadata",
        "streamtypechange",
        "targetlivewindowchange"
      ]
    },
    mediaTimeIsLive: {
      get(stateOwners) {
        const {
          media,
          // Default to 10 seconds
          options: { liveEdgeOffset = 10 } = {}
        } = stateOwners;
        if (!media)
          return false;
        if (typeof media.liveEdgeStart === "number") {
          if (Number.isNaN(media.liveEdgeStart))
            return false;
          return media.currentTime >= media.liveEdgeStart;
        }
        const live = stateMediator.mediaStreamType.get(stateOwners) === StreamTypes.LIVE;
        if (!live)
          return false;
        const seekable = media.seekable;
        if (!seekable)
          return true;
        if (!seekable.length)
          return false;
        const liveEdgeStart = seekable.end(seekable.length - 1) - liveEdgeOffset;
        return media.currentTime >= liveEdgeStart;
      },
      mediaEvents: ["playing", "timeupdate", "progress", "waiting", "emptied"]
    },
    // Text Tracks modeling
    mediaSubtitlesList: {
      get(stateOwners) {
        return getSubtitleTracks(stateOwners).map(
          ({ kind, label, language }) => ({ kind, label, language })
        );
      },
      mediaEvents: ["loadstart"],
      textTracksEvents: ["addtrack", "removetrack"]
    },
    mediaSubtitlesShowing: {
      get(stateOwners) {
        return getShowingSubtitleTracks(stateOwners).map(
          ({ kind, label, language }) => ({ kind, label, language })
        );
      },
      mediaEvents: ["loadstart"],
      textTracksEvents: ["addtrack", "removetrack", "change"],
      stateOwnersUpdateHandlers: [
        (_handler, stateOwners) => {
          var _a3, _b2;
          const { media, options } = stateOwners;
          if (!media)
            return;
          const updateDefaultSubtitlesCallback = (event) => {
            var _a22;
            if (!options.defaultSubtitles)
              return;
            const nonSubsEvent = event && ![TextTrackKinds.CAPTIONS, TextTrackKinds.SUBTITLES].includes(
              // @ts-ignore
              (_a22 = event == null ? void 0 : event.track) == null ? void 0 : _a22.kind
            );
            if (nonSubsEvent)
              return;
            toggleSubtitleTracks(stateOwners, true);
          };
          (_a3 = media.textTracks) == null ? void 0 : _a3.addEventListener(
            "addtrack",
            updateDefaultSubtitlesCallback
          );
          (_b2 = media.textTracks) == null ? void 0 : _b2.addEventListener(
            "removetrack",
            updateDefaultSubtitlesCallback
          );
          updateDefaultSubtitlesCallback();
          return () => {
            var _a22, _b22;
            (_a22 = media.textTracks) == null ? void 0 : _a22.removeEventListener(
              "addtrack",
              updateDefaultSubtitlesCallback
            );
            (_b22 = media.textTracks) == null ? void 0 : _b22.removeEventListener(
              "removetrack",
              updateDefaultSubtitlesCallback
            );
          };
        }
      ]
    },
    mediaChaptersCues: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        if (!media)
          return [];
        const [chaptersTrack] = getTextTracksList(media, {
          kind: TextTrackKinds.CHAPTERS
        });
        return Array.from((_a3 = chaptersTrack == null ? void 0 : chaptersTrack.cues) != null ? _a3 : []).map(
          ({ text, startTime, endTime }) => ({
            text,
            startTime,
            endTime
          })
        );
      },
      mediaEvents: ["loadstart", "loadedmetadata"],
      textTracksEvents: ["addtrack", "removetrack", "change"],
      stateOwnersUpdateHandlers: [
        (handler, stateOwners) => {
          const { media } = stateOwners;
          if (!media)
            return;
          const chaptersTrack = media.querySelector(
            'track[kind="chapters"][default][src]'
          );
          chaptersTrack == null ? void 0 : chaptersTrack.addEventListener("load", handler);
          return () => {
            chaptersTrack == null ? void 0 : chaptersTrack.removeEventListener("load", handler);
          };
        }
      ]
    },
    // Modeling state tied to root node
    mediaIsPip: {
      get(stateOwners) {
        var _a3, _b2;
        const { media, documentElement } = stateOwners;
        if (!media || !documentElement)
          return false;
        if (!documentElement.pictureInPictureElement)
          return false;
        if (documentElement.pictureInPictureElement === media)
          return true;
        if (documentElement.pictureInPictureElement instanceof HTMLMediaElement) {
          if (!((_a3 = media.localName) == null ? void 0 : _a3.includes("-")))
            return false;
          return containsComposedNode(
            media,
            documentElement.pictureInPictureElement
          );
        }
        if (documentElement.pictureInPictureElement.localName.includes("-")) {
          let currentRoot = documentElement.pictureInPictureElement.shadowRoot;
          while (currentRoot == null ? void 0 : currentRoot.pictureInPictureElement) {
            if (currentRoot.pictureInPictureElement === media)
              return true;
            currentRoot = (_b2 = currentRoot.pictureInPictureElement) == null ? void 0 : _b2.shadowRoot;
          }
        }
        return false;
      },
      set(value, stateOwners) {
        const { media } = stateOwners;
        if (!media)
          return;
        if (value) {
          if (!Document2.pictureInPictureEnabled) {
            console.warn("MediaChrome: Picture-in-picture is not enabled");
            return;
          }
          if (!media.requestPictureInPicture) {
            console.warn(
              "MediaChrome: The current media does not support picture-in-picture"
            );
            return;
          }
          const warnNotReady = () => {
            console.warn(
              "MediaChrome: The media is not ready for picture-in-picture. It must have a readyState > 0."
            );
          };
          media.requestPictureInPicture().catch((err) => {
            if (err.code === 11) {
              if (!media.src) {
                console.warn(
                  "MediaChrome: The media is not ready for picture-in-picture. It must have a src set."
                );
                return;
              }
              if (media.readyState === 0 && media.preload === "none") {
                const cleanup = () => {
                  media.removeEventListener("loadedmetadata", tryPip);
                  media.preload = "none";
                };
                const tryPip = () => {
                  media.requestPictureInPicture().catch(warnNotReady);
                  cleanup();
                };
                media.addEventListener("loadedmetadata", tryPip);
                media.preload = "metadata";
                setTimeout(() => {
                  if (media.readyState === 0)
                    warnNotReady();
                  cleanup();
                }, 1e3);
              } else {
                throw err;
              }
            } else {
              throw err;
            }
          });
        } else if (Document2.pictureInPictureElement) {
          Document2.exitPictureInPicture();
        }
      },
      mediaEvents: ["enterpictureinpicture", "leavepictureinpicture"]
    },
    mediaRenditionList: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        return [...(_a3 = media == null ? void 0 : media.videoRenditions) != null ? _a3 : []].map((videoRendition) => ({
          ...videoRendition
        }));
      },
      mediaEvents: ["emptied", "loadstart"],
      videoRenditionsEvents: ["addrendition", "removerendition"]
    },
    /** @TODO Model this as a derived value? (CJP) */
    mediaRenditionSelected: {
      get(stateOwners) {
        var _a3, _b2, _c;
        const { media } = stateOwners;
        return (_c = (_b2 = media == null ? void 0 : media.videoRenditions) == null ? void 0 : _b2[(_a3 = media.videoRenditions) == null ? void 0 : _a3.selectedIndex]) == null ? void 0 : _c.id;
      },
      set(value, stateOwners) {
        const { media } = stateOwners;
        if (!(media == null ? void 0 : media.videoRenditions)) {
          console.warn(
            "MediaController: Rendition selection not supported by this media."
          );
          return;
        }
        const renditionId = value;
        const index = Array.prototype.findIndex.call(
          media.videoRenditions,
          (r) => r.id == renditionId
        );
        if (media.videoRenditions.selectedIndex != index) {
          media.videoRenditions.selectedIndex = index;
        }
      },
      mediaEvents: ["emptied"],
      videoRenditionsEvents: ["addrendition", "removerendition", "change"]
    },
    mediaAudioTrackList: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        return [...(_a3 = media == null ? void 0 : media.audioTracks) != null ? _a3 : []];
      },
      mediaEvents: ["emptied", "loadstart"],
      audioTracksEvents: ["addtrack", "removetrack"]
    },
    mediaAudioTrackEnabled: {
      get(stateOwners) {
        var _a3, _b2;
        const { media } = stateOwners;
        return (_b2 = [...(_a3 = media == null ? void 0 : media.audioTracks) != null ? _a3 : []].find(
          (audioTrack) => audioTrack.enabled
        )) == null ? void 0 : _b2.id;
      },
      set(value, stateOwners) {
        const { media } = stateOwners;
        if (!(media == null ? void 0 : media.audioTracks)) {
          console.warn(
            "MediaChrome: Audio track selection not supported by this media."
          );
          return;
        }
        const audioTrackId = value;
        for (const track of media.audioTracks) {
          track.enabled = audioTrackId == track.id;
        }
      },
      mediaEvents: ["emptied"],
      audioTracksEvents: ["addtrack", "removetrack", "change"]
    },
    mediaIsFullscreen: {
      get(stateOwners) {
        return isFullscreen(stateOwners);
      },
      set(value, stateOwners) {
        if (!value) {
          exitFullscreen(stateOwners);
        } else {
          enterFullscreen(stateOwners);
        }
      },
      // older Safari version may require webkit-specific events
      rootEvents: ["fullscreenchange", "webkitfullscreenchange"],
      // iOS requires webkit-specific events on the video.
      mediaEvents: ["webkitbeginfullscreen", "webkitendfullscreen", "webkitpresentationmodechanged"]
    },
    mediaIsCasting: {
      // Note this relies on a customized castable-video element.
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        if (!(media == null ? void 0 : media.remote) || ((_a3 = media.remote) == null ? void 0 : _a3.state) === "disconnected")
          return false;
        return !!media.remote.state;
      },
      set(value, stateOwners) {
        var _a3, _b2;
        const { media } = stateOwners;
        if (!media)
          return;
        if (value && ((_a3 = media.remote) == null ? void 0 : _a3.state) !== "disconnected")
          return;
        if (!value && ((_b2 = media.remote) == null ? void 0 : _b2.state) !== "connected")
          return;
        if (typeof media.remote.prompt !== "function") {
          console.warn(
            "MediaChrome: Casting is not supported in this environment"
          );
          return;
        }
        media.remote.prompt().catch(() => {
        });
      },
      remoteEvents: ["connect", "connecting", "disconnect"]
    },
    // NOTE: Newly added state for tracking airplaying
    mediaIsAirplaying: {
      // NOTE: Cannot know if airplaying since Safari doesn't fully support HTMLMediaElement::remote yet (e.g. remote::state) (CJP)
      get() {
        return false;
      },
      set(_value2, stateOwners) {
        const { media } = stateOwners;
        if (!media)
          return;
        if (!(media.webkitShowPlaybackTargetPicker && GlobalThis.WebKitPlaybackTargetAvailabilityEvent)) {
          console.warn(
            "MediaChrome: received a request to select AirPlay but AirPlay is not supported in this environment"
          );
          return;
        }
        media.webkitShowPlaybackTargetPicker();
      },
      mediaEvents: ["webkitcurrentplaybacktargetiswirelesschanged"]
    },
    mediaFullscreenUnavailable: {
      get(stateOwners) {
        const { media } = stateOwners;
        if (!fullscreenSupported || !hasFullscreenSupport(media))
          return AvailabilityStates.UNSUPPORTED;
        return void 0;
      }
    },
    mediaPipUnavailable: {
      get(stateOwners) {
        const { media } = stateOwners;
        if (!pipSupported || !hasPipSupport(media))
          return AvailabilityStates.UNSUPPORTED;
      }
    },
    mediaVolumeUnavailable: {
      get(stateOwners) {
        const { media } = stateOwners;
        if (volumeSupported === false || (media == null ? void 0 : media.volume) == void 0) {
          return AvailabilityStates.UNSUPPORTED;
        }
        return void 0;
      },
      // NOTE: Slightly different impl here. Added generic support for
      // "stateOwnersUpdateHandlers" since the original impl had to hack around
      // race conditions. (CJP)
      stateOwnersUpdateHandlers: [
        (handler) => {
          if (volumeSupported == null) {
            volumeSupportPromise.then(
              (supported) => handler(supported ? void 0 : AvailabilityStates.UNSUPPORTED)
            );
          }
        }
      ]
    },
    mediaCastUnavailable: {
      // @ts-ignore
      get(stateOwners, { availability = "not-available" } = {}) {
        var _a3;
        const { media } = stateOwners;
        if (!castSupported || !((_a3 = media == null ? void 0 : media.remote) == null ? void 0 : _a3.state)) {
          return AvailabilityStates.UNSUPPORTED;
        }
        if (availability == null || availability === "available")
          return void 0;
        return AvailabilityStates.UNAVAILABLE;
      },
      stateOwnersUpdateHandlers: [
        (handler, stateOwners) => {
          var _a3;
          const { media } = stateOwners;
          if (!media)
            return;
          const remotePlaybackDisabled = media.disableRemotePlayback || media.hasAttribute("disableremoteplayback");
          if (!remotePlaybackDisabled) {
            (_a3 = media == null ? void 0 : media.remote) == null ? void 0 : _a3.watchAvailability((availabilityBool) => {
              const availability = availabilityBool ? "available" : "not-available";
              handler({ availability });
            }).catch((error) => {
              if (error.name === "NotSupportedError") {
                handler({ availability: null });
              } else {
                handler({ availability: "not-available" });
              }
            });
          }
          return () => {
            var _a22;
            (_a22 = media == null ? void 0 : media.remote) == null ? void 0 : _a22.cancelWatchAvailability().catch(() => {
            });
          };
        }
      ]
    },
    mediaAirplayUnavailable: {
      get(_stateOwners, event) {
        if (!airplaySupported)
          return AvailabilityStates.UNSUPPORTED;
        if ((event == null ? void 0 : event.availability) === "not-available") {
          return AvailabilityStates.UNAVAILABLE;
        }
        return void 0;
      },
      // NOTE: Keeping this event, as it's still the documented way of monitoring
      // for AirPlay availability from Apple.
      // See: https://developer.apple.com/documentation/webkitjs/adding_an_airplay_button_to_your_safari_media_controls#2940021 (CJP)
      mediaEvents: ["webkitplaybacktargetavailabilitychanged"],
      stateOwnersUpdateHandlers: [
        (handler, stateOwners) => {
          var _a3;
          const { media } = stateOwners;
          if (!media)
            return;
          const remotePlaybackDisabled = media.disableRemotePlayback || media.hasAttribute("disableremoteplayback");
          if (!remotePlaybackDisabled) {
            (_a3 = media == null ? void 0 : media.remote) == null ? void 0 : _a3.watchAvailability((availabilityBool) => {
              const availability = availabilityBool ? "available" : "not-available";
              handler({ availability });
            }).catch((error) => {
              if (error.name === "NotSupportedError") {
                handler({ availability: null });
              } else {
                handler({ availability: "not-available" });
              }
            });
          }
          return () => {
            var _a22;
            (_a22 = media == null ? void 0 : media.remote) == null ? void 0 : _a22.cancelWatchAvailability().catch(() => {
            });
          };
        }
      ]
    },
    mediaRenditionUnavailable: {
      get(stateOwners) {
        var _a3;
        const { media } = stateOwners;
        if (!(media == null ? void 0 : media.videoRenditions)) {
          return AvailabilityStates.UNSUPPORTED;
        }
        if (!((_a3 = media.videoRenditions) == null ? void 0 : _a3.length)) {
          return AvailabilityStates.UNAVAILABLE;
        }
        return void 0;
      },
      mediaEvents: ["emptied", "loadstart"],
      videoRenditionsEvents: ["addrendition", "removerendition"]
    },
    mediaAudioTrackUnavailable: {
      get(stateOwners) {
        var _a3, _b2;
        const { media } = stateOwners;
        if (!(media == null ? void 0 : media.audioTracks)) {
          return AvailabilityStates.UNSUPPORTED;
        }
        if (((_b2 = (_a3 = media.audioTracks) == null ? void 0 : _a3.length) != null ? _b2 : 0) <= 1) {
          return AvailabilityStates.UNAVAILABLE;
        }
        return void 0;
      },
      mediaEvents: ["emptied", "loadstart"],
      audioTracksEvents: ["addtrack", "removetrack"]
    }
  };

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-store/request-map.js
  var requestMap = {
    /**
     * @TODO Consider adding state to `StateMediator` for e.g. `mediaThumbnailCues` and use that for derived state here (CJP)
     */
    [MediaUIEvents.MEDIA_PREVIEW_REQUEST](stateMediator2, stateOwners, { detail }) {
      var _a3, _b2, _c;
      const { media } = stateOwners;
      const mediaPreviewTime = detail != null ? detail : void 0;
      let mediaPreviewImage = void 0;
      let mediaPreviewCoords = void 0;
      if (media && mediaPreviewTime != null) {
        const [track] = getTextTracksList(media, {
          kind: TextTrackKinds.METADATA,
          label: "thumbnails"
        });
        const cue = Array.prototype.find.call((_a3 = track == null ? void 0 : track.cues) != null ? _a3 : [], (c, i, cs) => {
          if (i === 0)
            return c.endTime > mediaPreviewTime;
          if (i === cs.length - 1)
            return c.startTime <= mediaPreviewTime;
          return c.startTime <= mediaPreviewTime && c.endTime > mediaPreviewTime;
        });
        if (cue) {
          const base = !/'^(?:[a-z]+:)?\/\//i.test(cue.text) ? (_b2 = media == null ? void 0 : media.querySelector(
            'track[label="thumbnails"]'
          )) == null ? void 0 : _b2.src : void 0;
          const url = new URL(cue.text, base);
          const previewCoordsStr = new URLSearchParams(url.hash).get("#xywh");
          mediaPreviewCoords = previewCoordsStr.split(",").map((numStr) => +numStr);
          mediaPreviewImage = url.href;
        }
      }
      const mediaDuration = stateMediator2.mediaDuration.get(stateOwners);
      const mediaChaptersCues = stateMediator2.mediaChaptersCues.get(stateOwners);
      let mediaPreviewChapter = (_c = mediaChaptersCues.find((c, i, cs) => {
        if (i === cs.length - 1 && mediaDuration === c.endTime) {
          return c.startTime <= mediaPreviewTime && c.endTime >= mediaPreviewTime;
        }
        return c.startTime <= mediaPreviewTime && c.endTime > mediaPreviewTime;
      })) == null ? void 0 : _c.text;
      if (detail != null && mediaPreviewChapter == null) {
        mediaPreviewChapter = "";
      }
      return {
        mediaPreviewTime,
        mediaPreviewImage,
        mediaPreviewCoords,
        mediaPreviewChapter
      };
    },
    [MediaUIEvents.MEDIA_PAUSE_REQUEST](stateMediator2, stateOwners) {
      const key = "mediaPaused";
      const value = true;
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_PLAY_REQUEST](stateMediator2, stateOwners) {
      var _a3;
      const key = "mediaPaused";
      const value = false;
      const live = stateMediator2.mediaStreamType.get(stateOwners) === StreamTypes.LIVE;
      if (live) {
        const notDvr = !(stateMediator2.mediaTargetLiveWindow.get(stateOwners) > 0);
        const liveEdgeTime = (_a3 = stateMediator2.mediaSeekable.get(stateOwners)) == null ? void 0 : _a3[1];
        if (notDvr && liveEdgeTime) {
          stateMediator2.mediaCurrentTime.set(liveEdgeTime, stateOwners);
        }
      }
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_PLAYBACK_RATE_REQUEST](stateMediator2, stateOwners, { detail }) {
      const key = "mediaPlaybackRate";
      const value = detail;
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_MUTE_REQUEST](stateMediator2, stateOwners) {
      const key = "mediaMuted";
      const value = true;
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_UNMUTE_REQUEST](stateMediator2, stateOwners) {
      const key = "mediaMuted";
      const value = false;
      if (!stateMediator2.mediaVolume.get(stateOwners)) {
        stateMediator2.mediaVolume.set(0.25, stateOwners);
      }
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_VOLUME_REQUEST](stateMediator2, stateOwners, { detail }) {
      const key = "mediaVolume";
      const value = detail;
      if (value && stateMediator2.mediaMuted.get(stateOwners)) {
        stateMediator2.mediaMuted.set(false, stateOwners);
      }
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_SEEK_REQUEST](stateMediator2, stateOwners, { detail }) {
      const key = "mediaCurrentTime";
      const value = detail;
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_SEEK_TO_LIVE_REQUEST](stateMediator2, stateOwners) {
      var _a3;
      const key = "mediaCurrentTime";
      const value = (_a3 = stateMediator2.mediaSeekable.get(stateOwners)) == null ? void 0 : _a3[1];
      if (!Number.isNaN(Number(value)))
        return;
      stateMediator2[key].set(value, stateOwners);
    },
    // Text Tracks state change requests
    [MediaUIEvents.MEDIA_SHOW_SUBTITLES_REQUEST](_stateMediator, stateOwners, { detail }) {
      var _a3;
      const { options } = stateOwners;
      const tracks = getSubtitleTracks(stateOwners);
      const tracksToUpdate = parseTracks(detail);
      const preferredLanguage = (_a3 = tracksToUpdate[0]) == null ? void 0 : _a3.language;
      if (preferredLanguage && !options.noSubtitlesLangPref) {
        GlobalThis.localStorage.setItem(
          "media-chrome-pref-subtitles-lang",
          preferredLanguage
        );
      }
      updateTracksModeTo(TextTrackModes.SHOWING, tracks, tracksToUpdate);
    },
    [MediaUIEvents.MEDIA_DISABLE_SUBTITLES_REQUEST](_stateMediator, stateOwners, { detail }) {
      const tracks = getSubtitleTracks(stateOwners);
      const tracksToUpdate = detail != null ? detail : [];
      updateTracksModeTo(TextTrackModes.DISABLED, tracks, tracksToUpdate);
    },
    [MediaUIEvents.MEDIA_TOGGLE_SUBTITLES_REQUEST](_stateMediator, stateOwners, { detail }) {
      toggleSubtitleTracks(stateOwners, detail);
    },
    // Renditions/Tracks state change requests
    [MediaUIEvents.MEDIA_RENDITION_REQUEST](stateMediator2, stateOwners, { detail }) {
      const key = "mediaRenditionSelected";
      const value = detail;
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_AUDIO_TRACK_REQUEST](stateMediator2, stateOwners, { detail }) {
      const key = "mediaAudioTrackEnabled";
      const value = detail;
      stateMediator2[key].set(value, stateOwners);
    },
    // State change requests dependent on root node
    [MediaUIEvents.MEDIA_ENTER_PIP_REQUEST](stateMediator2, stateOwners) {
      const key = "mediaIsPip";
      const value = true;
      if (stateMediator2.mediaIsFullscreen.get(stateOwners)) {
        stateMediator2.mediaIsFullscreen.set(false, stateOwners);
      }
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_EXIT_PIP_REQUEST](stateMediator2, stateOwners) {
      const key = "mediaIsPip";
      const value = false;
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_ENTER_FULLSCREEN_REQUEST](stateMediator2, stateOwners) {
      const key = "mediaIsFullscreen";
      const value = true;
      if (stateMediator2.mediaIsPip.get(stateOwners)) {
        stateMediator2.mediaIsPip.set(false, stateOwners);
      }
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_EXIT_FULLSCREEN_REQUEST](stateMediator2, stateOwners) {
      const key = "mediaIsFullscreen";
      const value = false;
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_ENTER_CAST_REQUEST](stateMediator2, stateOwners) {
      const key = "mediaIsCasting";
      const value = true;
      if (stateMediator2.mediaIsFullscreen.get(stateOwners)) {
        stateMediator2.mediaIsFullscreen.set(false, stateOwners);
      }
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_EXIT_CAST_REQUEST](stateMediator2, stateOwners) {
      const key = "mediaIsCasting";
      const value = false;
      stateMediator2[key].set(value, stateOwners);
    },
    [MediaUIEvents.MEDIA_AIRPLAY_REQUEST](stateMediator2, stateOwners) {
      const key = "mediaIsAirplaying";
      const value = true;
      stateMediator2[key].set(value, stateOwners);
    }
  };

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-store/media-store.js
  var createMediaStore = ({
    media,
    fullscreenElement,
    documentElement,
    stateMediator: stateMediator2 = stateMediator,
    requestMap: requestMap2 = requestMap,
    options = {},
    monitorStateOwnersOnlyWithSubscriptions = true
  }) => {
    const callbacks = [];
    const stateOwners = {
      // Spreading options here since folks should not rely on holding onto references
      // for any app-level logic wrt options.
      options: { ...options }
    };
    let state = Object.freeze({
      mediaPreviewTime: void 0,
      mediaPreviewImage: void 0,
      mediaPreviewCoords: void 0,
      mediaPreviewChapter: void 0
    });
    const updateState = (nextStateDelta) => {
      if (nextStateDelta == void 0)
        return;
      if (areValuesEq(nextStateDelta, state)) {
        return;
      }
      state = Object.freeze({
        ...state,
        ...nextStateDelta
      });
      callbacks.forEach((cb) => cb(state));
    };
    const updateStateFromFacade = () => {
      const nextState = Object.entries(stateMediator2).reduce(
        (nextState2, [stateName, { get }]) => {
          nextState2[stateName] = get(stateOwners);
          return nextState2;
        },
        {}
      );
      updateState(nextState);
    };
    const stateUpdateHandlers = {};
    let nextStateOwners = void 0;
    const updateStateOwners = async (nextStateOwnersDelta, nextSubscriberCount) => {
      var _a3, _b2, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p;
      const pendingUpdate = !!nextStateOwners;
      nextStateOwners = {
        ...stateOwners,
        ...nextStateOwners != null ? nextStateOwners : {},
        ...nextStateOwnersDelta
      };
      if (pendingUpdate)
        return;
      await prepareStateOwners(...Object.values(nextStateOwnersDelta));
      const shouldTeardownFromSubscriberCount = callbacks.length > 0 && nextSubscriberCount === 0 && monitorStateOwnersOnlyWithSubscriptions;
      const mediaChanged = stateOwners.media !== nextStateOwners.media;
      const textTracksChanged = ((_a3 = stateOwners.media) == null ? void 0 : _a3.textTracks) !== ((_b2 = nextStateOwners.media) == null ? void 0 : _b2.textTracks);
      const videoRenditionsChanged = ((_c = stateOwners.media) == null ? void 0 : _c.videoRenditions) !== ((_d = nextStateOwners.media) == null ? void 0 : _d.videoRenditions);
      const audioTracksChanged = ((_e = stateOwners.media) == null ? void 0 : _e.audioTracks) !== ((_f = nextStateOwners.media) == null ? void 0 : _f.audioTracks);
      const remoteChanged = ((_g = stateOwners.media) == null ? void 0 : _g.remote) !== ((_h = nextStateOwners.media) == null ? void 0 : _h.remote);
      const rootNodeChanged = stateOwners.documentElement !== nextStateOwners.documentElement;
      const teardownMedia = !!stateOwners.media && (mediaChanged || shouldTeardownFromSubscriberCount);
      const teardownTextTracks = !!((_i = stateOwners.media) == null ? void 0 : _i.textTracks) && (textTracksChanged || shouldTeardownFromSubscriberCount);
      const teardownVideoRenditions = !!((_j = stateOwners.media) == null ? void 0 : _j.videoRenditions) && (videoRenditionsChanged || shouldTeardownFromSubscriberCount);
      const teardownAudioTracks = !!((_k = stateOwners.media) == null ? void 0 : _k.audioTracks) && (audioTracksChanged || shouldTeardownFromSubscriberCount);
      const teardownRemote = !!((_l = stateOwners.media) == null ? void 0 : _l.remote) && (remoteChanged || shouldTeardownFromSubscriberCount);
      const teardownRootNode = !!stateOwners.documentElement && (rootNodeChanged || shouldTeardownFromSubscriberCount);
      const teardownSomething = teardownMedia || teardownTextTracks || teardownVideoRenditions || teardownAudioTracks || teardownRemote || teardownRootNode;
      const shouldSetupFromSubscriberCount = callbacks.length === 0 && nextSubscriberCount === 1 && monitorStateOwnersOnlyWithSubscriptions;
      const setupMedia = !!nextStateOwners.media && (mediaChanged || shouldSetupFromSubscriberCount);
      const setupTextTracks = !!((_m = nextStateOwners.media) == null ? void 0 : _m.textTracks) && (textTracksChanged || shouldSetupFromSubscriberCount);
      const setupVideoRenditions = !!((_n = nextStateOwners.media) == null ? void 0 : _n.videoRenditions) && (videoRenditionsChanged || shouldSetupFromSubscriberCount);
      const setupAudioTracks = !!((_o = nextStateOwners.media) == null ? void 0 : _o.audioTracks) && (audioTracksChanged || shouldSetupFromSubscriberCount);
      const setupRemote = !!((_p = nextStateOwners.media) == null ? void 0 : _p.remote) && (remoteChanged || shouldSetupFromSubscriberCount);
      const setupRootNode = !!nextStateOwners.documentElement && (rootNodeChanged || shouldSetupFromSubscriberCount);
      const setupSomething = setupMedia || setupTextTracks || setupVideoRenditions || setupAudioTracks || setupRemote || setupRootNode;
      const somethingToDo = teardownSomething || setupSomething;
      if (!somethingToDo) {
        Object.entries(nextStateOwners).forEach(
          ([stateOwnerName, stateOwner]) => {
            stateOwners[stateOwnerName] = stateOwner;
          }
        );
        updateStateFromFacade();
        nextStateOwners = void 0;
        return;
      }
      Object.entries(stateMediator2).forEach(
        ([
          stateName,
          {
            get,
            mediaEvents = [],
            textTracksEvents = [],
            videoRenditionsEvents = [],
            audioTracksEvents = [],
            remoteEvents = [],
            rootEvents = [],
            stateOwnersUpdateHandlers = []
          }
        ]) => {
          if (!stateUpdateHandlers[stateName]) {
            stateUpdateHandlers[stateName] = {};
          }
          const handler = (event) => {
            const nextValue = get(stateOwners, event);
            updateState({ [stateName]: nextValue });
          };
          let prevHandler;
          prevHandler = stateUpdateHandlers[stateName].mediaEvents;
          mediaEvents.forEach((eventType) => {
            if (prevHandler && teardownMedia) {
              stateOwners.media.removeEventListener(eventType, prevHandler);
              stateUpdateHandlers[stateName].mediaEvents = void 0;
            }
            if (setupMedia) {
              nextStateOwners.media.addEventListener(eventType, handler);
              stateUpdateHandlers[stateName].mediaEvents = handler;
            }
          });
          prevHandler = stateUpdateHandlers[stateName].textTracksEvents;
          textTracksEvents.forEach((eventType) => {
            var _a22, _b22;
            if (prevHandler && teardownTextTracks) {
              (_a22 = stateOwners.media.textTracks) == null ? void 0 : _a22.removeEventListener(
                eventType,
                prevHandler
              );
              stateUpdateHandlers[stateName].textTracksEvents = void 0;
            }
            if (setupTextTracks) {
              (_b22 = nextStateOwners.media.textTracks) == null ? void 0 : _b22.addEventListener(
                eventType,
                handler
              );
              stateUpdateHandlers[stateName].textTracksEvents = handler;
            }
          });
          prevHandler = stateUpdateHandlers[stateName].videoRenditionsEvents;
          videoRenditionsEvents.forEach((eventType) => {
            var _a22, _b22;
            if (prevHandler && teardownVideoRenditions) {
              (_a22 = stateOwners.media.videoRenditions) == null ? void 0 : _a22.removeEventListener(
                eventType,
                prevHandler
              );
              stateUpdateHandlers[stateName].videoRenditionsEvents = void 0;
            }
            if (setupVideoRenditions) {
              (_b22 = nextStateOwners.media.videoRenditions) == null ? void 0 : _b22.addEventListener(
                eventType,
                handler
              );
              stateUpdateHandlers[stateName].videoRenditionsEvents = handler;
            }
          });
          prevHandler = stateUpdateHandlers[stateName].audioTracksEvents;
          audioTracksEvents.forEach((eventType) => {
            var _a22, _b22;
            if (prevHandler && teardownAudioTracks) {
              (_a22 = stateOwners.media.audioTracks) == null ? void 0 : _a22.removeEventListener(
                eventType,
                prevHandler
              );
              stateUpdateHandlers[stateName].audioTracksEvents = void 0;
            }
            if (setupAudioTracks) {
              (_b22 = nextStateOwners.media.audioTracks) == null ? void 0 : _b22.addEventListener(
                eventType,
                handler
              );
              stateUpdateHandlers[stateName].audioTracksEvents = handler;
            }
          });
          prevHandler = stateUpdateHandlers[stateName].remoteEvents;
          remoteEvents.forEach((eventType) => {
            var _a22, _b22;
            if (prevHandler && teardownRemote) {
              (_a22 = stateOwners.media.remote) == null ? void 0 : _a22.removeEventListener(
                eventType,
                prevHandler
              );
              stateUpdateHandlers[stateName].remoteEvents = void 0;
            }
            if (setupRemote) {
              (_b22 = nextStateOwners.media.remote) == null ? void 0 : _b22.addEventListener(eventType, handler);
              stateUpdateHandlers[stateName].remoteEvents = handler;
            }
          });
          prevHandler = stateUpdateHandlers[stateName].rootEvents;
          rootEvents.forEach((eventType) => {
            if (prevHandler && teardownRootNode) {
              stateOwners.documentElement.removeEventListener(
                eventType,
                prevHandler
              );
              stateUpdateHandlers[stateName].rootEvents = void 0;
            }
            if (setupRootNode) {
              nextStateOwners.documentElement.addEventListener(
                eventType,
                handler
              );
              stateUpdateHandlers[stateName].rootEvents = handler;
            }
          });
          const prevHandlerTeardown = stateUpdateHandlers[stateName].stateOwnersUpdateHandlers;
          stateOwnersUpdateHandlers.forEach((fn) => {
            if (prevHandlerTeardown && teardownSomething) {
              prevHandlerTeardown();
            }
            if (setupSomething) {
              stateUpdateHandlers[stateName].stateOwnersUpdateHandlers = fn(
                handler,
                nextStateOwners
              );
            }
          });
        }
      );
      Object.entries(nextStateOwners).forEach(([stateOwnerName, stateOwner]) => {
        stateOwners[stateOwnerName] = stateOwner;
      });
      updateStateFromFacade();
      nextStateOwners = void 0;
    };
    updateStateOwners({ media, fullscreenElement, documentElement, options });
    return {
      // note that none of these cases directly interact with the media element, root node, full screen element, etc.
      // note these "actions" could just be the events if we wanted, especially if we normalize on "detail" for
      // any payload-relevant values
      // This is roughly equivalent to our used to be in our state requests dictionary object, though much of the
      // "heavy lifting" is now moved into the facade `set()`
      dispatch(action) {
        const { type, detail } = action;
        if (requestMap2[type]) {
          updateState(requestMap2[type](stateMediator2, stateOwners, action));
          return;
        }
        if (type === "mediaelementchangerequest") {
          updateStateOwners({ media: detail });
        } else if (type === "fullscreenelementchangerequest") {
          updateStateOwners({ fullscreenElement: detail });
        } else if (type === "documentelementchangerequest") {
          updateStateOwners({ documentElement: detail });
        } else if (type === "optionschangerequest") {
          Object.entries(detail != null ? detail : {}).forEach(([optionName, optionValue]) => {
            stateOwners.options[optionName] = optionValue;
          });
        }
      },
      getState() {
        return state;
      },
      subscribe(callback) {
        updateStateOwners({}, callbacks.length + 1);
        callbacks.push(callback);
        callback(state);
        return () => {
          const idx = callbacks.indexOf(callback);
          if (idx >= 0) {
            updateStateOwners({}, callbacks.length - 1);
            callbacks.splice(idx, 1);
          }
        };
      }
    };
  };
  var media_store_default = createMediaStore;

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-controller.js
  var __accessCheck4 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet4 = (obj, member, getter) => {
    __accessCheck4(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd4 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet4 = (obj, member, value, setter) => {
    __accessCheck4(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateMethod2 = (obj, member, method) => {
    __accessCheck4(obj, member, "access private method");
    return method;
  };
  var _hotKeys;
  var _fullscreenElement;
  var _mediaStore;
  var _mediaStateCallback;
  var _mediaStoreUnsubscribe;
  var _mediaStateEventHandler;
  var _setupDefaultStore;
  var setupDefaultStore_fn;
  var _keyUpHandler;
  var keyUpHandler_fn;
  var _keyDownHandler;
  var keyDownHandler_fn;
  var ButtonPressedKeys = [
    "ArrowLeft",
    "ArrowRight",
    "Enter",
    " ",
    "f",
    "m",
    "k",
    "c"
  ];
  var DEFAULT_SEEK_OFFSET = 10;
  var Attributes2 = {
    DEFAULT_SUBTITLES: "defaultsubtitles",
    DEFAULT_STREAM_TYPE: "defaultstreamtype",
    DEFAULT_DURATION: "defaultduration",
    FULLSCREEN_ELEMENT: "fullscreenelement",
    HOTKEYS: "hotkeys",
    KEYS_USED: "keysused",
    LIVE_EDGE_OFFSET: "liveedgeoffset",
    NO_AUTO_SEEK_TO_LIVE: "noautoseektolive",
    NO_HOTKEYS: "nohotkeys",
    NO_VOLUME_PREF: "novolumepref",
    NO_SUBTITLES_LANG_PREF: "nosubtitleslangpref",
    NO_DEFAULT_STORE: "nodefaultstore",
    KEYBOARD_FORWARD_SEEK_OFFSET: "keyboardforwardseekoffset",
    KEYBOARD_BACKWARD_SEEK_OFFSET: "keyboardbackwardseekoffset"
  };
  var MediaController = class extends MediaContainer {
    constructor() {
      super();
      __privateAdd4(this, _setupDefaultStore);
      __privateAdd4(this, _keyUpHandler);
      __privateAdd4(this, _keyDownHandler);
      this.mediaStateReceivers = [];
      this.associatedElementSubscriptions = /* @__PURE__ */ new Map();
      __privateAdd4(this, _hotKeys, new AttributeTokenList(this, Attributes2.HOTKEYS));
      __privateAdd4(this, _fullscreenElement, void 0);
      __privateAdd4(this, _mediaStore, void 0);
      __privateAdd4(this, _mediaStateCallback, void 0);
      __privateAdd4(this, _mediaStoreUnsubscribe, void 0);
      __privateAdd4(this, _mediaStateEventHandler, (event) => {
        var _a3;
        (_a3 = __privateGet4(this, _mediaStore)) == null ? void 0 : _a3.dispatch(event);
      });
      this.associateElement(this);
      let prevState = {};
      __privateSet4(this, _mediaStateCallback, (nextState) => {
        Object.entries(nextState).forEach(([stateName, stateValue]) => {
          if (stateName in prevState && prevState[stateName] === stateValue)
            return;
          this.propagateMediaState(stateName, stateValue);
          const attrName = stateName.toLowerCase();
          const evt = new GlobalThis.CustomEvent(
            AttributeToStateChangeEventMap[attrName],
            { composed: true, detail: stateValue }
          );
          this.dispatchEvent(evt);
        });
        prevState = nextState;
      });
      this.enableHotkeys();
    }
    static get observedAttributes() {
      return super.observedAttributes.concat(
        Attributes2.NO_HOTKEYS,
        Attributes2.HOTKEYS,
        Attributes2.DEFAULT_STREAM_TYPE,
        Attributes2.DEFAULT_SUBTITLES,
        Attributes2.DEFAULT_DURATION
      );
    }
    get mediaStore() {
      return __privateGet4(this, _mediaStore);
    }
    set mediaStore(value) {
      var _a3, _b2;
      if (__privateGet4(this, _mediaStore)) {
        (_a3 = __privateGet4(this, _mediaStoreUnsubscribe)) == null ? void 0 : _a3.call(this);
        __privateSet4(this, _mediaStoreUnsubscribe, void 0);
      }
      __privateSet4(this, _mediaStore, value);
      if (!__privateGet4(this, _mediaStore) && !this.hasAttribute(Attributes2.NO_DEFAULT_STORE)) {
        __privateMethod2(this, _setupDefaultStore, setupDefaultStore_fn).call(this);
        return;
      }
      __privateSet4(this, _mediaStoreUnsubscribe, (_b2 = __privateGet4(this, _mediaStore)) == null ? void 0 : _b2.subscribe(
        __privateGet4(this, _mediaStateCallback)
      ));
    }
    get fullscreenElement() {
      var _a3;
      return (_a3 = __privateGet4(this, _fullscreenElement)) != null ? _a3 : this;
    }
    set fullscreenElement(element) {
      var _a3;
      if (this.hasAttribute(Attributes2.FULLSCREEN_ELEMENT)) {
        this.removeAttribute(Attributes2.FULLSCREEN_ELEMENT);
      }
      __privateSet4(this, _fullscreenElement, element);
      (_a3 = __privateGet4(this, _mediaStore)) == null ? void 0 : _a3.dispatch({
        type: "fullscreenelementchangerequest",
        detail: this.fullscreenElement
      });
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      var _a3, _b2, _c, _d, _e, _f;
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === Attributes2.NO_HOTKEYS) {
        if (newValue !== oldValue && newValue === "") {
          if (this.hasAttribute(Attributes2.HOTKEYS)) {
            console.warn(
              "Media Chrome: Both `hotkeys` and `nohotkeys` have been set. All hotkeys will be disabled."
            );
          }
          this.disableHotkeys();
        } else if (newValue !== oldValue && newValue === null) {
          this.enableHotkeys();
        }
      } else if (attrName === Attributes2.HOTKEYS) {
        __privateGet4(this, _hotKeys).value = newValue;
      } else if (attrName === Attributes2.DEFAULT_SUBTITLES && newValue !== oldValue) {
        (_a3 = __privateGet4(this, _mediaStore)) == null ? void 0 : _a3.dispatch({
          type: "optionschangerequest",
          detail: {
            defaultSubtitles: this.hasAttribute(Attributes2.DEFAULT_SUBTITLES)
          }
        });
      } else if (attrName === Attributes2.DEFAULT_STREAM_TYPE) {
        (_c = __privateGet4(this, _mediaStore)) == null ? void 0 : _c.dispatch({
          type: "optionschangerequest",
          detail: {
            defaultStreamType: (_b2 = this.getAttribute(Attributes2.DEFAULT_STREAM_TYPE)) != null ? _b2 : void 0
          }
        });
      } else if (attrName === Attributes2.LIVE_EDGE_OFFSET) {
        (_d = __privateGet4(this, _mediaStore)) == null ? void 0 : _d.dispatch({
          type: "optionschangerequest",
          detail: {
            liveEdgeOffset: this.hasAttribute(Attributes2.LIVE_EDGE_OFFSET) ? +this.getAttribute(Attributes2.LIVE_EDGE_OFFSET) : void 0
          }
        });
      } else if (attrName === Attributes2.FULLSCREEN_ELEMENT) {
        const el = newValue ? (_e = this.getRootNode()) == null ? void 0 : _e.getElementById(newValue) : void 0;
        __privateSet4(this, _fullscreenElement, el);
        (_f = __privateGet4(this, _mediaStore)) == null ? void 0 : _f.dispatch({
          type: "fullscreenelementchangerequest",
          detail: this.fullscreenElement
        });
      }
    }
    connectedCallback() {
      var _a3, _b2;
      if (!__privateGet4(this, _mediaStore) && !this.hasAttribute(Attributes2.NO_DEFAULT_STORE)) {
        __privateMethod2(this, _setupDefaultStore, setupDefaultStore_fn).call(this);
      }
      (_a3 = __privateGet4(this, _mediaStore)) == null ? void 0 : _a3.dispatch({
        type: "documentelementchangerequest",
        detail: Document2
      });
      super.connectedCallback();
      if (__privateGet4(this, _mediaStore) && !__privateGet4(this, _mediaStoreUnsubscribe)) {
        __privateSet4(this, _mediaStoreUnsubscribe, (_b2 = __privateGet4(this, _mediaStore)) == null ? void 0 : _b2.subscribe(
          __privateGet4(this, _mediaStateCallback)
        ));
      }
      this.enableHotkeys();
    }
    disconnectedCallback() {
      var _a3, _b2, _c, _d;
      (_a3 = super.disconnectedCallback) == null ? void 0 : _a3.call(this);
      if (__privateGet4(this, _mediaStore)) {
        (_b2 = __privateGet4(this, _mediaStore)) == null ? void 0 : _b2.dispatch({
          type: "documentelementchangerequest",
          detail: void 0
        });
        (_c = __privateGet4(this, _mediaStore)) == null ? void 0 : _c.dispatch({
          type: MediaUIEvents.MEDIA_TOGGLE_SUBTITLES_REQUEST,
          detail: false
        });
      }
      if (__privateGet4(this, _mediaStoreUnsubscribe)) {
        (_d = __privateGet4(this, _mediaStoreUnsubscribe)) == null ? void 0 : _d.call(this);
        __privateSet4(this, _mediaStoreUnsubscribe, void 0);
      }
    }
    /**
     * @override
     * @param {HTMLMediaElement} media
     */
    mediaSetCallback(media) {
      var _a3;
      super.mediaSetCallback(media);
      (_a3 = __privateGet4(this, _mediaStore)) == null ? void 0 : _a3.dispatch({
        type: "mediaelementchangerequest",
        detail: media
      });
      if (!media.hasAttribute("tabindex")) {
        media.tabIndex = -1;
      }
    }
    /**
     * @override
     * @param {HTMLMediaElement} media
     */
    mediaUnsetCallback(media) {
      var _a3;
      super.mediaUnsetCallback(media);
      (_a3 = __privateGet4(this, _mediaStore)) == null ? void 0 : _a3.dispatch({
        type: "mediaelementchangerequest",
        detail: void 0
      });
    }
    propagateMediaState(stateName, state) {
      propagateMediaState(this.mediaStateReceivers, stateName, state);
    }
    associateElement(element) {
      if (!element)
        return;
      const { associatedElementSubscriptions } = this;
      if (associatedElementSubscriptions.has(element))
        return;
      const registerMediaStateReceiver = this.registerMediaStateReceiver.bind(this);
      const unregisterMediaStateReceiver = this.unregisterMediaStateReceiver.bind(this);
      const unsubscribe = monitorForMediaStateReceivers(
        element,
        registerMediaStateReceiver,
        unregisterMediaStateReceiver
      );
      Object.values(MediaUIEvents).forEach((eventName) => {
        element.addEventListener(eventName, __privateGet4(this, _mediaStateEventHandler));
      });
      associatedElementSubscriptions.set(element, unsubscribe);
    }
    unassociateElement(element) {
      if (!element)
        return;
      const { associatedElementSubscriptions } = this;
      if (!associatedElementSubscriptions.has(element))
        return;
      const unsubscribe = associatedElementSubscriptions.get(element);
      unsubscribe();
      associatedElementSubscriptions.delete(element);
      Object.values(MediaUIEvents).forEach((eventName) => {
        element.removeEventListener(eventName, __privateGet4(this, _mediaStateEventHandler));
      });
    }
    registerMediaStateReceiver(el) {
      if (!el)
        return;
      const els = this.mediaStateReceivers;
      const index = els.indexOf(el);
      if (index > -1)
        return;
      els.push(el);
      if (__privateGet4(this, _mediaStore)) {
        Object.entries(__privateGet4(this, _mediaStore).getState()).forEach(
          ([stateName, stateValue]) => {
            propagateMediaState([el], stateName, stateValue);
          }
        );
      }
    }
    unregisterMediaStateReceiver(el) {
      const els = this.mediaStateReceivers;
      const index = els.indexOf(el);
      if (index < 0)
        return;
      els.splice(index, 1);
    }
    enableHotkeys() {
      this.addEventListener("keydown", __privateMethod2(this, _keyDownHandler, keyDownHandler_fn));
    }
    disableHotkeys() {
      this.removeEventListener("keydown", __privateMethod2(this, _keyDownHandler, keyDownHandler_fn));
      this.removeEventListener("keyup", __privateMethod2(this, _keyUpHandler, keyUpHandler_fn));
    }
    get hotkeys() {
      return __privateGet4(this, _hotKeys);
    }
    keyboardShortcutHandler(e) {
      var _a3, _b2, _c, _d, _e;
      const target = e.target;
      const keysUsed = ((_c = (_b2 = (_a3 = target.getAttribute(Attributes2.KEYS_USED)) == null ? void 0 : _a3.split(" ")) != null ? _b2 : target == null ? void 0 : target.keysUsed) != null ? _c : []).map((key) => key === "Space" ? " " : key).filter(Boolean);
      if (keysUsed.includes(e.key)) {
        return;
      }
      let eventName, detail, evt;
      if (__privateGet4(this, _hotKeys).contains(`no${e.key.toLowerCase()}`))
        return;
      if (e.key === " " && __privateGet4(this, _hotKeys).contains(`nospace`))
        return;
      switch (e.key) {
        case " ":
        case "k":
          eventName = __privateGet4(this, _mediaStore).getState().mediaPaused ? MediaUIEvents.MEDIA_PLAY_REQUEST : MediaUIEvents.MEDIA_PAUSE_REQUEST;
          this.dispatchEvent(
            new GlobalThis.CustomEvent(eventName, {
              composed: true,
              bubbles: true
            })
          );
          break;
        case "m":
          eventName = this.mediaStore.getState().mediaVolumeLevel === "off" ? MediaUIEvents.MEDIA_UNMUTE_REQUEST : MediaUIEvents.MEDIA_MUTE_REQUEST;
          this.dispatchEvent(
            new GlobalThis.CustomEvent(eventName, {
              composed: true,
              bubbles: true
            })
          );
          break;
        case "f":
          eventName = this.mediaStore.getState().mediaIsFullscreen ? MediaUIEvents.MEDIA_EXIT_FULLSCREEN_REQUEST : MediaUIEvents.MEDIA_ENTER_FULLSCREEN_REQUEST;
          this.dispatchEvent(
            new GlobalThis.CustomEvent(eventName, {
              composed: true,
              bubbles: true
            })
          );
          break;
        case "c":
          this.dispatchEvent(
            new GlobalThis.CustomEvent(
              MediaUIEvents.MEDIA_TOGGLE_SUBTITLES_REQUEST,
              { composed: true, bubbles: true }
            )
          );
          break;
        case "ArrowLeft": {
          const offsetValue = this.hasAttribute(
            Attributes2.KEYBOARD_BACKWARD_SEEK_OFFSET
          ) ? +this.getAttribute(Attributes2.KEYBOARD_BACKWARD_SEEK_OFFSET) : DEFAULT_SEEK_OFFSET;
          detail = Math.max(
            ((_d = this.mediaStore.getState().mediaCurrentTime) != null ? _d : 0) - offsetValue,
            0
          );
          evt = new GlobalThis.CustomEvent(MediaUIEvents.MEDIA_SEEK_REQUEST, {
            composed: true,
            bubbles: true,
            detail
          });
          this.dispatchEvent(evt);
          break;
        }
        case "ArrowRight": {
          const offsetValue = this.hasAttribute(
            Attributes2.KEYBOARD_FORWARD_SEEK_OFFSET
          ) ? +this.getAttribute(Attributes2.KEYBOARD_FORWARD_SEEK_OFFSET) : DEFAULT_SEEK_OFFSET;
          detail = Math.max(
            ((_e = this.mediaStore.getState().mediaCurrentTime) != null ? _e : 0) + offsetValue,
            0
          );
          evt = new GlobalThis.CustomEvent(MediaUIEvents.MEDIA_SEEK_REQUEST, {
            composed: true,
            bubbles: true,
            detail
          });
          this.dispatchEvent(evt);
          break;
        }
        default:
          break;
      }
    }
  };
  _hotKeys = /* @__PURE__ */ new WeakMap();
  _fullscreenElement = /* @__PURE__ */ new WeakMap();
  _mediaStore = /* @__PURE__ */ new WeakMap();
  _mediaStateCallback = /* @__PURE__ */ new WeakMap();
  _mediaStoreUnsubscribe = /* @__PURE__ */ new WeakMap();
  _mediaStateEventHandler = /* @__PURE__ */ new WeakMap();
  _setupDefaultStore = /* @__PURE__ */ new WeakSet();
  setupDefaultStore_fn = function() {
    var _a3;
    this.mediaStore = media_store_default({
      media: this.media,
      fullscreenElement: this.fullscreenElement,
      options: {
        defaultSubtitles: this.hasAttribute(Attributes2.DEFAULT_SUBTITLES),
        defaultDuration: this.hasAttribute(Attributes2.DEFAULT_DURATION) ? +this.getAttribute(Attributes2.DEFAULT_DURATION) : void 0,
        defaultStreamType: (
          /** @type {import('./media-store/state-mediator.js').StreamTypeValue} */
          (_a3 = this.getAttribute(
            Attributes2.DEFAULT_STREAM_TYPE
          )) != null ? _a3 : void 0
        ),
        liveEdgeOffset: this.hasAttribute(Attributes2.LIVE_EDGE_OFFSET) ? +this.getAttribute(Attributes2.LIVE_EDGE_OFFSET) : void 0,
        // NOTE: This wasn't updated if it was changed later. Should it be? (CJP)
        noVolumePref: this.hasAttribute(Attributes2.NO_VOLUME_PREF),
        noSubtitlesLangPref: this.hasAttribute(
          Attributes2.NO_SUBTITLES_LANG_PREF
        )
      }
    });
  };
  _keyUpHandler = /* @__PURE__ */ new WeakSet();
  keyUpHandler_fn = function(e) {
    const { key } = e;
    if (!ButtonPressedKeys.includes(key)) {
      this.removeEventListener("keyup", __privateMethod2(this, _keyUpHandler, keyUpHandler_fn));
      return;
    }
    this.keyboardShortcutHandler(e);
  };
  _keyDownHandler = /* @__PURE__ */ new WeakSet();
  keyDownHandler_fn = function(e) {
    const { metaKey, altKey, key } = e;
    if (metaKey || altKey || !ButtonPressedKeys.includes(key)) {
      this.removeEventListener("keyup", __privateMethod2(this, _keyUpHandler, keyUpHandler_fn));
      return;
    }
    if ([" ", "ArrowLeft", "ArrowRight"].includes(key) && !(__privateGet4(this, _hotKeys).contains(`no${key.toLowerCase()}`) || key === " " && __privateGet4(this, _hotKeys).contains("nospace"))) {
      e.preventDefault();
    }
    this.addEventListener("keyup", __privateMethod2(this, _keyUpHandler, keyUpHandler_fn), { once: true });
  };
  var MEDIA_UI_ATTRIBUTE_NAMES2 = Object.values(MediaUIAttributes);
  var MEDIA_UI_PROP_NAMES = Object.values(MediaUIProps);
  var getMediaUIAttributesFrom = (child) => {
    var _a3, _b2, _c, _d;
    let { observedAttributes } = child.constructor;
    if (!observedAttributes && ((_a3 = child.nodeName) == null ? void 0 : _a3.includes("-"))) {
      GlobalThis.customElements.upgrade(child);
      ({ observedAttributes } = child.constructor);
    }
    const mediaChromeAttributesList = (_d = (_c = (_b2 = child == null ? void 0 : child.getAttribute) == null ? void 0 : _b2.call(child, MediaStateReceiverAttributes.MEDIA_CHROME_ATTRIBUTES)) == null ? void 0 : _c.split) == null ? void 0 : _d.call(_c, /\s+/);
    if (!Array.isArray(observedAttributes || mediaChromeAttributesList))
      return [];
    return (observedAttributes || mediaChromeAttributesList).filter(
      (attrName) => MEDIA_UI_ATTRIBUTE_NAMES2.includes(attrName)
    );
  };
  var hasMediaUIProps = (mediaStateReceiverCandidate) => {
    var _a3, _b2;
    if (((_a3 = mediaStateReceiverCandidate.nodeName) == null ? void 0 : _a3.includes("-")) && !!GlobalThis.customElements.get(
      (_b2 = mediaStateReceiverCandidate.nodeName) == null ? void 0 : _b2.toLowerCase()
    ) && !(mediaStateReceiverCandidate instanceof GlobalThis.customElements.get(
      mediaStateReceiverCandidate.nodeName.toLowerCase()
    ))) {
      GlobalThis.customElements.upgrade(mediaStateReceiverCandidate);
    }
    return MEDIA_UI_PROP_NAMES.some(
      (propName) => propName in mediaStateReceiverCandidate
    );
  };
  var isMediaStateReceiver = (child) => {
    return hasMediaUIProps(child) || !!getMediaUIAttributesFrom(child).length;
  };
  var serializeTuple = (tuple) => {
    var _a3;
    return (_a3 = tuple == null ? void 0 : tuple.join) == null ? void 0 : _a3.call(tuple, ":");
  };
  var CustomAttrSerializer = {
    [MediaUIAttributes.MEDIA_SUBTITLES_LIST]: stringifyTextTrackList,
    [MediaUIAttributes.MEDIA_SUBTITLES_SHOWING]: stringifyTextTrackList,
    [MediaUIAttributes.MEDIA_SEEKABLE]: serializeTuple,
    [MediaUIAttributes.MEDIA_BUFFERED]: (tuples) => tuples == null ? void 0 : tuples.map(serializeTuple).join(" "),
    [MediaUIAttributes.MEDIA_PREVIEW_COORDS]: (coords) => coords == null ? void 0 : coords.join(" "),
    [MediaUIAttributes.MEDIA_RENDITION_LIST]: stringifyRenditionList,
    [MediaUIAttributes.MEDIA_AUDIO_TRACK_LIST]: stringifyAudioTrackList
  };
  var setAttr = async (child, attrName, attrValue) => {
    var _a3, _b2;
    if (!child.isConnected) {
      await delay(0);
    }
    if (typeof attrValue === "boolean" || attrValue == null) {
      return setBooleanAttr(child, attrName, attrValue);
    }
    if (typeof attrValue === "number") {
      return setNumericAttr(child, attrName, attrValue);
    }
    if (typeof attrValue === "string") {
      return setStringAttr(child, attrName, attrValue);
    }
    if (Array.isArray(attrValue) && !attrValue.length) {
      return child.removeAttribute(attrName);
    }
    const val = (_b2 = (_a3 = CustomAttrSerializer[attrName]) == null ? void 0 : _a3.call(CustomAttrSerializer, attrValue)) != null ? _b2 : attrValue;
    return child.setAttribute(attrName, val);
  };
  var isMediaSlotElementDescendant = (el) => {
    var _a3;
    return !!((_a3 = el.closest) == null ? void 0 : _a3.call(el, '*[slot="media"]'));
  };
  var traverseForMediaStateReceivers = (rootNode, mediaStateReceiverCallback) => {
    if (isMediaSlotElementDescendant(rootNode)) {
      return;
    }
    const traverseForMediaStateReceiversSync = (rootNode2, mediaStateReceiverCallback2) => {
      var _a3, _b2;
      if (isMediaStateReceiver(rootNode2)) {
        mediaStateReceiverCallback2(rootNode2);
      }
      const { children = [] } = rootNode2 != null ? rootNode2 : {};
      const shadowChildren = (_b2 = (_a3 = rootNode2 == null ? void 0 : rootNode2.shadowRoot) == null ? void 0 : _a3.children) != null ? _b2 : [];
      const allChildren = [...children, ...shadowChildren];
      allChildren.forEach(
        (child) => traverseForMediaStateReceivers(
          child,
          mediaStateReceiverCallback2
        )
      );
    };
    const name = rootNode == null ? void 0 : rootNode.nodeName.toLowerCase();
    if (name.includes("-") && !isMediaStateReceiver(rootNode)) {
      GlobalThis.customElements.whenDefined(name).then(() => {
        traverseForMediaStateReceiversSync(rootNode, mediaStateReceiverCallback);
      });
      return;
    }
    traverseForMediaStateReceiversSync(rootNode, mediaStateReceiverCallback);
  };
  var propagateMediaState = (els, stateName, val) => {
    els.forEach((el) => {
      if (stateName in el) {
        el[stateName] = val;
        return;
      }
      const relevantAttrs = getMediaUIAttributesFrom(el);
      const attrName = stateName.toLowerCase();
      if (!relevantAttrs.includes(attrName))
        return;
      setAttr(el, attrName, val);
    });
  };
  var monitorForMediaStateReceivers = (rootNode, registerMediaStateReceiver, unregisterMediaStateReceiver) => {
    traverseForMediaStateReceivers(rootNode, registerMediaStateReceiver);
    const registerMediaStateReceiverHandler = (evt) => {
      var _a3;
      const el = (_a3 = evt == null ? void 0 : evt.composedPath()[0]) != null ? _a3 : evt.target;
      registerMediaStateReceiver(el);
    };
    const unregisterMediaStateReceiverHandler = (evt) => {
      var _a3;
      const el = (_a3 = evt == null ? void 0 : evt.composedPath()[0]) != null ? _a3 : evt.target;
      unregisterMediaStateReceiver(el);
    };
    rootNode.addEventListener(
      MediaUIEvents.REGISTER_MEDIA_STATE_RECEIVER,
      registerMediaStateReceiverHandler
    );
    rootNode.addEventListener(
      MediaUIEvents.UNREGISTER_MEDIA_STATE_RECEIVER,
      unregisterMediaStateReceiverHandler
    );
    const mutationCallback = (mutationsList) => {
      mutationsList.forEach((mutationRecord) => {
        const {
          addedNodes = [],
          removedNodes = [],
          type,
          target,
          attributeName
        } = mutationRecord;
        if (type === "childList") {
          Array.prototype.forEach.call(
            addedNodes,
            (node) => traverseForMediaStateReceivers(
              node,
              registerMediaStateReceiver
            )
          );
          Array.prototype.forEach.call(
            removedNodes,
            (node) => traverseForMediaStateReceivers(
              node,
              unregisterMediaStateReceiver
            )
          );
        } else if (type === "attributes" && attributeName === MediaStateReceiverAttributes.MEDIA_CHROME_ATTRIBUTES) {
          if (isMediaStateReceiver(target)) {
            registerMediaStateReceiver(target);
          } else {
            unregisterMediaStateReceiver(target);
          }
        }
      });
    };
    let prevSlotted = [];
    const slotChangeHandler = (event) => {
      const slotEl = event.target;
      if (slotEl.name === "media")
        return;
      prevSlotted.forEach(
        (node) => traverseForMediaStateReceivers(node, unregisterMediaStateReceiver)
      );
      prevSlotted = [
        ...slotEl.assignedElements({ flatten: true })
      ];
      prevSlotted.forEach(
        (node) => traverseForMediaStateReceivers(node, registerMediaStateReceiver)
      );
    };
    rootNode.addEventListener("slotchange", slotChangeHandler);
    const observer2 = new MutationObserver(mutationCallback);
    observer2.observe(rootNode, {
      childList: true,
      attributes: true,
      subtree: true
    });
    const unsubscribe = () => {
      traverseForMediaStateReceivers(rootNode, unregisterMediaStateReceiver);
      rootNode.removeEventListener("slotchange", slotChangeHandler);
      observer2.disconnect();
      rootNode.removeEventListener(
        MediaUIEvents.REGISTER_MEDIA_STATE_RECEIVER,
        registerMediaStateReceiverHandler
      );
      rootNode.removeEventListener(
        MediaUIEvents.UNREGISTER_MEDIA_STATE_RECEIVER,
        unregisterMediaStateReceiverHandler
      );
    };
    return unsubscribe;
  };
  if (!GlobalThis.customElements.get("media-controller")) {
    GlobalThis.customElements.define("media-controller", MediaController);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-chrome-button.js
  var __accessCheck5 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet5 = (obj, member, getter) => {
    __accessCheck5(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd5 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet5 = (obj, member, value, setter) => {
    __accessCheck5(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _mediaController2;
  var _clickListener;
  var _keyupListener;
  var _keydownListener;
  var Attributes3 = {
    TOOLTIP_PLACEMENT: "tooltipplacement"
  };
  var template3 = Document2.createElement("template");
  template3.innerHTML = /*html*/
  `
<style>
  :host {
    position: relative;
    font: var(--media-font,
      var(--media-font-weight, bold)
      var(--media-font-size, 14px) /
      var(--media-text-content-height, var(--media-control-height, 24px))
      var(--media-font-family, helvetica neue, segoe ui, roboto, arial, sans-serif));
    color: var(--media-text-color, var(--media-primary-color, rgb(238 238 238)));
    background: var(--media-control-background, var(--media-secondary-color, rgb(20 20 30 / .7)));
    padding: var(--media-button-padding, var(--media-control-padding, 10px));
    justify-content: var(--media-button-justify-content, center);
    display: inline-flex;
    align-items: center;
    vertical-align: middle;
    box-sizing: border-box;
    transition: background .15s linear;
    pointer-events: auto;
    cursor: pointer;
    -webkit-tap-highlight-color: transparent;
  }

  ${/*
    Only show outline when keyboard focusing.
    https://drafts.csswg.org/selectors-4/#the-focus-visible-pseudo
  */
  ""}
  :host(:focus-visible) {
    box-shadow: inset 0 0 0 2px rgb(27 127 204 / .9);
    outline: 0;
  }
  ${/*
  * hide default focus ring, particularly when using mouse
  */
  ""}
  :host(:where(:focus)) {
    box-shadow: none;
    outline: 0;
  }

  :host(:hover) {
    background: var(--media-control-hover-background, rgba(50 50 70 / .7));
  }

  svg, img, ::slotted(svg), ::slotted(img) {
    width: var(--media-button-icon-width);
    height: var(--media-button-icon-height, var(--media-control-height, 24px));
    transform: var(--media-button-icon-transform);
    transition: var(--media-button-icon-transition);
    fill: var(--media-icon-color, var(--media-primary-color, rgb(238 238 238)));
    vertical-align: middle;
    max-width: 100%;
    max-height: 100%;
    min-width: 100%;
  }

  media-tooltip {
    opacity: 0;
    transition: opacity .3s;
  }

  :host(:hover) media-tooltip,
  :host(:focus-visible) media-tooltip {
    opacity: 1;
  }

  :host([notooltip]) slot[name="tooltip"] {
    display: none;
  }
</style>

<slot name="tooltip">
  <media-tooltip>
    <slot name="tooltip-content"></slot>
  </media-tooltip>
</slot>
`;
  var MediaChromeButton = class extends GlobalThis.HTMLElement {
    constructor(options = {}) {
      var _a3;
      super();
      __privateAdd5(this, _mediaController2, void 0);
      this.preventClick = false;
      this.tooltipEl = null;
      this.tooltipContent = "";
      __privateAdd5(this, _clickListener, (e) => {
        if (!this.preventClick) {
          this.handleClick(e);
        }
        setTimeout(this.tooltipEl.updateXOffset, 0);
      });
      __privateAdd5(this, _keyupListener, (e) => {
        const { key } = e;
        if (!this.keysUsed.includes(key)) {
          this.removeEventListener("keyup", __privateGet5(this, _keyupListener));
          return;
        }
        if (!this.preventClick) {
          this.handleClick(e);
        }
      });
      __privateAdd5(this, _keydownListener, (e) => {
        const { metaKey, altKey, key } = e;
        if (metaKey || altKey || !this.keysUsed.includes(key)) {
          this.removeEventListener("keyup", __privateGet5(this, _keyupListener));
          return;
        }
        this.addEventListener("keyup", __privateGet5(this, _keyupListener), { once: true });
      });
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        const buttonHTML = template3.content.cloneNode(true);
        this.nativeEl = buttonHTML;
        let slotTemplate17 = options.slotTemplate;
        if (!slotTemplate17) {
          slotTemplate17 = Document2.createElement("template");
          slotTemplate17.innerHTML = `<slot>${options.defaultContent || ""}</slot>`;
        }
        if (options.tooltipContent) {
          buttonHTML.querySelector('slot[name="tooltip-content"]').innerHTML = (_a3 = options.tooltipContent) != null ? _a3 : "";
          this.tooltipContent = options.tooltipContent;
        }
        this.nativeEl.appendChild(slotTemplate17.content.cloneNode(true));
        this.shadowRoot.appendChild(buttonHTML);
        this.tooltipEl = this.shadowRoot.querySelector("media-tooltip");
      }
    }
    static get observedAttributes() {
      return [
        "disabled",
        Attributes3.TOOLTIP_PLACEMENT,
        MediaStateReceiverAttributes.MEDIA_CONTROLLER
      ];
    }
    enable() {
      this.addEventListener("click", __privateGet5(this, _clickListener));
      this.addEventListener("keydown", __privateGet5(this, _keydownListener));
      this.tabIndex = 0;
    }
    disable() {
      this.removeEventListener("click", __privateGet5(this, _clickListener));
      this.removeEventListener("keydown", __privateGet5(this, _keydownListener));
      this.removeEventListener("keyup", __privateGet5(this, _keyupListener));
      this.tabIndex = -1;
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      var _a3, _b2, _c, _d, _e, _f, _g;
      if (attrName === MediaStateReceiverAttributes.MEDIA_CONTROLLER) {
        if (oldValue) {
          (_b2 = (_a3 = __privateGet5(this, _mediaController2)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
          __privateSet5(this, _mediaController2, null);
        }
        if (newValue && this.isConnected) {
          __privateSet5(this, _mediaController2, (_c = this.getRootNode()) == null ? void 0 : _c.getElementById(newValue));
          (_e = (_d = __privateGet5(this, _mediaController2)) == null ? void 0 : _d.associateElement) == null ? void 0 : _e.call(_d, this);
        }
      } else if (attrName === "disabled" && newValue !== oldValue) {
        if (newValue == null) {
          this.enable();
        } else {
          this.disable();
        }
      } else if (attrName === Attributes3.TOOLTIP_PLACEMENT && this.tooltipEl && newValue !== oldValue) {
        this.tooltipEl.placement = newValue;
      }
      if (this.tooltipEl) {
        (_g = (_f = this.tooltipEl) == null ? void 0 : _f.updateXOffset) == null ? void 0 : _g.call(_f);
      }
    }
    connectedCallback() {
      var _a3, _b2, _c;
      const { style } = getOrInsertCSSRule(this.shadowRoot, ":host");
      style.setProperty(
        "display",
        `var(--media-control-display, var(--${this.localName}-display, inline-flex))`
      );
      if (!this.hasAttribute("disabled")) {
        this.enable();
      }
      this.setAttribute("role", "button");
      const mediaControllerId = this.getAttribute(
        MediaStateReceiverAttributes.MEDIA_CONTROLLER
      );
      if (mediaControllerId) {
        __privateSet5(
          this,
          _mediaController2,
          // @ts-ignore
          (_a3 = this.getRootNode()) == null ? void 0 : _a3.getElementById(mediaControllerId)
        );
        (_c = (_b2 = __privateGet5(this, _mediaController2)) == null ? void 0 : _b2.associateElement) == null ? void 0 : _c.call(_b2, this);
      }
      GlobalThis.customElements.whenDefined("media-tooltip").then(this.setupTooltip.bind(this));
    }
    disconnectedCallback() {
      var _a3, _b2, _c, _d;
      this.disable();
      (_b2 = (_a3 = __privateGet5(this, _mediaController2)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
      __privateSet5(this, _mediaController2, null);
      this.removeEventListener("mouseenter", (_c = this.tooltipEl) == null ? void 0 : _c.updateXOffset);
      this.removeEventListener("focus", (_d = this.tooltipEl) == null ? void 0 : _d.updateXOffset);
      this.removeEventListener("click", __privateGet5(this, _clickListener));
      this.tooltipEl = null;
    }
    get keysUsed() {
      return ["Enter", " "];
    }
    /**
     * Get or set tooltip placement
     */
    get tooltipPlacement() {
      return getStringAttr(this, Attributes3.TOOLTIP_PLACEMENT);
    }
    set tooltipPlacement(value) {
      setStringAttr(this, Attributes3.TOOLTIP_PLACEMENT, value);
    }
    /**
     * @abstract
     * @argument {Event} e
     */
    handleClick(e) {
    }
    // eslint-disable-line
    // Called when we know the tooltip is ready / defined
    setupTooltip() {
      this.addEventListener("mouseenter", this.tooltipEl.updateXOffset);
      this.addEventListener("focus", this.tooltipEl.updateXOffset);
      this.addEventListener("click", __privateGet5(this, _clickListener));
      const initialPlacement = this.tooltipPlacement;
      if (initialPlacement)
        this.tooltipEl.placement = initialPlacement;
    }
  };
  _mediaController2 = /* @__PURE__ */ new WeakMap();
  _clickListener = /* @__PURE__ */ new WeakMap();
  _keyupListener = /* @__PURE__ */ new WeakMap();
  _keydownListener = /* @__PURE__ */ new WeakMap();
  if (!GlobalThis.customElements.get("media-chrome-button")) {
    GlobalThis.customElements.define("media-chrome-button", MediaChromeButton);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-airplay-button.js
  var airplayIcon = `<svg aria-hidden="true" viewBox="0 0 26 24">
  <path d="M22.13 3H3.87a.87.87 0 0 0-.87.87v13.26a.87.87 0 0 0 .87.87h3.4L9 16H5V5h16v11h-4l1.72 2h3.4a.87.87 0 0 0 .87-.87V3.87a.87.87 0 0 0-.86-.87Zm-8.75 11.44a.5.5 0 0 0-.76 0l-4.91 5.73a.5.5 0 0 0 .38.83h9.82a.501.501 0 0 0 .38-.83l-4.91-5.73Z"/>
</svg>
`;
  var slotTemplate = Document2.createElement("template");
  slotTemplate.innerHTML = /*html*/
  `
  <style>
    :host([${MediaUIAttributes.MEDIA_IS_AIRPLAYING}]) slot[name=icon] slot:not([name=exit]) {
      display: none !important;
    }

    ${/* Double negative, but safer if display doesn't equal 'block' */
  ""}
    :host(:not([${MediaUIAttributes.MEDIA_IS_AIRPLAYING}])) slot[name=icon] slot:not([name=enter]) {
      display: none !important;
    }

    :host([${MediaUIAttributes.MEDIA_IS_AIRPLAYING}]) slot[name=tooltip-enter],
    :host(:not([${MediaUIAttributes.MEDIA_IS_AIRPLAYING}])) slot[name=tooltip-exit] {
      display: none;
    }
  </style>

  <slot name="icon">
    <slot name="enter">${airplayIcon}</slot>
    <slot name="exit">${airplayIcon}</slot>
  </slot>
`;
  var tooltipContent = (
    /*html*/
    `
  <slot name="tooltip-enter">${tooltipLabels.ENTER_AIRPLAY}</slot>
  <slot name="tooltip-exit">${tooltipLabels.EXIT_AIRPLAY}</slot>
`
  );
  var updateAriaLabel = (el) => {
    const label = el.mediaIsAirplaying ? verbs.EXIT_AIRPLAY() : verbs.ENTER_AIRPLAY();
    el.setAttribute("aria-label", label);
  };
  var MediaAirplayButton = class extends MediaChromeButton {
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_IS_AIRPLAYING,
        MediaUIAttributes.MEDIA_AIRPLAY_UNAVAILABLE
      ];
    }
    constructor(options = {}) {
      super({ slotTemplate, tooltipContent, ...options });
    }
    connectedCallback() {
      super.connectedCallback();
      updateAriaLabel(this);
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_IS_AIRPLAYING) {
        updateAriaLabel(this);
      }
    }
    /**
     * Are we currently airplaying
     */
    get mediaIsAirplaying() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_IS_AIRPLAYING);
    }
    set mediaIsAirplaying(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_IS_AIRPLAYING, value);
    }
    /**
     * Airplay unavailability state
     */
    get mediaAirplayUnavailable() {
      return getStringAttr(this, MediaUIAttributes.MEDIA_AIRPLAY_UNAVAILABLE);
    }
    set mediaAirplayUnavailable(value) {
      setStringAttr(this, MediaUIAttributes.MEDIA_AIRPLAY_UNAVAILABLE, value);
    }
    handleClick() {
      const evt = new GlobalThis.CustomEvent(
        MediaUIEvents.MEDIA_AIRPLAY_REQUEST,
        {
          composed: true,
          bubbles: true
        }
      );
      this.dispatchEvent(evt);
    }
  };
  if (!GlobalThis.customElements.get("media-airplay-button")) {
    GlobalThis.customElements.define("media-airplay-button", MediaAirplayButton);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-captions-button.js
  var ccIconOn = `<svg aria-hidden="true" viewBox="0 0 26 24">
  <path d="M22.83 5.68a2.58 2.58 0 0 0-2.3-2.5c-3.62-.24-11.44-.24-15.06 0a2.58 2.58 0 0 0-2.3 2.5c-.23 4.21-.23 8.43 0 12.64a2.58 2.58 0 0 0 2.3 2.5c3.62.24 11.44.24 15.06 0a2.58 2.58 0 0 0 2.3-2.5c.23-4.21.23-8.43 0-12.64Zm-11.39 9.45a3.07 3.07 0 0 1-1.91.57 3.06 3.06 0 0 1-2.34-1 3.75 3.75 0 0 1-.92-2.67 3.92 3.92 0 0 1 .92-2.77 3.18 3.18 0 0 1 2.43-1 2.94 2.94 0 0 1 2.13.78c.364.359.62.813.74 1.31l-1.43.35a1.49 1.49 0 0 0-1.51-1.17 1.61 1.61 0 0 0-1.29.58 2.79 2.79 0 0 0-.5 1.89 3 3 0 0 0 .49 1.93 1.61 1.61 0 0 0 1.27.58 1.48 1.48 0 0 0 1-.37 2.1 2.1 0 0 0 .59-1.14l1.4.44a3.23 3.23 0 0 1-1.07 1.69Zm7.22 0a3.07 3.07 0 0 1-1.91.57 3.06 3.06 0 0 1-2.34-1 3.75 3.75 0 0 1-.92-2.67 3.88 3.88 0 0 1 .93-2.77 3.14 3.14 0 0 1 2.42-1 3 3 0 0 1 2.16.82 2.8 2.8 0 0 1 .73 1.31l-1.43.35a1.49 1.49 0 0 0-1.51-1.21 1.61 1.61 0 0 0-1.29.58A2.79 2.79 0 0 0 15 12a3 3 0 0 0 .49 1.93 1.61 1.61 0 0 0 1.27.58 1.44 1.44 0 0 0 1-.37 2.1 2.1 0 0 0 .6-1.15l1.4.44a3.17 3.17 0 0 1-1.1 1.7Z"/>
</svg>`;
  var ccIconOff = `<svg aria-hidden="true" viewBox="0 0 26 24">
  <path d="M17.73 14.09a1.4 1.4 0 0 1-1 .37 1.579 1.579 0 0 1-1.27-.58A3 3 0 0 1 15 12a2.8 2.8 0 0 1 .5-1.85 1.63 1.63 0 0 1 1.29-.57 1.47 1.47 0 0 1 1.51 1.2l1.43-.34A2.89 2.89 0 0 0 19 9.07a3 3 0 0 0-2.14-.78 3.14 3.14 0 0 0-2.42 1 3.91 3.91 0 0 0-.93 2.78 3.74 3.74 0 0 0 .92 2.66 3.07 3.07 0 0 0 2.34 1 3.07 3.07 0 0 0 1.91-.57 3.17 3.17 0 0 0 1.07-1.74l-1.4-.45c-.083.43-.3.822-.62 1.12Zm-7.22 0a1.43 1.43 0 0 1-1 .37 1.58 1.58 0 0 1-1.27-.58A3 3 0 0 1 7.76 12a2.8 2.8 0 0 1 .5-1.85 1.63 1.63 0 0 1 1.29-.57 1.47 1.47 0 0 1 1.51 1.2l1.43-.34a2.81 2.81 0 0 0-.74-1.32 2.94 2.94 0 0 0-2.13-.78 3.18 3.18 0 0 0-2.43 1 4 4 0 0 0-.92 2.78 3.74 3.74 0 0 0 .92 2.66 3.07 3.07 0 0 0 2.34 1 3.07 3.07 0 0 0 1.91-.57 3.23 3.23 0 0 0 1.07-1.74l-1.4-.45a2.06 2.06 0 0 1-.6 1.07Zm12.32-8.41a2.59 2.59 0 0 0-2.3-2.51C18.72 3.05 15.86 3 13 3c-2.86 0-5.72.05-7.53.17a2.59 2.59 0 0 0-2.3 2.51c-.23 4.207-.23 8.423 0 12.63a2.57 2.57 0 0 0 2.3 2.5c1.81.13 4.67.19 7.53.19 2.86 0 5.72-.06 7.53-.19a2.57 2.57 0 0 0 2.3-2.5c.23-4.207.23-8.423 0-12.63Zm-1.49 12.53a1.11 1.11 0 0 1-.91 1.11c-1.67.11-4.45.18-7.43.18-2.98 0-5.76-.07-7.43-.18a1.11 1.11 0 0 1-.91-1.11c-.21-4.14-.21-8.29 0-12.43a1.11 1.11 0 0 1 .91-1.11C7.24 4.56 10 4.49 13 4.49s5.76.07 7.43.18a1.11 1.11 0 0 1 .91 1.11c.21 4.14.21 8.29 0 12.43Z"/>
</svg>`;
  var slotTemplate2 = Document2.createElement("template");
  slotTemplate2.innerHTML = /*html*/
  `
  <style>
    :host([aria-checked="true"]) slot[name=off] {
      display: none !important;
    }

    ${/* Double negative, but safer if display doesn't equal 'block' */
  ""}
    :host(:not([aria-checked="true"])) slot[name=on] {
      display: none !important;
    }

    :host([aria-checked="true"]) slot[name=tooltip-enable],
    :host(:not([aria-checked="true"])) slot[name=tooltip-disable] {
      display: none;
    }
  </style>

  <slot name="icon">
    <slot name="on">${ccIconOn}</slot>
    <slot name="off">${ccIconOff}</slot>
  </slot>
`;
  var tooltipContent2 = (
    /*html*/
    `
  <slot name="tooltip-enable">${tooltipLabels.ENABLE_CAPTIONS}</slot>
  <slot name="tooltip-disable">${tooltipLabels.DISABLE_CAPTIONS}</slot>
`
  );
  var updateAriaChecked = (el) => {
    el.setAttribute("aria-checked", areSubsOn(el).toString());
  };
  var MediaCaptionsButton = class extends MediaChromeButton {
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_SUBTITLES_LIST,
        MediaUIAttributes.MEDIA_SUBTITLES_SHOWING
      ];
    }
    constructor(options = {}) {
      super({ slotTemplate: slotTemplate2, tooltipContent: tooltipContent2, ...options });
      this._captionsReady = false;
    }
    connectedCallback() {
      super.connectedCallback();
      this.setAttribute("role", "switch");
      this.setAttribute("aria-label", nouns.CLOSED_CAPTIONS());
      updateAriaChecked(this);
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_SUBTITLES_SHOWING) {
        updateAriaChecked(this);
      }
    }
    /**
     * An array of TextTrack-like objects.
     * Objects must have the properties: kind, language, and label.
     */
    get mediaSubtitlesList() {
      return getSubtitlesListAttr(this, MediaUIAttributes.MEDIA_SUBTITLES_LIST);
    }
    set mediaSubtitlesList(list) {
      setSubtitlesListAttr(this, MediaUIAttributes.MEDIA_SUBTITLES_LIST, list);
    }
    /**
     * An array of TextTrack-like objects.
     * Objects must have the properties: kind, language, and label.
     */
    get mediaSubtitlesShowing() {
      return getSubtitlesListAttr(
        this,
        MediaUIAttributes.MEDIA_SUBTITLES_SHOWING
      );
    }
    set mediaSubtitlesShowing(list) {
      setSubtitlesListAttr(this, MediaUIAttributes.MEDIA_SUBTITLES_SHOWING, list);
    }
    handleClick() {
      this.dispatchEvent(
        new GlobalThis.CustomEvent(MediaUIEvents.MEDIA_TOGGLE_SUBTITLES_REQUEST, {
          composed: true,
          bubbles: true
        })
      );
    }
  };
  var getSubtitlesListAttr = (el, attrName) => {
    const attrVal = el.getAttribute(attrName);
    return attrVal ? parseTextTracksStr(attrVal) : [];
  };
  var setSubtitlesListAttr = (el, attrName, list) => {
    if (!(list == null ? void 0 : list.length)) {
      el.removeAttribute(attrName);
      return;
    }
    const newValStr = stringifyTextTrackList(list);
    const oldVal = el.getAttribute(attrName);
    if (oldVal === newValStr)
      return;
    el.setAttribute(attrName, newValStr);
  };
  if (!GlobalThis.customElements.get("media-captions-button")) {
    GlobalThis.customElements.define(
      "media-captions-button",
      MediaCaptionsButton
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-cast-button.js
  var enterIcon = `<svg aria-hidden="true" viewBox="0 0 24 24"><g><path class="cast_caf_icon_arch0" d="M1,18 L1,21 L4,21 C4,19.3 2.66,18 1,18 L1,18 Z"/><path class="cast_caf_icon_arch1" d="M1,14 L1,16 C3.76,16 6,18.2 6,21 L8,21 C8,17.13 4.87,14 1,14 L1,14 Z"/><path class="cast_caf_icon_arch2" d="M1,10 L1,12 C5.97,12 10,16.0 10,21 L12,21 C12,14.92 7.07,10 1,10 L1,10 Z"/><path class="cast_caf_icon_box" d="M21,3 L3,3 C1.9,3 1,3.9 1,5 L1,8 L3,8 L3,5 L21,5 L21,19 L14,19 L14,21 L21,21 C22.1,21 23,20.1 23,19 L23,5 C23,3.9 22.1,3 21,3 L21,3 Z"/></g></svg>`;
  var exitIcon = `<svg aria-hidden="true" viewBox="0 0 24 24"><g><path class="cast_caf_icon_arch0" d="M1,18 L1,21 L4,21 C4,19.3 2.66,18 1,18 L1,18 Z"/><path class="cast_caf_icon_arch1" d="M1,14 L1,16 C3.76,16 6,18.2 6,21 L8,21 C8,17.13 4.87,14 1,14 L1,14 Z"/><path class="cast_caf_icon_arch2" d="M1,10 L1,12 C5.97,12 10,16.0 10,21 L12,21 C12,14.92 7.07,10 1,10 L1,10 Z"/><path class="cast_caf_icon_box" d="M21,3 L3,3 C1.9,3 1,3.9 1,5 L1,8 L3,8 L3,5 L21,5 L21,19 L14,19 L14,21 L21,21 C22.1,21 23,20.1 23,19 L23,5 C23,3.9 22.1,3 21,3 L21,3 Z"/><path class="cast_caf_icon_boxfill" d="M5,7 L5,8.63 C8,8.6 13.37,14 13.37,17 L19,17 L19,7 Z"/></g></svg>`;
  var slotTemplate3 = Document2.createElement("template");
  slotTemplate3.innerHTML = /*html*/
  `
  <style>
  :host([${MediaUIAttributes.MEDIA_IS_CASTING}]) slot[name=icon] slot:not([name=exit]) {
    display: none !important;
  }

  ${/* Double negative, but safer if display doesn't equal 'block' */
  ""}
  :host(:not([${MediaUIAttributes.MEDIA_IS_CASTING}])) slot[name=icon] slot:not([name=enter]) {
    display: none !important;
  }

  :host([${MediaUIAttributes.MEDIA_IS_CASTING}]) slot[name=tooltip-enter],
    :host(:not([${MediaUIAttributes.MEDIA_IS_CASTING}])) slot[name=tooltip-exit] {
      display: none;
    }
  </style>

  <slot name="icon">
    <slot name="enter">${enterIcon}</slot>
    <slot name="exit">${exitIcon}</slot>
  </slot>
`;
  var tooltipContent3 = (
    /*html*/
    `
  <slot name="tooltip-enter">${tooltipLabels.START_CAST}</slot>
  <slot name="tooltip-exit">${tooltipLabels.STOP_CAST}</slot>
`
  );
  var updateAriaLabel2 = (el) => {
    const label = el.mediaIsCasting ? verbs.EXIT_CAST() : verbs.ENTER_CAST();
    el.setAttribute("aria-label", label);
  };
  var MediaCastButton = class extends MediaChromeButton {
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_IS_CASTING,
        MediaUIAttributes.MEDIA_CAST_UNAVAILABLE
      ];
    }
    constructor(options = {}) {
      super({ slotTemplate: slotTemplate3, tooltipContent: tooltipContent3, ...options });
    }
    connectedCallback() {
      super.connectedCallback();
      updateAriaLabel2(this);
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_IS_CASTING) {
        updateAriaLabel2(this);
      }
    }
    /**
     * @type {boolean} Are we currently casting
     */
    get mediaIsCasting() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_IS_CASTING);
    }
    set mediaIsCasting(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_IS_CASTING, value);
    }
    /**
     * @type {string | undefined} Cast unavailability state
     */
    get mediaCastUnavailable() {
      return getStringAttr(this, MediaUIAttributes.MEDIA_CAST_UNAVAILABLE);
    }
    set mediaCastUnavailable(value) {
      setStringAttr(this, MediaUIAttributes.MEDIA_CAST_UNAVAILABLE, value);
    }
    handleClick() {
      const eventName = this.mediaIsCasting ? MediaUIEvents.MEDIA_EXIT_CAST_REQUEST : MediaUIEvents.MEDIA_ENTER_CAST_REQUEST;
      this.dispatchEvent(
        new GlobalThis.CustomEvent(eventName, { composed: true, bubbles: true })
      );
    }
  };
  if (!GlobalThis.customElements.get("media-cast-button")) {
    GlobalThis.customElements.define("media-cast-button", MediaCastButton);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-chrome-dialog.js
  var __accessCheck6 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet6 = (obj, member, getter) => {
    __accessCheck6(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd6 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet6 = (obj, member, value, setter) => {
    __accessCheck6(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateMethod3 = (obj, member, method) => {
    __accessCheck6(obj, member, "access private method");
    return method;
  };
  var _previouslyFocused;
  var _invokerElement;
  var _handleOpen;
  var handleOpen_fn;
  var _handleClosed;
  var handleClosed_fn;
  var _handleInvoke;
  var handleInvoke_fn;
  var _handleFocusOut;
  var handleFocusOut_fn;
  var _handleKeyDown;
  var handleKeyDown_fn;
  var template4 = Document2.createElement("template");
  template4.innerHTML = /*html*/
  `
  <style>
    :host {
      font: var(--media-font,
        var(--media-font-weight, normal)
        var(--media-font-size, 14px) /
        var(--media-text-content-height, var(--media-control-height, 24px))
        var(--media-font-family, helvetica neue, segoe ui, roboto, arial, sans-serif));
      color: var(--media-text-color, var(--media-primary-color, rgb(238 238 238)));
      background: var(--media-dialog-background, var(--media-control-background, var(--media-secondary-color, rgb(20 20 30 / .8))));
      border-radius: var(--media-dialog-border-radius);
      border: var(--media-dialog-border, none);
      display: var(--media-dialog-display, inline-flex);
      transition: var(--media-dialog-transition-in,
        visibility 0s,
        opacity .2s ease-out,
        transform .15s ease-out
      ) !important;
      ${/* ^^Prevent transition override by media-container */
  ""}
      visibility: var(--media-dialog-visibility, visible);
      opacity: var(--media-dialog-opacity, 1);
      transform: var(--media-dialog-transform-in, translateY(0) scale(1));
    }

    :host([hidden]) {
      transition: var(--media-dialog-transition-out,
        visibility .15s ease-in,
        opacity .15s ease-in,
        transform .15s ease-in
      ) !important;
      visibility: var(--media-dialog-hidden-visibility, hidden);
      opacity: var(--media-dialog-hidden-opacity, 0);
      transform: var(--media-dialog-transform-out, translateY(2px) scale(.99));
      pointer-events: none;
    }
  </style>
  <slot></slot>
`;
  var Attributes4 = {
    HIDDEN: "hidden",
    ANCHOR: "anchor"
  };
  var MediaChromeDialog = class extends GlobalThis.HTMLElement {
    constructor() {
      super();
      __privateAdd6(this, _handleOpen);
      __privateAdd6(this, _handleClosed);
      __privateAdd6(this, _handleInvoke);
      __privateAdd6(this, _handleFocusOut);
      __privateAdd6(this, _handleKeyDown);
      __privateAdd6(this, _previouslyFocused, null);
      __privateAdd6(this, _invokerElement, null);
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        this.nativeEl = this.constructor.template.content.cloneNode(true);
        this.shadowRoot.append(this.nativeEl);
      }
      this.addEventListener("invoke", this);
      this.addEventListener("focusout", this);
      this.addEventListener("keydown", this);
    }
    static get observedAttributes() {
      return [Attributes4.HIDDEN, Attributes4.ANCHOR];
    }
    handleEvent(event) {
      switch (event.type) {
        case "invoke":
          __privateMethod3(this, _handleInvoke, handleInvoke_fn).call(this, event);
          break;
        case "focusout":
          __privateMethod3(this, _handleFocusOut, handleFocusOut_fn).call(this, event);
          break;
        case "keydown":
          __privateMethod3(this, _handleKeyDown, handleKeyDown_fn).call(this, event);
          break;
      }
    }
    connectedCallback() {
      if (!this.role) {
        this.role = "dialog";
      }
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      if (attrName === Attributes4.HIDDEN && newValue !== oldValue) {
        if (this.hidden) {
          __privateMethod3(this, _handleClosed, handleClosed_fn).call(this);
        } else {
          __privateMethod3(this, _handleOpen, handleOpen_fn).call(this);
        }
      }
    }
    focus() {
      __privateSet6(this, _previouslyFocused, getActiveElement());
      const focusable = this.querySelector(
        '[autofocus], [tabindex]:not([tabindex="-1"]), [role="menu"]'
      );
      focusable == null ? void 0 : focusable.focus();
    }
    get keysUsed() {
      return ["Escape", "Tab"];
    }
  };
  _previouslyFocused = /* @__PURE__ */ new WeakMap();
  _invokerElement = /* @__PURE__ */ new WeakMap();
  _handleOpen = /* @__PURE__ */ new WeakSet();
  handleOpen_fn = function() {
    var _a3;
    (_a3 = __privateGet6(this, _invokerElement)) == null ? void 0 : _a3.setAttribute("aria-expanded", "true");
    this.addEventListener("transitionend", () => this.focus(), { once: true });
  };
  _handleClosed = /* @__PURE__ */ new WeakSet();
  handleClosed_fn = function() {
    var _a3;
    (_a3 = __privateGet6(this, _invokerElement)) == null ? void 0 : _a3.setAttribute("aria-expanded", "false");
  };
  _handleInvoke = /* @__PURE__ */ new WeakSet();
  handleInvoke_fn = function(event) {
    __privateSet6(this, _invokerElement, event.relatedTarget);
    if (!containsComposedNode(this, event.relatedTarget)) {
      this.hidden = !this.hidden;
    }
  };
  _handleFocusOut = /* @__PURE__ */ new WeakSet();
  handleFocusOut_fn = function(event) {
    var _a3;
    if (!containsComposedNode(this, event.relatedTarget)) {
      (_a3 = __privateGet6(this, _previouslyFocused)) == null ? void 0 : _a3.focus();
      if (__privateGet6(this, _invokerElement) && __privateGet6(this, _invokerElement) !== event.relatedTarget && !this.hidden) {
        this.hidden = true;
      }
    }
  };
  _handleKeyDown = /* @__PURE__ */ new WeakSet();
  handleKeyDown_fn = function(event) {
    var _a3, _b2, _c, _d, _e;
    const { key, ctrlKey, altKey, metaKey } = event;
    if (ctrlKey || altKey || metaKey) {
      return;
    }
    if (!this.keysUsed.includes(key)) {
      return;
    }
    event.preventDefault();
    event.stopPropagation();
    if (key === "Tab") {
      if (event.shiftKey) {
        (_b2 = (_a3 = this.previousElementSibling) == null ? void 0 : _a3.focus) == null ? void 0 : _b2.call(_a3);
      } else {
        (_d = (_c = this.nextElementSibling) == null ? void 0 : _c.focus) == null ? void 0 : _d.call(_c);
      }
      this.blur();
    } else if (key === "Escape") {
      (_e = __privateGet6(this, _previouslyFocused)) == null ? void 0 : _e.focus();
      this.hidden = true;
    }
  };
  MediaChromeDialog.template = template4;
  if (!GlobalThis.customElements.get("media-chrome-dialog")) {
    GlobalThis.customElements.define("media-chrome-dialog", MediaChromeDialog);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-chrome-range.js
  var __accessCheck7 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet7 = (obj, member, getter) => {
    __accessCheck7(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd7 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet7 = (obj, member, value, setter) => {
    __accessCheck7(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateMethod4 = (obj, member, method) => {
    __accessCheck7(obj, member, "access private method");
    return method;
  };
  var _mediaController3;
  var _isInputTarget;
  var _startpoint;
  var _endpoint;
  var _cssRules;
  var _segments;
  var _onFocusIn;
  var _onFocusOut;
  var _updateComputedStyles;
  var _updateActiveSegment;
  var updateActiveSegment_fn;
  var _enableUserEvents;
  var enableUserEvents_fn;
  var _disableUserEvents;
  var disableUserEvents_fn;
  var _handlePointerDown;
  var handlePointerDown_fn;
  var _handlePointerEnter;
  var handlePointerEnter_fn;
  var _handlePointerUp2;
  var handlePointerUp_fn2;
  var _handlePointerLeave;
  var handlePointerLeave_fn;
  var _handlePointerMove2;
  var handlePointerMove_fn2;
  var template5 = Document2.createElement("template");
  template5.innerHTML = /*html*/
  `
  <style>
    :host {
      --_focus-box-shadow: var(--media-focus-box-shadow, inset 0 0 0 2px rgb(27 127 204 / .9));
      --_media-range-padding: var(--media-range-padding, var(--media-control-padding, 10px));

      box-shadow: var(--_focus-visible-box-shadow, none);
      background: var(--media-control-background, var(--media-secondary-color, rgb(20 20 30 / .7)));
      height: calc(var(--media-control-height, 24px) + 2 * var(--_media-range-padding));
      display: inline-flex;
      align-items: center;
      ${/* Don't horizontal align w/ justify-content! #container can go negative on the x-axis w/ small width. */
  ""}
      vertical-align: middle;
      box-sizing: border-box;
      position: relative;
      width: 100px;
      transition: background .15s linear;
      cursor: pointer;
      pointer-events: auto;
      touch-action: none; ${/* Prevent scrolling when dragging on mobile. */
  ""}
      z-index: 1; ${/* Apply z-index to overlap buttons below. */
  ""}
    }

    ${/* Reset before `outline` on track could be set by a CSS var */
  ""}
    input[type=range]:focus {
      outline: 0;
    }
    input[type=range]:focus::-webkit-slider-runnable-track {
      outline: 0;
    }

    :host(:hover) {
      background: var(--media-control-hover-background, rgb(50 50 70 / .7));
    }

    #leftgap {
      padding-left: var(--media-range-padding-left, var(--_media-range-padding));
    }

    #rightgap {
      padding-right: var(--media-range-padding-right, var(--_media-range-padding));
    }

    #startpoint,
    #endpoint {
      position: absolute;
    }

    #endpoint {
      right: 0;
    }

    #container {
      ${/* Not using the CSS `padding` prop makes it easier for slide open volume ranges so the width can be zero. */
  ""}
      width: var(--media-range-track-width, 100%);
      transform: translate(var(--media-range-track-translate-x, 0px), var(--media-range-track-translate-y, 0px));
      position: relative;
      height: 100%;
      display: flex;
      align-items: center;
      min-width: 40px;
    }

    #range {
      ${/* The input range acts as a hover and hit zone for input events. */
  ""}
      display: var(--media-time-range-hover-display, block);
      bottom: var(--media-time-range-hover-bottom, -7px);
      height: var(--media-time-range-hover-height, max(100% + 7px, 25px));
      width: 100%;
      position: absolute;
      cursor: pointer;

      -webkit-appearance: none; ${/* Hides the slider so that custom slider can be made */
  ""}
      -webkit-tap-highlight-color: transparent;
      background: transparent; ${/* Otherwise white in Chrome */
  ""}
      margin: 0;
      z-index: 1;
    }

    @media (hover: hover) {
      #range {
        bottom: var(--media-time-range-hover-bottom, -5px);
        height: var(--media-time-range-hover-height, max(100% + 5px, 20px));
      }
    }

    ${/* Special styling for WebKit/Blink */
  ""}
    ${/* Make thumb width/height small so it has no effect on range click position. */
  ""}
    #range::-webkit-slider-thumb {
      -webkit-appearance: none;
      background: transparent;
      width: .1px;
      height: .1px;
    }

    ${/* The thumb is not positioned relative to the track in Firefox */
  ""}
    #range::-moz-range-thumb {
      background: transparent;
      border: transparent;
      width: .1px;
      height: .1px;
    }

    #appearance {
      height: var(--media-range-track-height, 4px);
      display: flex;
      flex-direction: column;
      justify-content: center;
      width: 100%;
      position: absolute;
      ${/* Required for Safari to stop glitching track height on hover */
  ""}
      will-change: transform;
    }

    #background,
    #track {
      border-radius: var(--media-range-track-border-radius, 1px);
      position: absolute;
      width: 100%;
      height: 100%;
    }

    #background {
      background: var(--media-range-track-background, rgb(255 255 255 / .2));
      backdrop-filter: var(--media-range-track-background-backdrop-filter);
      -webkit-backdrop-filter: var(--media-range-track-background-backdrop-filter);
    }

    #track {
      border: var(--media-range-track-border, none);
      outline: var(--media-range-track-outline);
      outline-offset: var(--media-range-track-outline-offset);
      backdrop-filter: var(--media-range-track-backdrop-filter);
      -webkit-backdrop-filter: var(--media-range-track-backdrop-filter);
      box-shadow: var(--media-range-track-box-shadow, none);
      overflow: hidden;
    }

    #progress,
    #highlight,
    #pointer {
      position: absolute;
      height: 100%;
      will-change: width;
    }

    #progress {
      background: var(--media-range-bar-color, var(--media-primary-color, rgb(238 238 238)));
      transition: var(--media-range-track-transition);
    }

    #pointer {
      background: var(--media-range-track-pointer-background);
      border-right: var(--media-range-track-pointer-border-right);
      transition: visibility .25s, opacity .25s;
      visibility: hidden;
      opacity: 0;
    }

    @media (hover: hover) {
      :host(:hover) #pointer {
        transition: visibility .5s, opacity .5s;
        visibility: visible;
        opacity: 1;
      }
    }

    #thumb {
      width: var(--media-range-thumb-width, 10px);
      height: var(--media-range-thumb-height, 10px);
      margin-left: calc(var(--media-range-thumb-width, 10px) / -2);
      border: var(--media-range-thumb-border, none);
      border-radius: var(--media-range-thumb-border-radius, 10px);
      background: var(--media-range-thumb-background, var(--media-primary-color, rgb(238 238 238)));
      box-shadow: var(--media-range-thumb-box-shadow, 1px 1px 1px transparent);
      transition: var(--media-range-thumb-transition);
      transform: var(--media-range-thumb-transform, none);
      opacity: var(--media-range-thumb-opacity, 1);
      position: absolute;
      left: 0;
      cursor: pointer;
    }

    :host([disabled]) #thumb {
      background-color: #777;
    }

    .segments #appearance {
      height: var(--media-range-segment-hover-height, 7px);
    }

    #background,
    #track {
      clip-path: url(#segments-clipping);
    }

    #segments {
      --segments-gap: var(--media-range-segments-gap, 2px);
      position: absolute;
      width: 100%;
      height: 100%;
    }

    #segments-clipping {
      transform: translateX(calc(var(--segments-gap) / 2));
    }

    #segments-clipping:empty {
      display: none;
    }

    #segments-clipping rect {
      height: var(--media-range-track-height, 4px);
      y: calc((var(--media-range-segment-hover-height, 7px) - var(--media-range-track-height, 4px)) / 2);
      transition: var(--media-range-segment-transition, transform .1s ease-in-out);
      transform: var(--media-range-segment-transform, scaleY(1));
      transform-origin: center;
    }
  </style>
  <div id="leftgap"></div>
  <div id="container">
    <div id="startpoint"></div>
    <div id="endpoint"></div>
    <div id="appearance" part="appearance">
      <div id="background"></div>
      <div id="track">
        <div id="highlight"></div>
        <div id="pointer"></div>
        <div id="progress"></div>
      </div>
      <div id="thumb"></div>
      <svg id="segments"><clipPath id="segments-clipping"></clipPath></svg>
    </div>
    <input id="range" type="range" min="0" max="1" step="any" value="0">
  </div>
  <div id="rightgap"></div>
`;
  var MediaChromeRange = class extends GlobalThis.HTMLElement {
    constructor() {
      super();
      __privateAdd7(this, _updateActiveSegment);
      __privateAdd7(this, _enableUserEvents);
      __privateAdd7(this, _disableUserEvents);
      __privateAdd7(this, _handlePointerDown);
      __privateAdd7(this, _handlePointerEnter);
      __privateAdd7(this, _handlePointerUp2);
      __privateAdd7(this, _handlePointerLeave);
      __privateAdd7(this, _handlePointerMove2);
      __privateAdd7(this, _mediaController3, void 0);
      __privateAdd7(this, _isInputTarget, void 0);
      __privateAdd7(this, _startpoint, void 0);
      __privateAdd7(this, _endpoint, void 0);
      __privateAdd7(this, _cssRules, {});
      __privateAdd7(this, _segments, []);
      __privateAdd7(this, _onFocusIn, () => {
        if (this.range.matches(":focus-visible")) {
          const { style } = getOrInsertCSSRule(this.shadowRoot, ":host");
          style.setProperty(
            "--_focus-visible-box-shadow",
            "var(--_focus-box-shadow)"
          );
        }
      });
      __privateAdd7(this, _onFocusOut, () => {
        const { style } = getOrInsertCSSRule(this.shadowRoot, ":host");
        style.removeProperty("--_focus-visible-box-shadow");
      });
      __privateAdd7(this, _updateComputedStyles, () => {
        const clipping = this.shadowRoot.querySelector("#segments-clipping");
        if (clipping)
          clipping.parentNode.append(clipping);
      });
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        this.shadowRoot.appendChild(template5.content.cloneNode(true));
      }
      this.container = this.shadowRoot.querySelector("#container");
      __privateSet7(this, _startpoint, this.shadowRoot.querySelector("#startpoint"));
      __privateSet7(this, _endpoint, this.shadowRoot.querySelector("#endpoint"));
      this.range = this.shadowRoot.querySelector("#range");
      this.appearance = this.shadowRoot.querySelector("#appearance");
    }
    static get observedAttributes() {
      return [
        "disabled",
        "aria-disabled",
        MediaStateReceiverAttributes.MEDIA_CONTROLLER
      ];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      var _a3, _b2, _c, _d, _e;
      if (attrName === MediaStateReceiverAttributes.MEDIA_CONTROLLER) {
        if (oldValue) {
          (_b2 = (_a3 = __privateGet7(this, _mediaController3)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
          __privateSet7(this, _mediaController3, null);
        }
        if (newValue && this.isConnected) {
          __privateSet7(this, _mediaController3, (_c = this.getRootNode()) == null ? void 0 : _c.getElementById(newValue));
          (_e = (_d = __privateGet7(this, _mediaController3)) == null ? void 0 : _d.associateElement) == null ? void 0 : _e.call(_d, this);
        }
      } else if (attrName === "disabled" || attrName === "aria-disabled" && oldValue !== newValue) {
        if (newValue == null) {
          this.range.removeAttribute(attrName);
          __privateMethod4(this, _enableUserEvents, enableUserEvents_fn).call(this);
        } else {
          this.range.setAttribute(attrName, newValue);
          __privateMethod4(this, _disableUserEvents, disableUserEvents_fn).call(this);
        }
      }
    }
    connectedCallback() {
      var _a3, _b2, _c;
      const { style } = getOrInsertCSSRule(this.shadowRoot, ":host");
      style.setProperty(
        "display",
        `var(--media-control-display, var(--${this.localName}-display, inline-flex))`
      );
      __privateGet7(this, _cssRules).pointer = getOrInsertCSSRule(this.shadowRoot, "#pointer");
      __privateGet7(this, _cssRules).progress = getOrInsertCSSRule(this.shadowRoot, "#progress");
      __privateGet7(this, _cssRules).thumb = getOrInsertCSSRule(this.shadowRoot, "#thumb");
      const mediaControllerId = this.getAttribute(
        MediaStateReceiverAttributes.MEDIA_CONTROLLER
      );
      if (mediaControllerId) {
        __privateSet7(this, _mediaController3, (_a3 = this.getRootNode()) == null ? void 0 : _a3.getElementById(
          mediaControllerId
        ));
        (_c = (_b2 = __privateGet7(this, _mediaController3)) == null ? void 0 : _b2.associateElement) == null ? void 0 : _c.call(_b2, this);
      }
      this.updateBar();
      this.shadowRoot.addEventListener("focusin", __privateGet7(this, _onFocusIn));
      this.shadowRoot.addEventListener("focusout", __privateGet7(this, _onFocusOut));
      __privateMethod4(this, _enableUserEvents, enableUserEvents_fn).call(this);
      observeResize(this.container, __privateGet7(this, _updateComputedStyles));
    }
    disconnectedCallback() {
      var _a3, _b2;
      __privateMethod4(this, _disableUserEvents, disableUserEvents_fn).call(this);
      (_b2 = (_a3 = __privateGet7(this, _mediaController3)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
      __privateSet7(this, _mediaController3, null);
      this.shadowRoot.removeEventListener("focusin", __privateGet7(this, _onFocusIn));
      this.shadowRoot.removeEventListener("focusout", __privateGet7(this, _onFocusOut));
      unobserveResize(this.container, __privateGet7(this, _updateComputedStyles));
    }
    updatePointerBar(evt) {
      var _a3;
      (_a3 = __privateGet7(this, _cssRules).pointer) == null ? void 0 : _a3.style.setProperty(
        "width",
        `${this.getPointerRatio(evt) * 100}%`
      );
    }
    updateBar() {
      var _a3, _b2;
      const rangePercent = this.range.valueAsNumber * 100;
      (_a3 = __privateGet7(this, _cssRules).progress) == null ? void 0 : _a3.style.setProperty("width", `${rangePercent}%`);
      (_b2 = __privateGet7(this, _cssRules).thumb) == null ? void 0 : _b2.style.setProperty("left", `${rangePercent}%`);
    }
    updateSegments(segments) {
      const clipping = this.shadowRoot.querySelector("#segments-clipping");
      clipping.textContent = "";
      this.container.classList.toggle("segments", !!(segments == null ? void 0 : segments.length));
      if (!(segments == null ? void 0 : segments.length))
        return;
      __privateGet7(this, _cssRules).activeSegment = insertCSSRule(
        this.shadowRoot,
        "#segments-clipping rect:nth-child(0)"
      );
      const normalized = [
        .../* @__PURE__ */ new Set([
          +this.range.min,
          ...segments.flatMap((s) => [s.start, s.end]),
          +this.range.max
        ])
      ];
      __privateSet7(this, _segments, [...normalized]);
      const lastMarker = normalized.pop();
      for (const [i, marker] of normalized.entries()) {
        const [isFirst, isLast] = [i === 0, i === normalized.length - 1];
        const x = isFirst ? "calc(var(--segments-gap) / -1)" : `${marker * 100}%`;
        const x2 = isLast ? lastMarker : normalized[i + 1];
        const width = `calc(${(x2 - marker) * 100}%${isFirst || isLast ? "" : ` - var(--segments-gap)`})`;
        const segmentEl = Document2.createElementNS(
          "http://www.w3.org/2000/svg",
          "rect"
        );
        const cssRule = getOrInsertCSSRule(
          this.shadowRoot,
          `#segments-clipping rect:nth-child(${i + 1})`
        );
        cssRule.style.setProperty("x", x);
        cssRule.style.setProperty("width", width);
        clipping.append(segmentEl);
      }
    }
    getPointerRatio(evt) {
      const pointerRatio = getPointProgressOnLine(
        evt.clientX,
        evt.clientY,
        __privateGet7(this, _startpoint).getBoundingClientRect(),
        __privateGet7(this, _endpoint).getBoundingClientRect()
      );
      return Math.max(0, Math.min(1, pointerRatio));
    }
    get dragging() {
      return this.hasAttribute("dragging");
    }
    handleEvent(evt) {
      switch (evt.type) {
        case "pointermove":
          __privateMethod4(this, _handlePointerMove2, handlePointerMove_fn2).call(this, evt);
          break;
        case "input":
          this.updateBar();
          break;
        case "pointerenter":
          __privateMethod4(this, _handlePointerEnter, handlePointerEnter_fn).call(this, evt);
          break;
        case "pointerdown":
          __privateMethod4(this, _handlePointerDown, handlePointerDown_fn).call(this, evt);
          break;
        case "pointerup":
          __privateMethod4(this, _handlePointerUp2, handlePointerUp_fn2).call(this);
          break;
        case "pointerleave":
          __privateMethod4(this, _handlePointerLeave, handlePointerLeave_fn).call(this);
          break;
      }
    }
    get keysUsed() {
      return ["ArrowUp", "ArrowRight", "ArrowDown", "ArrowLeft"];
    }
  };
  _mediaController3 = /* @__PURE__ */ new WeakMap();
  _isInputTarget = /* @__PURE__ */ new WeakMap();
  _startpoint = /* @__PURE__ */ new WeakMap();
  _endpoint = /* @__PURE__ */ new WeakMap();
  _cssRules = /* @__PURE__ */ new WeakMap();
  _segments = /* @__PURE__ */ new WeakMap();
  _onFocusIn = /* @__PURE__ */ new WeakMap();
  _onFocusOut = /* @__PURE__ */ new WeakMap();
  _updateComputedStyles = /* @__PURE__ */ new WeakMap();
  _updateActiveSegment = /* @__PURE__ */ new WeakSet();
  updateActiveSegment_fn = function(evt) {
    const rule = __privateGet7(this, _cssRules).activeSegment;
    if (!rule)
      return;
    const pointerRatio = this.getPointerRatio(evt);
    const segmentIndex = __privateGet7(this, _segments).findIndex((start, i, arr) => {
      const end = arr[i + 1];
      return end != null && pointerRatio >= start && pointerRatio <= end;
    });
    const selectorText = `#segments-clipping rect:nth-child(${segmentIndex + 1})`;
    if (rule.selectorText != selectorText || !rule.style.transform) {
      rule.selectorText = selectorText;
      rule.style.setProperty(
        "transform",
        "var(--media-range-segment-hover-transform, scaleY(2))"
      );
    }
  };
  _enableUserEvents = /* @__PURE__ */ new WeakSet();
  enableUserEvents_fn = function() {
    if (this.hasAttribute("disabled"))
      return;
    this.addEventListener("input", this);
    this.addEventListener("pointerdown", this);
    this.addEventListener("pointerenter", this);
  };
  _disableUserEvents = /* @__PURE__ */ new WeakSet();
  disableUserEvents_fn = function() {
    var _a3, _b2;
    this.removeEventListener("input", this);
    this.removeEventListener("pointerdown", this);
    this.removeEventListener("pointerenter", this);
    (_a3 = GlobalThis.window) == null ? void 0 : _a3.removeEventListener("pointerup", this);
    (_b2 = GlobalThis.window) == null ? void 0 : _b2.removeEventListener("pointermove", this);
  };
  _handlePointerDown = /* @__PURE__ */ new WeakSet();
  handlePointerDown_fn = function(evt) {
    var _a3;
    __privateSet7(this, _isInputTarget, evt.composedPath().includes(this.range));
    (_a3 = GlobalThis.window) == null ? void 0 : _a3.addEventListener("pointerup", this);
  };
  _handlePointerEnter = /* @__PURE__ */ new WeakSet();
  handlePointerEnter_fn = function(evt) {
    var _a3;
    if (evt.pointerType !== "mouse")
      __privateMethod4(this, _handlePointerDown, handlePointerDown_fn).call(this, evt);
    this.addEventListener("pointerleave", this);
    (_a3 = GlobalThis.window) == null ? void 0 : _a3.addEventListener("pointermove", this);
  };
  _handlePointerUp2 = /* @__PURE__ */ new WeakSet();
  handlePointerUp_fn2 = function() {
    var _a3;
    (_a3 = GlobalThis.window) == null ? void 0 : _a3.removeEventListener("pointerup", this);
    this.toggleAttribute("dragging", false);
    this.range.disabled = this.hasAttribute("disabled");
  };
  _handlePointerLeave = /* @__PURE__ */ new WeakSet();
  handlePointerLeave_fn = function() {
    var _a3, _b2;
    this.removeEventListener("pointerleave", this);
    (_a3 = GlobalThis.window) == null ? void 0 : _a3.removeEventListener("pointermove", this);
    this.toggleAttribute("dragging", false);
    this.range.disabled = this.hasAttribute("disabled");
    (_b2 = __privateGet7(this, _cssRules).activeSegment) == null ? void 0 : _b2.style.removeProperty("transform");
  };
  _handlePointerMove2 = /* @__PURE__ */ new WeakSet();
  handlePointerMove_fn2 = function(evt) {
    this.toggleAttribute(
      "dragging",
      evt.buttons === 1 || evt.pointerType !== "mouse"
    );
    this.updatePointerBar(evt);
    __privateMethod4(this, _updateActiveSegment, updateActiveSegment_fn).call(this, evt);
    if (this.dragging && (evt.pointerType !== "mouse" || !__privateGet7(this, _isInputTarget))) {
      this.range.disabled = true;
      this.range.valueAsNumber = this.getPointerRatio(evt);
      this.range.dispatchEvent(
        new Event("input", { bubbles: true, composed: true })
      );
    }
  };
  if (!GlobalThis.customElements.get("media-chrome-range")) {
    GlobalThis.customElements.define("media-chrome-range", MediaChromeRange);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-control-bar.js
  var __accessCheck8 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet8 = (obj, member, getter) => {
    __accessCheck8(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd8 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet8 = (obj, member, value, setter) => {
    __accessCheck8(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _mediaController4;
  var template6 = Document2.createElement("template");
  template6.innerHTML = /*html*/
  `
  <style>
    :host {
      ${/* Need position to display above video for some reason */
  ""}
      box-sizing: border-box;
      display: var(--media-control-display, var(--media-control-bar-display, inline-flex));
      color: var(--media-text-color, var(--media-primary-color, rgb(238 238 238)));
      --media-loading-indicator-icon-height: 44px;
    }

    ::slotted(media-time-range),
    ::slotted(media-volume-range) {
      min-height: 100%;
    }

    ::slotted(media-time-range),
    ::slotted(media-clip-selector) {
      flex-grow: 1;
    }
  </style>

  <slot></slot>
`;
  var MediaControlBar = class extends GlobalThis.HTMLElement {
    constructor() {
      super();
      __privateAdd8(this, _mediaController4, void 0);
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        this.shadowRoot.appendChild(template6.content.cloneNode(true));
      }
    }
    static get observedAttributes() {
      return [MediaStateReceiverAttributes.MEDIA_CONTROLLER];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      var _a3, _b2, _c, _d, _e;
      if (attrName === MediaStateReceiverAttributes.MEDIA_CONTROLLER) {
        if (oldValue) {
          (_b2 = (_a3 = __privateGet8(this, _mediaController4)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
          __privateSet8(this, _mediaController4, null);
        }
        if (newValue && this.isConnected) {
          __privateSet8(this, _mediaController4, (_c = this.getRootNode()) == null ? void 0 : _c.getElementById(newValue));
          (_e = (_d = __privateGet8(this, _mediaController4)) == null ? void 0 : _d.associateElement) == null ? void 0 : _e.call(_d, this);
        }
      }
    }
    connectedCallback() {
      var _a3, _b2, _c;
      const mediaControllerId = this.getAttribute(
        MediaStateReceiverAttributes.MEDIA_CONTROLLER
      );
      if (mediaControllerId) {
        __privateSet8(this, _mediaController4, (_a3 = this.getRootNode()) == null ? void 0 : _a3.getElementById(
          mediaControllerId
        ));
        (_c = (_b2 = __privateGet8(this, _mediaController4)) == null ? void 0 : _b2.associateElement) == null ? void 0 : _c.call(_b2, this);
      }
    }
    disconnectedCallback() {
      var _a3, _b2;
      (_b2 = (_a3 = __privateGet8(this, _mediaController4)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
      __privateSet8(this, _mediaController4, null);
    }
  };
  _mediaController4 = /* @__PURE__ */ new WeakMap();
  if (!GlobalThis.customElements.get("media-control-bar")) {
    GlobalThis.customElements.define("media-control-bar", MediaControlBar);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-text-display.js
  var __accessCheck9 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet9 = (obj, member, getter) => {
    __accessCheck9(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd9 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet9 = (obj, member, value, setter) => {
    __accessCheck9(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _mediaController5;
  var template7 = Document2.createElement("template");
  template7.innerHTML = /*html*/
  `
  <style>
    :host {
      font: var(--media-font,
        var(--media-font-weight, normal)
        var(--media-font-size, 14px) /
        var(--media-text-content-height, var(--media-control-height, 24px))
        var(--media-font-family, helvetica neue, segoe ui, roboto, arial, sans-serif));
      color: var(--media-text-color, var(--media-primary-color, rgb(238 238 238)));
      background: var(--media-text-background, var(--media-control-background, var(--media-secondary-color, rgb(20 20 30 / .7))));
      padding: var(--media-control-padding, 10px);
      display: inline-flex;
      justify-content: center;
      align-items: center;
      vertical-align: middle;
      box-sizing: border-box;
      text-align: center;
      pointer-events: auto;
    }

    ${/*
    Only show outline when keyboard focusing.
    https://drafts.csswg.org/selectors-4/#the-focus-visible-pseudo
  */
  ""}
    :host(:focus-visible) {
      box-shadow: inset 0 0 0 2px rgb(27 127 204 / .9);
      outline: 0;
    }

    ${/*
  * hide default focus ring, particularly when using mouse
  */
  ""}
    :host(:where(:focus)) {
      box-shadow: none;
      outline: 0;
    }
  </style>
  <slot></slot>
`;
  var MediaTextDisplay = class extends GlobalThis.HTMLElement {
    constructor() {
      super();
      __privateAdd9(this, _mediaController5, void 0);
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        this.shadowRoot.appendChild(template7.content.cloneNode(true));
      }
    }
    static get observedAttributes() {
      return [MediaStateReceiverAttributes.MEDIA_CONTROLLER];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      var _a3, _b2, _c, _d, _e;
      if (attrName === MediaStateReceiverAttributes.MEDIA_CONTROLLER) {
        if (oldValue) {
          (_b2 = (_a3 = __privateGet9(this, _mediaController5)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
          __privateSet9(this, _mediaController5, null);
        }
        if (newValue && this.isConnected) {
          __privateSet9(this, _mediaController5, (_c = this.getRootNode()) == null ? void 0 : _c.getElementById(newValue));
          (_e = (_d = __privateGet9(this, _mediaController5)) == null ? void 0 : _d.associateElement) == null ? void 0 : _e.call(_d, this);
        }
      }
    }
    connectedCallback() {
      var _a3, _b2, _c;
      const { style } = getOrInsertCSSRule(this.shadowRoot, ":host");
      style.setProperty(
        "display",
        `var(--media-control-display, var(--${this.localName}-display, inline-flex))`
      );
      const mediaControllerId = this.getAttribute(
        MediaStateReceiverAttributes.MEDIA_CONTROLLER
      );
      if (mediaControllerId) {
        __privateSet9(this, _mediaController5, (_a3 = this.getRootNode()) == null ? void 0 : _a3.getElementById(
          mediaControllerId
        ));
        (_c = (_b2 = __privateGet9(this, _mediaController5)) == null ? void 0 : _b2.associateElement) == null ? void 0 : _c.call(_b2, this);
      }
    }
    disconnectedCallback() {
      var _a3, _b2;
      (_b2 = (_a3 = __privateGet9(this, _mediaController5)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
      __privateSet9(this, _mediaController5, null);
    }
  };
  _mediaController5 = /* @__PURE__ */ new WeakMap();
  if (!GlobalThis.customElements.get("media-text-display")) {
    GlobalThis.customElements.define("media-text-display", MediaTextDisplay);
  }
  var media_text_display_default = MediaTextDisplay;

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-duration-display.js
  var __accessCheck10 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet10 = (obj, member, getter) => {
    __accessCheck10(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd10 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet10 = (obj, member, value, setter) => {
    __accessCheck10(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _slot;
  var MediaDurationDisplay = class extends MediaTextDisplay {
    constructor() {
      super();
      __privateAdd10(this, _slot, void 0);
      __privateSet10(this, _slot, this.shadowRoot.querySelector("slot"));
      __privateGet10(this, _slot).textContent = formatTime(0);
    }
    static get observedAttributes() {
      return [...super.observedAttributes, MediaUIAttributes.MEDIA_DURATION];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      if (attrName === MediaUIAttributes.MEDIA_DURATION) {
        __privateGet10(this, _slot).textContent = formatTime(+newValue);
      }
      super.attributeChangedCallback(attrName, oldValue, newValue);
    }
    /**
     * @type {number | undefined} In seconds
     */
    get mediaDuration() {
      return getNumericAttr(this, MediaUIAttributes.MEDIA_DURATION);
    }
    set mediaDuration(time) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_DURATION, time);
    }
  };
  _slot = /* @__PURE__ */ new WeakMap();
  if (!GlobalThis.customElements.get("media-duration-display")) {
    GlobalThis.customElements.define(
      "media-duration-display",
      MediaDurationDisplay
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-fullscreen-button.js
  var enterFullscreenIcon = `<svg aria-hidden="true" viewBox="0 0 26 24">
  <path d="M16 3v2.5h3.5V9H22V3h-6ZM4 9h2.5V5.5H10V3H4v6Zm15.5 9.5H16V21h6v-6h-2.5v3.5ZM6.5 15H4v6h6v-2.5H6.5V15Z"/>
</svg>`;
  var exitFullscreenIcon = `<svg aria-hidden="true" viewBox="0 0 26 24">
  <path d="M18.5 6.5V3H16v6h6V6.5h-3.5ZM16 21h2.5v-3.5H22V15h-6v6ZM4 17.5h3.5V21H10v-6H4v2.5Zm3.5-11H4V9h6V3H7.5v3.5Z"/>
</svg>`;
  var slotTemplate4 = Document2.createElement("template");
  slotTemplate4.innerHTML = /*html*/
  `
  <style>
    :host([${MediaUIAttributes.MEDIA_IS_FULLSCREEN}]) slot[name=icon] slot:not([name=exit]) {
      display: none !important;
    }

    ${/* Double negative, but safer if display doesn't equal 'block' */
  ""}
    :host(:not([${MediaUIAttributes.MEDIA_IS_FULLSCREEN}])) slot[name=icon] slot:not([name=enter]) {
      display: none !important;
    }

    :host([${MediaUIAttributes.MEDIA_IS_FULLSCREEN}]) slot[name=tooltip-enter],
    :host(:not([${MediaUIAttributes.MEDIA_IS_FULLSCREEN}])) slot[name=tooltip-exit] {
      display: none;
    }
  </style>

  <slot name="icon">
    <slot name="enter">${enterFullscreenIcon}</slot>
    <slot name="exit">${exitFullscreenIcon}</slot>
  </slot>
`;
  var tooltipContent4 = (
    /*html*/
    `
  <slot name="tooltip-enter">${tooltipLabels.ENTER_FULLSCREEN}</slot>
  <slot name="tooltip-exit">${tooltipLabels.EXIT_FULLSCREEN}</slot>
`
  );
  var updateAriaLabel3 = (el) => {
    const label = el.mediaIsFullscreen ? verbs.EXIT_FULLSCREEN() : verbs.ENTER_FULLSCREEN();
    el.setAttribute("aria-label", label);
  };
  var MediaFullscreenButton = class extends MediaChromeButton {
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_IS_FULLSCREEN,
        MediaUIAttributes.MEDIA_FULLSCREEN_UNAVAILABLE
      ];
    }
    constructor(options = {}) {
      super({ slotTemplate: slotTemplate4, tooltipContent: tooltipContent4, ...options });
    }
    connectedCallback() {
      super.connectedCallback();
      updateAriaLabel3(this);
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_IS_FULLSCREEN) {
        updateAriaLabel3(this);
      }
    }
    /**
     * @type {string | undefined} Fullscreen unavailability state
     */
    get mediaFullscreenUnavailable() {
      return getStringAttr(this, MediaUIAttributes.MEDIA_FULLSCREEN_UNAVAILABLE);
    }
    set mediaFullscreenUnavailable(value) {
      setStringAttr(this, MediaUIAttributes.MEDIA_FULLSCREEN_UNAVAILABLE, value);
    }
    /**
     * @type {boolean} Whether fullscreen is available
     */
    get mediaIsFullscreen() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_IS_FULLSCREEN);
    }
    set mediaIsFullscreen(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_IS_FULLSCREEN, value);
    }
    handleClick() {
      const eventName = this.mediaIsFullscreen ? MediaUIEvents.MEDIA_EXIT_FULLSCREEN_REQUEST : MediaUIEvents.MEDIA_ENTER_FULLSCREEN_REQUEST;
      this.dispatchEvent(
        new GlobalThis.CustomEvent(eventName, { composed: true, bubbles: true })
      );
    }
  };
  if (!GlobalThis.customElements.get("media-fullscreen-button")) {
    GlobalThis.customElements.define(
      "media-fullscreen-button",
      MediaFullscreenButton
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-live-button.js
  var { MEDIA_TIME_IS_LIVE, MEDIA_PAUSED } = MediaUIAttributes;
  var { MEDIA_SEEK_TO_LIVE_REQUEST, MEDIA_PLAY_REQUEST } = MediaUIEvents;
  var indicatorSVG = '<svg viewBox="0 0 6 12"><circle cx="3" cy="6" r="2"></circle></svg>';
  var slotTemplate5 = Document2.createElement("template");
  slotTemplate5.innerHTML = /*html*/
  `
  <style>
  :host { --media-tooltip-display: none; }
  
  slot[name=indicator] > *,
  :host ::slotted([slot=indicator]) {
    ${/* Override styles for icon-only buttons */
  ""}
    min-width: auto;
    fill: var(--media-live-button-icon-color, rgb(140, 140, 140));
    color: var(--media-live-button-icon-color, rgb(140, 140, 140));
  }

  :host([${MEDIA_TIME_IS_LIVE}]:not([${MEDIA_PAUSED}])) slot[name=indicator] > *,
  :host([${MEDIA_TIME_IS_LIVE}]:not([${MEDIA_PAUSED}])) ::slotted([slot=indicator]) {
    fill: var(--media-live-button-indicator-color, rgb(255, 0, 0));
    color: var(--media-live-button-indicator-color, rgb(255, 0, 0));
  }

  :host([${MEDIA_TIME_IS_LIVE}]:not([${MEDIA_PAUSED}])) {
    cursor: not-allowed;
  }

  </style>

  <slot name="indicator">${indicatorSVG}</slot>
  ${/*
    A new line between spacer and text creates inconsistent spacing
    between slotted items and default slots.
  */
  ""}
  <slot name="spacer">&nbsp;</slot><slot name="text">LIVE</slot>
`;
  var updateAriaAttributes = (el) => {
    const isPausedOrNotLive = el.mediaPaused || !el.mediaTimeIsLive;
    const label = isPausedOrNotLive ? verbs.SEEK_LIVE() : verbs.PLAYING_LIVE();
    el.setAttribute("aria-label", label);
    isPausedOrNotLive ? el.removeAttribute("aria-disabled") : el.setAttribute("aria-disabled", "true");
  };
  var MediaLiveButton = class extends MediaChromeButton {
    static get observedAttributes() {
      return [...super.observedAttributes, MEDIA_PAUSED, MEDIA_TIME_IS_LIVE];
    }
    constructor(options = {}) {
      super({ slotTemplate: slotTemplate5, ...options });
    }
    connectedCallback() {
      updateAriaAttributes(this);
      super.connectedCallback();
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      updateAriaAttributes(this);
    }
    /**
     * @type {boolean} Is the media paused
     */
    get mediaPaused() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_PAUSED);
    }
    set mediaPaused(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_PAUSED, value);
    }
    /**
     * @type {boolean} Is the media playback currently live
     */
    get mediaTimeIsLive() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_TIME_IS_LIVE);
    }
    set mediaTimeIsLive(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_TIME_IS_LIVE, value);
    }
    handleClick() {
      if (!this.mediaPaused && this.mediaTimeIsLive)
        return;
      this.dispatchEvent(
        new GlobalThis.CustomEvent(MEDIA_SEEK_TO_LIVE_REQUEST, {
          composed: true,
          bubbles: true
        })
      );
      if (this.hasAttribute(MEDIA_PAUSED)) {
        this.dispatchEvent(
          new GlobalThis.CustomEvent(MEDIA_PLAY_REQUEST, {
            composed: true,
            bubbles: true
          })
        );
      }
    }
  };
  if (!GlobalThis.customElements.get("media-live-button")) {
    GlobalThis.customElements.define("media-live-button", MediaLiveButton);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-loading-indicator.js
  var __accessCheck11 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet11 = (obj, member, getter) => {
    __accessCheck11(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd11 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet11 = (obj, member, value, setter) => {
    __accessCheck11(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _mediaController6;
  var _delay;
  var Attributes5 = {
    LOADING_DELAY: "loadingdelay"
  };
  var DEFAULT_LOADING_DELAY = 500;
  var template8 = Document2.createElement("template");
  var loadingIndicatorIcon = `
<svg aria-hidden="true" viewBox="0 0 100 100">
  <path d="M73,50c0-12.7-10.3-23-23-23S27,37.3,27,50 M30.9,50c0-10.5,8.5-19.1,19.1-19.1S69.1,39.5,69.1,50">
    <animateTransform
       attributeName="transform"
       attributeType="XML"
       type="rotate"
       dur="1s"
       from="0 50 50"
       to="360 50 50"
       repeatCount="indefinite" />
  </path>
</svg>
`;
  template8.innerHTML = /*html*/
  `
<style>
:host {
  display: var(--media-control-display, var(--media-loading-indicator-display, inline-block));
  vertical-align: middle;
  box-sizing: border-box;
  --_loading-indicator-delay: var(--media-loading-indicator-transition-delay, ${DEFAULT_LOADING_DELAY}ms);
}

#status {
  color: rgba(0,0,0,0);
  width: 0px;
  height: 0px;
}

:host slot[name=icon] > *,
:host ::slotted([slot=icon]) {
  opacity: var(--media-loading-indicator-opacity, 0);
  transition: opacity 0.15s;
}

:host([${MediaUIAttributes.MEDIA_LOADING}]:not([${MediaUIAttributes.MEDIA_PAUSED}])) slot[name=icon] > *,
:host([${MediaUIAttributes.MEDIA_LOADING}]:not([${MediaUIAttributes.MEDIA_PAUSED}])) ::slotted([slot=icon]) {
  opacity: var(--media-loading-indicator-opacity, 1);
  transition: opacity 0.15s var(--_loading-indicator-delay);
}

:host #status {
  visibility: var(--media-loading-indicator-opacity, hidden);
  transition: visibility 0.15s;
}

:host([${MediaUIAttributes.MEDIA_LOADING}]:not([${MediaUIAttributes.MEDIA_PAUSED}])) #status {
  visibility: var(--media-loading-indicator-opacity, visible);
  transition: visibility 0.15s var(--_loading-indicator-delay);
}

svg, img, ::slotted(svg), ::slotted(img) {
  width: var(--media-loading-indicator-icon-width);
  height: var(--media-loading-indicator-icon-height, 100px);
  fill: var(--media-icon-color, var(--media-primary-color, rgb(238 238 238)));
  vertical-align: middle;
}
</style>

<slot name="icon">${loadingIndicatorIcon}</slot>
<div id="status" role="status" aria-live="polite">${nouns.MEDIA_LOADING()}</div>
`;
  var MediaLoadingIndicator = class extends GlobalThis.HTMLElement {
    constructor() {
      super();
      __privateAdd11(this, _mediaController6, void 0);
      __privateAdd11(this, _delay, DEFAULT_LOADING_DELAY);
      if (!this.shadowRoot) {
        const shadow = this.attachShadow({ mode: "open" });
        const indicatorHTML = template8.content.cloneNode(true);
        shadow.appendChild(indicatorHTML);
      }
    }
    static get observedAttributes() {
      return [
        MediaStateReceiverAttributes.MEDIA_CONTROLLER,
        MediaUIAttributes.MEDIA_PAUSED,
        MediaUIAttributes.MEDIA_LOADING,
        Attributes5.LOADING_DELAY
      ];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      var _a3, _b2, _c, _d, _e;
      if (attrName === Attributes5.LOADING_DELAY && oldValue !== newValue) {
        this.loadingDelay = Number(newValue);
      } else if (attrName === MediaStateReceiverAttributes.MEDIA_CONTROLLER) {
        if (oldValue) {
          (_b2 = (_a3 = __privateGet11(this, _mediaController6)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
          __privateSet11(this, _mediaController6, null);
        }
        if (newValue && this.isConnected) {
          __privateSet11(this, _mediaController6, (_c = this.getRootNode()) == null ? void 0 : _c.getElementById(newValue));
          (_e = (_d = __privateGet11(this, _mediaController6)) == null ? void 0 : _d.associateElement) == null ? void 0 : _e.call(_d, this);
        }
      }
    }
    connectedCallback() {
      var _a3, _b2, _c;
      const mediaControllerId = this.getAttribute(
        MediaStateReceiverAttributes.MEDIA_CONTROLLER
      );
      if (mediaControllerId) {
        __privateSet11(this, _mediaController6, (_a3 = this.getRootNode()) == null ? void 0 : _a3.getElementById(
          mediaControllerId
        ));
        (_c = (_b2 = __privateGet11(this, _mediaController6)) == null ? void 0 : _b2.associateElement) == null ? void 0 : _c.call(_b2, this);
      }
    }
    disconnectedCallback() {
      var _a3, _b2;
      (_b2 = (_a3 = __privateGet11(this, _mediaController6)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
      __privateSet11(this, _mediaController6, null);
    }
    /**
     * Delay in ms
     */
    get loadingDelay() {
      return __privateGet11(this, _delay);
    }
    set loadingDelay(delay2) {
      __privateSet11(this, _delay, delay2);
      const { style } = getOrInsertCSSRule(this.shadowRoot, ":host");
      style.setProperty(
        "--_loading-indicator-delay",
        `var(--media-loading-indicator-transition-delay, ${delay2}ms)`
      );
    }
    /**
     * Is the media paused
     */
    get mediaPaused() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_PAUSED);
    }
    set mediaPaused(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_PAUSED, value);
    }
    /**
     * Is the media loading
     */
    get mediaLoading() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_LOADING);
    }
    set mediaLoading(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_LOADING, value);
    }
  };
  _mediaController6 = /* @__PURE__ */ new WeakMap();
  _delay = /* @__PURE__ */ new WeakMap();
  if (!GlobalThis.customElements.get("media-loading-indicator")) {
    GlobalThis.customElements.define(
      "media-loading-indicator",
      MediaLoadingIndicator
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-mute-button.js
  var { MEDIA_VOLUME_LEVEL } = MediaUIAttributes;
  var offIcon = `<svg aria-hidden="true" viewBox="0 0 24 24">
  <path d="M16.5 12A4.5 4.5 0 0 0 14 8v2.18l2.45 2.45a4.22 4.22 0 0 0 .05-.63Zm2.5 0a6.84 6.84 0 0 1-.54 2.64L20 16.15A8.8 8.8 0 0 0 21 12a9 9 0 0 0-7-8.77v2.06A7 7 0 0 1 19 12ZM4.27 3 3 4.27 7.73 9H3v6h4l5 5v-6.73l4.25 4.25A6.92 6.92 0 0 1 14 18.7v2.06A9 9 0 0 0 17.69 19l2 2.05L21 19.73l-9-9L4.27 3ZM12 4 9.91 6.09 12 8.18V4Z"/>
</svg>`;
  var lowIcon = `<svg aria-hidden="true" viewBox="0 0 24 24">
  <path d="M3 9v6h4l5 5V4L7 9H3Zm13.5 3A4.5 4.5 0 0 0 14 8v8a4.47 4.47 0 0 0 2.5-4Z"/>
</svg>`;
  var highIcon = `<svg aria-hidden="true" viewBox="0 0 24 24">
  <path d="M3 9v6h4l5 5V4L7 9H3Zm13.5 3A4.5 4.5 0 0 0 14 8v8a4.47 4.47 0 0 0 2.5-4ZM14 3.23v2.06a7 7 0 0 1 0 13.42v2.06a9 9 0 0 0 0-17.54Z"/>
</svg>`;
  var slotTemplate6 = Document2.createElement("template");
  slotTemplate6.innerHTML = /*html*/
  `
  <style>
  ${/* Default to High slot/icon. */
  ""}
  :host(:not([${MEDIA_VOLUME_LEVEL}])) slot[name=icon] slot:not([name=high]), 
  :host([${MEDIA_VOLUME_LEVEL}=high]) slot[name=icon] slot:not([name=high]) {
    display: none !important;
  }

  :host([${MEDIA_VOLUME_LEVEL}=off]) slot[name=icon] slot:not([name=off]) {
    display: none !important;
  }

  :host([${MEDIA_VOLUME_LEVEL}=low]) slot[name=icon] slot:not([name=low]) {
    display: none !important;
  }

  :host([${MEDIA_VOLUME_LEVEL}=medium]) slot[name=icon] slot:not([name=medium]) {
    display: none !important;
  }

  :host(:not([${MEDIA_VOLUME_LEVEL}=off])) slot[name=tooltip-unmute],
  :host([${MEDIA_VOLUME_LEVEL}=off]) slot[name=tooltip-mute] {
    display: none;
  }
  </style>

  <slot name="icon">
    <slot name="off">${offIcon}</slot>
    <slot name="low">${lowIcon}</slot>
    <slot name="medium">${lowIcon}</slot>
    <slot name="high">${highIcon}</slot>
  </slot>
`;
  var tooltipContent5 = (
    /*html*/
    `
  <slot name="tooltip-mute">${tooltipLabels.MUTE}</slot>
  <slot name="tooltip-unmute">${tooltipLabels.UNMUTE}</slot>
`
  );
  var updateAriaLabel4 = (el) => {
    const muted = el.mediaVolumeLevel === "off";
    const label = muted ? verbs.UNMUTE() : verbs.MUTE();
    el.setAttribute("aria-label", label);
  };
  var MediaMuteButton = class extends MediaChromeButton {
    static get observedAttributes() {
      return [...super.observedAttributes, MediaUIAttributes.MEDIA_VOLUME_LEVEL];
    }
    constructor(options = {}) {
      super({ slotTemplate: slotTemplate6, tooltipContent: tooltipContent5, ...options });
    }
    connectedCallback() {
      updateAriaLabel4(this);
      super.connectedCallback();
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      if (attrName === MediaUIAttributes.MEDIA_VOLUME_LEVEL) {
        updateAriaLabel4(this);
      }
      super.attributeChangedCallback(attrName, oldValue, newValue);
    }
    /**
     * @type {string | undefined}
     */
    get mediaVolumeLevel() {
      return getStringAttr(this, MediaUIAttributes.MEDIA_VOLUME_LEVEL);
    }
    set mediaVolumeLevel(value) {
      setStringAttr(this, MediaUIAttributes.MEDIA_VOLUME_LEVEL, value);
    }
    handleClick() {
      const eventName = this.mediaVolumeLevel === "off" ? MediaUIEvents.MEDIA_UNMUTE_REQUEST : MediaUIEvents.MEDIA_MUTE_REQUEST;
      this.dispatchEvent(
        new GlobalThis.CustomEvent(eventName, { composed: true, bubbles: true })
      );
    }
  };
  if (!GlobalThis.customElements.get("media-mute-button")) {
    GlobalThis.customElements.define("media-mute-button", MediaMuteButton);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-pip-button.js
  var pipIcon = `<svg aria-hidden="true" viewBox="0 0 28 24">
  <path d="M24 3H4a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h20a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1Zm-1 16H5V5h18v14Zm-3-8h-7v5h7v-5Z"/>
</svg>`;
  var slotTemplate7 = Document2.createElement("template");
  slotTemplate7.innerHTML = /*html*/
  `
  <style>
  :host([${MediaUIAttributes.MEDIA_IS_PIP}]) slot[name=icon] slot:not([name=exit]) {
    display: none !important;
  }

  ${/* Double negative, but safer if display doesn't equal 'block' */
  ""}
  :host(:not([${MediaUIAttributes.MEDIA_IS_PIP}])) slot[name=icon] slot:not([name=enter]) {
    display: none !important;
  }

  :host([${MediaUIAttributes.MEDIA_IS_PIP}]) slot[name=tooltip-enter],
  :host(:not([${MediaUIAttributes.MEDIA_IS_PIP}])) slot[name=tooltip-exit] {
    display: none;
  }
  </style>

  <slot name="icon">
    <slot name="enter">${pipIcon}</slot>
    <slot name="exit">${pipIcon}</slot>
  </slot>
`;
  var tooltipContent6 = (
    /*html*/
    `
  <slot name="tooltip-enter">${tooltipLabels.ENTER_PIP}</slot>
  <slot name="tooltip-exit">${tooltipLabels.EXIT_PIP}</slot>
`
  );
  var updateAriaLabel5 = (el) => {
    const label = el.mediaIsPip ? verbs.EXIT_PIP() : verbs.ENTER_PIP();
    el.setAttribute("aria-label", label);
  };
  var MediaPipButton = class extends MediaChromeButton {
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_IS_PIP,
        MediaUIAttributes.MEDIA_PIP_UNAVAILABLE
      ];
    }
    constructor(options = {}) {
      super({ slotTemplate: slotTemplate7, tooltipContent: tooltipContent6, ...options });
    }
    connectedCallback() {
      updateAriaLabel5(this);
      super.connectedCallback();
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      if (attrName === MediaUIAttributes.MEDIA_IS_PIP) {
        updateAriaLabel5(this);
      }
      super.attributeChangedCallback(attrName, oldValue, newValue);
    }
    /**
     * @type {string | undefined} Pip unavailability state
     */
    get mediaPipUnavailable() {
      return getStringAttr(this, MediaUIAttributes.MEDIA_PIP_UNAVAILABLE);
    }
    set mediaPipUnavailable(value) {
      setStringAttr(this, MediaUIAttributes.MEDIA_PIP_UNAVAILABLE, value);
    }
    /**
     * @type {boolean} Is the media currently playing picture-in-picture
     */
    get mediaIsPip() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_IS_PIP);
    }
    set mediaIsPip(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_IS_PIP, value);
    }
    handleClick() {
      const eventName = this.mediaIsPip ? MediaUIEvents.MEDIA_EXIT_PIP_REQUEST : MediaUIEvents.MEDIA_ENTER_PIP_REQUEST;
      this.dispatchEvent(
        new GlobalThis.CustomEvent(eventName, { composed: true, bubbles: true })
      );
    }
  };
  if (!GlobalThis.customElements.get("media-pip-button")) {
    GlobalThis.customElements.define("media-pip-button", MediaPipButton);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-playback-rate-button.js
  var __accessCheck12 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet12 = (obj, member, getter) => {
    __accessCheck12(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd12 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var _rates;
  var Attributes6 = {
    RATES: "rates"
  };
  var DEFAULT_RATES = [1, 1.2, 1.5, 1.7, 2];
  var DEFAULT_RATE = 1;
  var slotTemplate8 = Document2.createElement("template");
  slotTemplate8.innerHTML = /*html*/
  `
  <style>
    :host {
      min-width: 5ch;
      padding: var(--media-button-padding, var(--media-control-padding, 10px 5px));
    }
  </style>
  <slot name="icon"></slot>
`;
  var MediaPlaybackRateButton = class extends MediaChromeButton {
    constructor(options = {}) {
      super({
        slotTemplate: slotTemplate8,
        tooltipContent: tooltipLabels.PLAYBACK_RATE,
        ...options
      });
      __privateAdd12(this, _rates, new AttributeTokenList(this, Attributes6.RATES, {
        defaultValue: DEFAULT_RATES
      }));
      this.container = this.shadowRoot.querySelector('slot[name="icon"]');
      this.container.innerHTML = `${DEFAULT_RATE}x`;
    }
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_PLAYBACK_RATE,
        Attributes6.RATES
      ];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === Attributes6.RATES) {
        __privateGet12(this, _rates).value = newValue;
      }
      if (attrName === MediaUIAttributes.MEDIA_PLAYBACK_RATE) {
        const newPlaybackRate = newValue ? +newValue : Number.NaN;
        const playbackRate = !Number.isNaN(newPlaybackRate) ? newPlaybackRate : DEFAULT_RATE;
        this.container.innerHTML = `${playbackRate}x`;
        this.setAttribute("aria-label", nouns.PLAYBACK_RATE({ playbackRate }));
      }
    }
    /**
     * @type { AttributeTokenList | Array<number> | undefined} Will return a DOMTokenList.
     * Setting a value will accept an array of numbers.
     */
    get rates() {
      return __privateGet12(this, _rates);
    }
    set rates(value) {
      if (!value) {
        __privateGet12(this, _rates).value = "";
      } else if (Array.isArray(value)) {
        __privateGet12(this, _rates).value = value.join(" ");
      }
    }
    /**
     * @type {number} The current playback rate
     */
    get mediaPlaybackRate() {
      return getNumericAttr(
        this,
        MediaUIAttributes.MEDIA_PLAYBACK_RATE,
        DEFAULT_RATE
      );
    }
    set mediaPlaybackRate(value) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_PLAYBACK_RATE, value);
    }
    handleClick() {
      var _a3, _b2;
      const availableRates = Array.from(this.rates.values(), (str) => +str).sort(
        (a, b) => a - b
      );
      const detail = (_b2 = (_a3 = availableRates.find((r) => r > this.mediaPlaybackRate)) != null ? _a3 : availableRates[0]) != null ? _b2 : DEFAULT_RATE;
      const evt = new GlobalThis.CustomEvent(
        MediaUIEvents.MEDIA_PLAYBACK_RATE_REQUEST,
        { composed: true, bubbles: true, detail }
      );
      this.dispatchEvent(evt);
    }
  };
  _rates = /* @__PURE__ */ new WeakMap();
  if (!GlobalThis.customElements.get("media-playback-rate-button")) {
    GlobalThis.customElements.define(
      "media-playback-rate-button",
      MediaPlaybackRateButton
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-play-button.js
  var playIcon = `<svg aria-hidden="true" viewBox="0 0 24 24">
  <path d="m6 21 15-9L6 3v18Z"/>
</svg>`;
  var pauseIcon = `<svg aria-hidden="true" viewBox="0 0 24 24">
  <path d="M6 20h4V4H6v16Zm8-16v16h4V4h-4Z"/>
</svg>`;
  var slotTemplate9 = Document2.createElement("template");
  slotTemplate9.innerHTML = /*html*/
  `
  <style>
    :host([${MediaUIAttributes.MEDIA_PAUSED}]) slot[name=pause],
    :host(:not([${MediaUIAttributes.MEDIA_PAUSED}])) slot[name=play] {
      display: none !important;
    }

    :host([${MediaUIAttributes.MEDIA_PAUSED}]) slot[name=tooltip-pause],
    :host(:not([${MediaUIAttributes.MEDIA_PAUSED}])) slot[name=tooltip-play] {
      display: none;
    }
  </style>

  <slot name="icon">
    <slot name="play">${playIcon}</slot>
    <slot name="pause">${pauseIcon}</slot>
  </slot>
`;
  var tooltipContent7 = (
    /*html*/
    `
  <slot name="tooltip-play">${tooltipLabels.PLAY}</slot>
  <slot name="tooltip-pause">${tooltipLabels.PAUSE}</slot>
`
  );
  var updateAriaLabel6 = (el) => {
    const label = el.mediaPaused ? verbs.PLAY() : verbs.PAUSE();
    el.setAttribute("aria-label", label);
  };
  var MediaPlayButton = class extends MediaChromeButton {
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_PAUSED,
        MediaUIAttributes.MEDIA_ENDED
      ];
    }
    constructor(options = {}) {
      super({ slotTemplate: slotTemplate9, tooltipContent: tooltipContent7, ...options });
    }
    connectedCallback() {
      updateAriaLabel6(this);
      super.connectedCallback();
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      if (attrName === MediaUIAttributes.MEDIA_PAUSED) {
        updateAriaLabel6(this);
      }
      super.attributeChangedCallback(attrName, oldValue, newValue);
    }
    /**
     * Is the media paused
     */
    get mediaPaused() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_PAUSED);
    }
    set mediaPaused(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_PAUSED, value);
    }
    handleClick() {
      const eventName = this.mediaPaused ? MediaUIEvents.MEDIA_PLAY_REQUEST : MediaUIEvents.MEDIA_PAUSE_REQUEST;
      this.dispatchEvent(
        new GlobalThis.CustomEvent(eventName, { composed: true, bubbles: true })
      );
    }
  };
  if (!GlobalThis.customElements.get("media-play-button")) {
    GlobalThis.customElements.define("media-play-button", MediaPlayButton);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-poster-image.js
  var Attributes7 = {
    PLACEHOLDER_SRC: "placeholdersrc",
    SRC: "src"
  };
  var template9 = Document2.createElement("template");
  template9.innerHTML = /*html*/
  `
  <style>
    :host {
      pointer-events: none;
      display: var(--media-poster-image-display, inline-block);
      box-sizing: border-box;
    }

    img {
      max-width: 100%;
      max-height: 100%;
      min-width: 100%;
      min-height: 100%;
      background-repeat: no-repeat;
      background-position: var(--media-poster-image-background-position, var(--media-object-position, center));
      background-size: var(--media-poster-image-background-size, var(--media-object-fit, contain));
      object-fit: var(--media-object-fit, contain);
      object-position: var(--media-object-position, center);
    }
  </style>

  <img part="poster img" aria-hidden="true" id="image"/>
`;
  var unsetBackgroundImage = (el) => {
    el.style.removeProperty("background-image");
  };
  var setBackgroundImage = (el, image) => {
    el.style["background-image"] = `url('${image}')`;
  };
  var MediaPosterImage = class extends GlobalThis.HTMLElement {
    static get observedAttributes() {
      return [Attributes7.PLACEHOLDER_SRC, Attributes7.SRC];
    }
    constructor() {
      super();
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        this.shadowRoot.appendChild(template9.content.cloneNode(true));
      }
      this.image = this.shadowRoot.querySelector("#image");
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      if (attrName === Attributes7.SRC) {
        if (newValue == null) {
          this.image.removeAttribute(Attributes7.SRC);
        } else {
          this.image.setAttribute(Attributes7.SRC, newValue);
        }
      }
      if (attrName === Attributes7.PLACEHOLDER_SRC) {
        if (newValue == null) {
          unsetBackgroundImage(this.image);
        } else {
          setBackgroundImage(this.image, newValue);
        }
      }
    }
    /**
     *
     */
    get placeholderSrc() {
      return getStringAttr(this, Attributes7.PLACEHOLDER_SRC);
    }
    set placeholderSrc(value) {
      setStringAttr(this, Attributes7.SRC, value);
    }
    /**
     *
     */
    get src() {
      return getStringAttr(this, Attributes7.SRC);
    }
    set src(value) {
      setStringAttr(this, Attributes7.SRC, value);
    }
  };
  if (!GlobalThis.customElements.get("media-poster-image")) {
    GlobalThis.customElements.define("media-poster-image", MediaPosterImage);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-preview-chapter-display.js
  var __accessCheck13 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet13 = (obj, member, getter) => {
    __accessCheck13(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd13 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet12 = (obj, member, value, setter) => {
    __accessCheck13(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _slot2;
  var MediaPreviewChapterDisplay = class extends media_text_display_default {
    constructor() {
      super();
      __privateAdd13(this, _slot2, void 0);
      __privateSet12(this, _slot2, this.shadowRoot.querySelector("slot"));
    }
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_PREVIEW_CHAPTER
      ];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_PREVIEW_CHAPTER) {
        if (newValue !== oldValue && newValue != null) {
          __privateGet13(this, _slot2).textContent = newValue;
          if (newValue !== "") {
            this.setAttribute("aria-valuetext", `chapter: ${newValue}`);
          } else {
            this.removeAttribute("aria-valuetext");
          }
        }
      }
    }
    /**
     * @type {string | undefined} Timeline preview chapter
     */
    get mediaPreviewChapter() {
      return getStringAttr(this, MediaUIAttributes.MEDIA_PREVIEW_CHAPTER);
    }
    set mediaPreviewChapter(value) {
      setStringAttr(this, MediaUIAttributes.MEDIA_PREVIEW_CHAPTER, value);
    }
  };
  _slot2 = /* @__PURE__ */ new WeakMap();
  if (!GlobalThis.customElements.get("media-preview-chapter-display")) {
    GlobalThis.customElements.define(
      "media-preview-chapter-display",
      MediaPreviewChapterDisplay
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-preview-thumbnail.js
  var __accessCheck14 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet14 = (obj, member, getter) => {
    __accessCheck14(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd14 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet13 = (obj, member, value, setter) => {
    __accessCheck14(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _mediaController7;
  var template10 = Document2.createElement("template");
  template10.innerHTML = /*html*/
  `
  <style>
    :host {
      box-sizing: border-box;
      display: var(--media-control-display, var(--media-preview-thumbnail-display, inline-block));
      overflow: hidden;
    }

    img {
      display: none;
      position: relative;
    }
  </style>
  <img crossorigin loading="eager" decoding="async">
`;
  var MediaPreviewThumbnail = class extends GlobalThis.HTMLElement {
    constructor() {
      super();
      __privateAdd14(this, _mediaController7, void 0);
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        this.shadowRoot.appendChild(template10.content.cloneNode(true));
      }
    }
    static get observedAttributes() {
      return [
        MediaStateReceiverAttributes.MEDIA_CONTROLLER,
        MediaUIAttributes.MEDIA_PREVIEW_IMAGE,
        MediaUIAttributes.MEDIA_PREVIEW_COORDS
      ];
    }
    connectedCallback() {
      var _a3, _b2, _c;
      const mediaControllerId = this.getAttribute(
        MediaStateReceiverAttributes.MEDIA_CONTROLLER
      );
      if (mediaControllerId) {
        __privateSet13(
          this,
          _mediaController7,
          // @ts-ignore
          (_a3 = this.getRootNode()) == null ? void 0 : _a3.getElementById(mediaControllerId)
        );
        (_c = (_b2 = __privateGet14(this, _mediaController7)) == null ? void 0 : _b2.associateElement) == null ? void 0 : _c.call(_b2, this);
      }
    }
    disconnectedCallback() {
      var _a3, _b2;
      (_b2 = (_a3 = __privateGet14(this, _mediaController7)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
      __privateSet13(this, _mediaController7, null);
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      var _a3, _b2, _c, _d, _e;
      if ([
        MediaUIAttributes.MEDIA_PREVIEW_IMAGE,
        MediaUIAttributes.MEDIA_PREVIEW_COORDS
      ].includes(attrName)) {
        this.update();
      }
      if (attrName === MediaStateReceiverAttributes.MEDIA_CONTROLLER) {
        if (oldValue) {
          (_b2 = (_a3 = __privateGet14(this, _mediaController7)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
          __privateSet13(this, _mediaController7, null);
        }
        if (newValue && this.isConnected) {
          __privateSet13(this, _mediaController7, (_c = this.getRootNode()) == null ? void 0 : _c.getElementById(newValue));
          (_e = (_d = __privateGet14(this, _mediaController7)) == null ? void 0 : _d.associateElement) == null ? void 0 : _e.call(_d, this);
        }
      }
    }
    /**
     * @type {string | undefined} The url of the preview image
     */
    get mediaPreviewImage() {
      return getStringAttr(this, MediaUIAttributes.MEDIA_PREVIEW_IMAGE);
    }
    set mediaPreviewImage(value) {
      setStringAttr(this, MediaUIAttributes.MEDIA_PREVIEW_IMAGE, value);
    }
    /**
     * @type {Array<number> | undefined} Fixed length array [x, y, width, height] or undefined
     */
    get mediaPreviewCoords() {
      const attrVal = this.getAttribute(MediaUIAttributes.MEDIA_PREVIEW_COORDS);
      if (!attrVal)
        return void 0;
      return attrVal.split(/\s+/).map((coord) => +coord);
    }
    set mediaPreviewCoords(value) {
      if (!value) {
        this.removeAttribute(MediaUIAttributes.MEDIA_PREVIEW_COORDS);
        return;
      }
      this.setAttribute(MediaUIAttributes.MEDIA_PREVIEW_COORDS, value.join(" "));
    }
    update() {
      const coords = this.mediaPreviewCoords;
      const previewImage = this.mediaPreviewImage;
      if (!(coords && previewImage))
        return;
      const [x, y, w, h] = coords;
      const src = previewImage.split("#")[0];
      const computedStyle = getComputedStyle(this);
      const { maxWidth, maxHeight, minWidth, minHeight } = computedStyle;
      const maxRatio = Math.min(parseInt(maxWidth) / w, parseInt(maxHeight) / h);
      const minRatio = Math.max(parseInt(minWidth) / w, parseInt(minHeight) / h);
      const isScalingDown = maxRatio < 1;
      const scale = isScalingDown ? maxRatio : minRatio > 1 ? minRatio : 1;
      const { style } = getOrInsertCSSRule(this.shadowRoot, ":host");
      const imgStyle = getOrInsertCSSRule(this.shadowRoot, "img").style;
      const img = this.shadowRoot.querySelector("img");
      const extremum = isScalingDown ? "min" : "max";
      style.setProperty(`${extremum}-width`, "initial", "important");
      style.setProperty(`${extremum}-height`, "initial", "important");
      style.width = `${w * scale}px`;
      style.height = `${h * scale}px`;
      const resize = () => {
        imgStyle.width = `${this.imgWidth * scale}px`;
        imgStyle.height = `${this.imgHeight * scale}px`;
        imgStyle.display = "block";
      };
      if (img.src !== src) {
        img.onload = () => {
          this.imgWidth = img.naturalWidth;
          this.imgHeight = img.naturalHeight;
          resize();
        };
        img.src = src;
        resize();
      }
      resize();
      imgStyle.transform = `translate(-${x * scale}px, -${y * scale}px)`;
    }
  };
  _mediaController7 = /* @__PURE__ */ new WeakMap();
  if (!GlobalThis.customElements.get("media-preview-thumbnail")) {
    GlobalThis.customElements.define(
      "media-preview-thumbnail",
      MediaPreviewThumbnail
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-preview-time-display.js
  var __accessCheck15 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet15 = (obj, member, getter) => {
    __accessCheck15(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd15 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet14 = (obj, member, value, setter) => {
    __accessCheck15(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _slot3;
  var MediaPreviewTimeDisplay = class extends MediaTextDisplay {
    constructor() {
      super();
      __privateAdd15(this, _slot3, void 0);
      __privateSet14(this, _slot3, this.shadowRoot.querySelector("slot"));
      __privateGet15(this, _slot3).textContent = formatTime(0);
    }
    static get observedAttributes() {
      return [...super.observedAttributes, MediaUIAttributes.MEDIA_PREVIEW_TIME];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_PREVIEW_TIME && newValue != null) {
        __privateGet15(this, _slot3).textContent = formatTime(parseFloat(newValue));
      }
    }
    /**
     * Timeline preview time
     */
    get mediaPreviewTime() {
      return getNumericAttr(this, MediaUIAttributes.MEDIA_PREVIEW_TIME);
    }
    set mediaPreviewTime(value) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_PREVIEW_TIME, value);
    }
  };
  _slot3 = /* @__PURE__ */ new WeakMap();
  if (!GlobalThis.customElements.get("media-preview-time-display")) {
    GlobalThis.customElements.define(
      "media-preview-time-display",
      MediaPreviewTimeDisplay
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-seek-backward-button.js
  var Attributes8 = {
    SEEK_OFFSET: "seekoffset"
  };
  var DEFAULT_SEEK_OFFSET2 = 30;
  var backwardIcon = `<svg aria-hidden="true" viewBox="0 0 20 24"><defs><style>.text{font-size:8px;font-family:Arial-BoldMT, Arial;font-weight:700;}</style></defs><text class="text value" transform="translate(2.18 19.87)">${DEFAULT_SEEK_OFFSET2}</text><path d="M10 6V3L4.37 7 10 10.94V8a5.54 5.54 0 0 1 1.9 10.48v2.12A7.5 7.5 0 0 0 10 6Z"/></svg>`;
  var slotTemplate10 = Document2.createElement("template");
  slotTemplate10.innerHTML = `
  <slot name="icon">${backwardIcon}</slot>
`;
  var DEFAULT_TIME = 0;
  var MediaSeekBackwardButton = class extends MediaChromeButton {
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_CURRENT_TIME,
        Attributes8.SEEK_OFFSET
      ];
    }
    constructor(options = {}) {
      super({
        slotTemplate: slotTemplate10,
        tooltipContent: tooltipLabels.SEEK_BACKWARD,
        ...options
      });
    }
    connectedCallback() {
      this.seekOffset = getNumericAttr(
        this,
        Attributes8.SEEK_OFFSET,
        DEFAULT_SEEK_OFFSET2
      );
      super.connectedCallback();
    }
    attributeChangedCallback(attrName, _oldValue, newValue) {
      if (attrName === Attributes8.SEEK_OFFSET) {
        this.seekOffset = getNumericAttr(
          this,
          Attributes8.SEEK_OFFSET,
          DEFAULT_SEEK_OFFSET2
        );
      }
      super.attributeChangedCallback(attrName, _oldValue, newValue);
    }
    // Own props
    /**
     * Seek amount in seconds
     */
    get seekOffset() {
      return getNumericAttr(this, Attributes8.SEEK_OFFSET, DEFAULT_SEEK_OFFSET2);
    }
    set seekOffset(value) {
      setNumericAttr(this, Attributes8.SEEK_OFFSET, value);
      this.setAttribute(
        "aria-label",
        verbs.SEEK_BACK_N_SECS({ seekOffset: this.seekOffset })
      );
      updateIconText(getSlotted(this, "icon"), this.seekOffset);
    }
    // Props derived from Media UI Attributes
    /**
     * The current time in seconds
     */
    get mediaCurrentTime() {
      return getNumericAttr(
        this,
        MediaUIAttributes.MEDIA_CURRENT_TIME,
        DEFAULT_TIME
      );
    }
    set mediaCurrentTime(time) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_CURRENT_TIME, time);
    }
    handleClick() {
      const detail = Math.max(this.mediaCurrentTime - this.seekOffset, 0);
      const evt = new GlobalThis.CustomEvent(MediaUIEvents.MEDIA_SEEK_REQUEST, {
        composed: true,
        bubbles: true,
        detail
      });
      this.dispatchEvent(evt);
    }
  };
  if (!GlobalThis.customElements.get("media-seek-backward-button")) {
    GlobalThis.customElements.define(
      "media-seek-backward-button",
      MediaSeekBackwardButton
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-seek-forward-button.js
  var Attributes9 = {
    SEEK_OFFSET: "seekoffset"
  };
  var DEFAULT_SEEK_OFFSET3 = 30;
  var forwardIcon = `<svg aria-hidden="true" viewBox="0 0 20 24"><defs><style>.text{font-size:8px;font-family:Arial-BoldMT, Arial;font-weight:700;}</style></defs><text class="text value" transform="translate(8.9 19.87)">${DEFAULT_SEEK_OFFSET3}</text><path d="M10 6V3l5.61 4L10 10.94V8a5.54 5.54 0 0 0-1.9 10.48v2.12A7.5 7.5 0 0 1 10 6Z"/></svg>`;
  var slotTemplate11 = Document2.createElement("template");
  slotTemplate11.innerHTML = `
  <slot name="icon">${forwardIcon}</slot>
`;
  var DEFAULT_TIME2 = 0;
  var MediaSeekForwardButton = class extends MediaChromeButton {
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_CURRENT_TIME,
        Attributes9.SEEK_OFFSET
      ];
    }
    constructor(options = {}) {
      super({
        slotTemplate: slotTemplate11,
        tooltipContent: tooltipLabels.SEEK_FORWARD,
        ...options
      });
    }
    connectedCallback() {
      this.seekOffset = getNumericAttr(
        this,
        Attributes9.SEEK_OFFSET,
        DEFAULT_SEEK_OFFSET3
      );
      super.connectedCallback();
    }
    attributeChangedCallback(attrName, _oldValue, newValue) {
      if (attrName === Attributes9.SEEK_OFFSET) {
        this.seekOffset = getNumericAttr(
          this,
          Attributes9.SEEK_OFFSET,
          DEFAULT_SEEK_OFFSET3
        );
      }
      super.attributeChangedCallback(attrName, _oldValue, newValue);
    }
    // Own props
    /**
     * Seek amount in seconds
     */
    get seekOffset() {
      return getNumericAttr(this, Attributes9.SEEK_OFFSET, DEFAULT_SEEK_OFFSET3);
    }
    set seekOffset(value) {
      setNumericAttr(this, Attributes9.SEEK_OFFSET, value);
      this.setAttribute(
        "aria-label",
        verbs.SEEK_FORWARD_N_SECS({ seekOffset: this.seekOffset })
      );
      updateIconText(getSlotted(this, "icon"), this.seekOffset);
    }
    // Props derived from Media UI Attributes
    /**
     * The current time in seconds
     */
    get mediaCurrentTime() {
      return getNumericAttr(
        this,
        MediaUIAttributes.MEDIA_CURRENT_TIME,
        DEFAULT_TIME2
      );
    }
    set mediaCurrentTime(time) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_CURRENT_TIME, time);
    }
    handleClick() {
      const detail = this.mediaCurrentTime + this.seekOffset;
      const evt = new GlobalThis.CustomEvent(MediaUIEvents.MEDIA_SEEK_REQUEST, {
        composed: true,
        bubbles: true,
        detail
      });
      this.dispatchEvent(evt);
    }
  };
  if (!GlobalThis.customElements.get("media-seek-forward-button")) {
    GlobalThis.customElements.define(
      "media-seek-forward-button",
      MediaSeekForwardButton
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-time-display.js
  var __accessCheck16 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet16 = (obj, member, getter) => {
    __accessCheck16(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd16 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet15 = (obj, member, value, setter) => {
    __accessCheck16(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _slot4;
  var Attributes10 = {
    REMAINING: "remaining",
    SHOW_DURATION: "showduration",
    NO_TOGGLE: "notoggle"
  };
  var CombinedAttributes = [
    ...Object.values(Attributes10),
    MediaUIAttributes.MEDIA_CURRENT_TIME,
    MediaUIAttributes.MEDIA_DURATION,
    MediaUIAttributes.MEDIA_SEEKABLE
  ];
  var ButtonPressedKeys2 = ["Enter", " "];
  var DEFAULT_TIMES_SEP = "&nbsp;/&nbsp;";
  var formatTimesLabel = (el, { timesSep = DEFAULT_TIMES_SEP } = {}) => {
    var _a3, _b2;
    const showRemaining = el.hasAttribute(Attributes10.REMAINING);
    const showDuration = el.hasAttribute(Attributes10.SHOW_DURATION);
    const currentTime = (_a3 = el.mediaCurrentTime) != null ? _a3 : 0;
    const [, seekableEnd] = (_b2 = el.mediaSeekable) != null ? _b2 : [];
    let endTime = 0;
    if (Number.isFinite(el.mediaDuration)) {
      endTime = el.mediaDuration;
    } else if (Number.isFinite(seekableEnd)) {
      endTime = seekableEnd;
    }
    const timeLabel = showRemaining ? formatTime(0 - (endTime - currentTime)) : formatTime(currentTime);
    if (!showDuration)
      return timeLabel;
    return `${timeLabel}${timesSep}${formatTime(endTime)}`;
  };
  var DEFAULT_MISSING_TIME_PHRASE = "video not loaded, unknown time.";
  var updateAriaValueText = (el) => {
    var _a3;
    const currentTime = el.mediaCurrentTime;
    const [, seekableEnd] = (_a3 = el.mediaSeekable) != null ? _a3 : [];
    let endTime = null;
    if (Number.isFinite(el.mediaDuration)) {
      endTime = el.mediaDuration;
    } else if (Number.isFinite(seekableEnd)) {
      endTime = seekableEnd;
    }
    if (currentTime == null || endTime === null) {
      el.setAttribute("aria-valuetext", DEFAULT_MISSING_TIME_PHRASE);
      return;
    }
    const showRemaining = el.hasAttribute(Attributes10.REMAINING);
    const showDuration = el.hasAttribute(Attributes10.SHOW_DURATION);
    const currentTimePhrase = showRemaining ? formatAsTimePhrase(0 - (endTime - currentTime)) : formatAsTimePhrase(currentTime);
    if (!showDuration) {
      el.setAttribute("aria-valuetext", currentTimePhrase);
      return;
    }
    const totalTimePhrase = formatAsTimePhrase(endTime);
    const fullPhrase = `${currentTimePhrase} of ${totalTimePhrase}`;
    el.setAttribute("aria-valuetext", fullPhrase);
  };
  var MediaTimeDisplay = class extends MediaTextDisplay {
    constructor() {
      super();
      __privateAdd16(this, _slot4, void 0);
      __privateSet15(this, _slot4, this.shadowRoot.querySelector("slot"));
      __privateGet16(this, _slot4).innerHTML = `${formatTimesLabel(this)}`;
    }
    static get observedAttributes() {
      return [...super.observedAttributes, ...CombinedAttributes, "disabled"];
    }
    connectedCallback() {
      const { style } = getOrInsertCSSRule(
        this.shadowRoot,
        ":host(:hover:not([notoggle]))"
      );
      style.setProperty("cursor", "pointer");
      style.setProperty(
        "background",
        "var(--media-control-hover-background, rgba(50 50 70 / .7))"
      );
      if (!this.hasAttribute("disabled")) {
        this.enable();
      }
      this.setAttribute("role", "progressbar");
      this.setAttribute("aria-label", nouns.PLAYBACK_TIME());
      const keyUpHandler = (evt) => {
        const { key } = evt;
        if (!ButtonPressedKeys2.includes(key)) {
          this.removeEventListener("keyup", keyUpHandler);
          return;
        }
        this.toggleTimeDisplay();
      };
      this.addEventListener("keydown", (evt) => {
        const { metaKey, altKey, key } = evt;
        if (metaKey || altKey || !ButtonPressedKeys2.includes(key)) {
          this.removeEventListener("keyup", keyUpHandler);
          return;
        }
        this.addEventListener("keyup", keyUpHandler);
      });
      this.addEventListener("click", this.toggleTimeDisplay);
      super.connectedCallback();
    }
    toggleTimeDisplay() {
      if (this.noToggle) {
        return;
      }
      if (this.hasAttribute("remaining")) {
        this.removeAttribute("remaining");
      } else {
        this.setAttribute("remaining", "");
      }
    }
    disconnectedCallback() {
      this.disable();
      super.disconnectedCallback();
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      if (CombinedAttributes.includes(attrName)) {
        this.update();
      } else if (attrName === "disabled" && newValue !== oldValue) {
        if (newValue == null) {
          this.enable();
        } else {
          this.disable();
        }
      }
      super.attributeChangedCallback(attrName, oldValue, newValue);
    }
    enable() {
      this.tabIndex = 0;
    }
    disable() {
      this.tabIndex = -1;
    }
    // Own props
    /**
     * Whether to show the remaining time
     */
    get remaining() {
      return getBooleanAttr(this, Attributes10.REMAINING);
    }
    set remaining(show) {
      setBooleanAttr(this, Attributes10.REMAINING, show);
    }
    /**
     * Whether to show the duration
     */
    get showDuration() {
      return getBooleanAttr(this, Attributes10.SHOW_DURATION);
    }
    set showDuration(show) {
      setBooleanAttr(this, Attributes10.SHOW_DURATION, show);
    }
    /**
     * Disable the default behavior that toggles between current and remaining time
     */
    get noToggle() {
      return getBooleanAttr(this, Attributes10.NO_TOGGLE);
    }
    set noToggle(noToggle) {
      setBooleanAttr(this, Attributes10.NO_TOGGLE, noToggle);
    }
    // Props derived from media UI attributes
    /**
     * Get the duration
     */
    get mediaDuration() {
      return getNumericAttr(this, MediaUIAttributes.MEDIA_DURATION);
    }
    set mediaDuration(time) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_DURATION, time);
    }
    /**
     * The current time in seconds
     */
    get mediaCurrentTime() {
      return getNumericAttr(this, MediaUIAttributes.MEDIA_CURRENT_TIME);
    }
    set mediaCurrentTime(time) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_CURRENT_TIME, time);
    }
    /**
     * Range of values that can be seeked to.
     * An array of two numbers [start, end]
     */
    get mediaSeekable() {
      const seekable = this.getAttribute(MediaUIAttributes.MEDIA_SEEKABLE);
      if (!seekable)
        return void 0;
      return seekable.split(":").map((time) => +time);
    }
    set mediaSeekable(range) {
      if (range == null) {
        this.removeAttribute(MediaUIAttributes.MEDIA_SEEKABLE);
        return;
      }
      this.setAttribute(MediaUIAttributes.MEDIA_SEEKABLE, range.join(":"));
    }
    update() {
      const timesLabel = formatTimesLabel(this);
      updateAriaValueText(this);
      if (timesLabel !== __privateGet16(this, _slot4).innerHTML) {
        __privateGet16(this, _slot4).innerHTML = timesLabel;
      }
    }
  };
  _slot4 = /* @__PURE__ */ new WeakMap();
  if (!GlobalThis.customElements.get("media-time-display")) {
    GlobalThis.customElements.define("media-time-display", MediaTimeDisplay);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/range-animation.js
  var __accessCheck17 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet17 = (obj, member, getter) => {
    __accessCheck17(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd17 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet16 = (obj, member, value, setter) => {
    __accessCheck17(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateWrapper = (obj, member, setter, getter) => ({
    set _(value) {
      __privateSet16(obj, member, value, setter);
    },
    get _() {
      return __privateGet17(obj, member, getter);
    }
  });
  var _range;
  var _startTime;
  var _previousTime;
  var _deltaTime;
  var _frameCount;
  var _updateTimestamp;
  var _updateStartValue;
  var _lastRangeIncrease;
  var _id;
  var _animate;
  var RangeAnimation = class {
    constructor(range, callback, fps) {
      __privateAdd17(this, _range, void 0);
      __privateAdd17(this, _startTime, void 0);
      __privateAdd17(this, _previousTime, void 0);
      __privateAdd17(this, _deltaTime, void 0);
      __privateAdd17(this, _frameCount, void 0);
      __privateAdd17(this, _updateTimestamp, void 0);
      __privateAdd17(this, _updateStartValue, void 0);
      __privateAdd17(this, _lastRangeIncrease, void 0);
      __privateAdd17(this, _id, 0);
      __privateAdd17(this, _animate, (now = performance.now()) => {
        __privateSet16(this, _id, requestAnimationFrame(__privateGet17(this, _animate)));
        __privateSet16(this, _deltaTime, performance.now() - __privateGet17(this, _previousTime));
        const fpsInterval = 1e3 / this.fps;
        if (__privateGet17(this, _deltaTime) > fpsInterval) {
          __privateSet16(this, _previousTime, now - __privateGet17(this, _deltaTime) % fpsInterval);
          const fps2 = 1e3 / ((now - __privateGet17(this, _startTime)) / ++__privateWrapper(this, _frameCount)._);
          const delta = (now - __privateGet17(this, _updateTimestamp)) / 1e3 / this.duration;
          let value = __privateGet17(this, _updateStartValue) + delta * this.playbackRate;
          const increase = value - __privateGet17(this, _range).valueAsNumber;
          if (increase > 0) {
            __privateSet16(this, _lastRangeIncrease, this.playbackRate / this.duration / fps2);
          } else {
            __privateSet16(this, _lastRangeIncrease, 0.995 * __privateGet17(this, _lastRangeIncrease));
            value = __privateGet17(this, _range).valueAsNumber + __privateGet17(this, _lastRangeIncrease);
          }
          this.callback(value);
        }
      });
      __privateSet16(this, _range, range);
      this.callback = callback;
      this.fps = fps;
    }
    start() {
      if (__privateGet17(this, _id) !== 0)
        return;
      __privateSet16(this, _previousTime, performance.now());
      __privateSet16(this, _startTime, __privateGet17(this, _previousTime));
      __privateSet16(this, _frameCount, 0);
      __privateGet17(this, _animate).call(this);
    }
    stop() {
      if (__privateGet17(this, _id) === 0)
        return;
      cancelAnimationFrame(__privateGet17(this, _id));
      __privateSet16(this, _id, 0);
    }
    update({ start, duration, playbackRate }) {
      const increase = start - __privateGet17(this, _range).valueAsNumber;
      const durationDelta = Math.abs(duration - this.duration);
      if (increase > 0 || increase < -0.03 || durationDelta >= 0.5) {
        this.callback(start);
      }
      __privateSet16(this, _updateStartValue, start);
      __privateSet16(this, _updateTimestamp, performance.now());
      this.duration = duration;
      this.playbackRate = playbackRate;
    }
  };
  _range = /* @__PURE__ */ new WeakMap();
  _startTime = /* @__PURE__ */ new WeakMap();
  _previousTime = /* @__PURE__ */ new WeakMap();
  _deltaTime = /* @__PURE__ */ new WeakMap();
  _frameCount = /* @__PURE__ */ new WeakMap();
  _updateTimestamp = /* @__PURE__ */ new WeakMap();
  _updateStartValue = /* @__PURE__ */ new WeakMap();
  _lastRangeIncrease = /* @__PURE__ */ new WeakMap();
  _id = /* @__PURE__ */ new WeakMap();
  _animate = /* @__PURE__ */ new WeakMap();

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-time-range.js
  var __accessCheck18 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet18 = (obj, member, getter) => {
    __accessCheck18(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd18 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet17 = (obj, member, value, setter) => {
    __accessCheck18(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateMethod5 = (obj, member, method) => {
    __accessCheck18(obj, member, "access private method");
    return method;
  };
  var _rootNode;
  var _animation;
  var _boxes;
  var _previewTime;
  var _previewBox;
  var _currentBox;
  var _boxPaddingLeft;
  var _boxPaddingRight;
  var _mediaChaptersCues;
  var _toggleRangeAnimation;
  var toggleRangeAnimation_fn;
  var _shouldRangeAnimate;
  var shouldRangeAnimate_fn;
  var _updateRange;
  var _getElementRects;
  var getElementRects_fn;
  var _getBoxPosition;
  var getBoxPosition_fn;
  var _getBoxShiftPosition;
  var getBoxShiftPosition_fn;
  var _handlePointerMove3;
  var handlePointerMove_fn3;
  var _previewRequest;
  var previewRequest_fn;
  var _seekRequest;
  var seekRequest_fn;
  var DEFAULT_MISSING_TIME_PHRASE2 = "video not loaded, unknown time.";
  var updateAriaValueText2 = (el) => {
    const range = el.range;
    const currentTimePhrase = formatAsTimePhrase(+calcTimeFromRangeValue(el));
    const totalTimePhrase = formatAsTimePhrase(+el.mediaSeekableEnd);
    const fullPhrase = !(currentTimePhrase && totalTimePhrase) ? DEFAULT_MISSING_TIME_PHRASE2 : `${currentTimePhrase} of ${totalTimePhrase}`;
    range.setAttribute("aria-valuetext", fullPhrase);
  };
  var template11 = Document2.createElement("template");
  template11.innerHTML = /*html*/
  `
  <style>
    :host {
      --media-box-border-radius: 4px;
      --media-box-padding-left: 10px;
      --media-box-padding-right: 10px;
      --media-preview-border-radius: var(--media-box-border-radius);
      --media-box-arrow-offset: var(--media-box-border-radius);
      --_control-background: var(--media-control-background, var(--media-secondary-color, rgb(20 20 30 / .7)));
      --_preview-background: var(--media-preview-background, var(--_control-background));

      ${/* 1% rail width trick was off in Safari, contain: layout seems to
  prevent the horizontal overflow as well. */
  ""}
      contain: layout;
    }

    #highlight {
      background: var(--media-time-range-buffered-color, rgb(255 255 255 / .4));
    }

    #preview-rail,
    #current-rail {
      width: 100%;
      position: absolute;
      left: 0;
      bottom: 100%;
      pointer-events: none;
      will-change: transform;
    }

    [part~="box"] {
      width: min-content;
      ${/* absolute position is needed here so the box doesn't overflow the bounds */
  ""}
      position: absolute;
      bottom: 100%;
      flex-direction: column;
      align-items: center;
      transform: translateX(-50%);
    }

    [part~="current-box"] {
      display: var(--media-current-box-display, var(--media-box-display, flex));
      margin: var(--media-current-box-margin, var(--media-box-margin, 0 0 5px));
      visibility: hidden;
    }

    [part~="preview-box"] {
      display: var(--media-preview-box-display, var(--media-box-display, flex));
      margin: var(--media-preview-box-margin, var(--media-box-margin, 0 0 5px));
      transition-property: var(--media-preview-transition-property, visibility, opacity);
      transition-duration: var(--media-preview-transition-duration-out, .25s);
      transition-delay: var(--media-preview-transition-delay-out, 0s);
      visibility: hidden;
      opacity: 0;
    }

    :host(:is([${MediaUIAttributes.MEDIA_PREVIEW_IMAGE}], [${MediaUIAttributes.MEDIA_PREVIEW_TIME}])[dragging]) [part~="preview-box"] {
      transition-duration: var(--media-preview-transition-duration-in, .5s);
      transition-delay: var(--media-preview-transition-delay-in, .25s);
      visibility: visible;
      opacity: 1;
    }

    @media (hover: hover) {
      :host(:is([${MediaUIAttributes.MEDIA_PREVIEW_IMAGE}], [${MediaUIAttributes.MEDIA_PREVIEW_TIME}]):hover) [part~="preview-box"] {
        transition-duration: var(--media-preview-transition-duration-in, .5s);
        transition-delay: var(--media-preview-transition-delay-in, .25s);
        visibility: visible;
        opacity: 1;
      }
    }

    media-preview-thumbnail,
    ::slotted(media-preview-thumbnail) {
      visibility: hidden;
      ${/* delay changing these CSS props until the preview box transition is ended */
  ""}
      transition: visibility 0s .25s;
      transition-delay: calc(var(--media-preview-transition-delay-out, 0s) + var(--media-preview-transition-duration-out, .25s));
      background: var(--media-preview-thumbnail-background, var(--_preview-background));
      box-shadow: var(--media-preview-thumbnail-box-shadow, 0 0 4px rgb(0 0 0 / .2));
      max-width: var(--media-preview-thumbnail-max-width, 180px);
      max-height: var(--media-preview-thumbnail-max-height, 160px);
      min-width: var(--media-preview-thumbnail-min-width, 120px);
      min-height: var(--media-preview-thumbnail-min-height, 80px);
      border: var(--media-preview-thumbnail-border);
      border-radius: var(--media-preview-thumbnail-border-radius,
        var(--media-preview-border-radius) var(--media-preview-border-radius) 0 0);
    }

    :host([${MediaUIAttributes.MEDIA_PREVIEW_IMAGE}][dragging]) media-preview-thumbnail,
    :host([${MediaUIAttributes.MEDIA_PREVIEW_IMAGE}][dragging]) ::slotted(media-preview-thumbnail) {
      transition-delay: var(--media-preview-transition-delay-in, .25s);
      visibility: visible;
    }

    @media (hover: hover) {
      :host([${MediaUIAttributes.MEDIA_PREVIEW_IMAGE}]:hover) media-preview-thumbnail,
      :host([${MediaUIAttributes.MEDIA_PREVIEW_IMAGE}]:hover) ::slotted(media-preview-thumbnail) {
        transition-delay: var(--media-preview-transition-delay-in, .25s);
        visibility: visible;
      }

      :host([${MediaUIAttributes.MEDIA_PREVIEW_TIME}]:hover) {
        --media-time-range-hover-display: block;
      }
    }

    media-preview-chapter-display,
    ::slotted(media-preview-chapter-display) {
      font-size: var(--media-font-size, 13px);
      line-height: 17px;
      min-width: 0;
      visibility: hidden;
      ${/* delay changing these CSS props until the preview box transition is ended */
  ""}
      transition: min-width 0s, border-radius 0s, margin 0s, padding 0s, visibility 0s;
      transition-delay: calc(var(--media-preview-transition-delay-out, 0s) + var(--media-preview-transition-duration-out, .25s));
      background: var(--media-preview-chapter-background, var(--_preview-background));
      border-radius: var(--media-preview-chapter-border-radius,
        var(--media-preview-border-radius) var(--media-preview-border-radius)
        var(--media-preview-border-radius) var(--media-preview-border-radius));
      padding: var(--media-preview-chapter-padding, 3.5px 9px);
      margin: var(--media-preview-chapter-margin, 0 0 5px);
      text-shadow: var(--media-preview-chapter-text-shadow, 0 0 4px rgb(0 0 0 / .75));
    }

    :host([${MediaUIAttributes.MEDIA_PREVIEW_IMAGE}]) media-preview-chapter-display,
    :host([${MediaUIAttributes.MEDIA_PREVIEW_IMAGE}]) ::slotted(media-preview-chapter-display) {
      transition-delay: var(--media-preview-transition-delay-in, .25s);
      border-radius: var(--media-preview-chapter-border-radius, 0);
      padding: var(--media-preview-chapter-padding, 3.5px 9px 0);
      margin: var(--media-preview-chapter-margin, 0);
      min-width: 100%;
    }

    media-preview-chapter-display[${MediaUIAttributes.MEDIA_PREVIEW_CHAPTER}],
    ::slotted(media-preview-chapter-display[${MediaUIAttributes.MEDIA_PREVIEW_CHAPTER}]) {
      visibility: visible;
    }

    media-preview-chapter-display:not([aria-valuetext]),
    ::slotted(media-preview-chapter-display:not([aria-valuetext])) {
      display: none;
    }

    media-preview-time-display,
    ::slotted(media-preview-time-display),
    media-time-display,
    ::slotted(media-time-display) {
      font-size: var(--media-font-size, 13px);
      line-height: 17px;
      min-width: 0;
      ${/* delay changing these CSS props until the preview box transition is ended */
  ""}
      transition: min-width 0s, border-radius 0s;
      transition-delay: calc(var(--media-preview-transition-delay-out, 0s) + var(--media-preview-transition-duration-out, .25s));
      background: var(--media-preview-time-background, var(--_preview-background));
      border-radius: var(--media-preview-time-border-radius,
        var(--media-preview-border-radius) var(--media-preview-border-radius)
        var(--media-preview-border-radius) var(--media-preview-border-radius));
      padding: var(--media-preview-time-padding, 3.5px 9px);
      margin: var(--media-preview-time-margin, 0);
      text-shadow: var(--media-preview-time-text-shadow, 0 0 4px rgb(0 0 0 / .75));
      transform: translateX(min(
        max(calc(50% - var(--_box-width) / 2),
        calc(var(--_box-shift, 0))),
        calc(var(--_box-width) / 2 - 50%)
      ));
    }

    :host([${MediaUIAttributes.MEDIA_PREVIEW_IMAGE}]) media-preview-time-display,
    :host([${MediaUIAttributes.MEDIA_PREVIEW_IMAGE}]) ::slotted(media-preview-time-display) {
      transition-delay: var(--media-preview-transition-delay-in, .25s);
      border-radius: var(--media-preview-time-border-radius,
        0 0 var(--media-preview-border-radius) var(--media-preview-border-radius));
      min-width: 100%;
    }

    :host([${MediaUIAttributes.MEDIA_PREVIEW_TIME}]:hover) {
      --media-time-range-hover-display: block;
    }

    [part~="arrow"],
    ::slotted([part~="arrow"]) {
      display: var(--media-box-arrow-display, inline-block);
      transform: translateX(min(
        max(calc(50% - var(--_box-width) / 2 + var(--media-box-arrow-offset)),
        calc(var(--_box-shift, 0))),
        calc(var(--_box-width) / 2 - 50% - var(--media-box-arrow-offset))
      ));
      ${/* border-color has to come before border-top-color! */
  ""}
      border-color: transparent;
      border-top-color: var(--media-box-arrow-background, var(--_control-background));
      border-width: var(--media-box-arrow-border-width,
        var(--media-box-arrow-height, 5px) var(--media-box-arrow-width, 6px) 0);
      border-style: solid;
      justify-content: center;
      height: 0;
    }
  </style>
  <div id="preview-rail">
    <slot name="preview" part="box preview-box">
      <media-preview-thumbnail></media-preview-thumbnail>
      <media-preview-chapter-display></media-preview-chapter-display>
      <media-preview-time-display></media-preview-time-display>
      <slot name="preview-arrow"><div part="arrow"></div></slot>
    </slot>
  </div>
  <div id="current-rail">
    <slot name="current" part="box current-box">
      ${/* Example: add the current time w/ arrow to the playhead
  <media-time-display slot="current"></media-time-display>
  <div part="arrow" slot="current"></div> */
  ""}
    </slot>
  </div>
`;
  var calcRangeValueFromTime = (el, time = el.mediaCurrentTime) => {
    const startTime = Number.isFinite(el.mediaSeekableStart) ? el.mediaSeekableStart : 0;
    const endTime = Number.isFinite(el.mediaDuration) ? el.mediaDuration : el.mediaSeekableEnd;
    if (Number.isNaN(endTime))
      return 0;
    const value = (time - startTime) / (endTime - startTime);
    return Math.max(0, Math.min(value, 1));
  };
  var calcTimeFromRangeValue = (el, value = el.range.valueAsNumber) => {
    const startTime = Number.isFinite(el.mediaSeekableStart) ? el.mediaSeekableStart : 0;
    const endTime = Number.isFinite(el.mediaDuration) ? el.mediaDuration : el.mediaSeekableEnd;
    if (Number.isNaN(endTime))
      return 0;
    return value * (endTime - startTime) + startTime;
  };
  var MediaTimeRange = class extends MediaChromeRange {
    constructor() {
      super();
      __privateAdd18(this, _toggleRangeAnimation);
      __privateAdd18(this, _shouldRangeAnimate);
      __privateAdd18(this, _getElementRects);
      __privateAdd18(this, _getBoxPosition);
      __privateAdd18(this, _getBoxShiftPosition);
      __privateAdd18(this, _handlePointerMove3);
      __privateAdd18(this, _previewRequest);
      __privateAdd18(this, _seekRequest);
      __privateAdd18(this, _rootNode, void 0);
      __privateAdd18(this, _animation, void 0);
      __privateAdd18(this, _boxes, void 0);
      __privateAdd18(this, _previewTime, void 0);
      __privateAdd18(this, _previewBox, void 0);
      __privateAdd18(this, _currentBox, void 0);
      __privateAdd18(this, _boxPaddingLeft, void 0);
      __privateAdd18(this, _boxPaddingRight, void 0);
      __privateAdd18(this, _mediaChaptersCues, void 0);
      __privateAdd18(this, _updateRange, (value) => {
        if (this.dragging)
          return;
        this.range.valueAsNumber = value;
        this.updateBar();
      });
      this.container.appendChild(template11.content.cloneNode(true));
      __privateSet17(this, _boxes, this.shadowRoot.querySelectorAll('[part~="box"]'));
      __privateSet17(this, _previewBox, this.shadowRoot.querySelector('[part~="preview-box"]'));
      __privateSet17(this, _currentBox, this.shadowRoot.querySelector('[part~="current-box"]'));
      const computedStyle = getComputedStyle(this);
      __privateSet17(this, _boxPaddingLeft, parseInt(
        computedStyle.getPropertyValue("--media-box-padding-left")
      ));
      __privateSet17(this, _boxPaddingRight, parseInt(
        computedStyle.getPropertyValue("--media-box-padding-right")
      ));
      __privateSet17(this, _animation, new RangeAnimation(this.range, __privateGet18(this, _updateRange), 60));
    }
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_PAUSED,
        MediaUIAttributes.MEDIA_DURATION,
        MediaUIAttributes.MEDIA_SEEKABLE,
        MediaUIAttributes.MEDIA_CURRENT_TIME,
        MediaUIAttributes.MEDIA_PREVIEW_IMAGE,
        MediaUIAttributes.MEDIA_PREVIEW_TIME,
        MediaUIAttributes.MEDIA_PREVIEW_CHAPTER,
        MediaUIAttributes.MEDIA_BUFFERED,
        MediaUIAttributes.MEDIA_PLAYBACK_RATE,
        MediaUIAttributes.MEDIA_LOADING,
        MediaUIAttributes.MEDIA_ENDED
      ];
    }
    connectedCallback() {
      var _a3;
      super.connectedCallback();
      this.range.setAttribute("aria-label", nouns.SEEK());
      __privateMethod5(this, _toggleRangeAnimation, toggleRangeAnimation_fn).call(this);
      __privateSet17(this, _rootNode, this.getRootNode());
      (_a3 = __privateGet18(this, _rootNode)) == null ? void 0 : _a3.addEventListener("transitionstart", this);
    }
    disconnectedCallback() {
      var _a3;
      super.disconnectedCallback();
      __privateMethod5(this, _toggleRangeAnimation, toggleRangeAnimation_fn).call(this);
      (_a3 = __privateGet18(this, _rootNode)) == null ? void 0 : _a3.removeEventListener("transitionstart", this);
      __privateSet17(this, _rootNode, null);
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (oldValue == newValue)
        return;
      if (attrName === MediaUIAttributes.MEDIA_CURRENT_TIME || attrName === MediaUIAttributes.MEDIA_PAUSED || attrName === MediaUIAttributes.MEDIA_ENDED || attrName === MediaUIAttributes.MEDIA_LOADING || attrName === MediaUIAttributes.MEDIA_DURATION || attrName === MediaUIAttributes.MEDIA_SEEKABLE) {
        __privateGet18(this, _animation).update({
          start: calcRangeValueFromTime(this),
          duration: this.mediaSeekableEnd - this.mediaSeekableStart,
          playbackRate: this.mediaPlaybackRate
        });
        __privateMethod5(this, _toggleRangeAnimation, toggleRangeAnimation_fn).call(this);
        updateAriaValueText2(this);
      } else if (attrName === MediaUIAttributes.MEDIA_BUFFERED) {
        this.updateBufferedBar();
      }
      if (attrName === MediaUIAttributes.MEDIA_DURATION || attrName === MediaUIAttributes.MEDIA_SEEKABLE) {
        this.mediaChaptersCues = __privateGet18(this, _mediaChaptersCues);
        this.updateBar();
      }
    }
    get mediaChaptersCues() {
      return __privateGet18(this, _mediaChaptersCues);
    }
    set mediaChaptersCues(value) {
      var _a3;
      __privateSet17(this, _mediaChaptersCues, value);
      this.updateSegments(
        (_a3 = __privateGet18(this, _mediaChaptersCues)) == null ? void 0 : _a3.map((c) => ({
          start: calcRangeValueFromTime(this, c.startTime),
          end: calcRangeValueFromTime(this, c.endTime)
        }))
      );
    }
    /**
     * Is the media paused
     */
    get mediaPaused() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_PAUSED);
    }
    set mediaPaused(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_PAUSED, value);
    }
    /**
     * Is the media loading
     */
    get mediaLoading() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_LOADING);
    }
    set mediaLoading(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_LOADING, value);
    }
    /**
     *
     */
    get mediaDuration() {
      return getNumericAttr(this, MediaUIAttributes.MEDIA_DURATION);
    }
    set mediaDuration(value) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_DURATION, value);
    }
    /**
     *
     */
    get mediaCurrentTime() {
      return getNumericAttr(this, MediaUIAttributes.MEDIA_CURRENT_TIME);
    }
    set mediaCurrentTime(value) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_CURRENT_TIME, value);
    }
    /**
     *
     */
    get mediaPlaybackRate() {
      return getNumericAttr(this, MediaUIAttributes.MEDIA_PLAYBACK_RATE, 1);
    }
    set mediaPlaybackRate(value) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_PLAYBACK_RATE, value);
    }
    /**
     * An array of ranges, each range being an array of two numbers.
     * e.g. [[1, 2], [3, 4]]
     */
    get mediaBuffered() {
      const buffered = this.getAttribute(MediaUIAttributes.MEDIA_BUFFERED);
      if (!buffered)
        return [];
      return buffered.split(" ").map((timePair) => timePair.split(":").map((timeStr) => +timeStr));
    }
    set mediaBuffered(list) {
      if (!list) {
        this.removeAttribute(MediaUIAttributes.MEDIA_BUFFERED);
        return;
      }
      const strVal = list.map((tuple) => tuple.join(":")).join(" ");
      this.setAttribute(MediaUIAttributes.MEDIA_BUFFERED, strVal);
    }
    /**
     * Range of values that can be seeked to
     * An array of two numbers [start, end]
     */
    get mediaSeekable() {
      const seekable = this.getAttribute(MediaUIAttributes.MEDIA_SEEKABLE);
      if (!seekable)
        return void 0;
      return seekable.split(":").map((time) => +time);
    }
    set mediaSeekable(range) {
      if (range == null) {
        this.removeAttribute(MediaUIAttributes.MEDIA_SEEKABLE);
        return;
      }
      this.setAttribute(MediaUIAttributes.MEDIA_SEEKABLE, range.join(":"));
    }
    /**
     *
     */
    get mediaSeekableEnd() {
      var _a3;
      const [, end = this.mediaDuration] = (_a3 = this.mediaSeekable) != null ? _a3 : [];
      return end;
    }
    get mediaSeekableStart() {
      var _a3;
      const [start = 0] = (_a3 = this.mediaSeekable) != null ? _a3 : [];
      return start;
    }
    /**
     * The url of the preview image
     */
    get mediaPreviewImage() {
      return getStringAttr(this, MediaUIAttributes.MEDIA_PREVIEW_IMAGE);
    }
    set mediaPreviewImage(value) {
      setStringAttr(this, MediaUIAttributes.MEDIA_PREVIEW_IMAGE, value);
    }
    /**
     *
     */
    get mediaPreviewTime() {
      return getNumericAttr(this, MediaUIAttributes.MEDIA_PREVIEW_TIME);
    }
    set mediaPreviewTime(value) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_PREVIEW_TIME, value);
    }
    /**
     *
     */
    get mediaEnded() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_ENDED);
    }
    set mediaEnded(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_ENDED, value);
    }
    /* Add a buffered progress bar */
    updateBar() {
      super.updateBar();
      this.updateBufferedBar();
      this.updateCurrentBox();
    }
    updateBufferedBar() {
      var _a3;
      const buffered = this.mediaBuffered;
      if (!buffered.length) {
        return;
      }
      let relativeBufferedEnd;
      if (!this.mediaEnded) {
        const currentTime = this.mediaCurrentTime;
        const [, bufferedEnd = this.mediaSeekableStart] = (_a3 = buffered.find(
          ([start, end]) => start <= currentTime && currentTime <= end
        )) != null ? _a3 : [];
        relativeBufferedEnd = calcRangeValueFromTime(this, bufferedEnd);
      } else {
        relativeBufferedEnd = 1;
      }
      const { style } = getOrInsertCSSRule(this.shadowRoot, "#highlight");
      style.setProperty("width", `${relativeBufferedEnd * 100}%`);
    }
    updateCurrentBox() {
      const currentSlot = this.shadowRoot.querySelector(
        'slot[name="current"]'
      );
      if (!currentSlot.assignedElements().length)
        return;
      const currentRailRule = getOrInsertCSSRule(
        this.shadowRoot,
        "#current-rail"
      );
      const currentBoxRule = getOrInsertCSSRule(
        this.shadowRoot,
        '[part~="current-box"]'
      );
      const rects = __privateMethod5(this, _getElementRects, getElementRects_fn).call(this, __privateGet18(this, _currentBox));
      const boxPos = __privateMethod5(this, _getBoxPosition, getBoxPosition_fn).call(this, rects, this.range.valueAsNumber);
      const boxShift = __privateMethod5(this, _getBoxShiftPosition, getBoxShiftPosition_fn).call(this, rects, this.range.valueAsNumber);
      currentRailRule.style.transform = `translateX(${boxPos})`;
      currentRailRule.style.setProperty("--_range-width", `${rects.range.width}`);
      currentBoxRule.style.setProperty("--_box-shift", `${boxShift}`);
      currentBoxRule.style.setProperty("--_box-width", `${rects.box.width}px`);
      currentBoxRule.style.setProperty("visibility", "initial");
    }
    handleEvent(evt) {
      super.handleEvent(evt);
      switch (evt.type) {
        case "input":
          __privateMethod5(this, _seekRequest, seekRequest_fn).call(this);
          break;
        case "pointermove":
          __privateMethod5(this, _handlePointerMove3, handlePointerMove_fn3).call(this, evt);
          break;
        case "pointerup":
        case "pointerleave":
          __privateMethod5(this, _previewRequest, previewRequest_fn).call(this, null);
          break;
        case "transitionstart":
          if (containsComposedNode(evt.target, this)) {
            setTimeout(() => __privateMethod5(this, _toggleRangeAnimation, toggleRangeAnimation_fn).call(this), 0);
          }
          break;
      }
    }
  };
  _rootNode = /* @__PURE__ */ new WeakMap();
  _animation = /* @__PURE__ */ new WeakMap();
  _boxes = /* @__PURE__ */ new WeakMap();
  _previewTime = /* @__PURE__ */ new WeakMap();
  _previewBox = /* @__PURE__ */ new WeakMap();
  _currentBox = /* @__PURE__ */ new WeakMap();
  _boxPaddingLeft = /* @__PURE__ */ new WeakMap();
  _boxPaddingRight = /* @__PURE__ */ new WeakMap();
  _mediaChaptersCues = /* @__PURE__ */ new WeakMap();
  _toggleRangeAnimation = /* @__PURE__ */ new WeakSet();
  toggleRangeAnimation_fn = function() {
    if (__privateMethod5(this, _shouldRangeAnimate, shouldRangeAnimate_fn).call(this)) {
      __privateGet18(this, _animation).start();
    } else {
      __privateGet18(this, _animation).stop();
    }
  };
  _shouldRangeAnimate = /* @__PURE__ */ new WeakSet();
  shouldRangeAnimate_fn = function() {
    return this.isConnected && !this.mediaPaused && !this.mediaLoading && !this.mediaEnded && this.mediaSeekableEnd > 0 && isElementVisible(this);
  };
  _updateRange = /* @__PURE__ */ new WeakMap();
  _getElementRects = /* @__PURE__ */ new WeakSet();
  getElementRects_fn = function(box) {
    var _a3;
    const bounds = (_a3 = this.getAttribute("bounds") ? closestComposedNode(this, `#${this.getAttribute("bounds")}`) : this.parentElement) != null ? _a3 : this;
    const boundsRect = bounds.getBoundingClientRect();
    const rangeRect = this.range.getBoundingClientRect();
    const width = box.offsetWidth;
    const min = -(rangeRect.left - boundsRect.left - width / 2);
    const max = boundsRect.right - rangeRect.left - width / 2;
    return {
      box: { width, min, max },
      bounds: boundsRect,
      range: rangeRect
    };
  };
  _getBoxPosition = /* @__PURE__ */ new WeakSet();
  getBoxPosition_fn = function(rects, ratio) {
    let position = `${ratio * 100}%`;
    const { width, min, max } = rects.box;
    if (!width)
      return position;
    if (!Number.isNaN(min)) {
      const pad = `var(--media-box-padding-left)`;
      const minPos = `calc(1 / var(--_range-width) * 100 * ${min}% + ${pad})`;
      position = `max(${minPos}, ${position})`;
    }
    if (!Number.isNaN(max)) {
      const pad = `var(--media-box-padding-right)`;
      const maxPos = `calc(1 / var(--_range-width) * 100 * ${max}% - ${pad})`;
      position = `min(${position}, ${maxPos})`;
    }
    return position;
  };
  _getBoxShiftPosition = /* @__PURE__ */ new WeakSet();
  getBoxShiftPosition_fn = function(rects, ratio) {
    const { width, min, max } = rects.box;
    const pointerX = ratio * rects.range.width;
    if (pointerX < min + __privateGet18(this, _boxPaddingLeft)) {
      const offset = rects.range.left - rects.bounds.left - __privateGet18(this, _boxPaddingLeft);
      return `${pointerX - width / 2 + offset}px`;
    }
    if (pointerX > max - __privateGet18(this, _boxPaddingRight)) {
      const offset = rects.bounds.right - rects.range.right - __privateGet18(this, _boxPaddingRight);
      return `${pointerX + width / 2 - offset - rects.range.width}px`;
    }
    return 0;
  };
  _handlePointerMove3 = /* @__PURE__ */ new WeakSet();
  handlePointerMove_fn3 = function(evt) {
    const isOverBoxes = [...__privateGet18(this, _boxes)].some(
      (b) => evt.composedPath().includes(b)
    );
    if (!this.dragging && (isOverBoxes || !evt.composedPath().includes(this))) {
      __privateMethod5(this, _previewRequest, previewRequest_fn).call(this, null);
      return;
    }
    const duration = this.mediaSeekableEnd;
    if (!duration)
      return;
    const previewRailRule = getOrInsertCSSRule(
      this.shadowRoot,
      "#preview-rail"
    );
    const previewBoxRule = getOrInsertCSSRule(
      this.shadowRoot,
      '[part~="preview-box"]'
    );
    const rects = __privateMethod5(this, _getElementRects, getElementRects_fn).call(this, __privateGet18(this, _previewBox));
    let pointerRatio = (evt.clientX - rects.range.left) / rects.range.width;
    pointerRatio = Math.max(0, Math.min(1, pointerRatio));
    const boxPos = __privateMethod5(this, _getBoxPosition, getBoxPosition_fn).call(this, rects, pointerRatio);
    const boxShift = __privateMethod5(this, _getBoxShiftPosition, getBoxShiftPosition_fn).call(this, rects, pointerRatio);
    previewRailRule.style.transform = `translateX(${boxPos})`;
    previewRailRule.style.setProperty("--_range-width", `${rects.range.width}`);
    previewBoxRule.style.setProperty("--_box-shift", `${boxShift}`);
    previewBoxRule.style.setProperty("--_box-width", `${rects.box.width}px`);
    const diff = Math.round(__privateGet18(this, _previewTime)) - Math.round(pointerRatio * duration);
    if (Math.abs(diff) < 1 && pointerRatio > 0.01 && pointerRatio < 0.99)
      return;
    __privateSet17(this, _previewTime, pointerRatio * duration);
    __privateMethod5(this, _previewRequest, previewRequest_fn).call(this, __privateGet18(this, _previewTime));
  };
  _previewRequest = /* @__PURE__ */ new WeakSet();
  previewRequest_fn = function(detail) {
    this.dispatchEvent(
      new GlobalThis.CustomEvent(MediaUIEvents.MEDIA_PREVIEW_REQUEST, {
        composed: true,
        bubbles: true,
        detail
      })
    );
  };
  _seekRequest = /* @__PURE__ */ new WeakSet();
  seekRequest_fn = function() {
    __privateGet18(this, _animation).stop();
    const detail = calcTimeFromRangeValue(this);
    this.dispatchEvent(
      new GlobalThis.CustomEvent(MediaUIEvents.MEDIA_SEEK_REQUEST, {
        composed: true,
        bubbles: true,
        detail
      })
    );
  };
  if (!GlobalThis.customElements.get("media-time-range")) {
    GlobalThis.customElements.define("media-time-range", MediaTimeRange);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-tooltip.js
  var Attributes11 = {
    PLACEMENT: "placement",
    BOUNDS: "bounds"
  };
  var template12 = Document2.createElement("template");
  template12.innerHTML = /*html*/
  `
  <style>
    :host {
      --_tooltip-background-color: var(--media-tooltip-background-color, var(--media-secondary-color, rgba(20, 20, 30, .7)));
      --_tooltip-background: var(--media-tooltip-background, var(--_tooltip-background-color));
      --_tooltip-arrow-half-width: calc(var(--media-tooltip-arrow-width, 12px) / 2);
      --_tooltip-arrow-height: var(--media-tooltip-arrow-height, 5px);
      --_tooltip-arrow-background: var(--media-tooltip-arrow-color, var(--_tooltip-background-color));
      position: relative;
      pointer-events: none;
      display: var(--media-tooltip-display, inline-flex);
      justify-content: center;
      align-items: center;
      box-sizing: border-box;
      z-index: var(--media-tooltip-z-index, 1);
      background: var(--_tooltip-background);
      color: var(--media-text-color, var(--media-primary-color, rgb(238 238 238)));
      font: var(--media-font,
        var(--media-font-weight, 400)
        var(--media-font-size, 13px) /
        var(--media-text-content-height, var(--media-control-height, 18px))
        var(--media-font-family, helvetica neue, segoe ui, roboto, arial, sans-serif));
      padding: var(--media-tooltip-padding, .35em .7em);
      border: var(--media-tooltip-border, none);
      border-radius: var(--media-tooltip-border-radius, 5px);
      filter: var(--media-tooltip-filter, drop-shadow(0 0 4px rgba(0, 0, 0, .2)));
      white-space: var(--media-tooltip-white-space, nowrap);
    }

    :host([hidden]) {
      display: none;
    }

    img, svg {
      display: inline-block;
    }

    #arrow {
      position: absolute;
      width: 0px;
      height: 0px;
      border-style: solid;
      display: var(--media-tooltip-arrow-display, block);
    }

    :host(:not([placement])),
    :host([placement="top"]) {
      position: absolute;
      bottom: calc(100% + var(--media-tooltip-distance, 12px));
      left: 50%;
      transform: translate(calc(-50% - var(--media-tooltip-offset-x, 0px)), 0);
    }
    :host(:not([placement])) #arrow,
    :host([placement="top"]) #arrow {
      top: 100%;
      left: 50%;
      border-width: var(--_tooltip-arrow-height) var(--_tooltip-arrow-half-width) 0 var(--_tooltip-arrow-half-width);
      border-color: var(--_tooltip-arrow-background) transparent transparent transparent;
      transform: translate(calc(-50% + var(--media-tooltip-offset-x, 0px)), 0);
    }

    :host([placement="right"]) {
      position: absolute;
      left: calc(100% + var(--media-tooltip-distance, 12px));
      top: 50%;
      transform: translate(0, -50%);
    }
    :host([placement="right"]) #arrow {
      top: 50%;
      right: 100%;
      border-width: var(--_tooltip-arrow-half-width) var(--_tooltip-arrow-height) var(--_tooltip-arrow-half-width) 0;
      border-color: transparent var(--_tooltip-arrow-background) transparent transparent;
      transform: translate(0, -50%);
    }

    :host([placement="bottom"]) {
      position: absolute;
      top: calc(100% + var(--media-tooltip-distance, 12px));
      left: 50%;
      transform: translate(calc(-50% - var(--media-tooltip-offset-x, 0px)), 0);
    }
    :host([placement="bottom"]) #arrow {
      bottom: 100%;
      left: 50%;
      border-width: 0 var(--_tooltip-arrow-half-width) var(--_tooltip-arrow-height) var(--_tooltip-arrow-half-width);
      border-color: transparent transparent var(--_tooltip-arrow-background) transparent;
      transform: translate(calc(-50% + var(--media-tooltip-offset-x, 0px)), 0);
    }

    :host([placement="left"]) {
      position: absolute;
      right: calc(100% + var(--media-tooltip-distance, 12px));
      top: 50%;
      transform: translate(0, -50%);
    }
    :host([placement="left"]) #arrow {
      top: 50%;
      left: 100%;
      border-width: var(--_tooltip-arrow-half-width) 0 var(--_tooltip-arrow-half-width) var(--_tooltip-arrow-height);
      border-color: transparent transparent transparent var(--_tooltip-arrow-background);
      transform: translate(0, -50%);
    }
    
    :host([placement="none"]) #arrow {
      display: none;
    }

  </style>
  <slot></slot>
  <div id="arrow"></div>
`;
  var MediaTooltip = class extends GlobalThis.HTMLElement {
    constructor() {
      super();
      this.updateXOffset = () => {
        var _a3;
        const placement = this.placement;
        if (placement === "left" || placement === "right") {
          this.style.removeProperty("--media-tooltip-offset-x");
          return;
        }
        const tooltipStyle = getComputedStyle(this);
        const containingEl = (_a3 = closestComposedNode(this, "#" + this.bounds)) != null ? _a3 : getMediaController(this);
        if (!containingEl)
          return;
        const { x: containerX, width: containerWidth } = containingEl.getBoundingClientRect();
        const { x: tooltipX, width: tooltipWidth } = this.getBoundingClientRect();
        const tooltipRight = tooltipX + tooltipWidth;
        const containerRight = containerX + containerWidth;
        const offsetXVal = tooltipStyle.getPropertyValue(
          "--media-tooltip-offset-x"
        );
        const currOffsetX = offsetXVal ? parseFloat(offsetXVal.replace("px", "")) : 0;
        const marginVal = tooltipStyle.getPropertyValue(
          "--media-tooltip-container-margin"
        );
        const currMargin = marginVal ? parseFloat(marginVal.replace("px", "")) : 0;
        const leftDiff = tooltipX - containerX + currOffsetX - currMargin;
        const rightDiff = tooltipRight - containerRight + currOffsetX + currMargin;
        if (leftDiff < 0) {
          this.style.setProperty("--media-tooltip-offset-x", `${leftDiff}px`);
          return;
        }
        if (rightDiff > 0) {
          this.style.setProperty("--media-tooltip-offset-x", `${rightDiff}px`);
          return;
        }
        this.style.removeProperty("--media-tooltip-offset-x");
      };
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        this.shadowRoot.appendChild(template12.content.cloneNode(true));
      }
      this.arrowEl = this.shadowRoot.querySelector("#arrow");
      if (Object.prototype.hasOwnProperty.call(this, "placement")) {
        const placement = this.placement;
        delete this.placement;
        this.placement = placement;
      }
    }
    static get observedAttributes() {
      return [Attributes11.PLACEMENT, Attributes11.BOUNDS];
    }
    /**
     * Get or set tooltip placement
     */
    get placement() {
      return getStringAttr(this, Attributes11.PLACEMENT);
    }
    set placement(value) {
      setStringAttr(this, Attributes11.PLACEMENT, value);
    }
    /**
     * Get or set tooltip container ID selector that will constrain the tooltips
     * horizontal position.
     */
    get bounds() {
      return getStringAttr(this, Attributes11.BOUNDS);
    }
    set bounds(value) {
      setStringAttr(this, Attributes11.BOUNDS, value);
    }
  };
  if (!GlobalThis.customElements.get("media-tooltip")) {
    GlobalThis.customElements.define("media-tooltip", MediaTooltip);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-volume-range.js
  var DEFAULT_VOLUME = 1;
  var toVolume = (el) => {
    if (el.mediaMuted)
      return 0;
    return el.mediaVolume;
  };
  var formatAsPercentString = ({ value }) => `${Math.round(value * 100)}%`;
  var MediaVolumeRange = class extends MediaChromeRange {
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_VOLUME,
        MediaUIAttributes.MEDIA_MUTED,
        MediaUIAttributes.MEDIA_VOLUME_UNAVAILABLE
      ];
    }
    constructor() {
      super();
      this.range.addEventListener("input", () => {
        const detail = this.range.value;
        const evt = new GlobalThis.CustomEvent(
          MediaUIEvents.MEDIA_VOLUME_REQUEST,
          {
            composed: true,
            bubbles: true,
            detail
          }
        );
        this.dispatchEvent(evt);
      });
    }
    connectedCallback() {
      super.connectedCallback();
      this.range.setAttribute("aria-label", nouns.VOLUME());
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_VOLUME || attrName === MediaUIAttributes.MEDIA_MUTED) {
        this.range.valueAsNumber = toVolume(this);
        this.range.setAttribute(
          "aria-valuetext",
          formatAsPercentString(this.range)
        );
        this.updateBar();
      }
    }
    /**
     *
     */
    get mediaVolume() {
      return getNumericAttr(this, MediaUIAttributes.MEDIA_VOLUME, DEFAULT_VOLUME);
    }
    set mediaVolume(value) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_VOLUME, value);
    }
    /**
     * Is the media currently muted
     */
    get mediaMuted() {
      return getBooleanAttr(this, MediaUIAttributes.MEDIA_MUTED);
    }
    set mediaMuted(value) {
      setBooleanAttr(this, MediaUIAttributes.MEDIA_MUTED, value);
    }
    /**
     * The volume unavailability state
     */
    get mediaVolumeUnavailable() {
      return getStringAttr(this, MediaUIAttributes.MEDIA_VOLUME_UNAVAILABLE);
    }
    set mediaVolumeUnavailable(value) {
      setStringAttr(this, MediaUIAttributes.MEDIA_VOLUME_UNAVAILABLE, value);
    }
  };
  if (!GlobalThis.customElements.get("media-volume-range")) {
    GlobalThis.customElements.define("media-volume-range", MediaVolumeRange);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/template-parts.js
  var __accessCheck19 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet19 = (obj, member, getter) => {
    __accessCheck19(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd19 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet18 = (obj, member, value, setter) => {
    __accessCheck19(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _parts;
  var _processor;
  var _items;
  var _value;
  var _element;
  var _attributeName;
  var _namespaceURI;
  var _list;
  var list_get;
  var _parentNode;
  var _nodes;
  var ELEMENT = 1;
  var STRING = 0;
  var PART = 1;
  var defaultProcessor = {
    processCallback(instance, parts, state) {
      if (!state)
        return;
      for (const [expression, part] of parts) {
        if (expression in state) {
          const value = state[expression];
          if (typeof value === "boolean" && part instanceof AttrPart && typeof part.element[part.attributeName] === "boolean") {
            part.booleanValue = value;
          } else if (typeof value === "function" && part instanceof AttrPart) {
            part.element[part.attributeName] = value;
          } else {
            part.value = value;
          }
        }
      }
    }
  };
  var TemplateInstance = class extends GlobalThis.DocumentFragment {
    constructor(template19, state, processor2 = defaultProcessor) {
      var _a3;
      super();
      __privateAdd19(this, _parts, void 0);
      __privateAdd19(this, _processor, void 0);
      this.append(template19.content.cloneNode(true));
      __privateSet18(this, _parts, parse(this));
      __privateSet18(this, _processor, processor2);
      (_a3 = processor2.createCallback) == null ? void 0 : _a3.call(processor2, this, __privateGet19(this, _parts), state);
      processor2.processCallback(this, __privateGet19(this, _parts), state);
    }
    update(state) {
      __privateGet19(this, _processor).processCallback(this, __privateGet19(this, _parts), state);
    }
  };
  _parts = /* @__PURE__ */ new WeakMap();
  _processor = /* @__PURE__ */ new WeakMap();
  var parse = (element, parts = []) => {
    let type, value;
    for (const attr of element.attributes || []) {
      if (attr.value.includes("{{")) {
        const list = new AttrPartList();
        for ([type, value] of tokenize(attr.value)) {
          if (!type)
            list.append(value);
          else {
            const part = new AttrPart(element, attr.name, attr.namespaceURI);
            list.append(part);
            parts.push([value, part]);
          }
        }
        attr.value = list.toString();
      }
    }
    for (const node of element.childNodes) {
      if (node.nodeType === ELEMENT && !(node instanceof HTMLTemplateElement)) {
        parse(node, parts);
      } else {
        const data = node.data;
        if (node.nodeType === ELEMENT || data.includes("{{")) {
          const items = [];
          if (data) {
            for ([type, value] of tokenize(data))
              if (!type)
                items.push(new Text(value));
              else {
                const part = new ChildNodePart(element);
                items.push(part);
                parts.push([value, part]);
              }
          } else if (node instanceof HTMLTemplateElement) {
            const part = new InnerTemplatePart(element, node);
            items.push(part);
            parts.push([part.expression, part]);
          }
          node.replaceWith(
            ...items.flatMap((part) => part.replacementNodes || [part])
          );
        }
      }
    }
    return parts;
  };
  var mem = {};
  var tokenize = (text) => {
    let value = "", open = 0, tokens = mem[text], i = 0, c;
    if (tokens)
      return tokens;
    else
      tokens = [];
    for (; c = text[i]; i++) {
      if (c === "{" && text[i + 1] === "{" && text[i - 1] !== "\\" && text[i + 2] && ++open == 1) {
        if (value)
          tokens.push([STRING, value]);
        value = "";
        i++;
      } else if (c === "}" && text[i + 1] === "}" && text[i - 1] !== "\\" && !--open) {
        tokens.push([PART, value.trim()]);
        value = "";
        i++;
      } else
        value += c || "";
    }
    if (value)
      tokens.push([STRING, (open > 0 ? "{{" : "") + value]);
    return mem[text] = tokens;
  };
  var FRAGMENT = 11;
  var Part = class {
    get value() {
      return "";
    }
    set value(val) {
    }
    toString() {
      return this.value;
    }
  };
  var attrPartToList = /* @__PURE__ */ new WeakMap();
  var AttrPartList = class {
    constructor() {
      __privateAdd19(this, _items, []);
    }
    [Symbol.iterator]() {
      return __privateGet19(this, _items).values();
    }
    get length() {
      return __privateGet19(this, _items).length;
    }
    item(index) {
      return __privateGet19(this, _items)[index];
    }
    append(...items) {
      for (const item of items) {
        if (item instanceof AttrPart) {
          attrPartToList.set(item, this);
        }
        __privateGet19(this, _items).push(item);
      }
    }
    toString() {
      return __privateGet19(this, _items).join("");
    }
  };
  _items = /* @__PURE__ */ new WeakMap();
  var AttrPart = class extends Part {
    constructor(element, attributeName, namespaceURI) {
      super();
      __privateAdd19(this, _list);
      __privateAdd19(this, _value, "");
      __privateAdd19(this, _element, void 0);
      __privateAdd19(this, _attributeName, void 0);
      __privateAdd19(this, _namespaceURI, void 0);
      __privateSet18(this, _element, element);
      __privateSet18(this, _attributeName, attributeName);
      __privateSet18(this, _namespaceURI, namespaceURI);
    }
    get attributeName() {
      return __privateGet19(this, _attributeName);
    }
    get attributeNamespace() {
      return __privateGet19(this, _namespaceURI);
    }
    get element() {
      return __privateGet19(this, _element);
    }
    get value() {
      return __privateGet19(this, _value);
    }
    set value(newValue) {
      if (__privateGet19(this, _value) === newValue)
        return;
      __privateSet18(this, _value, newValue);
      if (!__privateGet19(this, _list, list_get) || __privateGet19(this, _list, list_get).length === 1) {
        if (newValue == null) {
          __privateGet19(this, _element).removeAttributeNS(
            __privateGet19(this, _namespaceURI),
            __privateGet19(this, _attributeName)
          );
        } else {
          __privateGet19(this, _element).setAttributeNS(
            __privateGet19(this, _namespaceURI),
            __privateGet19(this, _attributeName),
            newValue
          );
        }
      } else {
        __privateGet19(this, _element).setAttributeNS(
          __privateGet19(this, _namespaceURI),
          __privateGet19(this, _attributeName),
          __privateGet19(this, _list, list_get).toString()
        );
      }
    }
    get booleanValue() {
      return __privateGet19(this, _element).hasAttributeNS(
        __privateGet19(this, _namespaceURI),
        __privateGet19(this, _attributeName)
      );
    }
    set booleanValue(value) {
      if (!__privateGet19(this, _list, list_get) || __privateGet19(this, _list, list_get).length === 1)
        this.value = value ? "" : null;
      else
        throw new DOMException("Value is not fully templatized");
    }
  };
  _value = /* @__PURE__ */ new WeakMap();
  _element = /* @__PURE__ */ new WeakMap();
  _attributeName = /* @__PURE__ */ new WeakMap();
  _namespaceURI = /* @__PURE__ */ new WeakMap();
  _list = /* @__PURE__ */ new WeakSet();
  list_get = function() {
    return attrPartToList.get(this);
  };
  var ChildNodePart = class extends Part {
    constructor(parentNode, nodes) {
      super();
      __privateAdd19(this, _parentNode, void 0);
      __privateAdd19(this, _nodes, void 0);
      __privateSet18(this, _parentNode, parentNode);
      __privateSet18(this, _nodes, nodes ? [...nodes] : [new Text()]);
    }
    get replacementNodes() {
      return __privateGet19(this, _nodes);
    }
    get parentNode() {
      return __privateGet19(this, _parentNode);
    }
    get nextSibling() {
      return __privateGet19(this, _nodes)[__privateGet19(this, _nodes).length - 1].nextSibling;
    }
    get previousSibling() {
      return __privateGet19(this, _nodes)[0].previousSibling;
    }
    // FIXME: not sure why do we need string serialization here? Just because parent class has type DOMString?
    get value() {
      return __privateGet19(this, _nodes).map((node) => node.textContent).join("");
    }
    set value(newValue) {
      this.replace(newValue);
    }
    replace(...nodes) {
      const normalisedNodes = nodes.flat().flatMap(
        (node) => node == null ? [new Text()] : node.forEach ? [...node] : node.nodeType === FRAGMENT ? [...node.childNodes] : node.nodeType ? [node] : [new Text(node)]
      );
      if (!normalisedNodes.length)
        normalisedNodes.push(new Text());
      __privateSet18(this, _nodes, swapdom(
        __privateGet19(this, _nodes)[0].parentNode,
        __privateGet19(this, _nodes),
        normalisedNodes,
        this.nextSibling
      ));
    }
  };
  _parentNode = /* @__PURE__ */ new WeakMap();
  _nodes = /* @__PURE__ */ new WeakMap();
  var InnerTemplatePart = class extends ChildNodePart {
    constructor(parentNode, template19) {
      const directive = template19.getAttribute("directive") || template19.getAttribute("type");
      let expression = template19.getAttribute("expression") || template19.getAttribute(directive) || "";
      if (expression.startsWith("{{"))
        expression = expression.trim().slice(2, -2).trim();
      super(parentNode);
      this.expression = expression;
      this.template = template19;
      this.directive = directive;
    }
  };
  function swapdom(parent, a, b, end = null) {
    let i = 0, cur, next, bi, n = b.length, m = a.length;
    while (i < n && i < m && a[i] == b[i])
      i++;
    while (i < n && i < m && b[n - 1] == a[m - 1])
      end = b[--m, --n];
    if (i == m)
      while (i < n)
        parent.insertBefore(b[i++], end);
    if (i == n)
      while (i < m)
        parent.removeChild(a[i++]);
    else {
      cur = a[i];
      while (i < n) {
        bi = b[i++], next = cur ? cur.nextSibling : end;
        if (cur == bi)
          cur = next;
        else if (i < n && b[i] == next)
          parent.replaceChild(bi, cur), cur = next;
        else
          parent.insertBefore(bi, cur);
      }
      while (cur != end)
        next = cur.nextSibling, parent.removeChild(cur), cur = next;
    }
    return b;
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/template-processor.js
  var pipeModifiers = {
    string: (value) => String(value)
  };
  var PartialTemplate = class {
    constructor(template19) {
      this.template = template19;
      this.state = void 0;
    }
  };
  var templates = /* @__PURE__ */ new WeakMap();
  var templateInstances = /* @__PURE__ */ new WeakMap();
  var Directives = {
    partial: (part, state) => {
      state[part.expression] = new PartialTemplate(part.template);
    },
    if: (part, state) => {
      var _a3;
      if (evaluateExpression(part.expression, state)) {
        if (templates.get(part) !== part.template) {
          templates.set(part, part.template);
          const tpl = new TemplateInstance(part.template, state, processor);
          part.replace(tpl);
          templateInstances.set(part, tpl);
        } else {
          (_a3 = templateInstances.get(part)) == null ? void 0 : _a3.update(state);
        }
      } else {
        part.replace("");
        templates.delete(part);
        templateInstances.delete(part);
      }
    }
  };
  var DirectiveNames = Object.keys(Directives);
  var processor = {
    processCallback(instance, parts, state) {
      var _a3, _b2;
      if (!state)
        return;
      for (const [expression, part] of parts) {
        if (part instanceof InnerTemplatePart) {
          if (!part.directive) {
            const directive = DirectiveNames.find(
              (n) => part.template.hasAttribute(n)
            );
            if (directive) {
              part.directive = directive;
              part.expression = part.template.getAttribute(directive);
            }
          }
          (_a3 = Directives[part.directive]) == null ? void 0 : _a3.call(Directives, part, state);
          continue;
        }
        let value = evaluateExpression(expression, state);
        if (value instanceof PartialTemplate) {
          if (templates.get(part) !== value.template) {
            templates.set(part, value.template);
            value = new TemplateInstance(value.template, value.state, processor);
            part.value = value;
            templateInstances.set(part, value);
          } else {
            (_b2 = templateInstances.get(part)) == null ? void 0 : _b2.update(value.state);
          }
          continue;
        }
        if (value) {
          if (part instanceof AttrPart) {
            if (part.attributeName.startsWith("aria-")) {
              value = String(value);
            }
          }
          if (part instanceof AttrPart) {
            if (typeof value === "boolean") {
              part.booleanValue = value;
            } else if (typeof value === "function") {
              part.element[part.attributeName] = value;
            } else {
              part.value = value;
            }
          } else {
            part.value = value;
            templates.delete(part);
            templateInstances.delete(part);
          }
        } else {
          if (part instanceof AttrPart) {
            part.value = void 0;
          } else {
            part.value = void 0;
            templates.delete(part);
            templateInstances.delete(part);
          }
        }
      }
    }
  };
  var operators = {
    "!": (a) => !a,
    "!!": (a) => !!a,
    "==": (a, b) => a == b,
    "!=": (a, b) => a != b,
    ">": (a, b) => a > b,
    ">=": (a, b) => a >= b,
    "<": (a, b) => a < b,
    "<=": (a, b) => a <= b,
    "??": (a, b) => a != null ? a : b,
    "|": (a, b) => {
      var _a3;
      return (_a3 = pipeModifiers[b]) == null ? void 0 : _a3.call(pipeModifiers, a);
    }
  };
  function tokenizeExpression(expr) {
    return tokenize2(expr, {
      boolean: /true|false/,
      number: /-?\d+\.?\d*/,
      string: /(["'])((?:\\.|[^\\])*?)\1/,
      operator: /[!=><][=!]?|\?\?|\|/,
      ws: /\s+/,
      param: /[$a-z_][$\w]*/i
    }).filter(({ type }) => type !== "ws");
  }
  function evaluateExpression(expr, state = {}) {
    var _a3, _b2, _c, _d, _e, _f, _g;
    const tokens = tokenizeExpression(expr);
    if (tokens.length === 0 || tokens.some(({ type }) => !type)) {
      return invalidExpression(expr);
    }
    if (((_a3 = tokens[0]) == null ? void 0 : _a3.token) === ">") {
      const partial = state[(_b2 = tokens[1]) == null ? void 0 : _b2.token];
      if (!partial) {
        return invalidExpression(expr);
      }
      const partialState = { ...state };
      partial.state = partialState;
      const args = tokens.slice(2);
      for (let i = 0; i < args.length; i += 3) {
        const name = (_c = args[i]) == null ? void 0 : _c.token;
        const operator = (_d = args[i + 1]) == null ? void 0 : _d.token;
        const value = (_e = args[i + 2]) == null ? void 0 : _e.token;
        if (name && operator === "=") {
          partialState[name] = getParamValue(value, state);
        }
      }
      return partial;
    }
    if (tokens.length === 1) {
      if (!isValidParam(tokens[0])) {
        return invalidExpression(expr);
      }
      return getParamValue(tokens[0].token, state);
    }
    if (tokens.length === 2) {
      const operator = (_f = tokens[0]) == null ? void 0 : _f.token;
      const run = operators[operator];
      if (!run || !isValidParam(tokens[1])) {
        return invalidExpression(expr);
      }
      const a = getParamValue(tokens[1].token, state);
      return run(a);
    }
    if (tokens.length === 3) {
      const operator = (_g = tokens[1]) == null ? void 0 : _g.token;
      const run = operators[operator];
      if (!run || !isValidParam(tokens[0]) || !isValidParam(tokens[2])) {
        return invalidExpression(expr);
      }
      const a = getParamValue(tokens[0].token, state);
      if (operator === "|") {
        return run(a, tokens[2].token);
      }
      const b = getParamValue(tokens[2].token, state);
      return run(a, b);
    }
  }
  function invalidExpression(expr) {
    console.warn(`Warning: invalid expression \`${expr}\``);
    return false;
  }
  function isValidParam({ type }) {
    return ["number", "boolean", "string", "param"].includes(type);
  }
  function getParamValue(raw, state) {
    const firstChar = raw[0];
    const lastChar = raw.slice(-1);
    if (raw === "true" || raw === "false") {
      return raw === "true";
    }
    if (firstChar === lastChar && [`'`, `"`].includes(firstChar)) {
      return raw.slice(1, -1);
    }
    if (isNumericString(raw)) {
      return parseFloat(raw);
    }
    return state[raw];
  }
  function tokenize2(str, parsers) {
    let len, match, token;
    const tokens = [];
    while (str) {
      token = null;
      len = str.length;
      for (const key in parsers) {
        match = parsers[key].exec(str);
        if (match && match.index < len) {
          token = {
            token: match[0],
            type: key,
            matches: match.slice(1)
          };
          len = match.index;
        }
      }
      if (len) {
        tokens.push({
          token: str.substr(0, len),
          type: void 0
        });
      }
      if (token) {
        tokens.push(token);
      }
      str = str.substr(len + (token ? token.token.length : 0));
    }
    return tokens;
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/media-theme-element.js
  var __accessCheck20 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet20 = (obj, member, getter) => {
    __accessCheck20(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd20 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet19 = (obj, member, value, setter) => {
    __accessCheck20(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateMethod6 = (obj, member, method) => {
    __accessCheck20(obj, member, "access private method");
    return method;
  };
  var _template;
  var _prevTemplate;
  var _prevTemplateId;
  var _upgradeProperty;
  var upgradeProperty_fn;
  var _updateTemplate;
  var updateTemplate_fn;
  var observedMediaAttributes = {
    mediatargetlivewindow: "targetlivewindow",
    mediastreamtype: "streamtype"
  };
  var prependTemplate = Document2.createElement("template");
  prependTemplate.innerHTML = /*html*/
  `
  <style>
    :host {
      display: inline-block;
      line-height: 0;

      /* Hide theme element until the breakpoints are available to avoid flicker. */
      visibility: hidden;
    }

    media-controller {
      width: 100%;
      height: 100%;
    }

    media-captions-button:not([mediasubtitleslist]),
    media-captions-menu:not([mediasubtitleslist]),
    media-captions-menu-button:not([mediasubtitleslist]),
    media-audio-track-menu[mediaaudiotrackunavailable],
    media-audio-track-menu-button[mediaaudiotrackunavailable],
    media-rendition-menu[mediarenditionunavailable],
    media-rendition-menu-button[mediarenditionunavailable],
    media-volume-range[mediavolumeunavailable],
    media-airplay-button[mediaairplayunavailable],
    media-fullscreen-button[mediafullscreenunavailable],
    media-cast-button[mediacastunavailable],
    media-pip-button[mediapipunavailable] {
      display: none;
    }
  </style>
`;
  var MediaThemeElement = class extends GlobalThis.HTMLElement {
    constructor() {
      super();
      __privateAdd20(this, _upgradeProperty);
      __privateAdd20(this, _updateTemplate);
      __privateAdd20(this, _template, void 0);
      __privateAdd20(this, _prevTemplate, void 0);
      __privateAdd20(this, _prevTemplateId, void 0);
      if (this.shadowRoot) {
        this.renderRoot = this.shadowRoot;
      } else {
        this.renderRoot = this.attachShadow({ mode: "open" });
        this.createRenderer();
      }
      const observer2 = new MutationObserver((mutationList) => {
        var _a3;
        if (this.mediaController && !((_a3 = this.mediaController) == null ? void 0 : _a3.breakpointsComputed))
          return;
        if (mutationList.some((mutation) => {
          const target = mutation.target;
          if (target === this)
            return true;
          if (target.localName !== "media-controller")
            return false;
          if (observedMediaAttributes[mutation.attributeName])
            return true;
          if (mutation.attributeName.startsWith("breakpoint"))
            return true;
          return false;
        })) {
          this.render();
        }
      });
      observer2.observe(this, { attributes: true });
      observer2.observe(this.renderRoot, {
        attributes: true,
        subtree: true
      });
      this.addEventListener(
        MediaStateChangeEvents.BREAKPOINTS_COMPUTED,
        this.render
      );
      __privateMethod6(this, _upgradeProperty, upgradeProperty_fn).call(this, "template");
    }
    /** @type {HTMLElement & { breakpointsComputed?: boolean }} */
    get mediaController() {
      return this.renderRoot.querySelector("media-controller");
    }
    get template() {
      var _a3;
      return (_a3 = __privateGet20(this, _template)) != null ? _a3 : this.constructor.template;
    }
    set template(element) {
      __privateSet19(this, _prevTemplateId, null);
      __privateSet19(this, _template, element);
      this.createRenderer();
    }
    get props() {
      var _a3, _b2, _c;
      const observedAttributes = [
        ...Array.from((_b2 = (_a3 = this.mediaController) == null ? void 0 : _a3.attributes) != null ? _b2 : []).filter(
          ({ name }) => {
            return observedMediaAttributes[name] || name.startsWith("breakpoint");
          }
        ),
        ...Array.from(this.attributes)
      ];
      const props = {};
      for (const attr of observedAttributes) {
        const name = (_c = observedMediaAttributes[attr.name]) != null ? _c : camelCase(attr.name);
        let { value } = attr;
        if (value != null) {
          if (isNumericString(value)) {
            value = parseFloat(value);
          }
          props[name] = value === "" ? true : value;
        } else {
          props[name] = false;
        }
      }
      return props;
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      if (attrName === "template" && oldValue != newValue) {
        __privateMethod6(this, _updateTemplate, updateTemplate_fn).call(this);
      }
    }
    connectedCallback() {
      __privateMethod6(this, _updateTemplate, updateTemplate_fn).call(this);
    }
    createRenderer() {
      if (this.template && this.template !== __privateGet20(this, _prevTemplate)) {
        __privateSet19(this, _prevTemplate, this.template);
        this.renderer = new TemplateInstance(
          this.template,
          this.props,
          // @ts-ignore
          this.constructor.processor
        );
        this.renderRoot.textContent = "";
        this.renderRoot.append(
          prependTemplate.content.cloneNode(true),
          this.renderer
        );
      }
    }
    render() {
      var _a3;
      (_a3 = this.renderer) == null ? void 0 : _a3.update(this.props);
      const { style } = getOrInsertCSSRule(this.renderRoot, ":host");
      if (style.visibility === "hidden") {
        style.removeProperty("visibility");
      }
    }
  };
  _template = /* @__PURE__ */ new WeakMap();
  _prevTemplate = /* @__PURE__ */ new WeakMap();
  _prevTemplateId = /* @__PURE__ */ new WeakMap();
  _upgradeProperty = /* @__PURE__ */ new WeakSet();
  upgradeProperty_fn = function(prop) {
    if (Object.prototype.hasOwnProperty.call(this, prop)) {
      const value = this[prop];
      delete this[prop];
      this[prop] = value;
    }
  };
  _updateTemplate = /* @__PURE__ */ new WeakSet();
  updateTemplate_fn = function() {
    var _a3;
    const templateId = this.getAttribute("template");
    if (!templateId || templateId === __privateGet20(this, _prevTemplateId))
      return;
    const rootNode = this.getRootNode();
    const template19 = (_a3 = rootNode == null ? void 0 : rootNode.getElementById) == null ? void 0 : _a3.call(rootNode, templateId);
    if (template19) {
      __privateSet19(this, _prevTemplateId, templateId);
      __privateSet19(this, _template, template19);
      this.createRenderer();
      return;
    }
    if (isValidUrl(templateId)) {
      __privateSet19(this, _prevTemplateId, templateId);
      request(templateId).then((data) => {
        const template22 = Document2.createElement("template");
        template22.innerHTML = data;
        __privateSet19(this, _template, template22);
        this.createRenderer();
      }).catch(console.error);
    }
  };
  MediaThemeElement.observedAttributes = ["template"];
  MediaThemeElement.processor = processor;
  function isValidUrl(url) {
    if (!/^(\/|\.\/|https?:\/\/)/.test(url))
      return false;
    const base = /^https?:\/\//.test(url) ? void 0 : location.origin;
    try {
      new URL(url, base);
    } catch (e) {
      return false;
    }
    return true;
  }
  async function request(resource) {
    const response = await fetch(resource);
    if (response.status !== 200) {
      throw new Error(
        `Failed to load resource: the server responded with a status of ${response.status}`
      );
    }
    return response.text();
  }
  if (!GlobalThis.customElements.get("media-theme")) {
    GlobalThis.customElements.define("media-theme", MediaThemeElement);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/anchor-utils.js
  function computePosition({
    anchor,
    floating,
    placement
  }) {
    const rects = getElementRects({ anchor, floating });
    const { x, y } = computeCoordsFromPlacement(rects, placement);
    return { x, y };
  }
  function getElementRects({
    anchor,
    floating
  }) {
    return {
      anchor: getRectRelativeToOffsetParent(anchor, floating.offsetParent),
      floating: {
        x: 0,
        y: 0,
        width: floating.offsetWidth,
        height: floating.offsetHeight
      }
    };
  }
  function getRectRelativeToOffsetParent(element, offsetParent) {
    const rect = element.getBoundingClientRect();
    const offsetRect = offsetParent.getBoundingClientRect();
    return {
      x: rect.x - offsetRect.x,
      y: rect.y - offsetRect.y,
      width: rect.width,
      height: rect.height
    };
  }
  function computeCoordsFromPlacement({ anchor, floating }, placement) {
    const alignmentAxis = getSideAxis(placement) === "x" ? "y" : "x";
    const alignLength = alignmentAxis === "y" ? "height" : "width";
    const side = getSide(placement);
    const commonX = anchor.x + anchor.width / 2 - floating.width / 2;
    const commonY = anchor.y + anchor.height / 2 - floating.height / 2;
    const commonAlign = anchor[alignLength] / 2 - floating[alignLength] / 2;
    let coords;
    switch (side) {
      case "top":
        coords = { x: commonX, y: anchor.y - floating.height };
        break;
      case "bottom":
        coords = { x: commonX, y: anchor.y + anchor.height };
        break;
      case "right":
        coords = { x: anchor.x + anchor.width, y: commonY };
        break;
      case "left":
        coords = { x: anchor.x - floating.width, y: commonY };
        break;
      default:
        coords = { x: anchor.x, y: anchor.y };
    }
    switch (placement.split("-")[1]) {
      case "start":
        coords[alignmentAxis] -= commonAlign;
        break;
      case "end":
        coords[alignmentAxis] += commonAlign;
        break;
    }
    return coords;
  }
  function getSide(placement) {
    return placement.split("-")[0];
  }
  function getSideAxis(placement) {
    return ["top", "bottom"].includes(getSide(placement)) ? "y" : "x";
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/utils/events.js
  var InvokeEvent = class extends Event {
    /**
     * @param init - The event options.
     */
    constructor({ action = "auto", relatedTarget, ...options }) {
      super("invoke", options);
      this.action = action;
      this.relatedTarget = relatedTarget;
    }
  };
  var ToggleEvent = class extends Event {
    /**
     * @param init - The event options.
     */
    constructor({ newState, oldState, ...options }) {
      super("toggle", options);
      this.newState = newState;
      this.oldState = oldState;
    }
  };

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-chrome-menu.js
  var __accessCheck21 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet21 = (obj, member, getter) => {
    __accessCheck21(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd21 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet20 = (obj, member, value, setter) => {
    __accessCheck21(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateMethod7 = (obj, member, method) => {
    __accessCheck21(obj, member, "access private method");
    return method;
  };
  var _mediaController8;
  var _previouslyFocused2;
  var _invokerElement2;
  var _keysSoFar;
  var _clearKeysTimeout;
  var _previousItems;
  var _mutationObserver;
  var _isPopover;
  var _handleSlotChange;
  var handleSlotChange_fn;
  var _handleMenuItems;
  var _updateLayoutStyle;
  var updateLayoutStyle_fn;
  var _handleInvoke2;
  var handleInvoke_fn2;
  var _handleOpen2;
  var handleOpen_fn2;
  var _handleClosed2;
  var handleClosed_fn2;
  var _handleBoundsResize;
  var _handleMenuResize;
  var _positionMenu;
  var positionMenu_fn;
  var _resizeMenu;
  var resizeMenu_fn;
  var _handleClick;
  var handleClick_fn;
  var _backButtonElement;
  var backButtonElement_get;
  var _handleToggle;
  var handleToggle_fn;
  var _checkSubmenuHasExpanded;
  var checkSubmenuHasExpanded_fn;
  var _handleFocusOut2;
  var handleFocusOut_fn2;
  var _handleKeyDown2;
  var handleKeyDown_fn2;
  var _getItem;
  var getItem_fn;
  var _getTabItem;
  var getTabItem_fn;
  var _setTabItem;
  var setTabItem_fn;
  var _selectItem;
  var selectItem_fn;
  function createMenuItem({
    type,
    text,
    value,
    checked
  }) {
    const item = Document2.createElement(
      "media-chrome-menu-item"
    );
    item.type = type != null ? type : "";
    item.part.add("menu-item");
    if (type)
      item.part.add(type);
    item.value = value;
    item.checked = checked;
    const label = Document2.createElement("span");
    label.textContent = text;
    item.append(label);
    return item;
  }
  function createIndicator(el, name) {
    let customIndicator = el.querySelector(`:scope > [slot="${name}"]`);
    if ((customIndicator == null ? void 0 : customIndicator.nodeName) == "SLOT")
      customIndicator = customIndicator.assignedElements({ flatten: true })[0];
    if (customIndicator) {
      customIndicator = customIndicator.cloneNode(true);
      return customIndicator;
    }
    const fallbackIndicator = el.shadowRoot.querySelector(
      `[name="${name}"] > svg`
    );
    if (fallbackIndicator) {
      return fallbackIndicator.cloneNode(true);
    }
    return "";
  }
  var template13 = Document2.createElement("template");
  template13.innerHTML = /*html*/
  `
  <style>
    :host {
      font: var(--media-font,
        var(--media-font-weight, normal)
        var(--media-font-size, 14px) /
        var(--media-text-content-height, var(--media-control-height, 24px))
        var(--media-font-family, helvetica neue, segoe ui, roboto, arial, sans-serif));
      color: var(--media-text-color, var(--media-primary-color, rgb(238 238 238)));
      background: var(--media-menu-background, var(--media-control-background, var(--media-secondary-color, rgb(20 20 30 / .8))));
      border-radius: var(--media-menu-border-radius);
      border: var(--media-menu-border, none);
      display: var(--media-menu-display, inline-flex);
      transition: var(--media-menu-transition-in,
        visibility 0s,
        opacity .2s ease-out,
        transform .15s ease-out,
        left .2s ease-in-out,
        min-width .2s ease-in-out,
        min-height .2s ease-in-out
      ) !important;
      ${/* ^^Prevent transition override by media-container */
  ""}
      visibility: var(--media-menu-visibility, visible);
      opacity: var(--media-menu-opacity, 1);
      max-height: var(--media-menu-max-height, var(--_menu-max-height, 300px));
      transform: var(--media-menu-transform-in, translateY(0) scale(1));
      flex-direction: column;
      ${/* Prevent overflowing a flex container */
  ""}
      min-height: 0;
      position: relative;
      box-sizing: border-box;
    }

    :host([hidden]) {
      transition: var(--media-menu-transition-out,
        visibility .15s ease-in,
        opacity .15s ease-in,
        transform .15s ease-in
      ) !important;
      visibility: var(--media-menu-hidden-visibility, hidden);
      opacity: var(--media-menu-hidden-opacity, 0);
      max-height: var(--media-menu-hidden-max-height,
        var(--media-menu-max-height, var(--_menu-max-height, 300px)));
      transform: var(--media-menu-transform-out, translateY(2px) scale(.99));
      pointer-events: none;
    }

    :host([slot="submenu"]) {
      background: none;
      width: 100%;
      min-height: 100%;
      position: absolute;
      bottom: 0;
      right: -100%;
    }

    #container {
      display: flex;
      flex-direction: column;
      min-height: 0;
      transition: transform .2s ease-out;
      transform: translate(0, 0);
    }

    #container.has-expanded {
      transition: transform .2s ease-in;
      transform: translate(-100%, 0);
    }

    slot[name="header"] {
      display: flex;
      padding: .4em .7em;
      border-bottom: 1px solid rgb(255 255 255 / .25);
      cursor: default;
    }

    slot[name="header"][hidden] {
      display: none;
    }

    button[part~="back"] {
      background: none;
      color: inherit;
      border: none;
      padding: 0;
      font: inherit;
      cursor: pointer;
      outline: inherit;
      display: inline-flex;
      align-items: center;
      cursor: pointer;
    }

    svg[part~="back"] {
      height: var(--media-menu-icon-height, var(--media-control-height, 24px));
      fill: var(--media-icon-color, var(--media-primary-color, rgb(238 238 238)));
      display: block;
      margin-right: .5ch;
    }

    slot:not([name]) {
      gap: var(--media-menu-gap);
      flex-direction: var(--media-menu-flex-direction, column);
      overflow: var(--media-menu-overflow, hidden auto);
      display: flex;
      min-height: 0;
    }

    :host([role="menu"]) slot:not([name]) {
      padding-block: .4em;
    }

    slot:not([name])::slotted([role="menu"]) {
      background: none;
    }

    media-chrome-menu-item > span {
      margin-right: .5ch;
      max-width: var(--media-menu-item-max-width);
      text-overflow: ellipsis;
      overflow: hidden;
    }
  </style>
  <style id="layout-row" media="width:0">

    slot[name="header"] {
      padding: .4em .5em;
    }

    slot:not([name]) {
      gap: var(--media-menu-gap, .25em);
      flex-direction: var(--media-menu-flex-direction, row);
      padding-inline: .5em;
    }

    media-chrome-menu-item {
      padding: .3em .5em;
    }

    media-chrome-menu-item[aria-checked="true"] {
      background: var(--media-menu-item-checked-background, rgb(255 255 255 / .2));
    }

    ${/* In row layout hide the checked indicator completely. */
  ""}
    media-chrome-menu-item::part(checked-indicator) {
      display: var(--media-menu-item-checked-indicator-display, none);
    }
  </style>
  <div id="container">
    <slot name="header" hidden>
      <button part="back button" aria-label="Back to previous menu">
        <slot name="back-icon">
          <svg aria-hidden="true" viewBox="0 0 20 24" part="back indicator">
            <path d="m11.88 17.585.742-.669-4.2-4.665 4.2-4.666-.743-.669-4.803 5.335 4.803 5.334Z"/>
          </svg>
        </slot>
        <slot name="title"></slot>
      </button>
    </slot>
    <slot></slot>
  </div>
  <slot name="checked-indicator" hidden></slot>
`;
  var Attributes12 = {
    STYLE: "style",
    HIDDEN: "hidden",
    DISABLED: "disabled",
    ANCHOR: "anchor"
  };
  var MediaChromeMenu = class extends GlobalThis.HTMLElement {
    constructor() {
      super();
      __privateAdd21(this, _handleSlotChange);
      __privateAdd21(this, _updateLayoutStyle);
      __privateAdd21(this, _handleInvoke2);
      __privateAdd21(this, _handleOpen2);
      __privateAdd21(this, _handleClosed2);
      __privateAdd21(this, _positionMenu);
      __privateAdd21(this, _resizeMenu);
      __privateAdd21(this, _handleClick);
      __privateAdd21(this, _backButtonElement);
      __privateAdd21(this, _handleToggle);
      __privateAdd21(this, _checkSubmenuHasExpanded);
      __privateAdd21(this, _handleFocusOut2);
      __privateAdd21(this, _handleKeyDown2);
      __privateAdd21(this, _getItem);
      __privateAdd21(this, _getTabItem);
      __privateAdd21(this, _setTabItem);
      __privateAdd21(this, _selectItem);
      __privateAdd21(this, _mediaController8, null);
      __privateAdd21(this, _previouslyFocused2, null);
      __privateAdd21(this, _invokerElement2, null);
      __privateAdd21(this, _keysSoFar, "");
      __privateAdd21(this, _clearKeysTimeout, null);
      __privateAdd21(this, _previousItems, /* @__PURE__ */ new Set());
      __privateAdd21(this, _mutationObserver, void 0);
      __privateAdd21(this, _isPopover, false);
      __privateAdd21(this, _handleMenuItems, () => {
        const previousItems = __privateGet21(this, _previousItems);
        const currentItems = new Set(this.items);
        for (const item of previousItems) {
          if (!currentItems.has(item)) {
            this.dispatchEvent(new CustomEvent("removemenuitem", { detail: item }));
          }
        }
        for (const item of currentItems) {
          if (!previousItems.has(item)) {
            this.dispatchEvent(new CustomEvent("addmenuitem", { detail: item }));
          }
        }
        __privateSet20(this, _previousItems, currentItems);
      });
      __privateAdd21(this, _handleBoundsResize, () => {
        __privateMethod7(this, _positionMenu, positionMenu_fn).call(this, false);
        __privateMethod7(this, _resizeMenu, resizeMenu_fn).call(this, false);
      });
      __privateAdd21(this, _handleMenuResize, () => {
        __privateMethod7(this, _positionMenu, positionMenu_fn).call(this, false);
      });
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        this.nativeEl = this.constructor.template.content.cloneNode(true);
        this.shadowRoot.append(this.nativeEl);
      }
      this.container = this.shadowRoot.querySelector("#container");
      this.defaultSlot = this.shadowRoot.querySelector(
        "slot:not([name])"
      );
      this.shadowRoot.addEventListener("slotchange", this);
      __privateSet20(this, _mutationObserver, new MutationObserver(__privateGet21(this, _handleMenuItems)));
      __privateGet21(this, _mutationObserver).observe(this.defaultSlot, { childList: true });
    }
    static get observedAttributes() {
      return [
        Attributes12.DISABLED,
        Attributes12.HIDDEN,
        Attributes12.STYLE,
        Attributes12.ANCHOR,
        MediaStateReceiverAttributes.MEDIA_CONTROLLER
      ];
    }
    static formatMenuItemText(text) {
      return text;
    }
    enable() {
      this.addEventListener("click", this);
      this.addEventListener("focusout", this);
      this.addEventListener("keydown", this);
      this.addEventListener("invoke", this);
      this.addEventListener("toggle", this);
    }
    disable() {
      this.removeEventListener("click", this);
      this.removeEventListener("focusout", this);
      this.removeEventListener("keyup", this);
      this.removeEventListener("invoke", this);
      this.removeEventListener("toggle", this);
    }
    handleEvent(event) {
      switch (event.type) {
        case "slotchange":
          __privateMethod7(this, _handleSlotChange, handleSlotChange_fn).call(this, event);
          break;
        case "invoke":
          __privateMethod7(this, _handleInvoke2, handleInvoke_fn2).call(this, event);
          break;
        case "click":
          __privateMethod7(this, _handleClick, handleClick_fn).call(this, event);
          break;
        case "toggle":
          __privateMethod7(this, _handleToggle, handleToggle_fn).call(this, event);
          break;
        case "focusout":
          __privateMethod7(this, _handleFocusOut2, handleFocusOut_fn2).call(this, event);
          break;
        case "keydown":
          __privateMethod7(this, _handleKeyDown2, handleKeyDown_fn2).call(this, event);
          break;
      }
    }
    connectedCallback() {
      var _a3, _b2;
      __privateMethod7(this, _updateLayoutStyle, updateLayoutStyle_fn).call(this);
      if (!this.hasAttribute("disabled")) {
        this.enable();
      }
      if (!this.role) {
        this.role = "menu";
      }
      __privateSet20(this, _mediaController8, getAttributeMediaController(this));
      (_b2 = (_a3 = __privateGet21(this, _mediaController8)) == null ? void 0 : _a3.associateElement) == null ? void 0 : _b2.call(_a3, this);
      if (!this.hidden) {
        observeResize(getBoundsElement(this), __privateGet21(this, _handleBoundsResize));
        observeResize(this, __privateGet21(this, _handleMenuResize));
      }
    }
    disconnectedCallback() {
      var _a3, _b2;
      unobserveResize(getBoundsElement(this), __privateGet21(this, _handleBoundsResize));
      unobserveResize(this, __privateGet21(this, _handleMenuResize));
      this.disable();
      (_b2 = (_a3 = __privateGet21(this, _mediaController8)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
      __privateSet20(this, _mediaController8, null);
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      var _a3, _b2, _c, _d;
      if (attrName === Attributes12.HIDDEN && newValue !== oldValue) {
        if (!__privateGet21(this, _isPopover))
          __privateSet20(this, _isPopover, true);
        if (this.hidden) {
          __privateMethod7(this, _handleClosed2, handleClosed_fn2).call(this);
        } else {
          __privateMethod7(this, _handleOpen2, handleOpen_fn2).call(this);
        }
        this.dispatchEvent(
          new ToggleEvent({
            oldState: this.hidden ? "open" : "closed",
            newState: this.hidden ? "closed" : "open",
            bubbles: true
          })
        );
      } else if (attrName === MediaStateReceiverAttributes.MEDIA_CONTROLLER) {
        if (oldValue) {
          (_b2 = (_a3 = __privateGet21(this, _mediaController8)) == null ? void 0 : _a3.unassociateElement) == null ? void 0 : _b2.call(_a3, this);
          __privateSet20(this, _mediaController8, null);
        }
        if (newValue && this.isConnected) {
          __privateSet20(this, _mediaController8, getAttributeMediaController(this));
          (_d = (_c = __privateGet21(this, _mediaController8)) == null ? void 0 : _c.associateElement) == null ? void 0 : _d.call(_c, this);
        }
      } else if (attrName === Attributes12.DISABLED && newValue !== oldValue) {
        if (newValue == null) {
          this.enable();
        } else {
          this.disable();
        }
      } else if (attrName === Attributes12.STYLE && newValue !== oldValue) {
        __privateMethod7(this, _updateLayoutStyle, updateLayoutStyle_fn).call(this);
      }
    }
    formatMenuItemText(text, data) {
      return this.constructor.formatMenuItemText(text, data);
    }
    get anchor() {
      return this.getAttribute("anchor");
    }
    set anchor(value) {
      this.setAttribute("anchor", `${value}`);
    }
    /**
     * Returns the anchor element when it is a floating menu.
     */
    get anchorElement() {
      var _a3;
      if (this.anchor) {
        return (_a3 = getDocumentOrShadowRoot(this)) == null ? void 0 : _a3.querySelector(`#${this.anchor}`);
      }
      return null;
    }
    /**
     * Returns the menu items.
     */
    get items() {
      return this.defaultSlot.assignedElements({ flatten: true }).filter(isMenuItem);
    }
    get radioGroupItems() {
      return this.items.filter((item) => item.role === "menuitemradio");
    }
    get checkedItems() {
      return this.items.filter((item) => item.checked);
    }
    get value() {
      var _a3, _b2;
      return (_b2 = (_a3 = this.checkedItems[0]) == null ? void 0 : _a3.value) != null ? _b2 : "";
    }
    set value(newValue) {
      const item = this.items.find((item2) => item2.value === newValue);
      if (!item)
        return;
      __privateMethod7(this, _selectItem, selectItem_fn).call(this, item);
    }
    focus() {
      __privateSet20(this, _previouslyFocused2, getActiveElement());
      if (this.items.length) {
        __privateMethod7(this, _setTabItem, setTabItem_fn).call(this, this.items[0]);
        this.items[0].focus();
        return;
      }
      const focusable = this.querySelector(
        '[autofocus], [tabindex]:not([tabindex="-1"]), [role="menu"]'
      );
      focusable == null ? void 0 : focusable.focus();
    }
    handleSelect(event) {
      var _a3;
      const item = __privateMethod7(this, _getItem, getItem_fn).call(this, event);
      if (!item)
        return;
      __privateMethod7(this, _selectItem, selectItem_fn).call(this, item, item.type === "checkbox");
      if (__privateGet21(this, _invokerElement2) && !this.hidden) {
        (_a3 = __privateGet21(this, _previouslyFocused2)) == null ? void 0 : _a3.focus();
        this.hidden = true;
      }
    }
    get keysUsed() {
      return [
        "Enter",
        "Escape",
        "Tab",
        " ",
        "ArrowDown",
        "ArrowUp",
        "Home",
        "End"
      ];
    }
    handleMove(event) {
      var _a3, _b2;
      const { key } = event;
      const items = this.items;
      const currentItem = (_b2 = (_a3 = __privateMethod7(this, _getItem, getItem_fn).call(this, event)) != null ? _a3 : __privateMethod7(this, _getTabItem, getTabItem_fn).call(this)) != null ? _b2 : items[0];
      const currentIndex = items.indexOf(currentItem);
      let index = Math.max(0, currentIndex);
      if (key === "ArrowDown") {
        index++;
      } else if (key === "ArrowUp") {
        index--;
      } else if (event.key === "Home") {
        index = 0;
      } else if (event.key === "End") {
        index = items.length - 1;
      }
      if (index < 0) {
        index = items.length - 1;
      }
      if (index > items.length - 1) {
        index = 0;
      }
      __privateMethod7(this, _setTabItem, setTabItem_fn).call(this, items[index]);
      items[index].focus();
    }
  };
  _mediaController8 = /* @__PURE__ */ new WeakMap();
  _previouslyFocused2 = /* @__PURE__ */ new WeakMap();
  _invokerElement2 = /* @__PURE__ */ new WeakMap();
  _keysSoFar = /* @__PURE__ */ new WeakMap();
  _clearKeysTimeout = /* @__PURE__ */ new WeakMap();
  _previousItems = /* @__PURE__ */ new WeakMap();
  _mutationObserver = /* @__PURE__ */ new WeakMap();
  _isPopover = /* @__PURE__ */ new WeakMap();
  _handleSlotChange = /* @__PURE__ */ new WeakSet();
  handleSlotChange_fn = function(event) {
    const slot = event.target;
    for (const node of slot.assignedNodes({ flatten: true })) {
      if (node.nodeType === 3 && node.textContent.trim() === "") {
        node.remove();
      }
    }
    if (["header", "title"].includes(slot.name)) {
      const header = this.shadowRoot.querySelector(
        'slot[name="header"]'
      );
      header.hidden = slot.assignedNodes().length === 0;
    }
    if (!slot.name) {
      __privateGet21(this, _handleMenuItems).call(this);
    }
  };
  _handleMenuItems = /* @__PURE__ */ new WeakMap();
  _updateLayoutStyle = /* @__PURE__ */ new WeakSet();
  updateLayoutStyle_fn = function() {
    var _a3;
    const layoutRowStyle = this.shadowRoot.querySelector("#layout-row");
    const menuLayout = (_a3 = getComputedStyle(this).getPropertyValue("--media-menu-layout")) == null ? void 0 : _a3.trim();
    layoutRowStyle.setAttribute("media", menuLayout === "row" ? "" : "width:0");
  };
  _handleInvoke2 = /* @__PURE__ */ new WeakSet();
  handleInvoke_fn2 = function(event) {
    __privateSet20(this, _invokerElement2, event.relatedTarget);
    if (!containsComposedNode(this, event.relatedTarget)) {
      this.hidden = !this.hidden;
    }
  };
  _handleOpen2 = /* @__PURE__ */ new WeakSet();
  handleOpen_fn2 = function() {
    var _a3;
    (_a3 = __privateGet21(this, _invokerElement2)) == null ? void 0 : _a3.setAttribute("aria-expanded", "true");
    requestAnimationFrame(() => __privateMethod7(this, _positionMenu, positionMenu_fn).call(this, false));
    this.addEventListener("transitionend", () => this.focus(), { once: true });
    observeResize(getBoundsElement(this), __privateGet21(this, _handleBoundsResize));
    observeResize(this, __privateGet21(this, _handleMenuResize));
  };
  _handleClosed2 = /* @__PURE__ */ new WeakSet();
  handleClosed_fn2 = function() {
    var _a3;
    (_a3 = __privateGet21(this, _invokerElement2)) == null ? void 0 : _a3.setAttribute("aria-expanded", "false");
    unobserveResize(getBoundsElement(this), __privateGet21(this, _handleBoundsResize));
    unobserveResize(this, __privateGet21(this, _handleMenuResize));
  };
  _handleBoundsResize = /* @__PURE__ */ new WeakMap();
  _handleMenuResize = /* @__PURE__ */ new WeakMap();
  _positionMenu = /* @__PURE__ */ new WeakSet();
  positionMenu_fn = function(animate, menuWidth) {
    if (this.hasAttribute("mediacontroller") && !this.anchor)
      return;
    if (this.hidden || !this.anchorElement)
      return;
    const { x, y } = computePosition({
      anchor: this.anchorElement,
      floating: this,
      placement: "top-start"
    });
    menuWidth != null ? menuWidth : menuWidth = this.offsetWidth;
    const bounds = getBoundsElement(this);
    const boundsRect = bounds.getBoundingClientRect();
    const anchorRect = this.anchorElement.getBoundingClientRect();
    const right = boundsRect.width - x - menuWidth;
    const bottom = boundsRect.height - y - this.offsetHeight;
    const maxHeight = boundsRect.height - anchorRect.height;
    const { style } = getOrInsertCSSRule(this.shadowRoot, ":host");
    if (!animate) {
      style.setProperty("--media-menu-transition-in", "none");
    }
    style.setProperty("position", "absolute");
    style.setProperty("right", `${Math.max(0, right)}px`);
    style.setProperty("bottom", `${bottom}px`);
    style.setProperty("--_menu-max-height", `${maxHeight}px`);
    style.removeProperty("--media-menu-transition-in");
  };
  _resizeMenu = /* @__PURE__ */ new WeakSet();
  resizeMenu_fn = function(animate) {
    const expandedMenuItem = this.querySelector(
      '[role="menuitem"][aria-haspopup][aria-expanded="true"]'
    );
    const expandedSubmenu = expandedMenuItem == null ? void 0 : expandedMenuItem.querySelector(
      '[role="menu"]'
    );
    const { style } = getOrInsertCSSRule(this.shadowRoot, ":host");
    if (!animate) {
      style.setProperty("--media-menu-transition-in", "none");
    }
    if (expandedSubmenu) {
      const height = expandedSubmenu.offsetHeight;
      const width = Math.max(
        expandedSubmenu.offsetWidth,
        expandedMenuItem.offsetWidth
      );
      this.style.setProperty("min-width", `${width}px`);
      this.style.setProperty("min-height", `${height}px`);
      __privateMethod7(this, _positionMenu, positionMenu_fn).call(this, animate, width);
    } else {
      this.style.removeProperty("min-width");
      this.style.removeProperty("min-height");
      __privateMethod7(this, _positionMenu, positionMenu_fn).call(this, animate);
    }
    style.removeProperty("--media-menu-transition-in");
  };
  _handleClick = /* @__PURE__ */ new WeakSet();
  handleClick_fn = function(event) {
    var _a3;
    event.stopPropagation();
    if (event.composedPath().includes(__privateGet21(this, _backButtonElement, backButtonElement_get))) {
      (_a3 = __privateGet21(this, _previouslyFocused2)) == null ? void 0 : _a3.focus();
      this.hidden = true;
      return;
    }
    const item = __privateMethod7(this, _getItem, getItem_fn).call(this, event);
    if (!item || item.hasAttribute("disabled"))
      return;
    __privateMethod7(this, _setTabItem, setTabItem_fn).call(this, item);
    this.handleSelect(event);
  };
  _backButtonElement = /* @__PURE__ */ new WeakSet();
  backButtonElement_get = function() {
    var _a3;
    const headerSlot = this.shadowRoot.querySelector(
      'slot[name="header"]'
    );
    return (_a3 = headerSlot.assignedElements({ flatten: true })) == null ? void 0 : _a3.find(
      (el) => el.part.contains("back") && el.part.contains("button")
    );
  };
  _handleToggle = /* @__PURE__ */ new WeakSet();
  handleToggle_fn = function(event) {
    if (event.target === this)
      return;
    __privateMethod7(this, _checkSubmenuHasExpanded, checkSubmenuHasExpanded_fn).call(this);
    const menuItemsWithSubmenu = Array.from(
      this.querySelectorAll('[role="menuitem"][aria-haspopup]')
    );
    for (const item of menuItemsWithSubmenu) {
      if (item.invokeTargetElement == event.target)
        continue;
      if (event.newState == "open" && item.getAttribute("aria-expanded") == "true" && !item.invokeTargetElement.hidden) {
        item.invokeTargetElement.dispatchEvent(
          new InvokeEvent({ relatedTarget: item })
        );
      }
    }
    for (const item of menuItemsWithSubmenu) {
      item.setAttribute("aria-expanded", `${!item.submenuElement.hidden}`);
    }
    __privateMethod7(this, _resizeMenu, resizeMenu_fn).call(this, true);
  };
  _checkSubmenuHasExpanded = /* @__PURE__ */ new WeakSet();
  checkSubmenuHasExpanded_fn = function() {
    const selector = '[role="menuitem"] > [role="menu"]:not([hidden])';
    const expandedMenuItem = this.querySelector(selector);
    this.container.classList.toggle("has-expanded", !!expandedMenuItem);
  };
  _handleFocusOut2 = /* @__PURE__ */ new WeakSet();
  handleFocusOut_fn2 = function(event) {
    var _a3;
    if (!containsComposedNode(this, event.relatedTarget)) {
      if (__privateGet21(this, _isPopover)) {
        (_a3 = __privateGet21(this, _previouslyFocused2)) == null ? void 0 : _a3.focus();
      }
      if (__privateGet21(this, _invokerElement2) && __privateGet21(this, _invokerElement2) !== event.relatedTarget && !this.hidden) {
        this.hidden = true;
      }
    }
  };
  _handleKeyDown2 = /* @__PURE__ */ new WeakSet();
  handleKeyDown_fn2 = function(event) {
    var _a3, _b2, _c, _d, _e;
    const { key, ctrlKey, altKey, metaKey } = event;
    if (ctrlKey || altKey || metaKey) {
      return;
    }
    if (!this.keysUsed.includes(key)) {
      return;
    }
    event.preventDefault();
    event.stopPropagation();
    if (key === "Tab") {
      if (__privateGet21(this, _isPopover)) {
        this.hidden = true;
        return;
      }
      if (event.shiftKey) {
        (_b2 = (_a3 = this.previousElementSibling) == null ? void 0 : _a3.focus) == null ? void 0 : _b2.call(_a3);
      } else {
        (_d = (_c = this.nextElementSibling) == null ? void 0 : _c.focus) == null ? void 0 : _d.call(_c);
      }
      this.blur();
    } else if (key === "Escape") {
      (_e = __privateGet21(this, _previouslyFocused2)) == null ? void 0 : _e.focus();
      if (__privateGet21(this, _isPopover)) {
        this.hidden = true;
      }
    } else if (key === "Enter" || key === " ") {
      this.handleSelect(event);
    } else {
      this.handleMove(event);
    }
  };
  _getItem = /* @__PURE__ */ new WeakSet();
  getItem_fn = function(event) {
    return event.composedPath().find((el) => {
      return ["menuitemradio", "menuitemcheckbox"].includes(
        el.role
      );
    });
  };
  _getTabItem = /* @__PURE__ */ new WeakSet();
  getTabItem_fn = function() {
    return this.items.find((item) => item.tabIndex === 0);
  };
  _setTabItem = /* @__PURE__ */ new WeakSet();
  setTabItem_fn = function(tabItem) {
    for (const item of this.items) {
      item.tabIndex = item === tabItem ? 0 : -1;
    }
  };
  _selectItem = /* @__PURE__ */ new WeakSet();
  selectItem_fn = function(item, toggle) {
    const oldCheckedItems = [...this.checkedItems];
    if (item.type === "radio") {
      this.radioGroupItems.forEach((el) => el.checked = false);
    }
    if (toggle) {
      item.checked = !item.checked;
    } else {
      item.checked = true;
    }
    if (this.checkedItems.some((opt, i) => opt != oldCheckedItems[i])) {
      this.dispatchEvent(
        new Event("change", { bubbles: true, composed: true })
      );
    }
  };
  MediaChromeMenu.template = template13;
  function isMenuItem(element) {
    return ["menuitem", "menuitemradio", "menuitemcheckbox"].includes(
      element == null ? void 0 : element.role
    );
  }
  function getBoundsElement(host) {
    var _a3;
    return (_a3 = host.getAttribute("bounds") ? closestComposedNode(host, `#${host.getAttribute("bounds")}`) : getMediaController(host) || host.parentElement) != null ? _a3 : host;
  }
  if (!GlobalThis.customElements.get("media-chrome-menu")) {
    GlobalThis.customElements.define("media-chrome-menu", MediaChromeMenu);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-chrome-menu-item.js
  var __accessCheck22 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet22 = (obj, member, getter) => {
    __accessCheck22(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd22 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet21 = (obj, member, value, setter) => {
    __accessCheck22(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateMethod8 = (obj, member, method) => {
    __accessCheck22(obj, member, "access private method");
    return method;
  };
  var _dirty;
  var _ownerElement;
  var _handleSlotChange2;
  var handleSlotChange_fn2;
  var _submenuConnected;
  var submenuConnected_fn;
  var _submenuDisconnected;
  var submenuDisconnected_fn;
  var _handleMenuItem;
  var _handleKeyUp;
  var handleKeyUp_fn;
  var _handleKeyDown3;
  var handleKeyDown_fn3;
  var _reset;
  var reset_fn;
  var template14 = Document2.createElement("template");
  template14.innerHTML = /*html*/
  `
  <style>
    :host {
      transition: var(--media-menu-item-transition,
        background .15s linear,
        opacity .2s ease-in-out
      );
      outline: var(--media-menu-item-outline, 0);
      outline-offset: var(--media-menu-item-outline-offset, -1px);
      cursor: pointer;
      display: flex;
      align-items: center;
      align-self: stretch;
      justify-self: stretch;
      white-space: nowrap;
      white-space-collapse: collapse;
      text-wrap: nowrap;
      padding: .4em .8em .4em 1em;
    }

    :host(:focus-visible) {
      box-shadow: var(--media-menu-item-focus-shadow, inset 0 0 0 2px rgb(27 127 204 / .9));
      outline: var(--media-menu-item-hover-outline, 0);
      outline-offset: var(--media-menu-item-hover-outline-offset,  var(--media-menu-item-outline-offset, -1px));
    }

    :host(:hover) {
      cursor: pointer;
      background: var(--media-menu-item-hover-background, rgb(92 92 102 / .5));
      outline: var(--media-menu-item-hover-outline);
      outline-offset: var(--media-menu-item-hover-outline-offset,  var(--media-menu-item-outline-offset, -1px));
    }

    :host([aria-checked="true"]) {
      background: var(--media-menu-item-checked-background);
    }

    :host([hidden]) {
      display: none;
    }

    :host([disabled]) {
      pointer-events: none;
      color: rgba(255, 255, 255, .3);
    }

    slot:not([name]) {
      width: 100%;
    }

    slot:not([name="submenu"]) {
      display: inline-flex;
      align-items: center;
      transition: inherit;
      opacity: var(--media-menu-item-opacity, 1);
    }

    slot[name="description"] {
      justify-content: end;
    }

    slot[name="description"] > span {
      display: inline-block;
      margin-inline: 1em .2em;
      max-width: var(--media-menu-item-description-max-width, 100px);
      text-overflow: ellipsis;
      overflow: hidden;
      font-size: .8em;
      font-weight: 400;
      text-align: right;
      position: relative;
      top: .04em;
    }

    slot[name="checked-indicator"] {
      display: none;
    }

    :host(:is([role="menuitemradio"],[role="menuitemcheckbox"])) slot[name="checked-indicator"] {
      display: var(--media-menu-item-checked-indicator-display, inline-block);
    }

    ${/* For all slotted icons in prefix and suffix. */
  ""}
    svg, img, ::slotted(svg), ::slotted(img) {
      height: var(--media-menu-item-icon-height, var(--media-control-height, 24px));
      fill: var(--media-icon-color, var(--media-primary-color, rgb(238 238 238)));
      display: block;
    }

    ${/* Only for indicator icons like checked-indicator or captions-indicator. */
  ""}
    [part~="indicator"],
    ::slotted([part~="indicator"]) {
      fill: var(--media-menu-item-indicator-fill,
        var(--media-icon-color, var(--media-primary-color, rgb(238 238 238))));
      height: var(--media-menu-item-indicator-height, 1.25em);
      margin-right: .5ch;
    }

    [part~="checked-indicator"] {
      visibility: hidden;
    }

    :host([aria-checked="true"]) [part~="checked-indicator"] {
      visibility: visible;
    }
  </style>
  <slot name="checked-indicator">
    <svg aria-hidden="true" viewBox="0 1 24 24" part="checked-indicator indicator">
      <path d="m10 15.17 9.193-9.191 1.414 1.414-10.606 10.606-6.364-6.364 1.414-1.414 4.95 4.95Z"/>
    </svg>
  </slot>
  <slot name="prefix"></slot>
  <slot></slot>
  <slot name="description"></slot>
  <slot name="suffix"></slot>
  <slot name="submenu"></slot>
`;
  var Attributes13 = {
    TYPE: "type",
    VALUE: "value",
    CHECKED: "checked",
    DISABLED: "disabled"
  };
  var MediaChromeMenuItem = class extends GlobalThis.HTMLElement {
    constructor() {
      super();
      __privateAdd22(this, _handleSlotChange2);
      __privateAdd22(this, _submenuConnected);
      __privateAdd22(this, _submenuDisconnected);
      __privateAdd22(this, _handleKeyUp);
      __privateAdd22(this, _handleKeyDown3);
      __privateAdd22(this, _reset);
      __privateAdd22(this, _dirty, false);
      __privateAdd22(this, _ownerElement, void 0);
      __privateAdd22(this, _handleMenuItem, () => {
        var _a3, _b2;
        this.setAttribute("submenusize", `${this.submenuElement.items.length}`);
        const descriptionSlot = this.shadowRoot.querySelector(
          'slot[name="description"]'
        );
        const description = (_b2 = (_a3 = this.submenuElement.checkedItems) == null ? void 0 : _a3[0]) == null ? void 0 : _b2.text;
        const span = Document2.createElement("span");
        span.textContent = description != null ? description : "";
        descriptionSlot.replaceChildren(span);
      });
      if (!this.shadowRoot) {
        this.attachShadow({ mode: "open" });
        this.shadowRoot.append(this.constructor.template.content.cloneNode(true));
      }
      this.shadowRoot.addEventListener("slotchange", this);
    }
    static get observedAttributes() {
      return [
        Attributes13.TYPE,
        Attributes13.DISABLED,
        Attributes13.CHECKED,
        Attributes13.VALUE
      ];
    }
    enable() {
      if (!this.hasAttribute("tabindex")) {
        this.setAttribute("tabindex", "-1");
      }
      if (isCheckable(this) && !this.hasAttribute("aria-checked")) {
        this.setAttribute("aria-checked", "false");
      }
      this.addEventListener("click", this);
      this.addEventListener("keydown", this);
    }
    disable() {
      this.removeAttribute("tabindex");
      this.removeEventListener("click", this);
      this.removeEventListener("keydown", this);
      this.removeEventListener("keyup", this);
    }
    handleEvent(event) {
      switch (event.type) {
        case "slotchange":
          __privateMethod8(this, _handleSlotChange2, handleSlotChange_fn2).call(this, event);
          break;
        case "click":
          this.handleClick(event);
          break;
        case "keydown":
          __privateMethod8(this, _handleKeyDown3, handleKeyDown_fn3).call(this, event);
          break;
        case "keyup":
          __privateMethod8(this, _handleKeyUp, handleKeyUp_fn).call(this, event);
          break;
      }
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      if (attrName === Attributes13.CHECKED && isCheckable(this) && !__privateGet22(this, _dirty)) {
        this.setAttribute("aria-checked", newValue != null ? "true" : "false");
      } else if (attrName === Attributes13.TYPE && newValue !== oldValue) {
        this.role = "menuitem" + newValue;
      } else if (attrName === Attributes13.DISABLED && newValue !== oldValue) {
        if (newValue == null) {
          this.enable();
        } else {
          this.disable();
        }
      }
    }
    connectedCallback() {
      if (!this.hasAttribute(Attributes13.DISABLED)) {
        this.enable();
      }
      this.role = "menuitem" + this.type;
      __privateSet21(this, _ownerElement, closestMenuItemsContainer(this, this.parentNode));
      __privateMethod8(this, _reset, reset_fn).call(this);
    }
    disconnectedCallback() {
      this.disable();
      __privateMethod8(this, _reset, reset_fn).call(this);
      __privateSet21(this, _ownerElement, null);
    }
    get invokeTarget() {
      return this.getAttribute("invoketarget");
    }
    set invokeTarget(value) {
      this.setAttribute("invoketarget", `${value}`);
    }
    /**
     * Returns the element with the id specified by the `invoketarget` attribute
     * or the slotted submenu element.
     */
    get invokeTargetElement() {
      var _a3;
      if (this.invokeTarget) {
        return (_a3 = getDocumentOrShadowRoot(this)) == null ? void 0 : _a3.querySelector(
          `#${this.invokeTarget}`
        );
      }
      return this.submenuElement;
    }
    /**
     * Returns the slotted submenu element.
     */
    get submenuElement() {
      const submenuSlot = this.shadowRoot.querySelector(
        'slot[name="submenu"]'
      );
      return submenuSlot.assignedElements({
        flatten: true
      })[0];
    }
    get type() {
      var _a3;
      return (_a3 = this.getAttribute(Attributes13.TYPE)) != null ? _a3 : "";
    }
    set type(val) {
      this.setAttribute(Attributes13.TYPE, `${val}`);
    }
    get value() {
      var _a3;
      return (_a3 = this.getAttribute(Attributes13.VALUE)) != null ? _a3 : this.text;
    }
    set value(val) {
      this.setAttribute(Attributes13.VALUE, val);
    }
    get text() {
      var _a3;
      return ((_a3 = this.textContent) != null ? _a3 : "").trim();
    }
    get checked() {
      if (!isCheckable(this))
        return void 0;
      return this.getAttribute("aria-checked") === "true";
    }
    set checked(value) {
      if (!isCheckable(this))
        return;
      __privateSet21(this, _dirty, true);
      this.setAttribute("aria-checked", value ? "true" : "false");
      if (value) {
        this.part.add("checked");
      } else {
        this.part.remove("checked");
      }
    }
    handleClick(event) {
      if (isCheckable(this))
        return;
      if (this.invokeTargetElement && containsComposedNode(this, event.target)) {
        this.invokeTargetElement.dispatchEvent(
          new InvokeEvent({ relatedTarget: this })
        );
      }
    }
    get keysUsed() {
      return ["Enter", " "];
    }
  };
  _dirty = /* @__PURE__ */ new WeakMap();
  _ownerElement = /* @__PURE__ */ new WeakMap();
  _handleSlotChange2 = /* @__PURE__ */ new WeakSet();
  handleSlotChange_fn2 = function(event) {
    const slot = event.target;
    const isDefaultSlot = !(slot == null ? void 0 : slot.name);
    if (isDefaultSlot) {
      for (const node of slot.assignedNodes({ flatten: true })) {
        if (node instanceof Text && node.textContent.trim() === "") {
          node.remove();
        }
      }
    }
    if (slot.name === "submenu") {
      if (this.submenuElement) {
        __privateMethod8(this, _submenuConnected, submenuConnected_fn).call(this);
      } else {
        __privateMethod8(this, _submenuDisconnected, submenuDisconnected_fn).call(this);
      }
    }
  };
  _submenuConnected = /* @__PURE__ */ new WeakSet();
  submenuConnected_fn = async function() {
    this.setAttribute("aria-haspopup", "menu");
    this.setAttribute("aria-expanded", `${!this.submenuElement.hidden}`);
    this.submenuElement.addEventListener("change", __privateGet22(this, _handleMenuItem));
    this.submenuElement.addEventListener("addmenuitem", __privateGet22(this, _handleMenuItem));
    this.submenuElement.addEventListener(
      "removemenuitem",
      __privateGet22(this, _handleMenuItem)
    );
    __privateGet22(this, _handleMenuItem).call(this);
  };
  _submenuDisconnected = /* @__PURE__ */ new WeakSet();
  submenuDisconnected_fn = function() {
    this.removeAttribute("aria-haspopup");
    this.removeAttribute("aria-expanded");
    this.submenuElement.removeEventListener("change", __privateGet22(this, _handleMenuItem));
    this.submenuElement.removeEventListener(
      "addmenuitem",
      __privateGet22(this, _handleMenuItem)
    );
    this.submenuElement.removeEventListener(
      "removemenuitem",
      __privateGet22(this, _handleMenuItem)
    );
    __privateGet22(this, _handleMenuItem).call(this);
  };
  _handleMenuItem = /* @__PURE__ */ new WeakMap();
  _handleKeyUp = /* @__PURE__ */ new WeakSet();
  handleKeyUp_fn = function(event) {
    const { key } = event;
    if (!this.keysUsed.includes(key)) {
      this.removeEventListener("keyup", __privateMethod8(this, _handleKeyUp, handleKeyUp_fn));
      return;
    }
    this.handleClick(event);
  };
  _handleKeyDown3 = /* @__PURE__ */ new WeakSet();
  handleKeyDown_fn3 = function(event) {
    const { metaKey, altKey, key } = event;
    if (metaKey || altKey || !this.keysUsed.includes(key)) {
      this.removeEventListener("keyup", __privateMethod8(this, _handleKeyUp, handleKeyUp_fn));
      return;
    }
    this.addEventListener("keyup", __privateMethod8(this, _handleKeyUp, handleKeyUp_fn), { once: true });
  };
  _reset = /* @__PURE__ */ new WeakSet();
  reset_fn = function() {
    var _a3;
    const items = (_a3 = __privateGet22(this, _ownerElement)) == null ? void 0 : _a3.radioGroupItems;
    if (!items)
      return;
    let checkedItem = items.filter((item) => item.getAttribute("aria-checked") === "true").pop();
    if (!checkedItem)
      checkedItem = items[0];
    for (const item of items) {
      item.setAttribute("aria-checked", "false");
    }
    checkedItem == null ? void 0 : checkedItem.setAttribute("aria-checked", "true");
  };
  MediaChromeMenuItem.template = template14;
  function isCheckable(item) {
    return item.type === "radio" || item.type === "checkbox";
  }
  function closestMenuItemsContainer(childNode, parentNode) {
    if (!childNode)
      return null;
    const { host } = childNode.getRootNode();
    if (!parentNode && host)
      return closestMenuItemsContainer(childNode, host);
    if (parentNode == null ? void 0 : parentNode.items)
      return parentNode;
    return closestMenuItemsContainer(parentNode, parentNode == null ? void 0 : parentNode.parentNode);
  }
  if (!GlobalThis.customElements.get("media-chrome-menu-item")) {
    GlobalThis.customElements.define(
      "media-chrome-menu-item",
      MediaChromeMenuItem
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-settings-menu.js
  var template15 = Document2.createElement("template");
  template15.innerHTML = MediaChromeMenu.template.innerHTML + /*html*/
  `
  <style>
    :host {
      background: var(--media-settings-menu-background,
        var(--media-menu-background,
        var(--media-control-background,
        var(--media-secondary-color, rgb(20 20 30 / .8)))));
      min-width: var(--media-settings-menu-min-width, 160px);
      border-radius: 2px 2px 0 0;
      overflow: hidden;
    }

    :host([role="menu"]) {
      ${/* Bottom fix setting menu items for animation when the height expands. */
  ""}
      justify-content: end;
    }

    slot:not([name]) {
      justify-content: var(--media-settings-menu-justify-content);
      flex-direction: var(--media-settings-menu-flex-direction, column);
      overflow: visible;
    }

    #container.has-expanded {
      --media-settings-menu-item-opacity: 0;
    }
  </style>
`;
  var MediaSettingsMenu = class extends MediaChromeMenu {
    /**
     * Returns the anchor element when it is a floating menu.
     */
    get anchorElement() {
      if (this.anchor !== "auto")
        return super.anchorElement;
      return getMediaController(this).querySelector("media-settings-menu-button");
    }
  };
  MediaSettingsMenu.template = template15;
  if (!GlobalThis.customElements.get("media-settings-menu")) {
    GlobalThis.customElements.define("media-settings-menu", MediaSettingsMenu);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-settings-menu-item.js
  var _a;
  var template16 = Document2.createElement("template");
  template16.innerHTML = MediaChromeMenuItem.template.innerHTML + /*html*/
  `
  <style>
    slot:not([name="submenu"]) {
      opacity: var(--media-settings-menu-item-opacity, var(--media-menu-item-opacity));
    }

    :host([aria-expanded="true"]:hover) {
      background: transparent;
    }
  </style>
`;
  if ((_a = template16.content) == null ? void 0 : _a.querySelector) {
    template16.content.querySelector('slot[name="suffix"]').innerHTML = /*html*/
    `
    <svg aria-hidden="true" viewBox="0 0 20 24">
      <path d="m8.12 17.585-.742-.669 4.2-4.665-4.2-4.666.743-.669 4.803 5.335-4.803 5.334Z"/>
    </svg>
  `;
  }
  var MediaSettingsMenuItem = class extends MediaChromeMenuItem {
  };
  MediaSettingsMenuItem.template = template16;
  if (!GlobalThis.customElements.get("media-settings-menu-item")) {
    GlobalThis.customElements.define(
      "media-settings-menu-item",
      MediaSettingsMenuItem
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-chrome-menu-button.js
  var MediaChromeMenuButton = class extends MediaChromeButton {
    connectedCallback() {
      super.connectedCallback();
      if (this.invokeTargetElement) {
        this.setAttribute("aria-haspopup", "menu");
      }
    }
    get invokeTarget() {
      return this.getAttribute("invoketarget");
    }
    set invokeTarget(value) {
      this.setAttribute("invoketarget", `${value}`);
    }
    /**
     * Returns the element with the id specified by the `invoketarget` attribute.
     * @return {HTMLElement | null}
     */
    get invokeTargetElement() {
      var _a3;
      if (this.invokeTarget) {
        return (_a3 = getDocumentOrShadowRoot(this)) == null ? void 0 : _a3.querySelector(
          `#${this.invokeTarget}`
        );
      }
      return null;
    }
    handleClick() {
      var _a3;
      (_a3 = this.invokeTargetElement) == null ? void 0 : _a3.dispatchEvent(
        new InvokeEvent({ relatedTarget: this })
      );
    }
  };
  if (!GlobalThis.customElements.get("media-chrome-menu-button")) {
    GlobalThis.customElements.define(
      "media-chrome-menu-button",
      MediaChromeMenuButton
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-settings-menu-button.js
  var slotTemplate12 = Document2.createElement("template");
  slotTemplate12.innerHTML = /*html*/
  `
  <style>
    :host([aria-expanded="true"]) slot[name=tooltip] {
      display: none;
    }
  </style>
  <slot name="icon">
    <svg aria-hidden="true" viewBox="0 0 24 24">
      <path d="M4.5 14.5a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Zm7.5 0a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Zm7.5 0a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Z"/>
    </svg>
  </slot>
`;
  var MediaSettingsMenuButton = class extends MediaChromeMenuButton {
    static get observedAttributes() {
      return [...super.observedAttributes, "target"];
    }
    constructor() {
      super({ slotTemplate: slotTemplate12, tooltipContent: tooltipLabels.SETTINGS });
    }
    connectedCallback() {
      super.connectedCallback();
      this.setAttribute("aria-label", nouns.SETTINGS());
    }
    /**
     * Returns the element with the id specified by the `invoketarget` attribute.
     * @return {HTMLElement | null}
     */
    get invokeTargetElement() {
      if (this.invokeTarget != void 0)
        return super.invokeTargetElement;
      return getMediaController(this).querySelector("media-settings-menu");
    }
  };
  if (!GlobalThis.customElements.get("media-settings-menu-button")) {
    GlobalThis.customElements.define(
      "media-settings-menu-button",
      MediaSettingsMenuButton
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-audio-track-menu.js
  var __accessCheck23 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet23 = (obj, member, getter) => {
    __accessCheck23(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd23 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet22 = (obj, member, value, setter) => {
    __accessCheck23(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateMethod9 = (obj, member, method) => {
    __accessCheck23(obj, member, "access private method");
    return method;
  };
  var _audioTrackList;
  var _prevState;
  var _render;
  var render_fn;
  var _onChange;
  var onChange_fn;
  var MediaAudioTrackMenu = class extends MediaChromeMenu {
    constructor() {
      super(...arguments);
      __privateAdd23(this, _render);
      __privateAdd23(this, _onChange);
      __privateAdd23(this, _audioTrackList, []);
      __privateAdd23(this, _prevState, void 0);
    }
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_AUDIO_TRACK_LIST,
        MediaUIAttributes.MEDIA_AUDIO_TRACK_ENABLED,
        MediaUIAttributes.MEDIA_AUDIO_TRACK_UNAVAILABLE
      ];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_AUDIO_TRACK_ENABLED && oldValue !== newValue) {
        this.value = newValue;
      } else if (attrName === MediaUIAttributes.MEDIA_AUDIO_TRACK_LIST && oldValue !== newValue) {
        __privateSet22(this, _audioTrackList, parseAudioTrackList(newValue != null ? newValue : ""));
        __privateMethod9(this, _render, render_fn).call(this);
      }
    }
    connectedCallback() {
      super.connectedCallback();
      this.addEventListener("change", __privateMethod9(this, _onChange, onChange_fn));
    }
    disconnectedCallback() {
      super.disconnectedCallback();
      this.removeEventListener("change", __privateMethod9(this, _onChange, onChange_fn));
    }
    /**
     * Returns the anchor element when it is a floating menu.
     */
    get anchorElement() {
      var _a3;
      if (this.anchor !== "auto")
        return super.anchorElement;
      return (_a3 = getMediaController(this)) == null ? void 0 : _a3.querySelector(
        "media-audio-track-menu-button"
      );
    }
    get mediaAudioTrackList() {
      return __privateGet23(this, _audioTrackList);
    }
    set mediaAudioTrackList(list) {
      __privateSet22(this, _audioTrackList, list);
      __privateMethod9(this, _render, render_fn).call(this);
    }
    /**
     * Get enabled audio track id.
     */
    get mediaAudioTrackEnabled() {
      var _a3;
      return (_a3 = getStringAttr(this, MediaUIAttributes.MEDIA_AUDIO_TRACK_ENABLED)) != null ? _a3 : "";
    }
    set mediaAudioTrackEnabled(id) {
      setStringAttr(this, MediaUIAttributes.MEDIA_AUDIO_TRACK_ENABLED, id);
    }
  };
  _audioTrackList = /* @__PURE__ */ new WeakMap();
  _prevState = /* @__PURE__ */ new WeakMap();
  _render = /* @__PURE__ */ new WeakSet();
  render_fn = function() {
    if (__privateGet23(this, _prevState) === JSON.stringify(this.mediaAudioTrackList))
      return;
    __privateSet22(this, _prevState, JSON.stringify(this.mediaAudioTrackList));
    const audioTrackList = this.mediaAudioTrackList;
    this.defaultSlot.textContent = "";
    for (const audioTrack of audioTrackList) {
      const text = this.formatMenuItemText(audioTrack.label, audioTrack);
      const item = createMenuItem({
        type: "radio",
        text,
        value: `${audioTrack.id}`,
        checked: audioTrack.enabled
      });
      item.prepend(createIndicator(this, "checked-indicator"));
      this.defaultSlot.append(item);
    }
  };
  _onChange = /* @__PURE__ */ new WeakSet();
  onChange_fn = function() {
    if (this.value == null)
      return;
    const event = new GlobalThis.CustomEvent(
      MediaUIEvents.MEDIA_AUDIO_TRACK_REQUEST,
      {
        composed: true,
        bubbles: true,
        detail: this.value
      }
    );
    this.dispatchEvent(event);
  };
  if (!GlobalThis.customElements.get("media-audio-track-menu")) {
    GlobalThis.customElements.define(
      "media-audio-track-menu",
      MediaAudioTrackMenu
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-audio-track-menu-button.js
  var audioTrackIcon = (
    /*html*/
    `<svg aria-hidden="true" viewBox="0 0 24 24">
  <path d="M11 17H9.5V7H11v10Zm-3-3H6.5v-4H8v4Zm6-5h-1.5v6H14V9Zm3 7h-1.5V8H17v8Z"/>
  <path d="M22 12c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Zm-2 0a8 8 0 1 0-16 0 8 8 0 0 0 16 0Z"/>
</svg>`
  );
  var slotTemplate13 = Document2.createElement("template");
  slotTemplate13.innerHTML = /*html*/
  `
  <style>
    :host([aria-expanded="true"]) slot[name=tooltip] {
      display: none;
    }
  </style>
  <slot name="icon">${audioTrackIcon}</slot>
`;
  var MediaAudioTrackMenuButton = class extends MediaChromeMenuButton {
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_AUDIO_TRACK_ENABLED,
        MediaUIAttributes.MEDIA_AUDIO_TRACK_UNAVAILABLE
      ];
    }
    constructor() {
      super({ slotTemplate: slotTemplate13, tooltipContent: tooltipLabels.AUDIO_TRACK_MENU });
    }
    connectedCallback() {
      super.connectedCallback();
      this.setAttribute("aria-label", nouns.AUDIO_TRACKS());
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
    }
    /**
     * Returns the element with the id specified by the `invoketarget` attribute.
     * @return {HTMLElement | null}
     */
    get invokeTargetElement() {
      var _a3;
      if (this.invokeTarget != void 0)
        return super.invokeTargetElement;
      return (_a3 = getMediaController(this)) == null ? void 0 : _a3.querySelector("media-audio-track-menu");
    }
    /**
     * Get enabled audio track id.
     * @return {string}
     */
    get mediaAudioTrackEnabled() {
      var _a3;
      return (_a3 = getStringAttr(this, MediaUIAttributes.MEDIA_AUDIO_TRACK_ENABLED)) != null ? _a3 : "";
    }
    set mediaAudioTrackEnabled(id) {
      setStringAttr(this, MediaUIAttributes.MEDIA_AUDIO_TRACK_ENABLED, id);
    }
  };
  if (!GlobalThis.customElements.get("media-audio-track-menu-button")) {
    GlobalThis.customElements.define(
      "media-audio-track-menu-button",
      MediaAudioTrackMenuButton
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-captions-menu.js
  var __accessCheck24 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet24 = (obj, member, getter) => {
    __accessCheck24(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd24 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet23 = (obj, member, value, setter) => {
    __accessCheck24(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateMethod10 = (obj, member, method) => {
    __accessCheck24(obj, member, "access private method");
    return method;
  };
  var _prevState2;
  var _render2;
  var render_fn2;
  var _onChange2;
  var onChange_fn2;
  var ccIcon = (
    /*html*/
    `
  <svg aria-hidden="true" viewBox="0 0 26 24" part="captions-indicator indicator">
    <path d="M22.83 5.68a2.58 2.58 0 0 0-2.3-2.5c-3.62-.24-11.44-.24-15.06 0a2.58 2.58 0 0 0-2.3 2.5c-.23 4.21-.23 8.43 0 12.64a2.58 2.58 0 0 0 2.3 2.5c3.62.24 11.44.24 15.06 0a2.58 2.58 0 0 0 2.3-2.5c.23-4.21.23-8.43 0-12.64Zm-11.39 9.45a3.07 3.07 0 0 1-1.91.57 3.06 3.06 0 0 1-2.34-1 3.75 3.75 0 0 1-.92-2.67 3.92 3.92 0 0 1 .92-2.77 3.18 3.18 0 0 1 2.43-1 2.94 2.94 0 0 1 2.13.78c.364.359.62.813.74 1.31l-1.43.35a1.49 1.49 0 0 0-1.51-1.17 1.61 1.61 0 0 0-1.29.58 2.79 2.79 0 0 0-.5 1.89 3 3 0 0 0 .49 1.93 1.61 1.61 0 0 0 1.27.58 1.48 1.48 0 0 0 1-.37 2.1 2.1 0 0 0 .59-1.14l1.4.44a3.23 3.23 0 0 1-1.07 1.69Zm7.22 0a3.07 3.07 0 0 1-1.91.57 3.06 3.06 0 0 1-2.34-1 3.75 3.75 0 0 1-.92-2.67 3.88 3.88 0 0 1 .93-2.77 3.14 3.14 0 0 1 2.42-1 3 3 0 0 1 2.16.82 2.8 2.8 0 0 1 .73 1.31l-1.43.35a1.49 1.49 0 0 0-1.51-1.21 1.61 1.61 0 0 0-1.29.58A2.79 2.79 0 0 0 15 12a3 3 0 0 0 .49 1.93 1.61 1.61 0 0 0 1.27.58 1.44 1.44 0 0 0 1-.37 2.1 2.1 0 0 0 .6-1.15l1.4.44a3.17 3.17 0 0 1-1.1 1.7Z"/>
  </svg>`
  );
  var template17 = Document2.createElement("template");
  template17.innerHTML = MediaChromeMenu.template.innerHTML + /*html*/
  `
  <slot name="captions-indicator" hidden>${ccIcon}</slot>`;
  var MediaCaptionsMenu = class extends MediaChromeMenu {
    constructor() {
      super(...arguments);
      __privateAdd24(this, _render2);
      __privateAdd24(this, _onChange2);
      __privateAdd24(this, _prevState2, void 0);
    }
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_SUBTITLES_LIST,
        MediaUIAttributes.MEDIA_SUBTITLES_SHOWING
      ];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_SUBTITLES_LIST && oldValue !== newValue) {
        __privateMethod10(this, _render2, render_fn2).call(this);
      } else if (attrName === MediaUIAttributes.MEDIA_SUBTITLES_SHOWING && oldValue !== newValue) {
        this.value = newValue;
      }
    }
    connectedCallback() {
      super.connectedCallback();
      this.addEventListener("change", __privateMethod10(this, _onChange2, onChange_fn2));
    }
    disconnectedCallback() {
      super.disconnectedCallback();
      this.removeEventListener("change", __privateMethod10(this, _onChange2, onChange_fn2));
    }
    /**
     * Returns the anchor element when it is a floating menu.
     */
    get anchorElement() {
      if (this.anchor !== "auto")
        return super.anchorElement;
      return getMediaController(this).querySelector("media-captions-menu-button");
    }
    /**
     * @type {Array<object>} An array of TextTrack-like objects.
     * Objects must have the properties: kind, language, and label.
     */
    get mediaSubtitlesList() {
      return getSubtitlesListAttr2(this, MediaUIAttributes.MEDIA_SUBTITLES_LIST);
    }
    set mediaSubtitlesList(list) {
      setSubtitlesListAttr2(this, MediaUIAttributes.MEDIA_SUBTITLES_LIST, list);
    }
    /**
     * An array of TextTrack-like objects.
     * Objects must have the properties: kind, language, and label.
     */
    get mediaSubtitlesShowing() {
      return getSubtitlesListAttr2(
        this,
        MediaUIAttributes.MEDIA_SUBTITLES_SHOWING
      );
    }
    set mediaSubtitlesShowing(list) {
      setSubtitlesListAttr2(this, MediaUIAttributes.MEDIA_SUBTITLES_SHOWING, list);
    }
  };
  _prevState2 = /* @__PURE__ */ new WeakMap();
  _render2 = /* @__PURE__ */ new WeakSet();
  render_fn2 = function() {
    var _a3;
    if (__privateGet24(this, _prevState2) === JSON.stringify(this.mediaSubtitlesList))
      return;
    __privateSet23(this, _prevState2, JSON.stringify(this.mediaSubtitlesList));
    this.defaultSlot.textContent = "";
    const isOff = !this.value;
    const item = createMenuItem({
      type: "radio",
      text: this.formatMenuItemText("Off"),
      value: "off",
      checked: isOff
    });
    item.prepend(createIndicator(this, "checked-indicator"));
    this.defaultSlot.append(item);
    const subtitlesList = this.mediaSubtitlesList;
    for (const subs of subtitlesList) {
      const item2 = createMenuItem({
        type: "radio",
        text: this.formatMenuItemText(subs.label, subs),
        value: formatTextTrackObj(subs),
        checked: this.value == formatTextTrackObj(subs)
      });
      item2.prepend(createIndicator(this, "checked-indicator"));
      const type = (_a3 = subs.kind) != null ? _a3 : "subs";
      if (type === "captions") {
        item2.append(createIndicator(this, "captions-indicator"));
      }
      this.defaultSlot.append(item2);
    }
  };
  _onChange2 = /* @__PURE__ */ new WeakSet();
  onChange_fn2 = function() {
    const showingSubs = this.mediaSubtitlesShowing;
    const showingSubsStr = this.getAttribute(
      MediaUIAttributes.MEDIA_SUBTITLES_SHOWING
    );
    const localStateChange = this.value !== showingSubsStr;
    if ((showingSubs == null ? void 0 : showingSubs.length) && localStateChange) {
      this.dispatchEvent(
        new GlobalThis.CustomEvent(
          MediaUIEvents.MEDIA_DISABLE_SUBTITLES_REQUEST,
          {
            composed: true,
            bubbles: true,
            detail: showingSubs
          }
        )
      );
    }
    if (!this.value || !localStateChange)
      return;
    const event = new GlobalThis.CustomEvent(
      MediaUIEvents.MEDIA_SHOW_SUBTITLES_REQUEST,
      {
        composed: true,
        bubbles: true,
        detail: this.value
      }
    );
    this.dispatchEvent(event);
  };
  MediaCaptionsMenu.template = template17;
  var getSubtitlesListAttr2 = (el, attrName) => {
    const attrVal = el.getAttribute(attrName);
    return attrVal ? parseTextTracksStr(attrVal) : [];
  };
  var setSubtitlesListAttr2 = (el, attrName, list) => {
    if (!(list == null ? void 0 : list.length)) {
      el.removeAttribute(attrName);
      return;
    }
    const newValStr = stringifyTextTrackList(list);
    const oldVal = el.getAttribute(attrName);
    if (oldVal === newValStr)
      return;
    el.setAttribute(attrName, newValStr);
  };
  if (!GlobalThis.customElements.get("media-captions-menu")) {
    GlobalThis.customElements.define("media-captions-menu", MediaCaptionsMenu);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-captions-menu-button.js
  var __accessCheck25 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateAdd25 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet24 = (obj, member, value, setter) => {
    __accessCheck25(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var _captionsReady;
  var ccIconOn2 = `<svg aria-hidden="true" viewBox="0 0 26 24">
  <path d="M22.83 5.68a2.58 2.58 0 0 0-2.3-2.5c-3.62-.24-11.44-.24-15.06 0a2.58 2.58 0 0 0-2.3 2.5c-.23 4.21-.23 8.43 0 12.64a2.58 2.58 0 0 0 2.3 2.5c3.62.24 11.44.24 15.06 0a2.58 2.58 0 0 0 2.3-2.5c.23-4.21.23-8.43 0-12.64Zm-11.39 9.45a3.07 3.07 0 0 1-1.91.57 3.06 3.06 0 0 1-2.34-1 3.75 3.75 0 0 1-.92-2.67 3.92 3.92 0 0 1 .92-2.77 3.18 3.18 0 0 1 2.43-1 2.94 2.94 0 0 1 2.13.78c.364.359.62.813.74 1.31l-1.43.35a1.49 1.49 0 0 0-1.51-1.17 1.61 1.61 0 0 0-1.29.58 2.79 2.79 0 0 0-.5 1.89 3 3 0 0 0 .49 1.93 1.61 1.61 0 0 0 1.27.58 1.48 1.48 0 0 0 1-.37 2.1 2.1 0 0 0 .59-1.14l1.4.44a3.23 3.23 0 0 1-1.07 1.69Zm7.22 0a3.07 3.07 0 0 1-1.91.57 3.06 3.06 0 0 1-2.34-1 3.75 3.75 0 0 1-.92-2.67 3.88 3.88 0 0 1 .93-2.77 3.14 3.14 0 0 1 2.42-1 3 3 0 0 1 2.16.82 2.8 2.8 0 0 1 .73 1.31l-1.43.35a1.49 1.49 0 0 0-1.51-1.21 1.61 1.61 0 0 0-1.29.58A2.79 2.79 0 0 0 15 12a3 3 0 0 0 .49 1.93 1.61 1.61 0 0 0 1.27.58 1.44 1.44 0 0 0 1-.37 2.1 2.1 0 0 0 .6-1.15l1.4.44a3.17 3.17 0 0 1-1.1 1.7Z"/>
</svg>`;
  var ccIconOff2 = `<svg aria-hidden="true" viewBox="0 0 26 24">
  <path d="M17.73 14.09a1.4 1.4 0 0 1-1 .37 1.579 1.579 0 0 1-1.27-.58A3 3 0 0 1 15 12a2.8 2.8 0 0 1 .5-1.85 1.63 1.63 0 0 1 1.29-.57 1.47 1.47 0 0 1 1.51 1.2l1.43-.34A2.89 2.89 0 0 0 19 9.07a3 3 0 0 0-2.14-.78 3.14 3.14 0 0 0-2.42 1 3.91 3.91 0 0 0-.93 2.78 3.74 3.74 0 0 0 .92 2.66 3.07 3.07 0 0 0 2.34 1 3.07 3.07 0 0 0 1.91-.57 3.17 3.17 0 0 0 1.07-1.74l-1.4-.45c-.083.43-.3.822-.62 1.12Zm-7.22 0a1.43 1.43 0 0 1-1 .37 1.58 1.58 0 0 1-1.27-.58A3 3 0 0 1 7.76 12a2.8 2.8 0 0 1 .5-1.85 1.63 1.63 0 0 1 1.29-.57 1.47 1.47 0 0 1 1.51 1.2l1.43-.34a2.81 2.81 0 0 0-.74-1.32 2.94 2.94 0 0 0-2.13-.78 3.18 3.18 0 0 0-2.43 1 4 4 0 0 0-.92 2.78 3.74 3.74 0 0 0 .92 2.66 3.07 3.07 0 0 0 2.34 1 3.07 3.07 0 0 0 1.91-.57 3.23 3.23 0 0 0 1.07-1.74l-1.4-.45a2.06 2.06 0 0 1-.6 1.07Zm12.32-8.41a2.59 2.59 0 0 0-2.3-2.51C18.72 3.05 15.86 3 13 3c-2.86 0-5.72.05-7.53.17a2.59 2.59 0 0 0-2.3 2.51c-.23 4.207-.23 8.423 0 12.63a2.57 2.57 0 0 0 2.3 2.5c1.81.13 4.67.19 7.53.19 2.86 0 5.72-.06 7.53-.19a2.57 2.57 0 0 0 2.3-2.5c.23-4.207.23-8.423 0-12.63Zm-1.49 12.53a1.11 1.11 0 0 1-.91 1.11c-1.67.11-4.45.18-7.43.18-2.98 0-5.76-.07-7.43-.18a1.11 1.11 0 0 1-.91-1.11c-.21-4.14-.21-8.29 0-12.43a1.11 1.11 0 0 1 .91-1.11C7.24 4.56 10 4.49 13 4.49s5.76.07 7.43.18a1.11 1.11 0 0 1 .91 1.11c.21 4.14.21 8.29 0 12.43Z"/>
</svg>`;
  var slotTemplate14 = Document2.createElement("template");
  slotTemplate14.innerHTML = /*html*/
  `
  <style>
    :host([aria-checked="true"]) slot[name=off] {
      display: none !important;
    }

    ${/* Double negative, but safer if display doesn't equal 'block' */
  ""}
    :host(:not([aria-checked="true"])) slot[name=on] {
      display: none !important;
    }

    :host([aria-expanded="true"]) slot[name=tooltip] {
      display: none;
    }
  </style>

  <slot name="icon">
    <slot name="on">${ccIconOn2}</slot>
    <slot name="off">${ccIconOff2}</slot>
  </slot>
`;
  var updateAriaChecked2 = (el) => {
    el.setAttribute("aria-checked", areSubsOn(el).toString());
  };
  var MediaCaptionsMenuButton = class extends MediaChromeMenuButton {
    constructor(options = {}) {
      super({ slotTemplate: slotTemplate14, tooltipContent: tooltipLabels.CAPTIONS, ...options });
      __privateAdd25(this, _captionsReady, void 0);
      __privateSet24(this, _captionsReady, false);
    }
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_SUBTITLES_LIST,
        MediaUIAttributes.MEDIA_SUBTITLES_SHOWING
      ];
    }
    connectedCallback() {
      super.connectedCallback();
      this.setAttribute("aria-label", nouns.CLOSED_CAPTIONS());
      updateAriaChecked2(this);
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_SUBTITLES_SHOWING) {
        updateAriaChecked2(this);
      }
    }
    /**
     * Returns the element with the id specified by the `invoketarget` attribute.
     * @return {HTMLElement | null}
     */
    get invokeTargetElement() {
      var _a3;
      if (this.invokeTarget != void 0)
        return super.invokeTargetElement;
      return (_a3 = getMediaController(this)) == null ? void 0 : _a3.querySelector("media-captions-menu");
    }
    /**
     * An array of TextTrack-like objects.
     * Objects must have the properties: kind, language, and label.
     */
    get mediaSubtitlesList() {
      return getSubtitlesListAttr3(this, MediaUIAttributes.MEDIA_SUBTITLES_LIST);
    }
    set mediaSubtitlesList(list) {
      setSubtitlesListAttr3(this, MediaUIAttributes.MEDIA_SUBTITLES_LIST, list);
    }
    /**
     * An array of TextTrack-like objects.
     * Objects must have the properties: kind, language, and label.
     */
    get mediaSubtitlesShowing() {
      return getSubtitlesListAttr3(
        this,
        MediaUIAttributes.MEDIA_SUBTITLES_SHOWING
      );
    }
    set mediaSubtitlesShowing(list) {
      setSubtitlesListAttr3(this, MediaUIAttributes.MEDIA_SUBTITLES_SHOWING, list);
    }
  };
  _captionsReady = /* @__PURE__ */ new WeakMap();
  var getSubtitlesListAttr3 = (el, attrName) => {
    const attrVal = el.getAttribute(attrName);
    return attrVal ? parseTextTracksStr(attrVal) : [];
  };
  var setSubtitlesListAttr3 = (el, attrName, list) => {
    if (!(list == null ? void 0 : list.length)) {
      el.removeAttribute(attrName);
      return;
    }
    const newValStr = stringifyTextTrackList(list);
    const oldVal = el.getAttribute(attrName);
    if (oldVal === newValStr)
      return;
    el.setAttribute(attrName, newValStr);
  };
  if (!GlobalThis.customElements.get("media-captions-menu-button")) {
    GlobalThis.customElements.define(
      "media-captions-menu-button",
      MediaCaptionsMenuButton
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-playback-rate-menu.js
  var __accessCheck26 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet25 = (obj, member, getter) => {
    __accessCheck26(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd26 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateMethod11 = (obj, member, method) => {
    __accessCheck26(obj, member, "access private method");
    return method;
  };
  var _rates2;
  var _render3;
  var render_fn3;
  var _onChange3;
  var onChange_fn3;
  var Attributes14 = {
    RATES: "rates"
  };
  var MediaPlaybackRateMenu = class extends MediaChromeMenu {
    constructor() {
      super();
      __privateAdd26(this, _render3);
      __privateAdd26(this, _onChange3);
      __privateAdd26(this, _rates2, new AttributeTokenList(this, Attributes14.RATES, {
        defaultValue: DEFAULT_RATES
      }));
      __privateMethod11(this, _render3, render_fn3).call(this);
    }
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_PLAYBACK_RATE,
        Attributes14.RATES
      ];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_PLAYBACK_RATE && oldValue != newValue) {
        this.value = newValue;
      } else if (attrName === Attributes14.RATES && oldValue != newValue) {
        __privateGet25(this, _rates2).value = newValue;
        __privateMethod11(this, _render3, render_fn3).call(this);
      }
    }
    connectedCallback() {
      super.connectedCallback();
      this.addEventListener("change", __privateMethod11(this, _onChange3, onChange_fn3));
    }
    disconnectedCallback() {
      super.disconnectedCallback();
      this.removeEventListener("change", __privateMethod11(this, _onChange3, onChange_fn3));
    }
    /**
     * Returns the anchor element when it is a floating menu.
     */
    get anchorElement() {
      if (this.anchor !== "auto")
        return super.anchorElement;
      return getMediaController(this).querySelector(
        "media-playback-rate-menu-button"
      );
    }
    /**
     * Will return a DOMTokenList.
     * Setting a value will accept an array of numbers.
     */
    get rates() {
      return __privateGet25(this, _rates2);
    }
    set rates(value) {
      if (!value) {
        __privateGet25(this, _rates2).value = "";
      } else if (Array.isArray(value)) {
        __privateGet25(this, _rates2).value = value.join(" ");
      }
      __privateMethod11(this, _render3, render_fn3).call(this);
    }
    /**
     * The current playback rate
     */
    get mediaPlaybackRate() {
      return getNumericAttr(
        this,
        MediaUIAttributes.MEDIA_PLAYBACK_RATE,
        DEFAULT_RATE
      );
    }
    set mediaPlaybackRate(value) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_PLAYBACK_RATE, value);
    }
  };
  _rates2 = /* @__PURE__ */ new WeakMap();
  _render3 = /* @__PURE__ */ new WeakSet();
  render_fn3 = function() {
    this.defaultSlot.textContent = "";
    for (const rate of this.rates) {
      const item = createMenuItem({
        type: "radio",
        text: this.formatMenuItemText(`${rate}x`, rate),
        value: rate,
        checked: this.mediaPlaybackRate == rate
      });
      item.prepend(createIndicator(this, "checked-indicator"));
      this.defaultSlot.append(item);
    }
  };
  _onChange3 = /* @__PURE__ */ new WeakSet();
  onChange_fn3 = function() {
    if (!this.value)
      return;
    const event = new GlobalThis.CustomEvent(
      MediaUIEvents.MEDIA_PLAYBACK_RATE_REQUEST,
      {
        composed: true,
        bubbles: true,
        detail: this.value
      }
    );
    this.dispatchEvent(event);
  };
  if (!GlobalThis.customElements.get("media-playback-rate-menu")) {
    GlobalThis.customElements.define(
      "media-playback-rate-menu",
      MediaPlaybackRateMenu
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-playback-rate-menu-button.js
  var __accessCheck27 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet26 = (obj, member, getter) => {
    __accessCheck27(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd27 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var _rates3;
  var Attributes15 = {
    RATES: "rates"
  };
  var DEFAULT_RATES2 = [1, 1.2, 1.5, 1.7, 2];
  var DEFAULT_RATE2 = 1;
  var slotTemplate15 = Document2.createElement("template");
  slotTemplate15.innerHTML = /*html*/
  `
  <style>
    :host {
      min-width: 5ch;
      padding: var(--media-button-padding, var(--media-control-padding, 10px 5px));
    }
    
    :host([aria-expanded="true"]) slot[name=tooltip] {
      display: none;
    }
  </style>
  <slot name="icon"></slot>
`;
  var MediaPlaybackRateMenuButton = class extends MediaChromeMenuButton {
    constructor(options = {}) {
      super({
        slotTemplate: slotTemplate15,
        tooltipContent: tooltipLabels.PLAYBACK_RATE,
        ...options
      });
      __privateAdd27(this, _rates3, new AttributeTokenList(this, Attributes15.RATES, {
        defaultValue: DEFAULT_RATES2
      }));
      this.container = this.shadowRoot.querySelector('slot[name="icon"]');
      this.container.innerHTML = `${DEFAULT_RATE2}x`;
    }
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_PLAYBACK_RATE,
        Attributes15.RATES
      ];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === Attributes15.RATES) {
        __privateGet26(this, _rates3).value = newValue;
      }
      if (attrName === MediaUIAttributes.MEDIA_PLAYBACK_RATE) {
        const newPlaybackRate = newValue ? +newValue : Number.NaN;
        const playbackRate = !Number.isNaN(newPlaybackRate) ? newPlaybackRate : DEFAULT_RATE2;
        this.container.innerHTML = `${playbackRate}x`;
        this.setAttribute("aria-label", nouns.PLAYBACK_RATE({ playbackRate }));
      }
    }
    /**
     * Returns the element with the id specified by the `invoketarget` attribute.
     */
    get invokeTargetElement() {
      if (this.invokeTarget != void 0)
        return super.invokeTargetElement;
      return getMediaController(this).querySelector("media-playback-rate-menu");
    }
    /**
     * Will return a DOMTokenList.
     * Setting a value will accept an array of numbers.
     */
    get rates() {
      return __privateGet26(this, _rates3);
    }
    set rates(value) {
      if (!value) {
        __privateGet26(this, _rates3).value = "";
      } else if (Array.isArray(value)) {
        __privateGet26(this, _rates3).value = value.join(" ");
      }
    }
    /**
     * The current playback rate
     */
    get mediaPlaybackRate() {
      return getNumericAttr(
        this,
        MediaUIAttributes.MEDIA_PLAYBACK_RATE,
        DEFAULT_RATE2
      );
    }
    set mediaPlaybackRate(value) {
      setNumericAttr(this, MediaUIAttributes.MEDIA_PLAYBACK_RATE, value);
    }
  };
  _rates3 = /* @__PURE__ */ new WeakMap();
  if (!GlobalThis.customElements.get("media-playback-rate-menu-button")) {
    GlobalThis.customElements.define(
      "media-playback-rate-menu-button",
      MediaPlaybackRateMenuButton
    );
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-rendition-menu.js
  var __accessCheck28 = (obj, member, msg) => {
    if (!member.has(obj))
      throw TypeError("Cannot " + msg);
  };
  var __privateGet27 = (obj, member, getter) => {
    __accessCheck28(obj, member, "read from private field");
    return getter ? getter.call(obj) : member.get(obj);
  };
  var __privateAdd28 = (obj, member, value) => {
    if (member.has(obj))
      throw TypeError("Cannot add the same private member more than once");
    member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
  };
  var __privateSet25 = (obj, member, value, setter) => {
    __accessCheck28(obj, member, "write to private field");
    setter ? setter.call(obj, value) : member.set(obj, value);
    return value;
  };
  var __privateMethod12 = (obj, member, method) => {
    __accessCheck28(obj, member, "access private method");
    return method;
  };
  var _renditionList;
  var _prevState3;
  var _render4;
  var render_fn4;
  var _onChange4;
  var onChange_fn4;
  var MediaRenditionMenu = class extends MediaChromeMenu {
    constructor() {
      super(...arguments);
      __privateAdd28(this, _render4);
      __privateAdd28(this, _onChange4);
      __privateAdd28(this, _renditionList, []);
      __privateAdd28(this, _prevState3, void 0);
    }
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_RENDITION_LIST,
        MediaUIAttributes.MEDIA_RENDITION_SELECTED,
        MediaUIAttributes.MEDIA_RENDITION_UNAVAILABLE
      ];
    }
    attributeChangedCallback(attrName, oldValue, newValue) {
      super.attributeChangedCallback(attrName, oldValue, newValue);
      if (attrName === MediaUIAttributes.MEDIA_RENDITION_SELECTED && oldValue !== newValue) {
        this.value = newValue != null ? newValue : "auto";
      } else if (attrName === MediaUIAttributes.MEDIA_RENDITION_LIST && oldValue !== newValue) {
        __privateSet25(this, _renditionList, parseRenditionList(newValue));
        __privateMethod12(this, _render4, render_fn4).call(this);
      }
    }
    connectedCallback() {
      super.connectedCallback();
      this.addEventListener("change", __privateMethod12(this, _onChange4, onChange_fn4));
    }
    disconnectedCallback() {
      super.disconnectedCallback();
      this.removeEventListener("change", __privateMethod12(this, _onChange4, onChange_fn4));
    }
    /**
     * Returns the anchor element when it is a floating menu.
     */
    get anchorElement() {
      if (this.anchor !== "auto")
        return super.anchorElement;
      return getMediaController(this).querySelector(
        "media-rendition-menu-button"
      );
    }
    get mediaRenditionList() {
      return __privateGet27(this, _renditionList);
    }
    set mediaRenditionList(list) {
      __privateSet25(this, _renditionList, list);
      __privateMethod12(this, _render4, render_fn4).call(this);
    }
    /**
     * Get selected rendition id.
     */
    get mediaRenditionSelected() {
      return getStringAttr(this, MediaUIAttributes.MEDIA_RENDITION_SELECTED);
    }
    set mediaRenditionSelected(id) {
      setStringAttr(this, MediaUIAttributes.MEDIA_RENDITION_SELECTED, id);
    }
  };
  _renditionList = /* @__PURE__ */ new WeakMap();
  _prevState3 = /* @__PURE__ */ new WeakMap();
  _render4 = /* @__PURE__ */ new WeakSet();
  render_fn4 = function() {
    if (__privateGet27(this, _prevState3) === JSON.stringify(this.mediaRenditionList))
      return;
    __privateSet25(this, _prevState3, JSON.stringify(this.mediaRenditionList));
    const renditionList = this.mediaRenditionList.sort(
      (a, b) => b.height - a.height
    );
    this.defaultSlot.textContent = "";
    const isAuto = !this.mediaRenditionSelected;
    for (const rendition of renditionList) {
      const text = this.formatMenuItemText(
        `${Math.min(rendition.width, rendition.height)}p`,
        rendition
      );
      const item2 = createMenuItem({
        type: "radio",
        text,
        value: `${rendition.id}`,
        checked: rendition.selected && !isAuto
      });
      item2.prepend(createIndicator(this, "checked-indicator"));
      this.defaultSlot.append(item2);
    }
    const item = createMenuItem({
      type: "radio",
      text: this.formatMenuItemText("Auto"),
      value: "auto",
      checked: isAuto
    });
    item.prepend(createIndicator(this, "checked-indicator"));
    this.defaultSlot.append(item);
  };
  _onChange4 = /* @__PURE__ */ new WeakSet();
  onChange_fn4 = function() {
    if (this.value == null)
      return;
    const event = new GlobalThis.CustomEvent(
      MediaUIEvents.MEDIA_RENDITION_REQUEST,
      {
        composed: true,
        bubbles: true,
        detail: this.value
      }
    );
    this.dispatchEvent(event);
  };
  if (!GlobalThis.customElements.get("media-rendition-menu")) {
    GlobalThis.customElements.define("media-rendition-menu", MediaRenditionMenu);
  }

  // ../../node_modules/player.style/node_modules/media-chrome/dist/menu/media-rendition-menu-button.js
  var renditionIcon = (
    /*html*/
    `<svg aria-hidden="true" viewBox="0 0 24 24">
  <path d="M13.5 2.5h2v6h-2v-2h-11v-2h11v-2Zm4 2h4v2h-4v-2Zm-12 4h2v6h-2v-2h-3v-2h3v-2Zm4 2h12v2h-12v-2Zm1 4h2v6h-2v-2h-8v-2h8v-2Zm4 2h7v2h-7v-2Z" />
</svg>`
  );
  var slotTemplate16 = Document2.createElement("template");
  slotTemplate16.innerHTML = /*html*/
  `
  <style>
    :host([aria-expanded="true"]) slot[name=tooltip] {
      display: none;
    }
  </style>
  <slot name="icon">${renditionIcon}</slot>
`;
  var MediaRenditionMenuButton = class extends MediaChromeMenuButton {
    static get observedAttributes() {
      return [
        ...super.observedAttributes,
        MediaUIAttributes.MEDIA_RENDITION_SELECTED,
        MediaUIAttributes.MEDIA_RENDITION_UNAVAILABLE
      ];
    }
    constructor() {
      super({ slotTemplate: slotTemplate16, tooltipContent: tooltipLabels.RENDITIONS });
    }
    connectedCallback() {
      super.connectedCallback();
      this.setAttribute("aria-label", nouns.QUALITY());
    }
    /**
     * Returns the element with the id specified by the `invoketarget` attribute.
     */
    get invokeTargetElement() {
      if (this.invokeTarget != void 0)
        return super.invokeTargetElement;
      return getMediaController(this).querySelector("media-rendition-menu");
    }
    /**
     * Get selected rendition id.
     */
    get mediaRenditionSelected() {
      return getStringAttr(this, MediaUIAttributes.MEDIA_RENDITION_SELECTED);
    }
    set mediaRenditionSelected(id) {
      setStringAttr(this, MediaUIAttributes.MEDIA_RENDITION_SELECTED, id);
    }
  };
  if (!GlobalThis.customElements.get("media-rendition-menu-button")) {
    GlobalThis.customElements.define(
      "media-rendition-menu-button",
      MediaRenditionMenuButton
    );
  }

  // ../../node_modules/player.style/themes/minimal/dist/media-theme.js
  var _a2, _b;
  var template18 = (_b = (_a2 = GlobalThis.document) == null ? void 0 : _a2.createElement) == null ? void 0 : _b.call(_a2, "template");
  if (template18) {
    template18.innerHTML = /*html*/
    `
    <style>
      :host {
        --_primary-color: var(--media-primary-color, #fff);
        --_secondary-color: var(--media-secondary-color, rgb(0 0 0 / .75));

        --media-icon-color: var(--_primary-color);
        --media-range-thumb-background: var(--_primary-color);
        --media-range-bar-color: var(--_primary-color);
        --media-control-background: transparent;
        --media-control-hover-background: transparent;
        --media-range-track-border-radius: 3px;
        --media-time-range-buffered-color: rgba(255, 255, 255, 0.4);
        --media-range-track-background: rgba(255, 255, 255, 0.5);
        --media-range-thumb-opacity: 0;
        --media-preview-thumbnail-border-radius: 2px;
        --media-tooltip-display: none;

        color: var(--_primary-color);
      }

      @supports (color: color-mix(in srgb, red, blue)) {
        :host {
          --_secondary-color: color-mix(in srgb, var(--media-secondary-color, #000) 75%, transparent);
        }
      }

      media-control-bar {
        --media-control-padding: 2px;
        background: var(--_secondary-color);
        align-items: center;
        height: 30px;
        border-radius: 4px;
        margin: 0 5px 5px;
        padding-inline: 2px;
      }

      media-controller[breakpointsm] media-control-bar {
        --media-control-padding: 4px;
        height: 38px;
        border-radius: 8px;
        padding-inline: 5px;
      }

      media-controller[breakpointmd] media-control-bar {
        height: 46px;
        margin: 0 8px 8px;
      }

      media-controller[breakpointlg] media-control-bar,
      media-controller[breakpointxl] media-control-bar {
        padding-inline: 7px;
      }

      .live-controls-left {
        margin-right: auto;
      }

      media-time-range,
      media-live-button,
      media-time-display,
      media-text-display,
      media-playback-rate-button[role='button'] {
        color: inherit;
      }

      [disabled]:not(media-live-button) {
        opacity: 60%;
        cursor: not-allowed;
      }

      ${/* Turn some buttons off by default */
    ""}
      media-seek-backward-button {
        display: var(--media-control-display, var(--media-seek-backward-button-display, none));
      }

      media-seek-forward-button {
        display: var(--media-control-display, var(--media-seek-forward-button-display, none));
      }

      media-pip-button {
        display: var(--media-control-display, var(--media-pip-button-display, none));
      }
    </style>

    <template partial="PlayButton">
      <media-play-button part="play button" disabled="{{disabled}}" aria-disabled="{{disabled}}">
        <svg aria-hidden="true" viewBox="0 0 24 24" slot="play">
          <path d="m6.73 20.93 14.05-8.54a.46.46 0 0 0 0-.78L6.73 3.07a.48.48 0 0 0-.73.39v17.07a.48.48 0 0 0 .73.4Z" />
        </svg>
        <svg aria-hidden="true" viewBox="0 0 24 24" slot="pause">
          <path
            d="M6 19.5a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-15a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5v15ZM14.5 4a.5.5 0 0 0-.5.5v15a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-15a.5.5 0 0 0-.5-.5h-3Z"
          />
        </svg>
      </media-play-button>
    </template>

    <template partial="MuteButton">
      <media-mute-button part="mute button" disabled="{{disabled}}" aria-disabled="{{disabled}}">
        <svg aria-hidden="true" viewBox="0 0 24 24" slot="high">
          <path
            d="m11.14 4.86-4 4a.49.49 0 0 1-.35.14H3.25a.25.25 0 0 0-.25.25v5.5a.25.25 0 0 0 .25.25h3.54a.49.49 0 0 1 .36.15l4 4a.5.5 0 0 0 .85-.36V5.21a.5.5 0 0 0-.86-.35Zm2.74-1.56v1.52A7.52 7.52 0 0 1 19.47 12a7.52 7.52 0 0 1-5.59 7.18v1.52A9 9 0 0 0 21 12a9 9 0 0 0-7.12-8.7Zm3.56 8.7a5.49 5.49 0 0 0-3.56-5.1v1.66a3.93 3.93 0 0 1 0 6.88v1.66a5.49 5.49 0 0 0 3.56-5.1Z"
          />
        </svg>
        <svg aria-hidden="true" viewBox="0 0 24 24" slot="medium">
          <path
            d="m11.14 4.853-4 4a.49.49 0 0 1-.35.14H3.25a.25.25 0 0 0-.25.25v5.5a.25.25 0 0 0 .25.25h3.54a.49.49 0 0 1 .36.15l4 4a.5.5 0 0 0 .85-.36V5.203a.5.5 0 0 0-.86-.35Zm6.3 7.14a5.49 5.49 0 0 0-3.56-5.1v1.66a3.93 3.93 0 0 1 0 6.88v1.66a5.49 5.49 0 0 0 3.56-5.1Z"
          />
        </svg>
        <svg aria-hidden="true" viewBox="0 0 24 24" slot="low">
          <path
            d="m11.14 4.853-4 4a.49.49 0 0 1-.35.14H3.25a.25.25 0 0 0-.25.25v5.5a.25.25 0 0 0 .25.25h3.54a.49.49 0 0 1 .36.15l4 4a.5.5 0 0 0 .85-.36V5.203a.5.5 0 0 0-.86-.35Zm6.3 7.14a5.49 5.49 0 0 0-3.56-5.1v1.66a3.93 3.93 0 0 1 0 6.88v1.66a5.49 5.49 0 0 0 3.56-5.1Z"
          />
        </svg>
        <svg aria-hidden="true" viewBox="0 0 24 24" slot="off">
          <path
            d="m3 4.05 4.48 4.47-.33.33a.49.49 0 0 1-.36.15H3.25a.25.25 0 0 0-.25.25v5.5a.25.25 0 0 0 .25.25h3.54a.49.49 0 0 1 .36.15l4 4a.48.48 0 0 0 .36.15.5.5 0 0 0 .5-.5v-5.75l4.67 4.66a7.71 7.71 0 0 1-2.79 1.47v1.52a9.32 9.32 0 0 0 3.87-1.91L20 21l1-1L4.06 3 3 4.05Zm5.36 5.36 2.39 2.39V17L8 14.26a1.74 1.74 0 0 0-1.24-.51H4.25v-3.5h2.54A1.74 1.74 0 0 0 8 9.74l.36-.33ZM19.47 12a7.19 7.19 0 0 1-.89 3.47l1.11 1.1A8.64 8.64 0 0 0 21 12a9 9 0 0 0-7.12-8.7v1.52A7.52 7.52 0 0 1 19.47 12ZM12 8.88V5.21a.5.5 0 0 0-.5-.5.48.48 0 0 0-.36.15L9.56 6.44 12 8.88ZM15.91 12a4.284 4.284 0 0 1-.07.72l1.22 1.22a5.2 5.2 0 0 0 .38-1.94 5.49 5.49 0 0 0-3.56-5.1v1.66A4 4 0 0 1 15.91 12Z"
          />
        </svg>
      </media-mute-button>
    </template>

    <template partial="CaptionsButton">
      <media-captions-button part="captions button" disabled="{{disabled}}" aria-disabled="{{disabled}}">
        <svg aria-hidden="true" viewBox="0 0 26 24" slot="on">
          <path
            d="M22.832 5.68a2.58 2.58 0 0 0-2.3-2.5c-3.62-.24-11.44-.24-15.06 0a2.58 2.58 0 0 0-2.3 2.5c-.23 4.21-.23 8.43 0 12.64a2.58 2.58 0 0 0 2.3 2.5c3.62.24 11.44.24 15.06 0a2.58 2.58 0 0 0 2.3-2.5c.23-4.21.23-8.43 0-12.64Zm-11.41 10.1a3.63 3.63 0 0 1-1.51.32 4.76 4.76 0 0 1-1.63-.27 4 4 0 0 1-1.28-.83 3.67 3.67 0 0 1-.84-1.26 4.23 4.23 0 0 1-.3-1.63 4.28 4.28 0 0 1 .3-1.64 3.53 3.53 0 0 1 .84-1.21 3.89 3.89 0 0 1 1.29-.8 4.76 4.76 0 0 1 1.63-.27 4.06 4.06 0 0 1 1.35.24c.225.091.44.205.64.34a2.7 2.7 0 0 1 .55.52l-1.27 1a1.79 1.79 0 0 0-.6-.46 2 2 0 0 0-.83-.16 2 2 0 0 0-1.56.69 2.35 2.35 0 0 0-.46.77 2.78 2.78 0 0 0-.16 1c-.009.34.046.68.16 1 .104.283.26.545.46.77.188.21.415.38.67.5a2 2 0 0 0 .84.18 1.87 1.87 0 0 0 .9-.21 1.78 1.78 0 0 0 .65-.6l1.38 1a2.88 2.88 0 0 1-1.22 1.01Zm7.52 0a3.63 3.63 0 0 1-1.51.32 4.76 4.76 0 0 1-1.63-.27 3.89 3.89 0 0 1-1.28-.83 3.55 3.55 0 0 1-.85-1.26 4.23 4.23 0 0 1-.3-1.63 4.28 4.28 0 0 1 .3-1.64 3.43 3.43 0 0 1 .85-1.25 3.75 3.75 0 0 1 1.28-.8 4.76 4.76 0 0 1 1.63-.27 4 4 0 0 1 1.35.24c.225.091.44.205.64.34.21.144.395.32.55.52l-1.27 1a1.79 1.79 0 0 0-.6-.46 2 2 0 0 0-.83-.16 2 2 0 0 0-1.56.69 2.352 2.352 0 0 0-.46.77 3.01 3.01 0 0 0-.16 1c-.003.34.05.678.16 1 .108.282.263.542.46.77.188.21.416.38.67.5a2 2 0 0 0 .84.18 1.87 1.87 0 0 0 .9-.21 1.78 1.78 0 0 0 .65-.6l1.38 1a2.82 2.82 0 0 1-1.21 1.05Z"
          />
        </svg>
        <svg aria-hidden="true" viewBox="0 0 26 24" slot="off">
          <path
            d="M22.832 5.68a2.58 2.58 0 0 0-2.3-2.5c-1.81-.12-4.67-.18-7.53-.18-2.86 0-5.72.06-7.53.18a2.58 2.58 0 0 0-2.3 2.5c-.23 4.21-.23 8.43 0 12.64a2.58 2.58 0 0 0 2.3 2.5c1.81.12 4.67.18 7.53.18 2.86 0 5.72-.06 7.53-.18a2.58 2.58 0 0 0 2.3-2.5c.23-4.21.23-8.43 0-12.64Zm-1.49 12.53a1.11 1.11 0 0 1-.91 1.11c-1.67.11-4.45.18-7.43.18-2.98 0-5.76-.07-7.43-.18a1.11 1.11 0 0 1-.91-1.11c-.21-4.137-.21-8.283 0-12.42a1.11 1.11 0 0 1 .91-1.11c1.67-.11 4.43-.18 7.43-.18s5.76.07 7.43.18a1.11 1.11 0 0 1 .91 1.11c.21 4.137.21 8.283 0 12.42ZM10.843 14a1.55 1.55 0 0 1-.76.18 1.57 1.57 0 0 1-.71-.18 1.69 1.69 0 0 1-.57-.42 2.099 2.099 0 0 1-.38-.58 2.47 2.47 0 0 1 0-1.64 2 2 0 0 1 .39-.66 1.73 1.73 0 0 1 .58-.42c.23-.103.479-.158.73-.16.241-.004.48.044.7.14.199.088.373.222.51.39l1.08-.89a2.179 2.179 0 0 0-.47-.44 2.81 2.81 0 0 0-.54-.32 2.91 2.91 0 0 0-.58-.15 2.71 2.71 0 0 0-.56 0 4.08 4.08 0 0 0-1.38.15 3.27 3.27 0 0 0-1.09.67 3.14 3.14 0 0 0-.71 1.06 3.62 3.62 0 0 0-.26 1.39 3.57 3.57 0 0 0 .26 1.38 3 3 0 0 0 .71 1.06c.316.293.687.52 1.09.67.443.16.91.238 1.38.23a3.2 3.2 0 0 0 1.28-.27c.401-.183.747-.47 1-.83l-1.17-.88a1.42 1.42 0 0 1-.53.52Zm6.62 0a1.58 1.58 0 0 1-.76.18 1.54 1.54 0 0 1-.7-.18 1.69 1.69 0 0 1-.57-.42 2.12 2.12 0 0 1-.43-.58 2.29 2.29 0 0 1 .39-2.3 1.84 1.84 0 0 1 1.32-.58c.241-.003.48.045.7.14.199.088.373.222.51.39l1.08-.92a2.43 2.43 0 0 0-.47-.44 3.22 3.22 0 0 0-.53-.29 2.999 2.999 0 0 0-.57-.15 2.87 2.87 0 0 0-.57 0 4.06 4.06 0 0 0-1.36.15 3.17 3.17 0 0 0-1.09.67 3 3 0 0 0-.72 1.06 3.62 3.62 0 0 0-.25 1.39 3.57 3.57 0 0 0 .25 1.38c.16.402.405.764.72 1.06a3.17 3.17 0 0 0 1.09.67c.44.16.904.237 1.37.23.441 0 .877-.092 1.28-.27a2.45 2.45 0 0 0 1-.83l-1.15-.85a1.49 1.49 0 0 1-.54.49Z"
          />
        </svg>
      </media-captions-button>
    </template>

    <template partial="FullscreenButton">
      <media-fullscreen-button part="fullscreen button" disabled="{{disabled}}" aria-disabled="{{disabled}}">
        <svg aria-hidden="true" viewBox="0 0 24 24" slot="enter">
          <path
            d="M20.25 14.5a.76.76 0 0 0-.75.75v4.25h-4.25a.75.75 0 1 0 0 1.5h5a.76.76 0 0 0 .75-.75v-5a.76.76 0 0 0-.75-.75Zm0-11.5h-5a.76.76 0 0 0-.75.75.76.76 0 0 0 .75.75h4.25v4.25a.75.75 0 1 0 1.5 0v-5a.76.76 0 0 0-.75-.75ZM8.75 19.5H4.5v-4.25a.76.76 0 0 0-.75-.75.76.76 0 0 0-.75.75v5a.76.76 0 0 0 .75.75h5a.75.75 0 1 0 0-1.5Zm0-16.5h-5a.76.76 0 0 0-.75.75v5a.76.76 0 0 0 .75.75.76.76 0 0 0 .75-.75V4.5h4.25a.76.76 0 0 0 .75-.75.76.76 0 0 0-.75-.75Z"
          />
        </svg>
        <svg aria-hidden="true" viewBox="0 0 24 24" slot="exit">
          <path
            d="M20.25 14.5h-5a.76.76 0 0 0-.75.75v5a.75.75 0 1 0 1.5 0V16h4.25a.75.75 0 1 0 0-1.5Zm-5-5h5a.75.75 0 1 0 0-1.5H16V3.75a.75.75 0 1 0-1.5 0v5a.76.76 0 0 0 .75.75Zm-6.5 5h-5a.75.75 0 1 0 0 1.5H8v4.25a.75.75 0 1 0 1.5 0v-5a.76.76 0 0 0-.75-.75Zm0-11.5a.76.76 0 0 0-.75.75V8H3.75a.75.75 0 0 0 0 1.5h5a.76.76 0 0 0 .75-.75v-5A.76.76 0 0 0 8.75 3Z"
          />
        </svg>
      </media-fullscreen-button>
    </template>

    <template partial="LiveButton">
      <media-live-button part="live seek-live button" disabled="{{disabled}}" aria-disabled="{{disabled}}">
        <span slot="text" style="font-weight: normal">Live</span>
        <svg
          slot="indicator"
          width="8"
          height="8"
          viewBox="0 0 8 8"
          xmlns="http://www.w3.org/2000/svg"
          style="width: 8px; height: 8px; margin-right: 2px"
        >
          <rect width="8" height="8" rx="2" />
        </svg>
      </media-live-button>
    </template>

    <template partial="PipButton">
      <media-pip-button part="pip button" disabled="{{disabled}}" aria-disabled="{{disabled}}">
        <svg aria-hidden="true" viewBox="0 0 26 24" slot="enter">
          <path
            d="M22 3H4a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h6.75v-1.25h-6.5V4.25h17.5v6.5H23V4a1 1 0 0 0-1-1Zm0 10h-8a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-6a1 1 0 0 0-1-1Zm-.5 6.5h-7v-5h7v5Z"
          />
        </svg>
        <svg aria-hidden="true" viewBox="0 0 26 24" slot="exit">
          <path
            d="M22 3H4a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h6.75v-1.25h-6.5V4.25h17.5v6.5H23V4a1 1 0 0 0-1-1Zm0 10h-8a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-6a1 1 0 0 0-1-1Zm-.5 6.5h-7v-5h7v5Z"
          />
        </svg>
      </media-pip-button>
    </template>

    <template partial="SeekBackwardButton">
      <media-seek-backward-button
        seekoffset="{{backwardseekoffset ?? 10}}"
        part="seek-backward button"
        disabled="{{disabled}}"
        aria-disabled="{{disabled}}"
      >
        <svg aria-hidden="true" viewBox="0 0 22 24" slot="icon">
          <path d="M11 6V3L5.37 7 11 10.94V8a5.54 5.54 0 0 1 1.9 10.48v2.12A7.5 7.5 0 0 0 11 6Z" />
          <text class="value" transform="translate(2.5 21)" style="font-size: 8px; font-family: 'ArialMT', 'Arial'">
            {{backwardseekoffset ?? 10}}
          </text>
        </svg>
      </media-seek-backward-button>
    </template>

    <template partial="SeekForwardButton">
      <media-seek-forward-button
        seekoffset="{{forwardseekoffset ?? 10}}"
        part="seek-forward button"
        disabled="{{disabled}}"
        aria-disabled="{{disabled}}"
      >
        <svg aria-hidden="true" viewBox="0 0 22 24" slot="icon">
          <path d="M11 6V3l5.61 4L11 10.94V8a5.54 5.54 0 0 0-1.9 10.48v2.12A7.5 7.5 0 0 1 11 6Z" />
          <text class="value" transform="translate(10 21)" style="font-size: 8px; font-family: 'ArialMT', 'Arial'">
            {{forwardseekoffset ?? 10}}
          </text>
        </svg>
      </media-seek-forward-button>
    </template>

    <template partial="AirplayButton">
      <media-airplay-button part="airplay button" disabled="{{disabled}}" aria-disabled="{{disabled}}">
        <svg aria-hidden="true" viewBox="0 0 26 24" slot="icon">
          <path d="M13.19 14.22a.25.25 0 0 0-.38 0l-5.46 6.37a.25.25 0 0 0 .19.41h10.92a.25.25 0 0 0 .19-.41l-5.46-6.37Z" />
          <path
            d="M22 3H4a1 1 0 0 0-1 1v13a1 1 0 0 0 1 1h2.94L8 16.75H4.25V4.25h17.5v12.5H18L19.06 18H22a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1Z"
          />
        </svg>
      </media-airplay-button>
    </template>

    <template partial="CastButton">
      <media-cast-button part="cast button" disabled="{{disabled}}" aria-disabled="{{disabled}}">
        <svg aria-hidden="true" viewBox="0 0 26 24" slot="enter">
          <path d="M3 15.5V17c2.206 0 4 1.794 4 4h1.5A5.5 5.5 0 0 0 3 15.5Zm0 3V21h2.5A2.5 2.5 0 0 0 3 18.5Z" />
          <path d="M3 12.5V14c3.86 0 7 3.14 7 7h1.5A8.5 8.5 0 0 0 3 12.5Z" />
          <path
            d="M22 3H4a1 1 0 0 0-1 1v6.984c.424 0 .84.035 1.25.086V4.25h17.5v15.5h-8.82c.051.41.086.826.086 1.25H22a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1Z"
          />
        </svg>
        <svg aria-hidden="true" viewBox="0 0 26 24" slot="exit">
          <path d="M3 15.5V17c2.206 0 4 1.794 4 4h1.5A5.5 5.5 0 0 0 3 15.5Zm0 3V21h2.5A2.5 2.5 0 0 0 3 18.5Z" />
          <path d="M3 12.5V14c3.86 0 7 3.14 7 7h1.5A8.5 8.5 0 0 0 3 12.5Z" />
          <path
            d="M22 3H4a1 1 0 0 0-1 1v6.984c.424 0 .84.035 1.25.086V4.25h17.5v15.5h-8.82c.051.41.086.826.086 1.25H22a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1Z"
          />
          <path d="M20.5 5.5h-15v5.811c3.52.906 6.283 3.67 7.189 7.19H20.5V5.5Z" />
        </svg>
      </media-cast-button>
    </template>

    <template partial="TimeRange">
      <media-time-range part="time range" disabled="{{disabled}}" aria-disabled="{{disabled}}"></media-time-range>
    </template>

    <template partial="VolumeRange">
      <media-volume-range part="volume range" disabled="{{disabled}}" aria-disabled="{{disabled}}"></media-volume-range>
    </template>

    <media-controller
      defaultsubtitles="{{defaultsubtitles}}"
      defaultduration="{{defaultduration}}"
      gesturesdisabled="{{disabled}}"
      hotkeys="{{hotkeys}}"
      nohotkeys="{{nohotkeys}}"
      defaultstreamtype="on-demand"
    >
      <slot name="media" slot="media"></slot>
      <slot name="poster" slot="poster"></slot>
      <media-loading-indicator slot="centered-chrome" noautohide></media-loading-indicator>

      <template if="title">
        <div slot="top-chrome">
          <media-text-display>{{title}}</media-text-display>
        </div>
      </template>

      <template if="streamtype == 'on-demand'">
        <template if="!breakpointsm">
          <media-control-bar>
            {{>PlayButton}} {{>TimeRange}} {{>MuteButton}} {{>CaptionsButton}} {{>FullscreenButton}}
          </media-control-bar>
        </template>

        <template if="breakpointsm">
          <media-control-bar>
            {{>PlayButton}} {{>SeekBackwardButton}} {{>SeekForwardButton}} {{>TimeRange}}
            <template if="breakpointmd">
              <media-time-display></media-time-display>
            </template>
            {{>MuteButton}} {{>VolumeRange}} {{>CaptionsButton}} {{>AirplayButton}} {{>CastButton}} {{>PipButton}}
            {{>FullscreenButton}}
          </media-control-bar>
        </template>
      </template>

      <template if="streamtype == 'live'">
        <media-control-bar>
          <div class="live-controls-left">
            {{>LiveButton}}
            <template if="!targetlivewindow">
              <template if="breakpointsm">
                <media-time-display></media-time-display>
              </template>
            </template>
          </div>
          <template if="targetlivewindow > 0">
            <template if="breakpointsm">{{>TimeRange}}</template>
          </template>
          <div class="live-controls-right">
            <template if="targetlivewindow > 0"> {{>SeekBackwardButton}} {{>SeekForwardButton}} </template>
            {{>MuteButton}} {{>VolumeRange}} {{>CaptionsButton}} {{>AirplayButton}} {{>CastButton}} {{>PipButton}}
            {{>FullscreenButton}}
          </div>
        </media-control-bar>
      </template>

      <slot></slot>
    </media-controller>

  `;
  }
  var MediaThemeMinimalElement = class extends MediaThemeElement {
  };
  __publicField(MediaThemeMinimalElement, "template", template18);
  if (GlobalThis.customElements && !GlobalThis.customElements.get("media-theme-minimal")) {
    GlobalThis.customElements.define("media-theme-minimal", MediaThemeMinimalElement);
  }
  return __toCommonJS(minimal_exports);
})();
